/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.util;

import java.io.InvalidObjectException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Scanner;

public final class JsonParser {
    private final String input;
    private int pos = 0;
    private final Deque<Object> stack = new ArrayDeque<Object>();

    public JsonParser(String input) {
        this.input = input;
    }

    public void parse() throws InvalidObjectException {
        if (!this.parseValue()) {
            throw new InvalidObjectException("Parsing json string failed.");
        }
    }

    private void skipWhitespace() {
        while (this.pos < this.input.length() && (this.input.charAt(this.pos) == ' ' || this.input.charAt(this.pos) == '\t' || this.input.charAt(this.pos) == '\n')) {
            ++this.pos;
        }
    }

    private boolean parseChar(char c) {
        boolean success;
        if (this.pos >= this.input.length()) {
            return false;
        }
        boolean bl = success = this.input.charAt(this.pos) == c;
        if (!success) {
            return false;
        }
        ++this.pos;
        this.skipWhitespace();
        return true;
    }

    public boolean parseValue() {
        return this.parseString() || this.parseNumber() || this.parseObject() || this.parseArray() || this.parseBoolAndNull();
    }

    private boolean parseString() {
        if (this.pos >= this.input.length()) {
            return false;
        }
        if (this.input.charAt(this.pos) != '\"') {
            return false;
        }
        int last = this.input.substring(this.pos + 1).indexOf(34);
        if (last < 0) {
            return false;
        }
        this.stack.push(this.input.substring(this.pos + 1, this.pos + last + 1));
        this.pos += last + 2;
        this.skipWhitespace();
        return true;
    }

    private boolean parseNumber() {
        if (this.pos >= this.input.length()) {
            return false;
        }
        Scanner scanner = new Scanner(this.input.substring(this.pos));
        String num = scanner.useDelimiter("[^0-9]").next();
        if (num.length() > 0) {
            this.stack.push(Integer.parseInt(num));
            this.pos += num.length();
            this.skipWhitespace();
            return true;
        }
        return false;
    }

    private boolean parseBoolAndNull() {
        if (this.pos >= this.input.length()) {
            return false;
        }
        if (this.input.startsWith("true", this.pos)) {
            this.stack.push(true);
            this.pos += 4;
        } else if (this.input.startsWith("false", this.pos)) {
            this.stack.push(false);
            this.pos += 5;
        } else if (this.input.startsWith("null", this.pos)) {
            this.stack.push(null);
            this.pos += 4;
        } else {
            return false;
        }
        this.skipWhitespace();
        return true;
    }

    private boolean parseObject() {
        boolean success;
        int pos0 = this.pos;
        int stack0 = this.stack.size();
        boolean bl = success = this.parseChar('{') && this.parsePairs() && this.parseChar('}');
        if (!success) {
            this.pos = pos0;
            return false;
        }
        HashMap<String, Object> object = new HashMap<String, Object>();
        while (this.stack.size() > stack0) {
            Object value = this.stack.pop();
            String string = (String)this.stack.pop();
            object.put(string, value);
        }
        this.stack.push(object);
        return true;
    }

    private boolean parsePairs() {
        if (this.parsePair()) {
            this.parsePairTails();
        }
        return true;
    }

    private boolean parsePairTails() {
        int pos0;
        boolean success;
        do {
            pos0 = this.pos;
        } while (success = this.parseChar(',') && this.parsePair());
        this.pos = pos0;
        return true;
    }

    private boolean parsePair() {
        boolean success;
        int pos0 = this.pos;
        boolean bl = success = this.parseString() && this.parseChar(':') && this.parseValue();
        if (!success) {
            this.pos = pos0;
        }
        return success;
    }

    private boolean parseArray() {
        boolean success;
        int pos0 = this.pos;
        int stack0 = this.stack.size();
        boolean bl = success = this.parseChar('[') && this.parseValues() && this.parseChar(']');
        if (!success) {
            this.pos = pos0;
            return false;
        }
        ArrayList<Object> array = new ArrayList<Object>();
        while (this.stack.size() > stack0) {
            array.add(this.stack.pop());
        }
        Collections.reverse(array);
        this.stack.push(array);
        return true;
    }

    private boolean parseValues() {
        if (this.parseValue()) {
            this.parseValueTails();
        }
        return true;
    }

    private boolean parseValueTails() {
        int pos0;
        boolean success;
        do {
            pos0 = this.pos;
        } while (success = this.parseChar(',') && this.parseValue());
        this.pos = pos0;
        return true;
    }

    public Deque<Object> getStack() {
        return this.stack;
    }
}

