/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.task;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.mapper.AbilityPluginJdHpartyCheckMapper;
import com.ohaotian.plugin.mapper.JdHpartyCheckTokenMapper;
import com.ohaotian.plugin.model.bo.req.RefreshTokenReqBO;
import com.ohaotian.plugin.model.bo.rsp.RefreshTokenRspBO;
import com.ohaotian.plugin.model.bo.rsp.SyncJdHpartyCheckTokenBO;
import com.ohaotian.plugin.model.po.JdHpartyCheckTokenPO;
import com.ohaotian.plugin.model.po.PluginJdHpartyCheckPO;
import com.ohaotian.plugin.util.JDToken;
import com.ohaotian.portalcommon.api.AbilityPluginDeployApi;
import com.ohaotian.portalcommon.api.ZookeeperAPI;
import com.ohaotian.portalcommon.model.bo.AbilityPluginDeployRspBO;
import com.ohaotian.portalcommon.model.bo.PluginDataRspBO;
import com.ohaotian.portalcommon.util.GsonUtil;
import com.ohaotian.portalcommon.util.HttpUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class JdTokenRefreshLogic {
    private static final Logger log = LogManager.getLogger(JdTokenRefreshLogic.class);

    public static void doLogic(JdHpartyCheckTokenMapper jdHpartyCheckTokenMapper, AbilityPluginJdHpartyCheckMapper abilityPluginJdHpartyCheckMapper, AbilityPluginDeployApi abilityPluginDeployApi, ZookeeperAPI zookeeperAPI, PluginJdHpartyCheckPO pluginJdHpartyCheckPO, JdHpartyCheckTokenPO jdToken) {
        RefreshTokenReqBO refreshTokenReqBO = (RefreshTokenReqBO)BeanMapper.map((Object)pluginJdHpartyCheckPO, RefreshTokenReqBO.class);
        refreshTokenReqBO.setUserName(jdToken.getUserName());
        refreshTokenReqBO.setUserPassword(jdToken.getUserPassword());
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter ofPattern = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        refreshTokenReqBO.setTimestamp(now.format(ofPattern));
        refreshTokenReqBO.setGrantType("access_token");
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Type", "application/x-www-form-urlencoded");
        try {
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            paramsMap.put("client_id", refreshTokenReqBO.getClientId());
            paramsMap.put("client_secret", refreshTokenReqBO.getClientSecret());
            paramsMap.put("username", refreshTokenReqBO.getUserName());
            paramsMap.put("grant_type", "access_token");
            paramsMap.put("timestamp", refreshTokenReqBO.getTimestamp());
            String password = JDToken.getMD5Str(refreshTokenReqBO.getUserPassword());
            String sign = refreshTokenReqBO.getClientSecret() + refreshTokenReqBO.getTimestamp() + refreshTokenReqBO.getClientId() + refreshTokenReqBO.getUserName() + password + "access_token" + refreshTokenReqBO.getClientSecret();
            sign = JDToken.getMD5Str(sign).toUpperCase();
            paramsMap.put("sign", sign);
            paramsMap.put("password", password);
            HttpUtil.doPost((String)pluginJdHpartyCheckPO.getTokenPath(), (status, map) -> {
                if (status != 200) {
                    log.error("token\u5237\u65b0\u8c03\u7528\u5931\u8d25\uff0ctoken\u8bb0\u5f55id: {}", (Object)GsonUtil.toJson((Object)jdToken));
                    JdTokenRefreshLogic.updateErrorToken(jdHpartyCheckTokenMapper, jdToken);
                    return null;
                }
                RefreshTokenRspBO refreshTokenRspBO = (RefreshTokenRspBO)GsonUtil.fromJson((String)map, RefreshTokenRspBO.class);
                log.info("token\u5237\u65b0\u6210\u529f:\uff0c\u4eac\u4e1c\u8fd4\u56de\u7ed3\u679c{}", (Object)GsonUtil.toJson((Object)refreshTokenRspBO));
                if (!refreshTokenRspBO.isSuccess()) {
                    log.error("token\u5237\u65b0\u9519\u8bef:\uff0ctoken\u8bb0\u5f55id:{}", (Object)GsonUtil.toJson((Object)jdToken));
                    JdTokenRefreshLogic.updateErrorToken(jdHpartyCheckTokenMapper, jdToken);
                    return null;
                }
                Long duration = refreshTokenRspBO.getResult().getExpires_in() * 1000L;
                Date time = new Date();
                String token = refreshTokenRspBO.getResult().getAccess_token();
                jdToken.setAccessToken(token);
                JdTokenRefreshLogic.updateToken(jdHpartyCheckTokenMapper, jdToken, new Date(time.getTime() + duration));
                log.info("token\u5237\u65b0\u6210\u529f:\uff0c\u63d2\u4ef6\u5206\u533a:{}", (Object)pluginJdHpartyCheckPO.getRegionCode());
                log.info("token\u5237\u65b0\u6210\u529f:\uff0ctoken\u8bb0\u5f55:{}", (Object)JSONObject.toJSONString((Object)jdToken));
                log.info("token\u5237\u65b0\u6210\u529f:\uff0ctoken\u503c:{}", (Object)token);
                JdTokenRefreshLogic.noticeForData(abilityPluginJdHpartyCheckMapper, abilityPluginDeployApi, zookeeperAPI, pluginJdHpartyCheckPO, jdToken);
                return status;
            }, paramsMap);
        }
        catch (Exception e) {
            log.error("token\u5237\u65b0\u5931\u8d25:\uff0ctoken\u8bb0\u5f55:{}", (Object)JSONObject.toJSONString((Object)jdToken), (Object)e);
            JdTokenRefreshLogic.updateErrorToken(jdHpartyCheckTokenMapper, jdToken);
        }
    }

    private static void updateToken(JdHpartyCheckTokenMapper jdHpartyCheckTokenMapper, JdHpartyCheckTokenPO jdHpartyCheckTokenPO, Date expiresIn) {
        jdHpartyCheckTokenPO.setIsRunning(1);
        jdHpartyCheckTokenPO.setExpiresIn(expiresIn);
        jdHpartyCheckTokenPO.setUpdateTime(new Date());
        jdHpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(jdHpartyCheckTokenPO);
    }

    private static void updateErrorToken(JdHpartyCheckTokenMapper jdHpartyCheckTokenMapper, JdHpartyCheckTokenPO jdHpartyCheckTokenPO) {
        jdHpartyCheckTokenPO.setIsRunning(2);
        jdHpartyCheckTokenPO.setUpdateTime(new Date());
        jdHpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(jdHpartyCheckTokenPO);
    }

    public static void noticeForData(AbilityPluginJdHpartyCheckMapper abilityPluginJdHpartyCheckMapper, AbilityPluginDeployApi abilityPluginDeployApi, ZookeeperAPI zookeeperAPI, PluginJdHpartyCheckPO pluginJdHpartyCheckPO, JdHpartyCheckTokenPO jdHpartyCheckTokenPO) {
        List abilityPluginDeployRspBOS;
        List<Long> abilityPluginDeployIds = abilityPluginJdHpartyCheckMapper.queryAllDeployIds();
        if (abilityPluginDeployIds.size() > 0 && (abilityPluginDeployRspBOS = abilityPluginDeployApi.qryAbilityPluginDeployById(abilityPluginDeployIds)) != null && abilityPluginDeployRspBOS.size() != 0) {
            List clusterIds = abilityPluginDeployRspBOS.stream().map(AbilityPluginDeployRspBO::getClusterId).collect(Collectors.toList());
            PluginDataRspBO pluginDataRspBO = new PluginDataRspBO();
            pluginDataRspBO.setClusterIds(clusterIds);
            pluginDataRspBO.setPluginType("jdHpartyCheck");
            pluginDataRspBO.setOpr("refresh");
            SyncJdHpartyCheckTokenBO syncJdHpartyCheckTokenBO = (SyncJdHpartyCheckTokenBO)BeanMapper.map((Object)jdHpartyCheckTokenPO, SyncJdHpartyCheckTokenBO.class);
            syncJdHpartyCheckTokenBO.setClientId(pluginJdHpartyCheckPO.getClientId());
            syncJdHpartyCheckTokenBO.setRegionCode(pluginJdHpartyCheckPO.getRegionCode());
            pluginDataRspBO.setData((Object)GsonUtil.toJson((Object)syncJdHpartyCheckTokenBO));
            log.info("\u96c6\u7fa4\u901a\u77e5{}", (Object)JSONObject.toJSONString((Object)pluginDataRspBO));
            zookeeperAPI.hpartyCheckPluginTokenNotice(JSONObject.toJSONString((Object)pluginDataRspBO));
        }
    }
}

