/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.controller;

import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.portalcommon.api.PluginAPI;
import com.ohaotian.portalcommon.constant.CodeMsg;
import com.ohaotian.portalcommon.model.bo.PluginReqBO;
import com.ohaotian.portalcommon.model.bo.PluginRspBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.service.PluginService;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/plugin/priority"})
public class PriorityController {
    private static Logger logger = LogManager.getLogger(PriorityController.class);
    @Resource
    PluginAPI pluginAPI;
    @Resource
    PluginService pluginService;

    @RequestMapping(value={"/pluginInfo"})
    @BusiResponseBody
    public RspBO getPluginInfo(@RequestBody PluginReqBO pluginReqBO) {
        logger.debug("\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}", (Object)pluginReqBO);
        if (StringUtils.isEmpty((Object)pluginReqBO.getPluginId())) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        PluginRspBO pluginRspBO = this.pluginAPI.getPluginInfo(pluginReqBO.getPluginId());
        RspBO rspBO = RspBO.success((Object)pluginRspBO);
        logger.debug("\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object)rspBO);
        return rspBO;
    }
}

