/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.config.pubsub.mq;

import com.ohaotian.abilityadmin.config.pubsub.ChannelNaming;
import com.ohaotian.abilityadmin.config.pubsub.properties.PubSubResProperties;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PubSubMqProvider {
    private static final Logger log = LoggerFactory.getLogger(PubSubMqProvider.class);
    @Resource(name="exteriorProvider")
    private ProxyMessageProducer proxyMessageProducer;
    @Autowired
    private PubSubResProperties pubSubResProperties;
    @Value(value="${atp.channel.value.size:200}")
    private int channelValueSize;

    public void provideMessage(String tag, String value) {
        Object sendResult = null;
        try {
            ProxyMessage proxyMessage = new ProxyMessage(ChannelNaming.get(this.pubSubResProperties.getAdmin2web()), tag, value);
            this.proxyMessageProducer.send(proxyMessage);
            log.info("MQ \u63a8\u9001\u901a\u9053\uff1atopic={} tag={} value={}", new Object[]{proxyMessage.getSubject(), proxyMessage.getTag(), value.substring(0, value.length() > this.channelValueSize ? this.channelValueSize : value.length())});
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException("exterior send message failed\uff01 " + e.getMessage());
        }
    }
}

