/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.config.cluster;

import com.ohaotian.abilityadmin.config.pubsub.loader.PubSubRes;
import com.ohaotian.abilityadmin.mapper.NodeMapper;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.portalcommon.config.cluster.AdminClusterConfig;
import com.ohaotian.portalcommon.config.systemcode.SystemParam;
import com.ohaotian.portalcommon.constant.ConstantBaseVersion;
import com.ohaotian.portalcommon.model.bo.AdminMasterBo;
import com.ohaotian.portalcommon.model.bo.RedisSyncDataBo;
import com.ohaotian.portalcommon.util.DateUtil;
import com.ohaotian.portalcommon.util.GsonUtil;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
public class InitClusterMonitor {
    private static final Logger log = LoggerFactory.getLogger(InitClusterMonitor.class);
    @Resource
    private NodeMapper nodeMapper;
    @Resource
    ThreadPoolTaskScheduler threadPoolTaskScheduler;
    @Autowired
    CacheClient cacheClient;
    @Autowired
    AdminClusterConfig adminClusterConfig;
    @Autowired
    ServerProperties serverProperties;
    @Resource
    private PubSubRes pubSubRes;
    @Autowired
    private SystemParam systemParam;
    @Value(value="${atp.sync.time:20}")
    private Integer syncTimeInterval;
    @Value(value="${redis.hashTags:false}")
    private Boolean hashTags;
    @Autowired
    private ConstantBaseVersion constantBaseVersion;
    private static final Semaphore SEMAPHORE = new Semaphore(2);

    public void run() {
        Runnable webNodeRedisRun = () -> {
            try {
                SEMAPHORE.acquire(1);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        };
        String number = String.valueOf(this.syncTimeInterval);
        try {
            number = String.valueOf(SecureRandom.getInstance("SHA1PRNG").nextInt(Integer.parseInt(number)) + 10);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        String adminCron = "0/" + number + " * * * * ?";
        log.info("\u4e3b\u8282\u70b9\u76d1\u6d4bcron:" + adminCron);
        String finalNumber = number;
        Runnable adminMasterRun = () -> {
            this.adminMasterMonitoring(finalNumber);
            SEMAPHORE.release(2);
        };
        String webCron = "0/" + Integer.parseInt(number) / 2 + " * * * * ?";
        log.info("\u96c6\u7fa4\u8282\u70b9\u76d1\u6d4bcron:" + webCron);
        String clusterNodeMonitoringNumber = String.valueOf(Integer.parseInt(number) / 2);
        Runnable webHeartBeatRun = () -> {
            try {
                SEMAPHORE.acquire(1);
                this.clusterNodeMonitoring(clusterNodeMonitoringNumber);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        };
        adminMasterRun.run();
        log.info("\u4e3b\u8282\u70b9\u76d1\u63a7\u542f\u52a8\uff01");
        webNodeRedisRun.run();
        log.info("web nodes\u7f13\u5b58\u52a0\u8f7d\uff01");
        webHeartBeatRun.run();
        log.info("web\u8282\u70b9\u5fc3\u8df3\u76d1\u63a7\u542f\u52a8\uff01");
        this.threadPoolTaskScheduler.schedule(webNodeRedisRun, (Trigger)new CronTrigger("0 0 0 */1 * ?"));
        this.threadPoolTaskScheduler.schedule(adminMasterRun, (Trigger)new CronTrigger(adminCron));
        this.threadPoolTaskScheduler.schedule(webHeartBeatRun, (Trigger)new CronTrigger(webCron));
    }

    private void adminMasterMonitoring(String finalNumber) {
        AdminMasterBo adminMasterBo;
        if (ObjectUtils.isEmpty((Object)this.cacheClient.get(this.constantBaseVersion.getMASTER_NAME()))) {
            Date date = new Date(System.currentTimeMillis() + 1000L * (Long.parseLong(finalNumber) + 2L));
            this.cacheClient.set(this.constantBaseVersion.getMASTER_NAME(), (Object)GsonUtil.toJson((Object)AdminMasterBo.builder().name(this.adminClusterConfig.getName()).time(DateUtil.formatDateWithMS((Date)new Date())).expired(DateUtil.formatDateWithMS((Date)date)).build()));
            this.cacheClient.expire(this.constantBaseVersion.getMASTER_NAME(), Integer.parseInt(finalNumber) + 2);
        }
        if ((adminMasterBo = (AdminMasterBo)GsonUtil.fromJson((String)this.cacheClient.get(this.constantBaseVersion.getMASTER_NAME()).toString(), AdminMasterBo.class)).getName().equalsIgnoreCase(this.adminClusterConfig.getName())) {
            if (Boolean.FALSE.equals(this.adminClusterConfig.isMaster())) {
                log.info("{} \u6ce8\u518c\u4e3a\u4e3b\u8282\u70b9\uff01", (Object)this.adminClusterConfig.getName());
            }
            this.adminClusterConfig.setMaster(Boolean.TRUE.booleanValue());
            Date date = new Date(System.currentTimeMillis() + 1000L * (Long.parseLong(finalNumber) + 2L));
            adminMasterBo.setTime(DateUtil.formatDateWithMS((Date)new Date()));
            adminMasterBo.setExpired(DateUtil.formatDateWithMS((Date)date));
            this.cacheClient.set(this.constantBaseVersion.getMASTER_NAME(), (Object)GsonUtil.toJson((Object)adminMasterBo));
            this.cacheClient.expire(this.constantBaseVersion.getMASTER_NAME(), Integer.parseInt(finalNumber) + 2);
        } else {
            this.adminClusterConfig.setMaster(Boolean.FALSE.booleanValue());
        }
    }

    private void initClusterWebNodeToRedis() {
        if (this.adminClusterConfig.isMaster()) {
            try {
                TimeUnit.SECONDS.sleep(60L);
                HashMap<String, List> clusters = new HashMap<String, List>();
                Boolean existFlag = Boolean.FALSE;
                for (String nodeName : this.adminClusterConfig.getCoreHeart()) {
                    String name = StringUtils.substringAfter((String)nodeName, (String)this.constantBaseVersion.getWEB_NODES_HEARTBEAT());
                    String[] splitName = name.split("-");
                    String clusterId = splitName[0];
                    String nodeIp = splitName[1];
                    String port = splitName[2];
                    Map webHeartbeatInfo = GsonUtil.toObjectMap((String)this.cacheClient.get(nodeName).toString());
                    ArrayList nodes = new ArrayList();
                    HashMap<String, Object> node = new HashMap<String, Object>();
                    ArrayList efficientNodes = new ArrayList();
                    HashMap<String, String> efficientNode = new HashMap<String, String>();
                    efficientNode.put("updateUserId", "1");
                    efficientNode.put("createUserId", "1");
                    efficientNode.put("validFlag", "0");
                    efficientNode.put("startTime", webHeartbeatInfo.get("startTime").toString());
                    efficientNode.put("name", "<" + StringUtils.substringAfter((String)nodeName, (String)"<"));
                    efficientNode.put("remark", "\u5237\u65b0\u6210\u529f:" + DateUtil.formatDateWithMS((Date)new Date()));
                    efficientNode.put("resUsingRate", "0");
                    efficientNodes.add(efficientNode);
                    node.put("nodeIp", nodeIp);
                    node.put("port", port);
                    node.put("efficientNodes", efficientNodes);
                    node.put("efficientNodeCount", efficientNodes.size() + "");
                    node.put("invalidNodes", new ArrayList());
                    node.put("invalidNodeCount", "0");
                    node.put("createTime", DateUtil.formatDateWithMS((Date)new Date()));
                    List oldNodes = (List)clusters.get(clusterId);
                    if (CollectionUtils.isEmpty((Collection)oldNodes)) {
                        nodes.add(node);
                        clusters.put(clusterId, nodes);
                        continue;
                    }
                    for (Map oldNode : oldNodes) {
                        if (!oldNode.get("nodeIp").equals(nodeIp) || !oldNode.get("port").equals(port)) continue;
                        existFlag = Boolean.TRUE;
                        ArrayList<HashMap<String, String>> oldEfficientNodes = new ArrayList<HashMap<String, String>>();
                        oldEfficientNodes.addAll(GsonUtil.toListMap((String)GsonUtil.toJson(oldNode.get("efficientNodes"))));
                        oldEfficientNodes.add(efficientNode);
                        oldNode.put("efficientNodes", oldEfficientNodes);
                        oldNode.put("efficientNodeCount", oldEfficientNodes.size() + "");
                        break;
                    }
                    if (Boolean.TRUE.equals(existFlag)) {
                        existFlag = Boolean.FALSE;
                    } else {
                        oldNodes.add(node);
                    }
                    clusters.put(clusterId, oldNodes);
                }
                this.cacheClient.set(this.constantBaseVersion.getWEB_NODES(), (Object)GsonUtil.toJson(clusters));
                log.info("\u5f02\u6b65\u5bb9\u5668\u8282\u70b9\u521d\u59cb\u5316\u5b8c\u6210\uff01");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                log.info("\u5f02\u6b65\u5bb9\u5668\u8282\u70b9\u521d\u59cb\u5316\u5f02\u5e38\uff01 {}", (Object)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void clusterNodeMonitoring(String clusterNodeMonitoringNumber) {
        InitClusterMonitor initClusterMonitor = this;
        synchronized (initClusterMonitor) {
            if (this.adminClusterConfig.isMaster()) {
                Object obj = this.cacheClient.get(this.constantBaseVersion.getWEB_NODES());
                Map nodes = new HashMap();
                if (!ObjectUtils.isEmpty((Object)obj)) {
                    nodes = (Map)GsonUtil.fromJson((String)obj.toString(), Map.class);
                }
                HashSet<String> existNodeNames = new HashSet<String>();
                for (Map.Entry cluster : nodes.entrySet()) {
                    String clusterId = (String)cluster.getKey();
                    ArrayList<Map> nodeInfos = new ArrayList<Map>();
                    for (Object node : (List)cluster.getValue()) {
                        Object nodeNowInfo;
                        String nodeName;
                        Map nodeInfo = GsonUtil.toObjectMap((String)GsonUtil.toJson(node));
                        String nodeIp = nodeInfo.get("nodeIp").toString();
                        String port = nodeInfo.get("port").toString();
                        ArrayList efficientNodes = new ArrayList();
                        efficientNodes.addAll(GsonUtil.fromList((String)GsonUtil.toJson(nodeInfo.get("efficientNodes")), Object[].class));
                        ArrayList<Map> invalidNodes = new ArrayList<Map>();
                        invalidNodes.addAll(GsonUtil.fromList((String)GsonUtil.toJson(nodeInfo.get("invalidNodes")), Object[].class));
                        ArrayList<Map> efficientUpdateNodes = new ArrayList<Map>();
                        ArrayList<Map> invalidUpdateNodes = new ArrayList<Map>();
                        String baseNodeName = this.constantBaseVersion.getWEB_NODES_HEARTBEAT() + clusterId + "-" + nodeIp + "-" + port;
                        if (Boolean.FALSE.equals(this.hashTags)) {
                            baseNodeName = baseNodeName.replace("{", "").replace("}", "");
                        }
                        for (Object e : efficientNodes) {
                            Map efficientNodeInfo = GsonUtil.toObjectMap((String)GsonUtil.toJson(e));
                            nodeName = baseNodeName + "-" + efficientNodeInfo.get("name");
                            nodeNowInfo = this.cacheClient.get(nodeName);
                            existNodeNames.add(nodeName);
                            if (ObjectUtils.isEmpty((Object)nodeNowInfo)) {
                                log.error("web\u8282\u70b9\u5f02\u5e38\uff1a" + nodeName);
                                efficientNodeInfo.put("validFlag", "0");
                                efficientNodeInfo.put("remark", "\u8bbf\u95ee\u5931\u8d25:" + DateUtil.formatDateWithMS((Date)new Date()));
                                invalidNodes.add(efficientNodeInfo);
                                this.adminClusterConfig.getCoreHeart().remove(nodeName);
                                continue;
                            }
                            efficientNodeInfo.put("remark", "\u5237\u65b0\u6210\u529f:" + DateUtil.formatDateWithMS((Date)new Date()));
                            efficientUpdateNodes.add(efficientNodeInfo);
                        }
                        for (Object e : invalidNodes) {
                            Map invalidNodeInfo = GsonUtil.toObjectMap((String)GsonUtil.toJson(e));
                            nodeName = baseNodeName + "-" + invalidNodeInfo.get("name");
                            nodeNowInfo = this.cacheClient.get(nodeName);
                            existNodeNames.add(nodeName);
                            if (!ObjectUtils.isEmpty((Object)nodeNowInfo)) {
                                invalidNodeInfo.put("validFlag", "1");
                                invalidNodeInfo.put("remark", "\u5237\u65b0\u6210\u529f:" + DateUtil.formatDateWithMS((Date)new Date()));
                                efficientUpdateNodes.add(invalidNodeInfo);
                                this.adminClusterConfig.getCoreHeart().add(nodeName);
                                continue;
                            }
                            invalidUpdateNodes.add(invalidNodeInfo);
                            this.adminClusterConfig.getCoreHeart().remove(nodeName);
                        }
                        String finalBaseNodeName = baseNodeName;
                        List list = this.adminClusterConfig.getCoreHeart().stream().filter(item -> item.contains(finalBaseNodeName)).collect(Collectors.toList());
                        for (String possibleNodeName : list) {
                            if (existNodeNames.contains(possibleNodeName)) continue;
                            nodeNowInfo = this.cacheClient.get(possibleNodeName);
                            if (ObjectUtils.isEmpty((Object)nodeNowInfo)) {
                                log.error("\u9057\u6f0fweb\u8282\u70b9\u5f02\u5e38\uff1a" + possibleNodeName);
                                this.adminClusterConfig.getCoreHeart().remove(possibleNodeName);
                                continue;
                            }
                            HashMap<String, String> newEfficientNode = new HashMap<String, String>();
                            newEfficientNode.put("createUserId", "1");
                            newEfficientNode.put("updateUserId", "1");
                            newEfficientNode.put("validFlag", "0");
                            newEfficientNode.put("startTime", DateUtil.formatDateWithMS((Date)new Date()));
                            newEfficientNode.put("name", "<" + StringUtils.substringAfter((String)possibleNodeName, (String)"<"));
                            newEfficientNode.put("remark", "\u5237\u65b0\u6210\u529f:" + DateUtil.formatDateWithMS((Date)new Date()));
                            newEfficientNode.put("resUsingRate", "0");
                            log.error("\u9057\u6f0fweb\u8282\u70b9\u52a0\u5165\uff1a" + possibleNodeName);
                            efficientUpdateNodes.add(newEfficientNode);
                        }
                        nodeInfo.put("efficientNodes", efficientUpdateNodes);
                        nodeInfo.put("invalidNodes", invalidUpdateNodes);
                        nodeInfo.put("efficientNodeCount", efficientUpdateNodes.size() + "");
                        nodeInfo.put("invalidNodeCount", invalidUpdateNodes.size() + "");
                        nodeInfos.add(nodeInfo);
                    }
                    nodes.put(clusterId, nodeInfos);
                }
                this.cacheClient.set(this.constantBaseVersion.getWEB_NODES(), (Object)GsonUtil.toJson(nodes), Integer.parseInt(clusterNodeMonitoringNumber) + 2);
            }
        }
    }

    private Map<String, String> congestionClusterNodeDeal(RedisSyncDataBo redisSyncDataBo, Map<String, String> nodePo) {
        if (redisSyncDataBo.getNodeIp().equals(nodePo.get("nodeIp")) && redisSyncDataBo.getPort().equals(nodePo.get("port"))) {
            nodePo.put("validFlag", "1");
            nodePo.put("congestedStatus", "0");
            nodePo.put("remark", DateUtil.formatDateWithMS((Date)new Date()));
        } else {
            nodePo.put("validFlag", "0");
            nodePo.put("congestedStatus", "2");
            nodePo.put("remark", "\u8282\u70b9\u62e5\u585e:" + DateUtil.formatDateWithMS((Date)new Date()));
            log.error("\u8282\u70b9\u540d\u79f0\u4e0e\u6570\u636e\u4e0d\u4e00\u81f4\uff0c\u4fee\u6539\u6838\u5fc3\u8282\u70b9\u5931\u8d25\uff01 \u63a8\u9001\u8282\u70b9\u540d\u79f0:{}  ip:port:{}", (Object)(redisSyncDataBo.getNodeIp() + redisSyncDataBo.getPort()), (Object)(nodePo.get("nodeIp") + nodePo.get("port")));
        }
        return nodePo;
    }
}

