/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Maps;
import com.google.gson.internal.LinkedTreeMap;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.portalcommon.util.GsonUtil;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.StringUtils;

public class TransUtil {
    private static final String SCHEMA_KEY = "$schema";
    private static final String SCHEMA_TYPE = "type";
    private static final String SCHEMA_PROPERTIES = "properties";
    private static final String SCHEMA_DESCRIPTION = "description";
    private static final String SCHEMA_ITEMS = "items";
    private static final String SCHEMA_PATH_SEPARATOR = "/";
    private static final String SCHEMA_OBJECT = "object";
    private static final String SCHEMA_ARRAY = "array";
    private static final String SCHEMA_STRING = "string";

    public static String jsonTrans(String str, String flag) {
        TransObj root = TransUtil.json2Obj(str);
        String transJson = TransUtil.obj2Model(root, flag);
        return transJson;
    }

    private static TransObj json2Obj(String json) {
        Map map = (Map)GsonUtil.fromJson((String)json, Map.class);
        Map propertiesMap = (Map)map.get(SCHEMA_PROPERTIES);
        TransObj root = null;
        if (propertiesMap != null) {
            root = new TransObj();
            root.setType(SCHEMA_OBJECT);
            HashMap properties = Maps.newHashMap();
            for (Map.Entry entry : propertiesMap.entrySet()) {
                Map value = (Map)entry.getValue();
                if (value == null) continue;
                try {
                    TransObj tmp = TransUtil.map2Obj(value, false);
                    properties.put(entry.getKey(), tmp);
                }
                catch (ZTBusinessException e) {
                    throw new ZTBusinessException("\u8282\u70b9\u8def\u5f84/" + (String)entry.getKey() + e.getMessage());
                }
            }
            root.setProperties(properties);
        }
        return root;
    }

    private static TransObj map2Obj(Map map, boolean isItem) {
        TransObj transObj = null;
        String type = (String)map.get(SCHEMA_TYPE);
        if (type.equalsIgnoreCase(SCHEMA_OBJECT)) {
            Map propertiesMap = (Map)map.get(SCHEMA_PROPERTIES);
            if (propertiesMap == null) {
                throw new ZTBusinessException(" : \u5bf9\u8c61\u914d\u7f6e\u9519\u8bef");
            }
            transObj = new TransObj();
            transObj.setType(type);
            HashMap properties = Maps.newHashMap();
            for (Map.Entry entry : propertiesMap.entrySet()) {
                Map value = (Map)entry.getValue();
                if (value == null) continue;
                try {
                    TransObj tmp = TransUtil.map2Obj(value, isItem);
                    properties.put(entry.getKey(), tmp);
                }
                catch (ZTBusinessException e) {
                    throw new ZTBusinessException(SCHEMA_PATH_SEPARATOR + (String)entry.getKey() + e.getMessage());
                }
            }
            transObj.setProperties(properties);
        } else if (type.equalsIgnoreCase(SCHEMA_ARRAY)) {
            Map itemsMap = (Map)map.get(SCHEMA_ITEMS);
            String path = (String)map.get(SCHEMA_DESCRIPTION);
            if (!isItem && StringUtils.isEmpty((Object)path)) {
                throw new ZTBusinessException(" : \u8def\u5f84\u6ca1\u6709\u914d\u7f6e");
            }
            if (!path.startsWith(SCHEMA_PATH_SEPARATOR)) {
                throw new ZTBusinessException(" : \u8def\u5f84\u8def\u5f84\u914d\u7f6e\u9519\u8bef");
            }
            if (itemsMap == null) {
                throw new ZTBusinessException(" : \u6570\u7ec4\u914d\u7f6e\u9519\u8bef");
            }
            transObj = new TransObj();
            transObj.setType(type);
            if (isItem) {
                return transObj;
            }
            transObj.setPath(path);
            try {
                TransObj tmp = TransUtil.map2Obj(itemsMap, true);
                transObj.setItems(tmp);
            }
            catch (ZTBusinessException e) {
                throw new ZTBusinessException("/items" + e.getMessage());
            }
        } else {
            String path = (String)map.get(SCHEMA_DESCRIPTION);
            if (!isItem && StringUtils.isEmpty((Object)path)) {
                throw new ZTBusinessException(" : \u8def\u5f84\u6ca1\u6709\u914d\u7f6e");
            }
            if (!path.startsWith(SCHEMA_PATH_SEPARATOR)) {
                throw new ZTBusinessException(" : \u8def\u5f84\u8def\u5f84\u914d\u7f6e\u9519\u8bef");
            }
            transObj = new TransObj();
            transObj.setType(type);
            transObj.setPath(path);
        }
        return transObj;
    }

    private static String obj2Model(TransObj transObj, String flag) {
        Map<String, TransObj> properties = transObj.getProperties();
        StringBuilder sb = new StringBuilder();
        if ("json".equals(flag)) {
            sb.append("{");
            for (Map.Entry<String, TransObj> entry : properties.entrySet()) {
                sb.append(TransUtil.obj2Str(entry.getKey(), entry.getValue(), flag, false));
                sb.append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append("}");
        } else {
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
            sb.append("<xml>");
            for (Map.Entry<String, TransObj> entry : properties.entrySet()) {
                sb.append(TransUtil.obj2Str(entry.getKey(), entry.getValue(), flag, false));
            }
            sb.append("</xml>");
        }
        return sb.toString();
    }

    private static String obj2Str(String key, TransObj transObj, String flag, boolean isItem) {
        String type = transObj.getType();
        StringBuilder sb = new StringBuilder();
        if (type.equalsIgnoreCase(SCHEMA_OBJECT)) {
            Map<String, TransObj> properties = transObj.getProperties();
            if ("json".equals(flag)) {
                if (key != null) {
                    sb.append("\"");
                    sb.append(key);
                    sb.append("\":{");
                } else {
                    sb.append("{");
                }
                for (Map.Entry<String, TransObj> entry : properties.entrySet()) {
                    sb.append(TransUtil.obj2Str(entry.getKey(), entry.getValue(), flag, isItem));
                    sb.append(",");
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.append("}");
            } else {
                if (key != null) {
                    sb.append("<");
                    sb.append(key);
                    sb.append(">");
                }
                for (Map.Entry<String, TransObj> entry : properties.entrySet()) {
                    sb.append(TransUtil.obj2Str(entry.getKey(), entry.getValue(), flag, isItem));
                }
                if (key != null) {
                    sb.append("</");
                    sb.append(key);
                    sb.append(">");
                }
            }
        } else if (type.equalsIgnoreCase(SCHEMA_ARRAY)) {
            if (isItem) {
                return "";
            }
            TransObj items = transObj.getItems();
            String path = transObj.getPath();
            if ("json".equals(flag)) {
                sb.append("\"");
                sb.append(key);
                sb.append("\":");
                sb.append("[");
                String bool = "json".equals(flag) ? "true" : "false";
                sb.append("{esb:list isjson=" + bool + " path=\"" + path + "\"}\n");
                sb.append(TransUtil.obj2Str(null, items, flag, true));
                sb.append("{/esb:list}\n");
                sb.append("]");
            } else {
                String bool = "json".equals(flag) ? "true" : "false";
                sb.append("{esb:list isjson=" + bool + " path=\"" + path + "\"}\n");
                sb.append("<");
                sb.append(key);
                sb.append(">");
                sb.append(TransUtil.obj2Str(null, items, flag, true));
                sb.append("</");
                sb.append(key);
                sb.append(">");
                sb.append("{/esb:list}\n");
            }
        } else if (type.equalsIgnoreCase(SCHEMA_STRING)) {
            String path = transObj.getPath();
            if ("json".equals(flag)) {
                sb.append("\"");
                sb.append(key);
                sb.append("\":");
                sb.append("\"");
                sb.append("{esb:entity path=\"" + path + "\"}");
                sb.append("\"\n");
            } else {
                sb.append("<");
                sb.append(key);
                sb.append(">");
                sb.append("{esb:entity path=\"" + path + "\"}");
                sb.append("\"\n");
                sb.append("</");
                sb.append(key);
                sb.append(">");
            }
        } else {
            String path = transObj.getPath();
            if ("json".equals(flag)) {
                sb.append("\"");
                sb.append(key);
                sb.append("\":");
                sb.append("{esb:entity path=\"" + path + "\"}\n");
            } else {
                sb.append("<");
                sb.append(key);
                sb.append(">");
                sb.append("{esb:entity path=\"" + path + "\"}\n");
                sb.append("</");
                sb.append(key);
                sb.append(">");
            }
        }
        return sb.toString();
    }

    public static Map parseBaseSchema(JsonNode jsonNode, String path, String name) {
        StringBuffer url = TransUtil.getUrl(path, name);
        LinkedTreeMap map = new LinkedTreeMap();
        map.put(SCHEMA_TYPE, jsonNode.get(SCHEMA_TYPE).asText());
        map.put(SCHEMA_DESCRIPTION, url.toString());
        return map;
    }

    public static Map parseArraSchema(JsonNode jsonNode, String path, String name) {
        StringBuffer url = TransUtil.getUrl(path, name);
        LinkedTreeMap map = new LinkedTreeMap();
        map.put(SCHEMA_TYPE, jsonNode.get(SCHEMA_TYPE).asText());
        map.put(SCHEMA_DESCRIPTION, url.toString());
        JsonNode itemes = jsonNode.get(SCHEMA_ITEMS);
        switch (itemes.get(SCHEMA_TYPE).asText()) {
            case "object": {
                map.put(SCHEMA_ITEMS, TransUtil.parseSchema(itemes, url.toString(), ""));
                break;
            }
            case "array": {
                map.put(SCHEMA_ITEMS, TransUtil.parseArraSchema(itemes, url.toString(), ""));
                break;
            }
            default: {
                map.put(SCHEMA_ITEMS, TransUtil.parseBaseSchema(itemes, url.toString(), ""));
            }
        }
        return map;
    }

    public static Map parseSchema(JsonNode jsonNode, String path, String name) {
        LinkedTreeMap map = new LinkedTreeMap();
        LinkedTreeMap childMap = new LinkedTreeMap();
        StringBuffer url = TransUtil.getUrl(path, name);
        if (url.length() > 0) {
            map.put(SCHEMA_TYPE, jsonNode.get(SCHEMA_TYPE).asText());
        } else {
            map.put(SCHEMA_KEY, jsonNode.get(SCHEMA_KEY).asText());
            map.put(SCHEMA_TYPE, jsonNode.get(SCHEMA_TYPE).asText());
        }
        JsonNode nodes = jsonNode.get(SCHEMA_PROPERTIES);
        nodes.fieldNames().forEachRemaining(arg_0 -> TransUtil.lambda$parseSchema$0(nodes, (Map)childMap, url, arg_0));
        map.put(SCHEMA_PROPERTIES, childMap);
        return map;
    }

    public static StringBuffer getUrl(String path, String name) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!StringUtils.isEmpty((Object)path)) {
            stringBuffer.append(path);
        }
        if (!StringUtils.isEmpty((Object)name)) {
            stringBuffer.append(SCHEMA_PATH_SEPARATOR).append(name);
        }
        return stringBuffer;
    }

    public static void main(String[] args) {
        String str = "{\"$schema\":\"http://json-schema.org/draft-04/schema#\",\"type\":\"object\",\"properties\":{\"ATTACHED\":{\"type\":\"string\",\"description\":\"/UNI_BSS_ATTACHED\"},\"BODY\":{\"type\":\"string\",\"description\":\"/UNI_BSS_BODY\"},\"HEAD\":{\"type\":\"object\",\"properties\":{\"APP_ID\":{\"type\":\"string\",\"description\":\"/UNI_BSS_HEAD/APP_ID\"},\"RESERVED\":{\"type\":\"array\",\"description\":\"/UNI_BSS_HEAD/RESERVED\",\"items\":{\"type\":\"object\",\"properties\":{\"RESERVED_ID\":{\"type\":\"string\",\"description\":\"/UNI_BSS_HEAD/RESERVED/RESERVED_ID\"},\"RESERVED_VALUE\":{\"type\":\"string\",\"description\":\"/UNI_BSS_HEAD/RESERVED/RESERVED_VALUE\"}}}},\"TIMESTAMP\":{\"type\":\"string\",\"description\":\"/UNI_BSS_HEAD/TIMESTAMP\"},\"TOKEN\":{\"type\":\"number\",\"description\":\"/UNI_BSS_HEAD/TOKEN\"},\"TRANS_ID\":{\"type\":\"boolean\",\"description\":\"/UNI_BSS_HEAD/TRANS_ID\"}}}}}";
        TransObj obj = TransUtil.json2Obj(str);
        String ssss = TransUtil.obj2Model(obj, "xml");
        System.out.println(obj);
        System.out.println(ssss);
        System.out.println(TransUtil.jsonTrans(str, "json"));
    }

    private static /* synthetic */ void lambda$parseSchema$0(JsonNode nodes, Map childMap, StringBuffer url, String k) {
        JsonNode node = nodes.get(k);
        switch (node.get(SCHEMA_TYPE).asText()) {
            case "object": {
                childMap.put(k, TransUtil.parseSchema(nodes.get(k), url.toString(), k));
                break;
            }
            case "array": {
                childMap.put(k, TransUtil.parseArraSchema(nodes.get(k), url.toString(), k));
                break;
            }
            default: {
                childMap.put(k, TransUtil.parseBaseSchema(nodes.get(k), url.toString(), k));
            }
        }
    }

    static class TransObj {
        private String type;
        private Map<String, TransObj> properties;
        private String path;
        private TransObj items;

        public String getType() {
            return this.type;
        }

        public Map<String, TransObj> getProperties() {
            return this.properties;
        }

        public String getPath() {
            return this.path;
        }

        public TransObj getItems() {
            return this.items;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setProperties(Map<String, TransObj> properties) {
            this.properties = properties;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setItems(TransObj items) {
            this.items = items;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransObj)) {
                return false;
            }
            TransObj other = (TransObj)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Map<String, TransObj> this$properties = this.getProperties();
            Map<String, TransObj> other$properties = other.getProperties();
            if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            TransObj this$items = this.getItems();
            TransObj other$items = other.getItems();
            return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TransObj;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Map<String, TransObj> $properties = this.getProperties();
            result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            TransObj $items = this.getItems();
            result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
            return result;
        }

        public String toString() {
            return "TransUtil.TransObj(type=" + this.getType() + ", properties=" + this.getProperties() + ", path=" + this.getPath() + ", items=" + this.getItems() + ")";
        }
    }
}

