/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.ability.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.abilityadmin.ability.model.bo.QryAbilityParameterFormatReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.QryAbilityParameterFormatRspBO;
import com.ohaotian.abilityadmin.ability.model.bo.QryAbilityParameterReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.QryAbilityParameterRspBO;
import com.ohaotian.abilityadmin.ability.model.bo.QryAbilityParameterTemplateReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.QryAbilityParameterTemplateRspBO;
import com.ohaotian.abilityadmin.ability.service.AbilityParameterService;
import com.ohaotian.abilityadmin.ability.service.impl.AbilityTestServiceImpl;
import com.ohaotian.abilityadmin.component.deploy.AbilitySvcComponent;
import com.ohaotian.abilityadmin.mapper.AbilityExtMapper;
import com.ohaotian.abilityadmin.mapper.AbilityMapper;
import com.ohaotian.abilityadmin.mapper.AbilityModifyMapper;
import com.ohaotian.abilityadmin.mapper.AbilityParamMapper;
import com.ohaotian.abilityadmin.mapper.AbilityWsExtMapper;
import com.ohaotian.abilityadmin.model.po.AbilityExtPO;
import com.ohaotian.abilityadmin.model.po.AbilityModifyPO;
import com.ohaotian.abilityadmin.model.po.AbilityPO;
import com.ohaotian.abilityadmin.model.po.AbilityParamPO;
import com.ohaotian.abilityadmin.model.po.AbilityWsExtPO;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.piscesplatform.mapper.AbilityInterfaceTaskMapper;
import com.ohaotian.piscesplatform.mapper.AbilityParamTargetMapper;
import com.ohaotian.piscesplatform.model.bo.InsertTaskReqBo;
import com.ohaotian.piscesplatform.model.po.AbilityInterfaceTaskPo;
import com.ohaotian.piscesplatform.model.po.AbilityParamTargetPo;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.portalcommon.enums.AbilityOperateTypeEnum;
import com.ohaotian.portalcommon.model.bo.OptionGenerRspBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.util.GsonUtil;
import com.ohaotian.portalcommon.util.JaxbUtil;
import com.ohaotian.portalcommon.util.ObjectUtil;
import com.ohaotian.portalcommon.util.ValidBatchUtils;
import com.ohaotian.portalcommon.util.json.JSONUtil;
import com.ohaotian.portalcommon.util.xml.XMLUtil;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class AbilityParameterServiceImpl
implements AbilityParameterService {
    @Resource
    AbilityMapper abilityMapper;
    @Resource
    AbilityParamMapper abilityParamMapper;
    @Resource
    AbilitySvcComponent abilitySvcComponent;
    @Resource
    AbilityExtMapper abilityExtMapper;
    @Resource
    AbilityModifyMapper abilityModifyMapper;
    @Resource
    AbilityWsExtMapper abilityWsExtMapper;
    @Resource
    AbilityParamTargetMapper abilityParamTargetMapper;
    @Resource
    AbilityInterfaceTaskMapper abilityInterfaceTaskMapper;

    @Override
    public QryAbilityParameterRspBO abilityParameter(QryAbilityParameterReqBO qryAbilityParameterReqBO) {
        AbilityParamPO abilityParamPO = new AbilityParamPO();
        abilityParamPO.setAbilityId(qryAbilityParameterReqBO.getAbilityId());
        AbilityParamPO abilityParamRsp = this.abilityParamMapper.queryLimitOne(abilityParamPO);
        if (ObjectUtils.isEmpty((Object)abilityParamPO)) {
            throw new ZTBusinessException("\u4e0d\u5b58\u5728\u80fd\u529b\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\uff01");
        }
        AbilityParamTargetPo abilityParamTargetPo = new AbilityParamTargetPo();
        abilityParamTargetPo.setAbilityId(qryAbilityParameterReqBO.getAbilityId());
        AbilityParamTargetPo abilityParamTargetRsp = this.abilityParamTargetMapper.queryLimitOne(abilityParamTargetPo);
        QryAbilityParameterRspBO qryAbilityParameterRspBO = (QryAbilityParameterRspBO)BeanMapper.map((Object)abilityParamRsp, QryAbilityParameterRspBO.class);
        qryAbilityParameterRspBO.setTargetReqXsd(abilityParamTargetRsp.getTargetReqXsd());
        qryAbilityParameterRspBO.setTargetRspXsd(abilityParamTargetRsp.getTargetRspXsd());
        qryAbilityParameterRspBO.setTargetReqJsonschema(abilityParamTargetRsp.getTargetReqJsonschema());
        qryAbilityParameterRspBO.setTargetRspJsonschema(abilityParamTargetRsp.getTargetRspJsonschema());
        qryAbilityParameterRspBO.setTargetReqJsonTemplate(abilityParamTargetRsp.getTargetReqJsonTemplate());
        qryAbilityParameterRspBO.setTargetRspJsonTemplate(abilityParamTargetRsp.getTargetRspJsonTemplate());
        qryAbilityParameterRspBO.setReqRootNodeName("xml");
        qryAbilityParameterRspBO.setRspRootNodeName("xml");
        qryAbilityParameterRspBO.setTargetReqRootNodeName("xml");
        qryAbilityParameterRspBO.setTargetRspRootNodeName("xml");
        AbilityWsExtPO abilityWsExtPO = this.abilityWsExtMapper.queryByAbilityId(qryAbilityParameterReqBO.getAbilityId());
        if (abilityWsExtPO != null) {
            qryAbilityParameterRspBO.setWsdl(abilityWsExtPO.getAbilityWsdl());
        }
        AbilityPO abilityPO = this.abilityMapper.queryByAbilityId(qryAbilityParameterReqBO.getAbilityId());
        List<String> inputProtocaList = Arrays.asList(abilityPO.getInputProtocal().split(","));
        qryAbilityParameterRspBO.setInputProtocaList(inputProtocaList);
        return qryAbilityParameterRspBO;
    }

    @Override
    public Map<String, Map<String, JSONObject>> getDocxTemplate(InsertTaskReqBo insertTaskReqBo) {
        HashMap<String, Map<String, JSONObject>> docxTemplate = new HashMap<String, Map<String, JSONObject>>();
        HashMap req = new HashMap();
        HashMap rsp = new HashMap();
        List<QryAbilityParameterRspBO> parameterRspBOList = this.abilityParameterList(insertTaskReqBo);
        parameterRspBOList.forEach(qryAbilityParameterRspBO -> {
            String abilityEname = this.abilityMapper.queryAbilityRspByAbilityId(qryAbilityParameterRspBO.getAbilityId()).getAbilityEname();
            if (insertTaskReqBo.getReqOrRsp() == 1) {
                req.put(abilityEname, this.getAbilityDocxTemplate(qryAbilityParameterRspBO.getTargetReqJsonschema(), qryAbilityParameterRspBO.getAbilityId()));
            } else if (insertTaskReqBo.getReqOrRsp() == 2) {
                rsp.put(abilityEname, this.getAbilityDocxTemplate(qryAbilityParameterRspBO.getTargetRspJsonschema(), qryAbilityParameterRspBO.getAbilityId()));
            } else if (insertTaskReqBo.getReqOrRsp() == 3) {
                req.put(abilityEname, this.getAbilityDocxTemplate("{}", qryAbilityParameterRspBO.getAbilityId()));
            } else if (insertTaskReqBo.getReqOrRsp() == 4) {
                rsp.put(abilityEname, this.getAbilityDocxTemplate("{}", qryAbilityParameterRspBO.getAbilityId()));
            } else {
                throw new ZTBusinessException("\u8bf7\u6307\u5b9a\u751f\u6210\u6a21\u677f\u7684\u9636\u6bb5\u7c7b\u578b");
            }
        });
        if (req.isEmpty() && Boolean.FALSE.equals(rsp.isEmpty())) {
            docxTemplate.put("rsp", rsp);
        } else if (rsp.isEmpty() && Boolean.FALSE.equals(req.isEmpty())) {
            docxTemplate.put("req", req);
        } else {
            throw new ZTBusinessException("\u751f\u6210\u6a21\u677f\u51fa\u9519\u4e86\uff0c\u6570\u636e\u4e3a\u7a7a\u6216\u6570\u636e\u51b2\u7a81");
        }
        return docxTemplate;
    }

    public JSONObject getAbilityDocxTemplate(String jsonschema, Long abilityId) {
        JSONObject jsonObject = JSON.parseObject((String)jsonschema);
        if (jsonObject.isEmpty()) {
            JSONObject properties = new JSONObject();
            JSONObject childString = new JSONObject();
            childString.put("type", (Object)"String");
            properties.put("filed1", (Object)childString);
            jsonObject.put("properties", (Object)properties);
        } else {
            JSONObject properties = (JSONObject)jsonObject.get((Object)"properties");
            jsonObject.put("properties", (Object)this.getChildProperties(properties));
        }
        jsonObject.put("title", (Object)(abilityId + "##"));
        jsonObject.put("abilityId", (Object)abilityId);
        if (jsonObject.get((Object)"type") != null) {
            jsonObject.put("type", (Object)(jsonObject.get((Object)"type").toString().equals("object") ? "Object" : "Array"));
        } else {
            jsonObject.put("type", (Object)"Object");
        }
        return jsonObject;
    }

    public JSONObject getChildProperties(JSONObject obj) {
        if (obj == null) {
            return null;
        }
        for (Map.Entry entry : obj.entrySet()) {
            String key = (String)entry.getKey();
            JSONObject value = (JSONObject)entry.getValue();
            String type = value.get((Object)"type").toString();
            value.put("type", (Object)this.getDocxType(type));
            if ("object".equals(type) && value.get((Object)"properties") != null) {
                value.put("properties", (Object)this.getChildProperties((JSONObject)value.get((Object)"properties")));
            } else if ("array".equals(type)) {
                if (value.get((Object)"items") != null) {
                    JSONObject items = (JSONObject)value.get((Object)"items");
                    String itemsType = items.get((Object)"type").toString();
                    items.put("type", (Object)this.getDocxType(itemsType));
                    if ("object".equals(itemsType) && items.get((Object)"properties") != null) {
                        items.put("properties", (Object)this.getChildProperties((JSONObject)items.get((Object)"properties")));
                    }
                } else {
                    throw new ZTBusinessException(key + "\u7684\u6570\u7ec4\u7c7b\u578b\u4e2d\u6ca1\u6709\u6307\u5b9aitem\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6587\u6863\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
            }
            obj.put(key, (Object)value);
        }
        return obj;
    }

    public String getDocxType(String type) {
        if ("string".equals(type)) {
            return "String";
        }
        if ("integer".equals(type)) {
            return "Long";
        }
        if ("boolean".equals(type)) {
            return "Boolean";
        }
        if ("number".equals(type)) {
            return "BigDecimal";
        }
        if ("object".equals(type)) {
            return "Object";
        }
        if ("array".equals(type)) {
            return "Array";
        }
        throw new ZTBusinessException("jsonschema\u4e2d\u6ca1\u6709 " + type + " \u7c7b\u578b\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6587\u6863\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\uff01");
    }

    public JSONObject getChildProperties(String jsonTemplate) {
        JSONObject jsonObject = JSON.parseObject((String)jsonTemplate);
        JSONObject resultObject = new JSONObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            JSONObject childNumber;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                JSONObject childObject = new JSONObject();
                childObject.put("type", (Object)"Object");
                childObject.put("properties", (Object)this.getChildProperties(JSON.toJSONString(value)));
                resultObject.put(key, (Object)childObject);
                continue;
            }
            if (value instanceof List) {
                JSONObject childArray = new JSONObject();
                childArray.put("type", (Object)"Array");
                childArray.put("items", (Object)this.getChildItems(JSON.toJSONString(value)));
                resultObject.put(key, (Object)childArray);
                continue;
            }
            if (value instanceof CharSequence) {
                JSONObject childString = new JSONObject();
                childString.put("type", (Object)"String");
                resultObject.put(key, (Object)childString);
                continue;
            }
            if (value instanceof Long || value instanceof Integer) {
                JSONObject childLong = new JSONObject();
                childLong.put("type", (Object)"Long");
                resultObject.put(key, (Object)childLong);
                continue;
            }
            if (value instanceof Number) {
                childNumber = new JSONObject();
                childNumber.put("type", (Object)"BigDecimal");
                resultObject.put(key, (Object)childNumber);
                continue;
            }
            if (value instanceof Boolean) {
                childNumber = new JSONObject();
                childNumber.put("type", (Object)"Boolean");
                resultObject.put(key, (Object)childNumber);
                continue;
            }
            throw new ZTBusinessException("json\u6a21\u677f\u53c2\u6570\u65e0\u6cd5\u89e3\u6790\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5!");
        }
        if (jsonObject.isEmpty()) {
            JSONObject childString = new JSONObject();
            childString.put("type", (Object)"String");
            resultObject.put("filed1", (Object)childString);
        }
        return resultObject;
    }

    public JSONObject getChildItems(String value) {
        JSONArray array = JSON.parseArray((String)value);
        JSONObject resultObject = new JSONObject();
        if (array.isEmpty()) {
            resultObject.put("type", (Object)"Object");
            resultObject.put("properties", (Object)new JSONObject());
        } else {
            Object o = array.get(0);
            if (o instanceof Map) {
                resultObject.put("type", (Object)"Object");
                resultObject.put("properties", (Object)this.getChildProperties(JSON.toJSONString((Object)o)));
            } else if (o instanceof List) {
                resultObject.put("type", (Object)"Array");
                resultObject.put("items", (Object)this.getChildItems(JSON.toJSONString((Object)value)));
            } else if (o instanceof CharSequence) {
                resultObject.put("type", (Object)"String");
            } else if (o instanceof Long || o instanceof Integer) {
                resultObject.put("type", (Object)"Long");
            } else if (o instanceof Number) {
                resultObject.put("type", (Object)"BigDecimal");
            } else {
                throw new ZTBusinessException("json\u6a21\u677f\u4e0b\u6570\u7ec4\u53c2\u6570\u65e0\u6cd5\u89e3\u6790\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5!");
            }
        }
        return resultObject;
    }

    @Override
    public List<QryAbilityParameterRspBO> abilityParameterList(InsertTaskReqBo insertTaskReqBo) {
        ArrayList<QryAbilityParameterRspBO> qryAbilityParameterRspBOList = new ArrayList<QryAbilityParameterRspBO>();
        QryAbilityParameterReqBO qryAbilityParameterReqBO = new QryAbilityParameterReqBO();
        qryAbilityParameterReqBO.setAbilityId(insertTaskReqBo.getAbilityId());
        qryAbilityParameterRspBOList.add(this.formatParameterJson(this.abilityParameter(qryAbilityParameterReqBO)));
        insertTaskReqBo.getTaskVersionInfo().getAbilityIdList().forEach(abilityId -> {
            QryAbilityParameterReqBO qryParamReqBO = new QryAbilityParameterReqBO();
            qryParamReqBO.setAbilityId((Long)abilityId);
            qryAbilityParameterRspBOList.add(this.formatParameterJson(this.abilityParameter(qryParamReqBO)));
        });
        Collections.reverse(qryAbilityParameterRspBOList);
        return qryAbilityParameterRspBOList;
    }

    public QryAbilityParameterRspBO formatParameterJson(QryAbilityParameterRspBO qryAbilityParameterRspBO) {
        qryAbilityParameterRspBO.setReqJsonschema(AbilityTestServiceImpl.fomatJson(qryAbilityParameterRspBO.getReqJsonschema()));
        qryAbilityParameterRspBO.setRspJsonschema(AbilityTestServiceImpl.fomatJson(qryAbilityParameterRspBO.getRspJsonschema()));
        qryAbilityParameterRspBO.setTargetReqJsonschema(AbilityTestServiceImpl.fomatJson(qryAbilityParameterRspBO.getTargetReqJsonschema()));
        qryAbilityParameterRspBO.setTargetRspJsonschema(AbilityTestServiceImpl.fomatJson(qryAbilityParameterRspBO.getTargetRspJsonschema()));
        return qryAbilityParameterRspBO;
    }

    @Override
    public RspBO checkTaskWithAbilityId(Long abilityId) {
        AbilityInterfaceTaskPo qryPo = new AbilityInterfaceTaskPo();
        qryPo.setAbilityId(abilityId);
        AbilityInterfaceTaskPo qryResultPo = this.abilityInterfaceTaskMapper.queryByTaskInfo(qryPo);
        if (Boolean.FALSE.equals(ObjectUtils.isEmpty((Object)qryResultPo))) {
            throw new ZTBusinessException("\u8be5\u4e3b\u80fd\u529b\u5df2\u7ecf\u5b58\u5728\u4efb\u52a1\u4e86\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u65b0\u5efa\uff01");
        }
        return RspBO.success((Object)"\u6821\u9a8c\u901a\u8fc7");
    }

    @Override
    @Transactional
    public void modReqParameter(QryAbilityParameterReqBO qryAbilityParameterReqBO) {
        Long userId = Long.valueOf(UserHolder.getUserId());
        AbilityParamPO abilityParamReq = (AbilityParamPO)BeanMapper.map((Object)qryAbilityParameterReqBO, AbilityParamPO.class);
        AbilityParamPO abilityParam = new AbilityParamPO();
        abilityParam.setAbilityId(abilityParamReq.getAbilityId());
        AbilityParamPO abilityParamPO = this.abilityParamMapper.queryLimitOne(abilityParam);
        abilityParamReq.setRspJsonschema(abilityParamPO.getRspJsonschema());
        AbilityParamTargetPo abilityParamTarget = new AbilityParamTargetPo();
        abilityParamTarget.setAbilityId(qryAbilityParameterReqBO.getAbilityId());
        AbilityParamTargetPo abilityParamTargetPo = this.abilityParamTargetMapper.queryLimitOne(abilityParamTarget);
        this.reCompile(abilityParamReq, abilityParamTargetPo);
        AbilityModifyPO abilityModifyPO = new AbilityModifyPO();
        abilityModifyPO.setAbilityId(abilityParamReq.getAbilityId());
        abilityModifyPO.setOperType(AbilityOperateTypeEnum.ABILITY_REQXSD_UPDATE.getValue());
        abilityModifyPO.setModifyRecord("");
        abilityModifyPO.setOperId(userId);
        abilityModifyPO.setOperTime(new Date());
        this.abilityModifyMapper.insertSelective(abilityModifyPO);
    }

    @Override
    @Transactional
    public void modRspParameter(QryAbilityParameterReqBO qryAbilityParameterReqBO) {
        Long userId = Long.valueOf(UserHolder.getUserId());
        AbilityParamPO abilityParamRsp = (AbilityParamPO)BeanMapper.map((Object)qryAbilityParameterReqBO, AbilityParamPO.class);
        AbilityParamPO abilityParam = new AbilityParamPO();
        abilityParam.setAbilityId(abilityParamRsp.getAbilityId());
        AbilityParamPO abilityParamPO = this.abilityParamMapper.queryLimitOne(abilityParam);
        abilityParamRsp.setReqJsonschema(abilityParamPO.getReqJsonschema());
        AbilityParamTargetPo abilityParamTarget = new AbilityParamTargetPo();
        abilityParamTarget.setAbilityId(qryAbilityParameterReqBO.getAbilityId());
        AbilityParamTargetPo abilityParamTargetPo = this.abilityParamTargetMapper.queryLimitOne(abilityParamTarget);
        this.reCompile(abilityParamRsp, abilityParamTargetPo);
        AbilityModifyPO abilityModifyPO = new AbilityModifyPO();
        abilityModifyPO.setAbilityId(abilityParamRsp.getAbilityId());
        abilityModifyPO.setOperType(AbilityOperateTypeEnum.ABILITY_RSPXSD_UPDATE.getValue());
        abilityModifyPO.setModifyRecord("");
        abilityModifyPO.setOperId(userId);
        abilityModifyPO.setOperTime(new Date());
        this.abilityModifyMapper.insertSelective(abilityModifyPO);
    }

    @Override
    @Transactional
    public void modTargetReqParameter(QryAbilityParameterReqBO qryAbilityParameterReqBO) {
        Long userId = Long.valueOf(UserHolder.getUserId());
        AbilityParamTargetPo abilityParamTargetReq = (AbilityParamTargetPo)BeanMapper.map((Object)qryAbilityParameterReqBO, AbilityParamTargetPo.class);
        AbilityParamPO abilityParam = new AbilityParamPO();
        abilityParam.setAbilityId(qryAbilityParameterReqBO.getAbilityId());
        AbilityParamPO abilityParamPO = this.abilityParamMapper.queryLimitOne(abilityParam);
        AbilityParamTargetPo abilityParamTarget = new AbilityParamTargetPo();
        abilityParamTarget.setAbilityId(abilityParamTargetReq.getAbilityId());
        AbilityParamTargetPo abilityParamTargetPo = this.abilityParamTargetMapper.queryLimitOne(abilityParamTarget);
        abilityParamTargetReq.setTargetRspJsonschema(abilityParamTargetPo.getTargetRspJsonschema());
        this.reCompile(abilityParamPO, abilityParamTargetReq);
        AbilityModifyPO abilityModifyPO = new AbilityModifyPO();
        abilityModifyPO.setAbilityId(abilityParamTargetReq.getAbilityId());
        abilityModifyPO.setOperType(AbilityOperateTypeEnum.ABILITY_TARGETREQXSD_UPDATE.getValue());
        abilityModifyPO.setModifyRecord("");
        abilityModifyPO.setOperId(userId);
        abilityModifyPO.setOperTime(new Date());
        this.abilityModifyMapper.insertSelective(abilityModifyPO);
    }

    @Override
    @Transactional
    public void modTargetRspParameter(QryAbilityParameterReqBO qryAbilityParameterReqBO) {
        Long userId = Long.valueOf(UserHolder.getUserId());
        AbilityParamTargetPo abilityParamTargetRsp = (AbilityParamTargetPo)BeanMapper.map((Object)qryAbilityParameterReqBO, AbilityParamTargetPo.class);
        AbilityParamPO abilityParam = new AbilityParamPO();
        abilityParam.setAbilityId(qryAbilityParameterReqBO.getAbilityId());
        AbilityParamPO abilityParamPO = this.abilityParamMapper.queryLimitOne(abilityParam);
        AbilityParamTargetPo abilityParamTarget = new AbilityParamTargetPo();
        abilityParamTarget.setAbilityId(abilityParamTargetRsp.getAbilityId());
        AbilityParamTargetPo abilityParamTargetPo = this.abilityParamTargetMapper.queryLimitOne(abilityParamTarget);
        abilityParamTargetRsp.setTargetReqJsonschema(abilityParamTargetPo.getTargetReqJsonschema());
        this.reCompile(abilityParamPO, abilityParamTargetRsp);
        AbilityModifyPO abilityModifyPO = new AbilityModifyPO();
        abilityModifyPO.setAbilityId(abilityParamTargetRsp.getAbilityId());
        abilityModifyPO.setOperType(AbilityOperateTypeEnum.ABILITY_TARGETRSPXSD_UPDATE.getValue());
        abilityModifyPO.setModifyRecord("");
        abilityModifyPO.setOperId(userId);
        abilityModifyPO.setOperTime(new Date());
        this.abilityModifyMapper.insertSelective(abilityModifyPO);
    }

    @Override
    @Transactional
    public void modWsdlParameter(QryAbilityParameterReqBO qryAbilityParameterReqBO) {
        Long userId = Long.valueOf(UserHolder.getUserId());
        ValidBatchUtils.isNotEmpty((Object)qryAbilityParameterReqBO, (String[])new String[]{"wsdl", "abilityId"});
        AbilityParamPO abilityParamRsp = (AbilityParamPO)BeanMapper.map((Object)qryAbilityParameterReqBO, AbilityParamPO.class);
        AbilityParamPO abilityParam = new AbilityParamPO();
        abilityParam.setAbilityId(abilityParamRsp.getAbilityId());
        AbilityParamPO abilityParamPO = this.abilityParamMapper.queryLimitOne(abilityParam);
        abilityParamRsp.setReqJsonschema(abilityParamPO.getReqJsonschema());
        AbilityWsExtPO abilityWsExtPO = new AbilityWsExtPO();
        abilityWsExtPO.setAbilityWsdl(qryAbilityParameterReqBO.getWsdl());
        abilityWsExtPO.setAbilityId(qryAbilityParameterReqBO.getAbilityId());
        this.abilityWsExtMapper.updateAbilityWsExtByAbilityId(abilityWsExtPO);
        this.reCompileWs(abilityParamRsp, abilityWsExtPO);
        AbilityModifyPO abilityModifyPO = new AbilityModifyPO();
        abilityModifyPO.setAbilityId(abilityParamRsp.getAbilityId());
        abilityModifyPO.setOperType(AbilityOperateTypeEnum.ABILITY_RSPXSD_UPDATE.getValue());
        abilityModifyPO.setModifyRecord("\u4fee\u6539ws\u80fd\u529bwsdl");
        abilityModifyPO.setOperId(userId);
        abilityModifyPO.setOperTime(new Date());
        this.abilityModifyMapper.insertSelective(abilityModifyPO);
    }

    @Override
    public QryAbilityParameterTemplateRspBO parameterTemplate(QryAbilityParameterTemplateReqBO qryAbilityParameterTemplateReqBO) {
        AbilityParamPO abilityParamPO = new AbilityParamPO();
        abilityParamPO.setAbilityId(qryAbilityParameterTemplateReqBO.getAbilityId());
        abilityParamPO = this.abilityParamMapper.queryLimitOne(abilityParamPO);
        if (abilityParamPO == null) {
            return null;
        }
        AbilityParamTargetPo abilityParamTargetPo = new AbilityParamTargetPo();
        abilityParamTargetPo.setAbilityId(qryAbilityParameterTemplateReqBO.getAbilityId());
        abilityParamTargetPo = this.abilityParamTargetMapper.queryLimitOne(abilityParamTargetPo);
        if (abilityParamTargetPo == null) {
            return null;
        }
        QryAbilityParameterTemplateRspBO qryAbilityParameterTemplateRspBO = new QryAbilityParameterTemplateRspBO();
        qryAbilityParameterTemplateRspBO.setAbilityId(abilityParamPO.getAbilityId());
        if (qryAbilityParameterTemplateReqBO.getParamType() == 1) {
            qryAbilityParameterTemplateRspBO.setReqTemplate(abilityParamPO.getReqXmlTemplate());
            qryAbilityParameterTemplateRspBO.setRspTemplate(abilityParamPO.getRspXmlTemplate());
            qryAbilityParameterTemplateRspBO.setTargetReqTemplate(abilityParamTargetPo.getTargetReqXmlTemplate());
            qryAbilityParameterTemplateRspBO.setTargetRspTemplate(abilityParamTargetPo.getTargetRspXmlTemplate());
        } else if (qryAbilityParameterTemplateReqBO.getParamType() == 2) {
            qryAbilityParameterTemplateRspBO.setReqTemplate(abilityParamPO.getReqWsTemplate());
            qryAbilityParameterTemplateRspBO.setRspTemplate(abilityParamPO.getRspWsTemplate());
            qryAbilityParameterTemplateRspBO.setTargetReqTemplate(abilityParamTargetPo.getTargetReqWsTemplate());
            qryAbilityParameterTemplateRspBO.setTargetRspTemplate(abilityParamTargetPo.getTargetRspWsTemplate());
        } else {
            qryAbilityParameterTemplateRspBO.setReqTemplate(abilityParamPO.getReqJsonTemplate());
            qryAbilityParameterTemplateRspBO.setRspTemplate(abilityParamPO.getRspJsonTemplate());
            qryAbilityParameterTemplateRspBO.setTargetReqTemplate(abilityParamTargetPo.getTargetReqJsonTemplate());
            qryAbilityParameterTemplateRspBO.setTargetRspTemplate(abilityParamTargetPo.getTargetRspJsonTemplate());
        }
        return qryAbilityParameterTemplateRspBO;
    }

    @Override
    public void generateParameterTemplate(Long abilityId, String reqJsonSchema, String rspJsonSchema, String reqXsd, String rspXsd, String reqJarPath, String reqClassName, String rspJarPath, String rspClassName) throws Exception {
        AbilityParamPO abilityParamPO = new AbilityParamPO();
        abilityParamPO.setAbilityId(abilityId);
        abilityParamPO.setReqJsonschema(reqJsonSchema);
        abilityParamPO.setReqXsd(reqXsd);
        abilityParamPO.setRspJsonschema(rspJsonSchema);
        abilityParamPO.setRespXsd(rspXsd);
        URL reqUrl = new File(reqJarPath).toURI().toURL();
        URL rspUrl = new File(rspJarPath).toURI().toURL();
        try (URLClassLoader loader = new URLClassLoader(new URL[]{reqUrl, rspUrl}, Thread.currentThread().getContextClassLoader());){
            Class<?> reqClass = loader.loadClass(reqClassName);
            Class<?> rspClass = loader.loadClass(rspClassName);
            Object repObject = ObjectUtil.getObject(reqClass);
            Object rspObject = ObjectUtil.getObject(rspClass);
            abilityParamPO.setReqJsonTemplate(GsonUtil.toJson((Object)repObject));
            abilityParamPO.setRspJsonTemplate(GsonUtil.toJson((Object)rspObject));
            abilityParamPO.setReqXmlTemplate(JaxbUtil.beanToXml((Object)repObject));
            abilityParamPO.setRspXmlTemplate(JaxbUtil.beanToXml((Object)rspObject));
            this.abilityParamMapper.updateByAbilityId(abilityParamPO);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        this.abilityParamMapper.updateByAbilityId(abilityParamPO);
    }

    @Override
    public void generateParameterTargetTemplate(Long abilityId, String targetReqJsonSchema, String targetRspJsonSchema, String targetReqXsd, String targetRspXsd, String targetReqJarPath, String targetReqClassName, String targetRspJarPath, String targetRspClassName) throws Exception {
        AbilityParamTargetPo abilityParamTargetPo = new AbilityParamTargetPo();
        abilityParamTargetPo.setAbilityId(abilityId);
        abilityParamTargetPo.setTargetReqJsonschema(targetReqJsonSchema);
        abilityParamTargetPo.setTargetReqXsd(targetReqXsd);
        abilityParamTargetPo.setTargetRspJsonschema(targetRspJsonSchema);
        abilityParamTargetPo.setTargetRspXsd(targetRspXsd);
        URL reqUrl = new File(targetReqJarPath).toURI().toURL();
        URL rspUrl = new File(targetRspJarPath).toURI().toURL();
        try (URLClassLoader loader = new URLClassLoader(new URL[]{reqUrl, rspUrl}, Thread.currentThread().getContextClassLoader());){
            Class<?> reqClass = loader.loadClass(targetReqClassName);
            Class<?> rspClass = loader.loadClass(targetRspClassName);
            Object repObject = ObjectUtil.getObject(reqClass);
            Object rspObject = ObjectUtil.getObject(rspClass);
            abilityParamTargetPo.setTargetReqJsonTemplate(GsonUtil.toJson((Object)repObject));
            abilityParamTargetPo.setTargetRspJsonTemplate(GsonUtil.toJson((Object)rspObject));
            abilityParamTargetPo.setTargetReqXmlTemplate(JaxbUtil.beanToXml((Object)repObject));
            abilityParamTargetPo.setTargetRspXmlTemplate(JaxbUtil.beanToXml((Object)rspObject));
            this.abilityParamTargetMapper.updateByAbilityId(abilityParamTargetPo);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        this.abilityParamTargetMapper.updateByAbilityId(abilityParamTargetPo);
    }

    @Override
    public List<OptionGenerRspBO<String, Integer>> paramType(QryAbilityParameterTemplateReqBO qryAbilityParameterTemplateReqBO) {
        ArrayList paramType = new ArrayList();
        AbilityPO abilityPO = this.abilityMapper.queryByAbilityId(qryAbilityParameterTemplateReqBO.getAbilityId());
        List<String> inputProtocaList = Arrays.asList(abilityPO.getInputProtocal().split(","));
        inputProtocaList.stream().forEach(in -> {
            OptionGenerRspBO<String, Integer> optionGener = this.getOptionGener((String)in);
            paramType.add(optionGener);
        });
        return paramType.stream().sorted(Comparator.comparing(OptionGenerRspBO::getValue)).collect(Collectors.toList());
    }

    @Override
    public RspBO<QryAbilityParameterFormatRspBO> paramFormat(QryAbilityParameterFormatReqBO qryAbilityParameterFormatReqBO) {
        if (StringUtils.isEmpty((Object)qryAbilityParameterFormatReqBO.getReqText())) {
            throw new ZTBusinessException("\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)qryAbilityParameterFormatReqBO.getParamType())) {
            throw new ZTBusinessException("\u4f20\u5165\u53c2\u6570\u7c7b\u578b\u4e3a\u7a7a");
        }
        String s = "";
        try {
            switch (qryAbilityParameterFormatReqBO.getParamType()) {
                case 0: {
                    s = JSONUtil.fomateByFastJson((String)qryAbilityParameterFormatReqBO.getReqText());
                    break;
                }
                case 1: {
                    s = XMLUtil.fomateXml((String)qryAbilityParameterFormatReqBO.getReqText());
                    break;
                }
                default: {
                    s = qryAbilityParameterFormatReqBO.getReqText();
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u683c\u5f0f\u5316\u5931\u8d25\uff0c\u4f20\u5165\u53c2\u6570\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f>>>" + e.getMessage());
        }
        QryAbilityParameterFormatRspBO qryAbilityParameterFormatRspBO = new QryAbilityParameterFormatRspBO();
        qryAbilityParameterFormatRspBO.setParamType(qryAbilityParameterFormatReqBO.getParamType());
        qryAbilityParameterFormatRspBO.setRspText(s);
        RspBO rspBO = RspBO.success((Object)qryAbilityParameterFormatRspBO);
        return rspBO;
    }

    public OptionGenerRspBO<String, Integer> getOptionGener(String type) {
        OptionGenerRspBO option = new OptionGenerRspBO((Serializable)((Object)"JSON"), (Serializable)Integer.valueOf(0));
        switch (type) {
            case "json": {
                option = new OptionGenerRspBO((Serializable)((Object)"JSON"), (Serializable)Integer.valueOf(0));
                break;
            }
            case "xml": {
                option = new OptionGenerRspBO((Serializable)((Object)"XML"), (Serializable)Integer.valueOf(1));
                break;
            }
            case "ws": {
                option = new OptionGenerRspBO((Serializable)((Object)"WS"), (Serializable)Integer.valueOf(2));
                break;
            }
            default: {
                option = new OptionGenerRspBO((Serializable)((Object)"JSON"), (Serializable)Integer.valueOf(0));
            }
        }
        return option;
    }

    private void reCompile(AbilityParamPO abilityParam, AbilityParamTargetPo abilityParamTarget) {
        String reqXml = "";
        String rspXml = "";
        String targetReqXml = "";
        String targetRspXml = "";
        try {
            reqXml = this.abilitySvcComponent.jsonSchemaToXsd(abilityParam.getReqJsonschema(), "xml");
            rspXml = this.abilitySvcComponent.jsonSchemaToXsd(abilityParam.getRspJsonschema(), "xml");
            targetReqXml = this.abilitySvcComponent.jsonSchemaToXsd(abilityParamTarget.getTargetReqJsonschema(), "xml");
            targetRspXml = this.abilitySvcComponent.jsonSchemaToXsd(abilityParamTarget.getTargetRspJsonschema(), "xml");
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u8bf7\u586b\u5199\u6b63\u786e\u7684\u62a5\u6587\u53c2\u6570\uff01\uff01\uff01");
        }
        AbilityExtPO abilityExtPOReq = new AbilityExtPO();
        abilityExtPOReq.setAbilityId(abilityParam.getAbilityId());
        abilityExtPOReq = this.abilityExtMapper.queryLimitOne(abilityExtPOReq);
        AbilityPO abilityPO = this.abilityMapper.queryByAbilityId(abilityParam.getAbilityId());
        AbilityParamPO abilityParamPO = new AbilityParamPO();
        abilityParamPO.setAbilityId(abilityParam.getAbilityId());
        AbilityParamPO abilityParamBefore = this.abilityParamMapper.queryLimitOne(abilityParamPO);
        abilityParam.setReqJsonschemaFilename(abilityParamBefore.getReqJsonschemaFilename());
        abilityParam.setRspJsonschemaFilename(abilityParamBefore.getRspJsonschemaFilename());
        abilityParam.setReqXsdFile(abilityParamBefore.getReqXsdFile());
        abilityParam.setReqXsd(reqXml);
        abilityParam.setRespXsdFile(abilityParamBefore.getRespXsdFile());
        abilityParam.setRespXsd(rspXml);
        AbilityParamTargetPo abilityParamTargetPo = new AbilityParamTargetPo();
        abilityParamTargetPo.setAbilityId(abilityParamTarget.getAbilityId());
        AbilityParamTargetPo abilityParamTargetBefore = this.abilityParamTargetMapper.queryLimitOne(abilityParamTargetPo);
        abilityParamTarget.setTargetReqJsonschemaFilename(abilityParamTargetBefore.getTargetReqJsonschemaFilename());
        abilityParamTarget.setTargetRspJsonschemaFilename(abilityParamTargetBefore.getTargetRspJsonschemaFilename());
        abilityParamTarget.setTargetReqXsdFile(abilityParamTargetBefore.getTargetReqXsdFile());
        abilityParamTarget.setTargetReqXsd(targetReqXml);
        abilityParamTarget.setTargetRspXsdFile(abilityParamTargetBefore.getTargetRspXsdFile());
        abilityParamTarget.setTargetRspXsd(targetRspXml);
        this.abilitySvcComponent.deployCustomSvc(abilityPO, abilityExtPOReq, abilityParam, abilityParamTarget);
    }

    private void reCompileWs(AbilityParamPO abilityParam, AbilityWsExtPO abilityWsExtPO) {
        AbilityPO abilityPO = this.abilityMapper.queryByAbilityId(abilityParam.getAbilityId());
        AbilityParamPO abilityParamPO = new AbilityParamPO();
        abilityParamPO.setAbilityId(abilityParam.getAbilityId());
        AbilityParamPO abilityParamBefore = this.abilityParamMapper.queryLimitOne(abilityParamPO);
        abilityParam.setReqJsonschemaFilename(abilityParamBefore.getReqJsonschemaFilename());
        abilityParam.setRspJsonschemaFilename(abilityParamBefore.getRspJsonschemaFilename());
        abilityParam.setReqXsdFile(abilityParamBefore.getReqXsdFile());
        abilityParam.setReqXsd(StringUtils.isEmpty((Object)abilityParamBefore.getReqJsonschema()) ? null : this.abilitySvcComponent.jsonSchemaToXsd(abilityParamBefore.getReqJsonschema(), "xml"));
        abilityParam.setRespXsdFile(abilityParamBefore.getRespXsdFile());
        abilityParam.setRespXsd(StringUtils.isEmpty((Object)abilityParamBefore.getRspJsonschema()) ? null : this.abilitySvcComponent.jsonSchemaToXsd(abilityParamBefore.getRspJsonschema(), "xml"));
        AbilityExtPO abilityExtPO = this.abilityExtMapper.queryByAbilityId(abilityParam.getAbilityId());
        this.abilitySvcComponent.deployCustomSvcFromWsdl(abilityPO, abilityWsExtPO, abilityExtPO);
    }
}

