/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.ability.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.abilityadmin.ability.model.bo.importmdp.QryLayoutRspBO;
import com.ohaotian.abilityadmin.ability.model.bo.importmdp.QryMdpServiceLayoutReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.importmdp.QryMdpServiceLayoutRspBO;
import com.ohaotian.abilityadmin.ability.model.bo.importmdp.QryMdpServiceMethodListReqBO;
import com.ohaotian.abilityadmin.ability.service.ImportMdpService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.portalcommon.util.HttpUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ImportMdpServiceImpl
implements ImportMdpService {
    private static final Logger log = LogManager.getLogger(ImportMdpServiceImpl.class);
    @Value(value="${import.mdp.url:http://192.168.10.16:10210}")
    public String url;
    @Value(value="${import.mdp.router.layout:/mdp/mdp/ability/qryServiceLayoutObjProperty}")
    public String qryServiceLayOutRouter = "/mdp/mdp/ability/qryServiceLayoutObjProperty";
    @Value(value="${import.mdp.router.method:/mdp/mdp/ability/getServiceMethodPageList}")
    public String qryServiceMethodListRouter = "/mdp/mdp/ability/getServiceMethodPageList";

    @Override
    public QryMdpServiceLayoutRspBO qryMdpServiceLayout(QryMdpServiceLayoutReqBO qryMdpServiceLayoutReqBO) {
        QryMdpServiceLayoutRspBO qryMdpServiceLayoutRspBO = new QryMdpServiceLayoutRspBO();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        qryMdpServiceLayoutReqBO.setSign(0);
        qryMdpServiceLayoutRspBO.setRspJsonschema(this.strToJsonschema(this.doPostHttp(JSON.toJSONString((Object)qryMdpServiceLayoutReqBO), headers, this.qryServiceLayOutRouter)));
        qryMdpServiceLayoutReqBO.setSign(1);
        qryMdpServiceLayoutRspBO.setReqJsonschema(this.strToJsonschema(this.doPostHttp(JSON.toJSONString((Object)qryMdpServiceLayoutReqBO), headers, this.qryServiceLayOutRouter)));
        qryMdpServiceLayoutRspBO.setObjMethodId(qryMdpServiceLayoutReqBO.getObjMethodId());
        return qryMdpServiceLayoutRspBO;
    }

    @Override
    public String qryMdpServiceMethodList(QryMdpServiceMethodListReqBO qryMdpServiceMethodListReqBO) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        return this.doPostHttp(JSON.toJSONString((Object)qryMdpServiceMethodListReqBO), headers, this.qryServiceMethodListRouter);
    }

    private String strToJsonschema(String str) {
        JSONObject jsonObject = JSON.parseObject((String)str);
        QryLayoutRspBO data = (QryLayoutRspBO)BeanMapper.map((Object)jsonObject.get((Object)"data"), QryLayoutRspBO.class);
        JSONObject resultObj = new JSONObject();
        resultObj.put("type", (Object)"object");
        resultObj.put("properties", (Object)this.jsonToJsonschema(JSON.parseArray((String)JSON.toJSONString(data.getServiceLayoutObjPropertyDataBOList()))));
        return resultObj.toString();
    }

    private JSONObject jsonToJsonschema(JSONArray array) {
        JSONObject jsonObject = new JSONObject();
        for (Object obj : array) {
            JSONObject items;
            JSONObject o = (JSONObject)obj;
            JSONObject value = new JSONObject();
            String fieldName = o.get((Object)"attrCode").toString();
            String description = o.get((Object)"attrInfo").toString();
            String dataType = o.get((Object)"dataType").toString();
            Object children = o.get((Object)"children");
            if (children != null && dataType.startsWith("List")) {
                items = new JSONObject();
                items.put("type", (Object)"object");
                items.put("properties", (Object)this.jsonToJsonschema(JSON.parseArray((String)JSON.toJSONString((Object)children))));
                value.put("items", (Object)items);
            } else if (children != null) {
                value.put("properties", (Object)this.jsonToJsonschema(JSON.parseArray((String)JSON.toJSONString((Object)children))));
            } else if (dataType.startsWith("List")) {
                items = new JSONObject();
                items.put("type", (Object)this.getJsonschemaType(dataType.substring(5, dataType.length() - 1)));
                value.put("items", (Object)items);
            }
            value.put("type", (Object)this.getJsonschemaType(dataType));
            value.put("description", (Object)description);
            jsonObject.put(fieldName, (Object)value);
        }
        return jsonObject;
    }

    private String getJsonschemaType(String type) {
        if (StringUtils.isEmpty((Object)type)) {
            throw new ZTBusinessException("\u67e5\u8be2\u51fa\u6765\u7684\u53c2\u6570\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (type.startsWith("List")) {
            return "array";
        }
        if ("Integer".equals(type) || "Long".equals(type)) {
            return "integer";
        }
        if ("BigDecimal".equals(type) || "Double".equals(type)) {
            return "number";
        }
        if ("String".equals(type) || "Date".equals(type)) {
            return "string";
        }
        if ("Boolean".equals(type)) {
            return "boolean";
        }
        return "object";
    }

    public String doPostHttp(String body, Map<String, String> headers, String router) {
        String addr = this.url + router;
        log.info("\u8c03\u7528\u5143\u6570\u636e\u8bf7\u6c42\u6570\u636e>>>{}", (Object)body);
        log.info("\u8c03\u7528\u5143\u6570\u636e\u8bf7\u6c42\u5730\u5740>>>{}", (Object)addr);
        log.info("\u8c03\u7528\u5143\u6570\u636e\u8bf7\u6c42head>>>{}", headers);
        String rsp = null;
        try {
            rsp = (String)HttpUtil.doPostJson((String)addr, (String)body, (status, str) -> {
                if (status == 200) {
                    return str;
                }
                throw new ZTBusinessException("\u8c03\u7528\u5143\u6570\u636e\u670d\u52a1\u5931\u8d25\uff0c\u5931\u8d25\u72b6\u6001\u7801\u4e3a\uff1a" + status + "\uff0c\u54cd\u5e94\u4fe1\u606f\u4e3a\uff1a" + str);
            }, headers);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u8c03\u7528\u5143\u6570\u636e\u670d\u52a1\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage() + " \n\u8c03\u7528\u5730\u5740\u4e3a\uff1a" + this.url + router);
        }
        return rsp;
    }
}

