/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.app.controller;

import com.ohaotian.abilityadmin.app.model.bo.AppIdsReqBO;
import com.ohaotian.abilityadmin.app.model.bo.AppProviderReqBO;
import com.ohaotian.abilityadmin.app.model.bo.AppRegionRepBO;
import com.ohaotian.abilityadmin.app.model.bo.AppReqBO;
import com.ohaotian.abilityadmin.app.model.bo.AppReqModifyBO;
import com.ohaotian.abilityadmin.app.service.AppService;
import com.ohaotian.abilityadmin.plugin.service.PluginAdminService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.portalcommon.model.bo.RspBO;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app"})
public class AppController {
    @Resource
    AppService appService;
    @Resource
    PluginAdminService pluginAdminService;

    @RequestMapping(value={"/qryAppListPage"})
    @BusiResponseBody
    public RspBO qryAppListPage(@RequestBody AppReqBO appReqBO) {
        return this.appService.qryAppListPageByCond(appReqBO);
    }

    @RequestMapping(value={"/qryAllAppProvide"})
    @BusiResponseBody
    public RspBO qryAllAppProvide() {
        return this.appService.qryAppProvideByTenantId();
    }

    @RequestMapping(value={"/appRegiste"})
    @BusiResponseBody
    public RspBO appRegiste(@RequestBody AppReqBO appReqBO) {
        return this.appService.appRegiste(appReqBO);
    }

    @RequestMapping(value={"/qryAppByAppId"})
    @BusiResponseBody
    public RspBO qryAppByAppId(@RequestBody AppReqBO appReqBO) {
        return this.appService.qryAppByAppId(appReqBO.getAppId());
    }

    @RequestMapping(value={"/signin"})
    @BusiResponseBody
    public RspBO signin(@RequestBody AppIdsReqBO appIdsReqBO) {
        List<Long> list = appIdsReqBO.getIds();
        return this.appService.updateAttendIn(list);
    }

    @RequestMapping(value={"/signout"})
    @BusiResponseBody
    public RspBO signout(@RequestBody AppIdsReqBO appIdsReqBO) {
        List<Long> list = appIdsReqBO.getIds();
        return this.appService.updateAttendOut(list);
    }

    @RequestMapping(value={"/qryPluginList"})
    @BusiResponseBody
    public RspBO qryPluginList() {
        return this.pluginAdminService.qryPluginList();
    }

    @RequestMapping(value={"/appUpdate"})
    @BusiResponseBody
    public RspBO appUpdate(@RequestBody AppReqModifyBO appReqBO) {
        return this.appService.appUpdate(appReqBO);
    }

    @RequestMapping(value={"/appDelete"})
    @BusiResponseBody
    public RspBO appDelete(@RequestBody AppReqBO appReqBO) {
        return this.appService.deleteApp(appReqBO.getAppId());
    }

    @RequestMapping(value={"/qryAppProviderList"})
    @BusiResponseBody
    public RspBO qryAppProviderList(@RequestBody AppProviderReqBO appProviderReqBO) {
        return this.appService.qryAppProviderPageByCond(appProviderReqBO);
    }

    @RequestMapping(value={"/checkRegionCode"})
    @BusiResponseBody
    public RspBO checkRegionCode(@RequestBody AppRegionRepBO appRegionRepBO) {
        return this.appService.checkRegionCode(appRegionRepBO.getRegionCode());
    }

    @RequestMapping(value={"/checkAppCode"})
    @BusiResponseBody
    public RspBO checkAppCode(@RequestBody AppReqBO appReqBO) {
        return this.appService.checkAppCode(appReqBO.getAppId(), appReqBO.getAppCode());
    }

    @RequestMapping(value={"/checkAppName"})
    @BusiResponseBody
    public RspBO checkAppName(@RequestBody AppReqBO appReqBO) {
        return this.appService.checkAppName(appReqBO.getAppId(), appReqBO.getAppName());
    }
}

