/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.ability.service.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.page.PageMethod;
import com.google.common.collect.Lists;
import com.ohaotian.abilityadmin.ability.model.bo.AbilityAddReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.AbilityDetailReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.AbilityDetailRspBO;
import com.ohaotian.abilityadmin.ability.model.bo.AbilityModifyReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.AbilityModifyRspBO;
import com.ohaotian.abilityadmin.ability.model.bo.QryPluginReqBO;
import com.ohaotian.abilityadmin.ability.service.AbilityDetailService;
import com.ohaotian.abilityadmin.ability.service.AbilityPluginService;
import com.ohaotian.abilityadmin.component.deploy.AbilitySvcComponent;
import com.ohaotian.abilityadmin.config.pubsub.PubSubMsgHandler;
import com.ohaotian.abilityadmin.mapper.AbilityAppMapper;
import com.ohaotian.abilityadmin.mapper.AbilityExtColumnMapper;
import com.ohaotian.abilityadmin.mapper.AbilityExtCustomMapper;
import com.ohaotian.abilityadmin.mapper.AbilityExtDefaultMapper;
import com.ohaotian.abilityadmin.mapper.AbilityExtMapper;
import com.ohaotian.abilityadmin.mapper.AbilityLogicMapper;
import com.ohaotian.abilityadmin.mapper.AbilityMapper;
import com.ohaotian.abilityadmin.mapper.AbilityModifyMapper;
import com.ohaotian.abilityadmin.mapper.AbilityParamMapper;
import com.ohaotian.abilityadmin.mapper.AbilityPluginDeployMapper;
import com.ohaotian.abilityadmin.mapper.AbilityPluginMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideDeployMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideDubboCustomInputMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideDubboCustomMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideDubboDefaultInputMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideDubboDefaultMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideHsfCustomInputMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideHsfCustomMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideHsfDefaultInputMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideHsfDefaultMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideHttpCustomMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideHttpDefaultMapper;
import com.ohaotian.abilityadmin.mapper.AbilityToVegaMapper;
import com.ohaotian.abilityadmin.mapper.AbilityTransMapper;
import com.ohaotian.abilityadmin.mapper.AbilityWsExtMapper;
import com.ohaotian.abilityadmin.mapper.AppMapper;
import com.ohaotian.abilityadmin.mapper.AppRegionMapper;
import com.ohaotian.abilityadmin.mapper.AppSubscribeDeployMapper;
import com.ohaotian.abilityadmin.mapper.ClusterMapper;
import com.ohaotian.abilityadmin.mapper.RateLimiterAbilityDefaultMapper;
import com.ohaotian.abilityadmin.mapper.RateLimiterAbilityMapper;
import com.ohaotian.abilityadmin.mapper.RateLimiterSubscribeMapper;
import com.ohaotian.abilityadmin.mapper.RegionMapper;
import com.ohaotian.abilityadmin.mapper.SubAbilityMapper;
import com.ohaotian.abilityadmin.model.po.AbilityAppPO;
import com.ohaotian.abilityadmin.model.po.AbilityExtColumnPO;
import com.ohaotian.abilityadmin.model.po.AbilityExtDefaultPO;
import com.ohaotian.abilityadmin.model.po.AbilityExtPO;
import com.ohaotian.abilityadmin.model.po.AbilityLogicPO;
import com.ohaotian.abilityadmin.model.po.AbilityModifyPO;
import com.ohaotian.abilityadmin.model.po.AbilityPO;
import com.ohaotian.abilityadmin.model.po.AbilityParamPO;
import com.ohaotian.abilityadmin.model.po.AbilityPluginDeployPO;
import com.ohaotian.abilityadmin.model.po.AbilityPluginPO;
import com.ohaotian.abilityadmin.model.po.AbilityProvideDeployPO;
import com.ohaotian.abilityadmin.model.po.AbilityProvideDubboDefaultInputPO;
import com.ohaotian.abilityadmin.model.po.AbilityProvideDubboDefaultPO;
import com.ohaotian.abilityadmin.model.po.AbilityProvideHsfDefaultInputPO;
import com.ohaotian.abilityadmin.model.po.AbilityProvideHsfDefaultPO;
import com.ohaotian.abilityadmin.model.po.AbilityProvideHttpDefaultPO;
import com.ohaotian.abilityadmin.model.po.AbilityToVegaPo;
import com.ohaotian.abilityadmin.model.po.AbilityWsExtPO;
import com.ohaotian.abilityadmin.model.po.AppPO;
import com.ohaotian.abilityadmin.model.po.AppRegionPO;
import com.ohaotian.abilityadmin.model.po.AppSubscribeDeployPO;
import com.ohaotian.abilityadmin.model.po.ClusterPO;
import com.ohaotian.abilityadmin.model.po.RateLimiterAbilityDefaultPO;
import com.ohaotian.abilityadmin.model.po.RegionPO;
import com.ohaotian.abilityadmin.model.po.SubAbilityPO;
import com.ohaotian.atp.base.service.IdGenerator;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.authority.model.AuthorityUserInfoBO;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.piscesplatform.mapper.AbilityParamTargetMapper;
import com.ohaotian.piscesplatform.model.po.AbilityParamTargetPo;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.portalcommon.config.systemcode.SystemCodeMap;
import com.ohaotian.portalcommon.constant.Constants;
import com.ohaotian.portalcommon.enums.AbilityOperateTypeEnum;
import com.ohaotian.portalcommon.enums.FisrtLevelEnum;
import com.ohaotian.portalcommon.enums.SecondLevelEnum;
import com.ohaotian.portalcommon.model.bo.ModifyStatusBO;
import com.ohaotian.portalcommon.model.bo.OptionGenerRspBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.page.RspPage;
import com.ohaotian.portalcommon.service.AbilityHandlerService;
import com.ohaotian.portalcommon.strategy.HandlerContext;
import com.ohaotian.portalcommon.util.ValidBatchUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class AbilityDetailServiceImpl
implements AbilityDetailService {
    private static Logger logger = LogManager.getLogger(AbilityDetailServiceImpl.class);
    @Resource
    AbilityMapper abilityMapper;
    @Resource
    AbilityAppMapper abilityAppMapper;
    @Resource
    AppMapper appMapper;
    @Resource
    SubAbilityMapper subAbilityMapper;
    @Resource
    AbilityModifyMapper abilityModifyMapper;
    @Resource
    AbilityExtColumnMapper abilityExtColumnMapper;
    @Resource
    AbilityHandlerService abilityHandlerService;
    @Resource
    private AbilityExtDefaultMapper abilityExtDefaultMapper;
    @Resource
    private AbilityExtCustomMapper abilityExtCustomMapper;
    @Resource
    private AbilityProvideHttpDefaultMapper abilityProvideHttpDefaultMapper;
    @Resource
    private HandlerContext handlerContext;
    @Resource
    private AbilityProvideHsfDefaultMapper abilityProvideHsfDefaultMapper;
    @Resource
    private AbilityProvideHsfDefaultInputMapper abilityProvideHsfDefaultInputMapper;
    @Resource
    private AbilityProvideDubboDefaultMapper abilityProvideDubboDefaultMapper;
    @Resource
    private AbilityProvideDubboDefaultInputMapper abilityProvideDubboDefaultInputMapper;
    @Resource
    private AbilityExtMapper abilityExtMapper;
    @Resource
    private AuthorityService authorityService;
    @Resource
    private AbilitySvcComponent abilitySvcComponent;
    @Resource
    AbilityProvideDeployMapper abilityProvideDeployMapper;
    @Resource
    AbilityParamMapper abilityParamMapper;
    @Resource
    AbilityParamTargetMapper abilityParamTargetMapper;
    @Resource
    AbilityPluginMapper abilityPluginMapper;
    @Resource
    AbilityPluginDeployMapper abilityPluginDeployMapper;
    @Resource
    AbilityLogicMapper abilityLogicMapper;
    @Resource
    ClusterMapper clusterMapper;
    @Resource
    AppRegionMapper appRegionMapper;
    @Resource
    RegionMapper regionMapper;
    @Resource
    AbilityWsExtMapper abilityWsExtMapper;
    @Resource
    AppSubscribeDeployMapper appSubscribeDeployMapper;
    @Resource
    private RateLimiterAbilityDefaultMapper rateLimiterAbilityDefaultMapper;
    @Resource
    private RateLimiterSubscribeMapper rateLimiterSubscribeMapper;
    @Resource
    private RateLimiterAbilityMapper rateLimiterAbilityMapper;
    @Resource
    private AbilityProvideHsfCustomInputMapper abilityProvideHsfCustomInputMapper;
    @Resource
    private AbilityProvideHsfCustomMapper abilityProvideHsfCustomMapper;
    @Resource
    private AbilityProvideDubboCustomInputMapper abilityProvideDubboCustomInputMapper;
    @Resource
    private AbilityProvideDubboCustomMapper abilityProvideDubboCustomMapper;
    @Resource
    private AbilityProvideHttpCustomMapper abilityProvideHttpCustomMapper;
    @Resource
    private AbilityToVegaMapper abilityToVegaMapper;
    @Resource
    private AbilityPluginService abilityPluginService;
    @Autowired
    private PubSubMsgHandler pubSubMsgHandler;
    @Resource
    private AbilityTransMapper abilityTransMapper;
    @Autowired
    private IdGenerator idGenerator;

    @Override
    public RspBO qryAbilityInfo(AbilityDetailReqBO abilityDetailReqBO) {
        AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
        Long tenantId = Long.valueOf(authorityUserInfoBO.getTenantId());
        AbilityPO abilityPOReq = this.abilityMapper.queryByAbilityId(abilityDetailReqBO.getAbilityId());
        AbilityDetailRspBO abilityDetailRspBO = this.abilityMapper.queryAbilityRspByAbilityId(abilityDetailReqBO.getAbilityId());
        AbilityAppPO abilityAppPO = new AbilityAppPO();
        abilityAppPO.setHirerId(tenantId);
        abilityAppPO.setRelationType(Constants.RelationType.PROVIDE);
        abilityAppPO.setAbilityEname(abilityPOReq.getAbilityEname());
        abilityAppPO.setAbilityVersion(abilityPOReq.getAbilityVersion());
        abilityAppPO = this.abilityAppMapper.queryLimitOne(abilityAppPO);
        if (abilityAppPO != null) {
            AppPO appPO = (AppPO)BeanMapper.map((Object)abilityAppPO, AppPO.class);
            appPO = this.appMapper.queryLimitOne(appPO);
            abilityDetailRspBO.setAppName(appPO.getAppName());
            abilityDetailRspBO.setAppId(appPO.getAppId());
        }
        RateLimiterAbilityDefaultPO rateLimiterAbilityDefaultPO = new RateLimiterAbilityDefaultPO();
        rateLimiterAbilityDefaultPO.setAbilityId(abilityDetailReqBO.getAbilityId());
        RateLimiterAbilityDefaultPO rateLimiterAbilityDefaultPO1 = this.rateLimiterAbilityDefaultMapper.queryLimitOne(rateLimiterAbilityDefaultPO);
        if (!Objects.isNull(rateLimiterAbilityDefaultPO1)) {
            abilityDetailRspBO.setGlobalLimit(rateLimiterAbilityDefaultPO1.getGlobalLimit() + "");
            abilityDetailRspBO.setSingleLimit(rateLimiterAbilityDefaultPO1.getSingleLimit() + "");
            abilityDetailRspBO.setRate(rateLimiterAbilityDefaultPO1.getRate());
            abilityDetailRspBO.setCapacity(rateLimiterAbilityDefaultPO1.getCapacity());
            abilityDetailRspBO.setDailyCapacity(rateLimiterAbilityDefaultPO1.getDailyCapacity());
            abilityDetailRspBO.setSingleMaxRate(rateLimiterAbilityDefaultPO1.getSingleMaxRate());
            abilityDetailRspBO.setSingleMaxCount(rateLimiterAbilityDefaultPO1.getSingleMaxCount());
            abilityDetailRspBO.setSingleDailyMaxCount(rateLimiterAbilityDefaultPO1.getSingleDailyMaxCount());
        }
        AbilityExtDefaultPO abilityExtDefaultPO = new AbilityExtDefaultPO();
        abilityExtDefaultPO.setAbilityId(abilityDetailReqBO.getAbilityId());
        abilityExtDefaultPO = this.abilityExtDefaultMapper.queryLimitOne(abilityExtDefaultPO);
        abilityDetailRspBO.setOvertime(abilityExtDefaultPO.getOvertime());
        abilityDetailRspBO.setRetryTime(abilityExtDefaultPO.getRetryTime());
        abilityDetailRspBO.setInputProtocaList(Arrays.asList(abilityDetailRspBO.getInputProtocal().split(",")));
        if (Constants.AbilityType.COMBINATION.equals(abilityDetailRspBO.getAbilityType())) {
            Object subAbilityPO = new SubAbilityPO();
            ((SubAbilityPO)subAbilityPO).setParentAbilityId(abilityDetailReqBO.getAbilityId());
            subAbilityPO = this.subAbilityMapper.queryLimitOne((SubAbilityPO)subAbilityPO);
            AbilityPO abilityPO = this.abilityMapper.queryByAbilityId(((SubAbilityPO)subAbilityPO).getAbilityId());
            abilityDetailRspBO.setSubAbilityId(abilityPO.getAbilityId());
        }
        switch (abilityDetailRspBO.getOutputProtocal()) {
            case "hsf": {
                AbilityProvideHsfDefaultPO abilityProvideHsfDefaultPO = new AbilityProvideHsfDefaultPO();
                abilityProvideHsfDefaultPO.setAbilityId(abilityDetailReqBO.getAbilityId());
                abilityProvideHsfDefaultPO = this.abilityProvideHsfDefaultMapper.queryLimitOne(abilityProvideHsfDefaultPO);
                AbilityProvideHsfDefaultInputPO abilityProvideHsfDefaultInputPO = (AbilityProvideHsfDefaultInputPO)BeanMapper.map((Object)abilityProvideHsfDefaultPO, AbilityProvideHsfDefaultInputPO.class);
                List<AbilityProvideHsfDefaultInputPO> abilityProvideHsfDefaultInputPOS = this.abilityProvideHsfDefaultInputMapper.queryByCond(abilityProvideHsfDefaultInputPO);
                HashMap<String, Object> hsfMap = new HashMap<String, Object>();
                hsfMap.put("formData", abilityProvideHsfDefaultPO);
                hsfMap.put("inputParams", abilityProvideHsfDefaultInputPOS);
                abilityDetailRspBO.setExtendInfo(hsfMap);
                break;
            }
            case "dubbo": {
                AbilityProvideDubboDefaultPO abilityProvideDubboDefaultPO = new AbilityProvideDubboDefaultPO();
                abilityProvideDubboDefaultPO.setAbilityId(abilityDetailReqBO.getAbilityId());
                abilityProvideDubboDefaultPO = this.abilityProvideDubboDefaultMapper.queryLimitOne(abilityProvideDubboDefaultPO);
                AbilityProvideDubboDefaultInputPO abilityProvideDubboDefaultInputPO = (AbilityProvideDubboDefaultInputPO)BeanMapper.map((Object)abilityProvideDubboDefaultPO, AbilityProvideDubboDefaultInputPO.class);
                List<AbilityProvideDubboDefaultInputPO> abilityProvideDubboDefaultInputPOS = this.abilityProvideDubboDefaultInputMapper.queryByCond(abilityProvideDubboDefaultInputPO);
                HashMap<String, Object> dubboMap = new HashMap<String, Object>();
                dubboMap.put("formData", abilityProvideDubboDefaultPO);
                dubboMap.put("inputParams", abilityProvideDubboDefaultInputPOS);
                abilityDetailRspBO.setExtendInfo(dubboMap);
                break;
            }
            default: {
                AbilityProvideHttpDefaultPO abilityProvideHttpDefaultPO = this.abilityProvideHttpDefaultMapper.selectHttpByAbilityId(abilityDetailReqBO.getAbilityId());
                abilityDetailRspBO.setEprPath(abilityProvideHttpDefaultPO.getEprPath());
            }
        }
        AbilityToVegaPo abilityToVegaPo = this.abilityToVegaMapper.queryByAbilityId(abilityDetailReqBO.getAbilityId());
        if (Boolean.FALSE.equals(ObjectUtils.isEmpty((Object)abilityToVegaPo))) {
            abilityDetailRspBO.setForwardStatus(abilityToVegaPo.getForwardStatus());
            abilityDetailRspBO.setRouterAddress(abilityToVegaPo.getRouterAddress());
            abilityDetailRspBO.setToVegaPath(abilityToVegaPo.getToVegaPath());
            abilityDetailRspBO.setRegionCodes(abilityToVegaPo.getRegionCodes());
        } else {
            abilityDetailRspBO.setForwardStatus(0);
        }
        AbilityWsExtPO abilityWsExtPO = this.abilityWsExtMapper.queryByAbilityId(abilityDetailReqBO.getAbilityId());
        if (abilityWsExtPO != null) {
            abilityDetailRspBO.setWsdl(abilityWsExtPO.getAbilityWsdl());
        }
        return RspBO.success((Object)abilityDetailRspBO);
    }

    @Override
    @Transactional
    public Integer checkIn(Long abilityId) {
        Long userId = Long.valueOf(UserHolder.getUserId());
        AbilityPO abilityPO = new AbilityPO();
        abilityPO.setAbilityId(abilityId);
        abilityPO.setAttendStatus(Constants.AttendStatus.SIGN_IN);
        Date date = new Date();
        abilityPO.setCheckinTime(date);
        abilityPO.setUpdateTime(date);
        abilityPO.setUpdateUserId(userId);
        this.abilityChangeRecord(abilityId, AbilityOperateTypeEnum.CHECKIN.getValue(), null, userId, date);
        int num = this.abilityMapper.updateAbilityByAbilityId(abilityPO);
        ArrayList ids = Lists.newArrayList();
        ids.add(abilityId);
        this.notifyModify(ids, 1);
        return num;
    }

    @Override
    @Transactional
    public Boolean checkInBatch(List<Long> abilityIds) {
        Long userId = Long.valueOf(UserHolder.getUserId());
        for (Long abilityId : abilityIds) {
            AbilityPO abilityPO = new AbilityPO();
            abilityPO.setAbilityId(abilityId);
            abilityPO.setAttendStatus(Constants.AttendStatus.SIGN_IN);
            Date date = new Date();
            abilityPO.setCheckinTime(date);
            abilityPO.setUpdateTime(date);
            abilityPO.setUpdateUserId(userId);
            this.abilityChangeRecord(abilityId, AbilityOperateTypeEnum.CHECKIN.getValue(), null, userId, date);
            int num = this.abilityMapper.updateAbilityByAbilityId(abilityPO);
            if (num >= 1) continue;
            throw new ZTBusinessException("\u4fee\u6539\u5931\u8d25");
        }
        this.notifyModify(abilityIds, 1);
        return true;
    }

    @Override
    @Transactional
    public Integer checkOut(Long abilityId) {
        Long userId = Long.valueOf(UserHolder.getUserId());
        Date date = new Date();
        AbilityPO abilityPO = new AbilityPO();
        abilityPO.setAbilityId(abilityId);
        abilityPO.setAttendStatus(Constants.AttendStatus.SIGN_OUT);
        abilityPO.setCheckinTime(date);
        abilityPO.setUpdateTime(date);
        abilityPO.setUpdateUserId(userId);
        this.abilityChangeRecord(abilityId, AbilityOperateTypeEnum.CHECKOUT.getValue(), null, userId, date);
        int num = this.abilityMapper.updateAbilityByAbilityId(abilityPO);
        ArrayList ids = Lists.newArrayList();
        ids.add(abilityId);
        this.notifyModify(ids, 0);
        return num;
    }

    @Override
    @Transactional
    public Boolean checkOutBatch(List<Long> abilityIds) {
        Long userId = Long.valueOf(UserHolder.getUserId());
        for (Long abilityId : abilityIds) {
            Date date = new Date();
            AbilityPO abilityPO = new AbilityPO();
            abilityPO.setAbilityId(abilityId);
            abilityPO.setAttendStatus(Constants.AttendStatus.SIGN_OUT);
            abilityPO.setCheckinTime(date);
            abilityPO.setUpdateTime(date);
            abilityPO.setUpdateUserId(userId);
            this.abilityChangeRecord(abilityId, AbilityOperateTypeEnum.CHECKOUT.getValue(), null, userId, date);
            int num = this.abilityMapper.updateAbilityByAbilityId(abilityPO);
            if (num >= 1) continue;
            throw new ZTBusinessException("\u4fee\u6539\u5931\u8d25");
        }
        this.notifyModify(abilityIds, 0);
        return true;
    }

    @Override
    @Transactional
    public void delAbility(Long abilityId) {
        Long userId = Long.valueOf(UserHolder.getUserId());
        Date date = new Date();
        AbilityPO abilityPO_query = new AbilityPO();
        abilityPO_query.setAbilityId(abilityId);
        AbilityPO abilityPO = this.abilityMapper.queryLimitOne(abilityPO_query);
        if (abilityPO == null) {
            throw new ZTBusinessException("\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        if (abilityPO.getAttendStatus() == 1) {
            throw new ZTBusinessException("\u7b7e\u5230\u72b6\u6001\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        SubAbilityPO subAbilityPO = new SubAbilityPO();
        subAbilityPO.setAbilityId(abilityId);
        subAbilityPO = this.subAbilityMapper.queryLimitOne(subAbilityPO);
        if (subAbilityPO != null) {
            throw new ZTBusinessException("\u8be5\u80fd\u529b\u5b58\u5728\u7236\u80fd\u529b\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        this.abilityChangeRecord(abilityId, AbilityOperateTypeEnum.DELETE.getValue(), null, userId, date);
        this.abilityTransMapper.deleteEntityByAbilityIds(Collections.singletonList(abilityId));
        this.abilityExtMapper.deleteByAbilityId(abilityId);
        this.abilityExtColumnMapper.deleteAbilityExtColumnByAbilityId(abilityId);
        this.abilityExtDefaultMapper.deleteByAbilityId(abilityId);
        this.abilityParamMapper.deleteByAbilitId(abilityId);
        this.abilityParamTargetMapper.deleteByAbilitId(abilityId);
        this.subAbilityMapper.deleteByParentAbilityId(abilityId);
        this.abilityLogicMapper.deleteLogicScriptByAbilityId(abilityId);
        this.abilityWsExtMapper.deleteAbilityWsExtByAbilityId(abilityId);
        Long hirerId = abilityPO.getHirerId();
        String abilityEname = abilityPO.getAbilityEname();
        String abilityVersion = abilityPO.getAbilityVersion();
        AbilityAppPO abilityAppPO = new AbilityAppPO();
        abilityAppPO.setHirerId(hirerId);
        abilityAppPO.setAbilityEname(abilityEname);
        abilityAppPO.setAbilityVersion(abilityVersion);
        List<AbilityAppPO> abilityAppPOList = this.abilityAppMapper.queryByCond(abilityAppPO);
        if (abilityAppPOList != null && abilityAppPOList.size() > 0) {
            List<AppSubscribeDeployPO> appSubscribeDeployPOS;
            this.abilityAppMapper.deleteByAbility(abilityEname, hirerId, abilityVersion);
            List<Long> abilityAppIdList = abilityAppPOList.stream().map(AbilityAppPO::getAbilityAppId).collect(Collectors.toList());
            List<AbilityProvideDeployPO> abilityProvideDeployPOList = this.abilityProvideDeployMapper.queryByabilityAppIds(abilityAppIdList);
            if (abilityProvideDeployPOList != null && abilityProvideDeployPOList.size() > 0) {
                List<Long> abilityProvideDeployIds = abilityProvideDeployPOList.stream().map(AbilityProvideDeployPO::getProvideDeployId).collect(Collectors.toList());
                this.abilityExtCustomMapper.deleteByProvideDeployIds(abilityProvideDeployIds);
                this.abilityProvideDeployMapper.deleteAbilityProvideDeployByIds(abilityProvideDeployIds);
                this.abilityProvideHsfCustomInputMapper.deleteByProvideDeployIds(abilityProvideDeployIds);
                this.abilityProvideHsfCustomMapper.deleteByProvideDeployIds(abilityProvideDeployIds);
                this.abilityProvideDubboCustomMapper.deleteByProvideDeployIds(abilityProvideDeployIds);
                this.abilityProvideDubboCustomInputMapper.deleteByProvideDeployIds(abilityProvideDeployIds);
                this.abilityProvideHttpCustomMapper.deleteByProvideDeployIds(abilityProvideDeployIds);
            }
            if ((appSubscribeDeployPOS = this.appSubscribeDeployMapper.queryByabilityAppIds(abilityAppIdList)) != null && appSubscribeDeployPOS.size() > 0) {
                List<Long> collect = appSubscribeDeployPOS.stream().map(a -> a.getSubscribeDeployId()).collect(Collectors.toList());
                this.rateLimiterSubscribeMapper.deleteRateLimiterSubscribeBySubscribeDeployIds(collect);
                this.appSubscribeDeployMapper.deleteAppSubscribeDeployByIds(collect);
            }
        }
        AbilityPluginPO abilityPluginPO = new AbilityPluginPO();
        abilityPluginPO.setHirerId(hirerId);
        abilityPluginPO.setAbilityEname(abilityEname);
        abilityPluginPO.setAbilityVersion(abilityVersion);
        List<AbilityPluginPO> abilityPluginPOList = this.abilityPluginMapper.queryByCond(abilityPluginPO);
        if (abilityPluginPOList != null && abilityPluginPOList.size() > 0) {
            List<Long> abilityPluginIdList = abilityPluginPOList.stream().map(AbilityPluginPO::getAbilityPluginId).collect(Collectors.toList());
            List<AbilityPluginDeployPO> abilityPluginDeployPOs = this.abilityPluginDeployMapper.queryByabilityPluginIds(abilityPluginIdList);
            List<Long> abilityPluginDeployIdList = abilityPluginDeployPOs.stream().map(AbilityPluginDeployPO::getAbilityPluginDeployId).collect(Collectors.toList());
            QryPluginReqBO qryPluginReqBO = new QryPluginReqBO();
            qryPluginReqBO.setAbilityPluginDeployIds(abilityPluginDeployIdList);
            this.abilityPluginService.bathDeleteAbilityPlugin(qryPluginReqBO);
        }
        if (!"rpc".equals(abilityPO.getOutputTransProtocal())) {
            AbilityProvideHttpDefaultPO abilityProvideHttpDefaultPO = new AbilityProvideHttpDefaultPO();
            abilityProvideHttpDefaultPO.setAbilityId(abilityId);
            abilityProvideHttpDefaultPO = this.abilityProvideHttpDefaultMapper.queryLimitOne(abilityProvideHttpDefaultPO);
            if (abilityProvideHttpDefaultPO != null) {
                this.abilityProvideHttpDefaultMapper.deleteAbilityProvideHttpDefaultByHttpDefaultId(abilityProvideHttpDefaultPO.getHttpDefaultId());
            }
        } else {
            HashMap<String, Long> extendInfo = new HashMap<String, Long>();
            extendInfo.put("abilityId", abilityId);
            this.abilityHandlerService.handleDelete(extendInfo, abilityPO.getOutputProtocal());
        }
        this.rateLimiterAbilityDefaultMapper.deleteRateLimiterAbilityDefaultByAbilityId(abilityId);
        this.rateLimiterAbilityMapper.deleteRateLimiterAbilityByAbilityId(abilityId);
        this.abilityMapper.deleteAbilityByAbilityId(abilityId);
    }

    @Override
    @Transactional
    public RspBO addAbility(AbilityAddReqBO abilityAddReqBO) {
        Long userId = Long.valueOf(UserHolder.getUserId());
        AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
        Long tenantId = Long.valueOf(authorityUserInfoBO.getTenantId());
        if (StringUtils.isEmpty((Object)userId)) {
            throw new ZTBusinessException("\u83b7\u53d6\u7528\u6237id\u5931\u8d25");
        }
        if (tenantId == null) {
            throw new ZTBusinessException("\u83b7\u53d6\u79df\u6237id\u5931\u8d25");
        }
        abilityAddReqBO.setCreateUserId(userId);
        abilityAddReqBO.setHirerId(tenantId);
        Date date = new Date();
        AbilityPO abilityPO = (AbilityPO)BeanMapper.map((Object)abilityAddReqBO, AbilityPO.class);
        AbilityPO ability = new AbilityPO();
        ability.setAbilityEname(abilityPO.getAbilityEname());
        ability.setAbilityVersion(abilityPO.getAbilityVersion());
        ability.setHirerId(abilityAddReqBO.getHirerId());
        List<AbilityPO> abilityPOS = this.abilityMapper.queryByCond(ability);
        if (abilityPOS.size() > 0) {
            StringBuilder errInfo = new StringBuilder();
            errInfo.append(ability.getAbilityEname()).append("_");
            if (ability.getAbilityVersion().toUpperCase().indexOf("V") >= 0) {
                errInfo.append(ability.getAbilityVersion()).append("\u5df2\u7ecf\u5b58\u5728!");
            } else {
                errInfo.append("v").append(ability.getAbilityVersion()).append("\u5df2\u7ecf\u5b58\u5728!");
            }
            throw new ZTBusinessException(errInfo.toString());
        }
        abilityPO.setCreateTime(date);
        abilityPO.setUpdateTime(date);
        abilityPO.setUpdateUserId(userId);
        abilityPO.setIsDraft(Constants.AbilityDraftType.DRAFT);
        if (abilityAddReqBO.getInputProtocal() == null || abilityAddReqBO.getInputProtocal().size() <= 0) {
            StringBuilder label = new StringBuilder();
            label.append(ability.getAbilityEname()).append("_");
            if (ability.getAbilityVersion().toUpperCase().indexOf("V") >= 0) {
                label.append(ability.getAbilityVersion());
            } else {
                label.append("v").append(ability.getAbilityVersion());
            }
            throw new ZTBusinessException("\u80fd\u529b" + label.toString() + "\u63a5\u5165\u534f\u8bae\u672a\u914d\u7f6e");
        }
        String collect = abilityAddReqBO.getInputProtocal().stream().collect(Collectors.joining(","));
        abilityPO.setInputProtocal(collect);
        abilityPO.setAttendStatus(Constants.AttendStatus.SIGN_OUT);
        this.abilityMapper.insertSelective(abilityPO);
        Long abilityId = abilityPO.getAbilityId();
        AbilityExtColumnPO abilityExtColumnPO = abilityAddReqBO.getExtInfo();
        abilityExtColumnPO.setAbilityId(abilityId);
        this.abilityExtColumnMapper.insertSelective(abilityExtColumnPO);
        AbilityAppPO abilityAppPO = new AbilityAppPO();
        abilityAppPO.setRelationType(Constants.RelationType.PROVIDE);
        abilityAppPO.setAbilityVersion(ability.getAbilityVersion());
        abilityAppPO.setAbilityEname(ability.getAbilityEname());
        abilityAppPO.setHirerId(ability.getHirerId());
        AppPO appPO = this.appMapper.queryByAppId(abilityAddReqBO.getAppId());
        abilityAppPO.setAppCode(appPO.getAppCode());
        this.abilityAppMapper.insertSelective(abilityAppPO);
        AbilityExtDefaultPO abilityExtDefaultPO = new AbilityExtDefaultPO();
        abilityExtDefaultPO.setAbilityId(abilityId);
        abilityExtDefaultPO.setOvertime(abilityAddReqBO.getOvertime());
        abilityExtDefaultPO.setRetryTime(abilityAddReqBO.getRetryTime());
        this.abilityExtDefaultMapper.insertSelective(abilityExtDefaultPO);
        RateLimiterAbilityDefaultPO rateLimiterAbilityDefaultPO = new RateLimiterAbilityDefaultPO();
        rateLimiterAbilityDefaultPO.setAbilityId(abilityId);
        rateLimiterAbilityDefaultPO.setGlobalLimit(abilityAddReqBO.getGlobalLimit());
        rateLimiterAbilityDefaultPO.setSingleLimit(abilityAddReqBO.getSingleLimit());
        rateLimiterAbilityDefaultPO.setRate(abilityAddReqBO.getRate());
        rateLimiterAbilityDefaultPO.setCapacity(abilityAddReqBO.getCapacity());
        rateLimiterAbilityDefaultPO.setDailyCapacity(abilityAddReqBO.getDailyCapacity());
        rateLimiterAbilityDefaultPO.setSingleMaxRate(abilityAddReqBO.getSingleMaxRate());
        rateLimiterAbilityDefaultPO.setSingleMaxCount(abilityAddReqBO.getSingleMaxCount());
        rateLimiterAbilityDefaultPO.setSingleDailyMaxCount(abilityAddReqBO.getSingleDailyMaxCount());
        this.rateLimiterAbilityDefaultMapper.insertSelective(rateLimiterAbilityDefaultPO);
        HashMap<String, Long> extendInfo = abilityAddReqBO.getExtendInfo();
        if (StringUtils.isEmpty((Object)extendInfo)) {
            extendInfo = new HashMap<String, Long>();
        }
        extendInfo.put("abilityId", abilityId);
        this.abilityHandlerService.handleAdd(extendInfo, abilityAddReqBO.getOutputProtocal());
        if (!"rpc".equals(abilityAddReqBO.getOutputTransProtocal())) {
            AbilityProvideHttpDefaultPO abilityProvideHttpDefaultPO = (AbilityProvideHttpDefaultPO)BeanMapper.map((Object)abilityAddReqBO.getExtendInfo(), AbilityProvideHttpDefaultPO.class);
            this.abilityProvideHttpDefaultMapper.insertSelective(abilityProvideHttpDefaultPO);
        }
        if (!StringUtils.isEmpty((Object)abilityAddReqBO.getAbilityType()) && Constants.AbilityType.COMBINATION.equals(abilityAddReqBO.getAbilityType())) {
            SubAbilityPO subAbilityPO = new SubAbilityPO();
            subAbilityPO.setParentAbilityId(abilityId);
            subAbilityPO.setAbilityId(abilityAddReqBO.getSubAbilityId());
            this.subAbilityMapper.insertSelective(subAbilityPO);
            AbilityLogicPO abilityLogicPO = new AbilityLogicPO();
            abilityLogicPO.setAbilityId(abilityId);
            abilityLogicPO.setLogicScript(abilityAddReqBO.getLogicScript());
            this.abilityLogicMapper.insertSelective(abilityLogicPO);
        }
        AbilityExtPO abilityExtPO = new AbilityExtPO();
        abilityExtPO.setAbilityId(abilityId);
        this.abilityExtMapper.insertSelective(abilityExtPO);
        AbilityParamPO abilityParamPO = new AbilityParamPO();
        abilityParamPO.setAbilityId(abilityId);
        abilityParamPO.setReqXsdFile("req");
        abilityParamPO.setRespXsdFile("rsp");
        abilityParamPO.setReqJsonschemaFilename("req");
        abilityParamPO.setRspJsonschemaFilename("rsp");
        abilityParamPO.setReqJsonschema(abilityAddReqBO.getReqJsonschema());
        abilityParamPO.setRspJsonschema(abilityAddReqBO.getRspJsonschema());
        abilityParamPO.setReqXsd(StringUtils.isEmpty((Object)abilityAddReqBO.getReqJsonschema()) ? null : this.abilitySvcComponent.jsonSchemaToXsd(abilityAddReqBO.getReqJsonschema(), "xml"));
        abilityParamPO.setRespXsd(StringUtils.isEmpty((Object)abilityAddReqBO.getRspJsonschema()) ? null : this.abilitySvcComponent.jsonSchemaToXsd(abilityAddReqBO.getRspJsonschema(), "xml"));
        this.abilityParamMapper.insertSelective(abilityParamPO);
        AbilityParamTargetPo abilityParamTargetPo = new AbilityParamTargetPo();
        abilityParamTargetPo.setAbilityId(abilityId);
        abilityParamTargetPo.setTargetReqXsdFile("targetReq");
        abilityParamTargetPo.setTargetRspXsdFile("targetRsp");
        abilityParamTargetPo.setTargetReqJsonschemaFilename("targetReq");
        abilityParamTargetPo.setTargetRspJsonschemaFilename("targetRsp");
        abilityParamTargetPo.setTargetReqJsonschema(abilityAddReqBO.getTargetReqJsonschema());
        abilityParamTargetPo.setTargetRspJsonschema(abilityAddReqBO.getTargetRspJsonschema());
        abilityParamTargetPo.setTargetReqXsd(StringUtils.isEmpty((Object)abilityAddReqBO.getTargetReqJsonschema()) ? null : this.abilitySvcComponent.jsonSchemaToXsd(abilityAddReqBO.getTargetReqJsonschema(), "xml"));
        abilityParamTargetPo.setTargetRspXsd(StringUtils.isEmpty((Object)abilityAddReqBO.getTargetRspJsonschema()) ? null : this.abilitySvcComponent.jsonSchemaToXsd(abilityAddReqBO.getTargetRspJsonschema(), "xml"));
        this.abilityParamTargetMapper.insertSelective(abilityParamTargetPo);
        AbilityWsExtPO abilityWsExtPO = new AbilityWsExtPO();
        abilityWsExtPO.setAbilityId(abilityId);
        abilityWsExtPO.setAbilityWsdl(abilityAddReqBO.getWsdl());
        this.abilityWsExtMapper.insertSelective(abilityWsExtPO);
        if (abilityAddReqBO.getInputProtocal().contains("ws")) {
            this.abilitySvcComponent.deployCustomSvcFromWsdl(abilityPO, abilityWsExtPO, abilityExtPO);
        } else {
            this.abilitySvcComponent.deployCustomSvc(abilityPO, abilityExtPO, abilityParamPO, abilityParamTargetPo);
        }
        this.abilityChangeRecord(abilityId, AbilityOperateTypeEnum.ADD.getValue(), null, abilityAddReqBO.getCreateUserId(), date);
        this.addDeploy(abilityAddReqBO, appPO, abilityAppPO);
        return RspBO.success((Object)abilityPO);
    }

    @Override
    @Transactional
    public RspBO submitAbility(AbilityAddReqBO abilityAddReqBO) {
        Long userId = Long.valueOf(UserHolder.getUserId());
        AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
        Long tenantId = Long.valueOf(authorityUserInfoBO.getTenantId());
        if (StringUtils.isEmpty((Object)userId)) {
            throw new ZTBusinessException("\u83b7\u53d6\u7528\u6237id\u5931\u8d25");
        }
        if (StringUtils.isEmpty((Object)tenantId)) {
            throw new ZTBusinessException("\u83b7\u53d6\u79df\u6237id\u5931\u8d25");
        }
        abilityAddReqBO.setCreateUserId(userId);
        abilityAddReqBO.setHirerId(tenantId);
        AbilityModifyReqBO map = (AbilityModifyReqBO)BeanMapper.map((Object)abilityAddReqBO, AbilityModifyReqBO.class);
        RspBO rspBO = StringUtils.isEmpty((Object)map.getAbilityId()) ? this.addAbility(abilityAddReqBO) : this.modifyAbility(map);
        if ("1".equals(rspBO.getCode())) {
            throw new ZTBusinessException("\u80fd\u529b\u63d0\u4ea4\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a" + rspBO.getMessage());
        }
        AbilityPO ability = (AbilityPO)BeanMapper.map((Object)rspBO.getData(), AbilityPO.class);
        if (StringUtils.isEmpty((Object)ability.getAbilityId())) {
            throw new ZTBusinessException("\u80fd\u529b\u63d0\u4ea4\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        ability.setIsDraft(Constants.AbilityDraftType.NORMAL);
        ability.setAttendStatus(Constants.AttendStatus.SIGN_IN);
        this.abilityMapper.updateAbilityByAbilityId(ability);
        this.abilityChangeRecord(ability.getAbilityId(), AbilityOperateTypeEnum.ABILITY_SUBMIT.getValue(), abilityAddReqBO.getModifyRecord(), abilityAddReqBO.getCreateUserId(), new Date());
        return RspBO.success((Object)ability);
    }

    @Override
    @Transactional
    public RspBO modifyAbility(AbilityModifyReqBO abilityModifyReqBO) {
        AbilityProvideHttpDefaultPO abilityProvideHttpDefaultPO;
        AppPO appPO;
        Object collect;
        Long userId = Long.valueOf(UserHolder.getUserId());
        AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
        Long tenantId = Long.valueOf(authorityUserInfoBO.getTenantId());
        if (StringUtils.isEmpty((Object)userId)) {
            throw new ZTBusinessException("\u83b7\u53d6\u7528\u6237id\u5931\u8d25");
        }
        if (StringUtils.isEmpty((Object)tenantId)) {
            throw new ZTBusinessException("\u83b7\u53d6\u79df\u6237id\u5931\u8d25");
        }
        abilityModifyReqBO.setUpdateUserId(userId);
        abilityModifyReqBO.setHirerId(tenantId);
        Date date = new Date();
        Long abilityId = abilityModifyReqBO.getAbilityId();
        AbilityPO abilityPO = (AbilityPO)BeanMapper.map((Object)abilityModifyReqBO, AbilityPO.class);
        AbilityPO ability = new AbilityPO();
        ability.setAbilityEname(abilityPO.getAbilityEname());
        ability.setAbilityVersion(abilityPO.getAbilityVersion());
        ability.setHirerId(abilityModifyReqBO.getHirerId());
        List<AbilityPO> abilityPOS = this.abilityMapper.queryByCond(ability);
        if (abilityPOS.size() > 0 && (collect = abilityPOS.stream().filter(a -> !abilityId.equals(a.getAbilityId())).collect(Collectors.toList())).size() > 0) {
            StringBuilder errInfo = new StringBuilder();
            errInfo.append(ability.getAbilityEname()).append("_");
            if (ability.getAbilityVersion().toUpperCase().indexOf("V") >= 0) {
                errInfo.append(ability.getAbilityVersion()).append("\u5df2\u7ecf\u5b58\u5728!");
            } else {
                errInfo.append("v").append(ability.getAbilityVersion()).append("\u5df2\u7ecf\u5b58\u5728!");
            }
            throw new ZTBusinessException(errInfo.toString());
        }
        if (abilityModifyReqBO.getInputProtocal() == null || abilityModifyReqBO.getInputProtocal().size() <= 0) {
            StringBuffer label = new StringBuffer();
            label.append(ability.getAbilityEname()).append("_");
            if (ability.getAbilityVersion().toUpperCase().indexOf("V") >= 0) {
                label.append(ability.getAbilityVersion());
            } else {
                label.append("v").append(ability.getAbilityVersion());
            }
            throw new ZTBusinessException("\u80fd\u529b" + label.toString() + "\u63a5\u5165\u534f\u8bae\u672a\u914d\u7f6e");
        }
        collect = abilityModifyReqBO.getInputProtocal().stream().collect(Collectors.joining(","));
        abilityPO.setInputProtocal((String)collect);
        AbilityPO abilityPOBefor = this.abilityMapper.queryByAbilityId(abilityModifyReqBO.getAbilityId());
        if (StringUtils.isEmpty((Object)abilityPOBefor)) {
            StringBuilder label = new StringBuilder();
            label.append(ability.getAbilityEname()).append("_");
            if (ability.getAbilityVersion().toUpperCase().indexOf("V") >= 0) {
                label.append(ability.getAbilityVersion());
            } else {
                label.append("v").append(ability.getAbilityVersion());
            }
            throw new ZTBusinessException("\u80fd\u529b" + label.toString() + "\u4e0d\u5b58\u5728\uff01");
        }
        abilityPO.setUpdateTime(date);
        abilityPO.setUpdateUserId(abilityModifyReqBO.getUpdateUserId());
        abilityPO.setIsDraft(abilityModifyReqBO.getIsDraft());
        abilityPO.setAttendStatus(abilityPOBefor.getAttendStatus());
        abilityPO.setCheckoutTime(abilityPOBefor.getCheckoutTime());
        abilityPO.setCreateTime(abilityPOBefor.getCreateTime());
        abilityPO.setCheckinTime(abilityPOBefor.getCheckinTime());
        try {
            this.abilityMapper.updateAbilityByAbilityId(abilityPO);
        }
        catch (Exception e) {
            logger.error((Object)e);
            StringBuilder sb = new StringBuilder();
            sb.append(abilityPO.getAbilityEname()).append("_");
            if (abilityPO.getAbilityVersion().toUpperCase().indexOf("V") >= 0) {
                sb.append(abilityPO.getAbilityVersion());
            } else {
                sb.append("v").append(abilityPO.getAbilityVersion());
            }
            throw new ZTBusinessException("\u80fd\u529b" + sb.toString() + "\u66f4\u65b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
        }
        AbilityExtColumnPO abilityExtColumnPO = abilityModifyReqBO.getExtInfo();
        if (!StringUtils.isEmpty((Object)abilityExtColumnPO)) {
            abilityExtColumnPO.setAbilityId(abilityId);
            this.abilityExtColumnMapper.updateAbilityExtColumnByAbilityId(abilityExtColumnPO);
        }
        Long hirerId = abilityPO.getHirerId();
        String abilityEname = abilityPO.getAbilityEname();
        String abilityVersion_ = abilityPO.getAbilityVersion();
        AbilityAppPO abilityAppPO = new AbilityAppPO();
        abilityAppPO.setRelationType(Constants.RelationType.PROVIDE);
        abilityAppPO.setHirerId(hirerId);
        abilityAppPO.setAbilityEname(abilityEname);
        abilityAppPO.setAbilityVersion(abilityVersion_);
        AbilityAppPO abilityAppBefor = this.abilityAppMapper.queryLimitOne(abilityAppPO);
        if (abilityAppBefor != null) {
            appPO = this.appMapper.queryByAppId(abilityModifyReqBO.getAppId());
            abilityAppPO.setAppCode(appPO.getAppCode());
            abilityAppPO.setAbilityAppId(abilityAppBefor.getAbilityAppId());
            this.abilityAppMapper.updateAbilityAppByAbilityAppId(abilityAppPO);
        } else {
            appPO = this.appMapper.queryByAppId(abilityModifyReqBO.getAppId());
            abilityAppPO.setAppCode(appPO.getAppCode());
            this.abilityAppMapper.insertSelective(abilityAppPO);
        }
        AbilityExtDefaultPO abilityExtDefaultPO = new AbilityExtDefaultPO();
        abilityExtDefaultPO.setAbilityId(abilityId);
        abilityExtDefaultPO.setOvertime(abilityModifyReqBO.getOvertime());
        abilityExtDefaultPO.setRetryTime(abilityModifyReqBO.getRetryTime());
        this.abilityExtDefaultMapper.updateAbilityExtDefaultByAbilityId(abilityExtDefaultPO);
        RateLimiterAbilityDefaultPO rateLimiterAbilityDefaultPO = new RateLimiterAbilityDefaultPO();
        rateLimiterAbilityDefaultPO.setAbilityId(abilityId);
        rateLimiterAbilityDefaultPO.setGlobalLimit(abilityModifyReqBO.getGlobalLimit());
        rateLimiterAbilityDefaultPO.setSingleLimit(abilityModifyReqBO.getSingleLimit());
        rateLimiterAbilityDefaultPO.setRate(abilityModifyReqBO.getRate());
        rateLimiterAbilityDefaultPO.setCapacity(abilityModifyReqBO.getCapacity());
        rateLimiterAbilityDefaultPO.setDailyCapacity(abilityModifyReqBO.getDailyCapacity());
        rateLimiterAbilityDefaultPO.setSingleMaxRate(abilityModifyReqBO.getSingleMaxRate());
        rateLimiterAbilityDefaultPO.setSingleMaxCount(abilityModifyReqBO.getSingleMaxCount());
        rateLimiterAbilityDefaultPO.setSingleDailyMaxCount(abilityModifyReqBO.getSingleDailyMaxCount());
        this.rateLimiterAbilityDefaultMapper.updateRateLimiterAbilityDefaultByAbilityId(rateLimiterAbilityDefaultPO);
        Map extendInfo = abilityModifyReqBO.getExtendInfo();
        extendInfo.put("abilityId", abilityId);
        this.abilityHandlerService.handleDelete((Object)extendInfo, abilityPOBefor.getOutputProtocal());
        this.abilityHandlerService.handleAdd((Object)extendInfo, abilityModifyReqBO.getOutputProtocal());
        if ("POST".equals(abilityPOBefor.getOutputTransProtocal()) || "GET".equals(abilityPOBefor.getOutputTransProtocal()) || "Kafka".equals(abilityPOBefor.getOutputTransProtocal()) || "RocketMq".equals(abilityPOBefor.getOutputTransProtocal())) {
            abilityProvideHttpDefaultPO = new AbilityProvideHttpDefaultPO();
            abilityProvideHttpDefaultPO.setAbilityId(abilityId);
            AbilityProvideHttpDefaultPO abilityProvideHttpDefault = this.abilityProvideHttpDefaultMapper.queryLimitOne(abilityProvideHttpDefaultPO);
            if (!StringUtils.isEmpty((Object)abilityProvideHttpDefault)) {
                this.abilityProvideHttpDefaultMapper.deleteAbilityProvideHttpDefaultByHttpDefaultId(abilityProvideHttpDefault.getHttpDefaultId());
            }
        }
        if ("POST".equals(abilityModifyReqBO.getOutputTransProtocal()) || "GET".equals(abilityModifyReqBO.getOutputTransProtocal()) || "Kafka".equals(abilityModifyReqBO.getOutputTransProtocal()) || "RocketMq".equals(abilityModifyReqBO.getOutputTransProtocal())) {
            abilityProvideHttpDefaultPO = (AbilityProvideHttpDefaultPO)BeanMapper.map((Object)abilityModifyReqBO.getExtendInfo(), AbilityProvideHttpDefaultPO.class);
            abilityProvideHttpDefaultPO.setAbilityId(abilityId);
            AbilityProvideHttpDefaultPO abilityProvideHttpDefaultPOBefor = this.abilityProvideHttpDefaultMapper.queryLimitOne(abilityProvideHttpDefaultPO);
            if (StringUtils.isEmpty((Object)abilityProvideHttpDefaultPOBefor)) {
                this.abilityProvideHttpDefaultMapper.insertSelective(abilityProvideHttpDefaultPO);
            } else {
                abilityProvideHttpDefaultPO.setHttpDefaultId(abilityProvideHttpDefaultPOBefor.getHttpDefaultId());
                this.abilityProvideHttpDefaultMapper.updateAbilityProvideHttpDefaultByHttpDefaultId(abilityProvideHttpDefaultPO);
            }
        }
        this.abilityLogicMapper.deleteLogicScriptByAbilityId(abilityId);
        if (!StringUtils.isEmpty((Object)abilityModifyReqBO.getAbilityType()) && Constants.AbilityType.COMBINATION.equals(abilityModifyReqBO.getAbilityType())) {
            SubAbilityPO subAbilityPO = new SubAbilityPO();
            subAbilityPO.setParentAbilityId(abilityModifyReqBO.getAbilityId());
            List<SubAbilityPO> subAbilityPOS = this.subAbilityMapper.queryByCond(subAbilityPO);
            subAbilityPOS.forEach(s -> this.subAbilityMapper.deleteSubAbilityByAppSubscribeId(s.getSubAbilityId()));
            subAbilityPO.setAbilityId(abilityModifyReqBO.getSubAbilityId());
            this.subAbilityMapper.insertSelective(subAbilityPO);
            AbilityLogicPO abilityLogicPO = new AbilityLogicPO();
            abilityLogicPO.setAbilityId(abilityId);
            abilityLogicPO.setLogicScript(abilityModifyReqBO.getLogicScript());
            this.abilityLogicMapper.insertSelective(abilityLogicPO);
        }
        AbilityWsExtPO abilityWsExtPO = new AbilityWsExtPO();
        abilityWsExtPO.setAbilityId(abilityId);
        abilityWsExtPO.setAbilityWsdl(abilityModifyReqBO.getWsdl());
        this.abilityWsExtMapper.updateAbilityWsExtByAbilityId(abilityWsExtPO);
        AbilityExtPO abilityExtPO = new AbilityExtPO();
        abilityExtPO.setAbilityId(abilityId);
        AbilityExtPO abilityExtReq = this.abilityExtMapper.queryLimitOne(abilityExtPO);
        if (abilityModifyReqBO.getInputProtocal().contains("ws")) {
            this.abilitySvcComponent.deployCustomSvcFromWsdl(abilityPO, abilityWsExtPO, abilityExtReq);
        } else {
            AbilityParamPO abilityParamPO = new AbilityParamPO();
            abilityParamPO.setAbilityId(abilityId);
            abilityParamPO.setReqJsonschema(abilityModifyReqBO.getReqJsonschema());
            abilityParamPO.setRspJsonschema(abilityModifyReqBO.getRspJsonschema());
            abilityParamPO.setReqXsd(StringUtils.isEmpty((Object)abilityModifyReqBO.getReqJsonschema()) ? null : this.abilitySvcComponent.jsonSchemaToXsd(abilityModifyReqBO.getReqJsonschema(), "xml"));
            abilityParamPO.setRespXsd(StringUtils.isEmpty((Object)abilityModifyReqBO.getRspJsonschema()) ? null : this.abilitySvcComponent.jsonSchemaToXsd(abilityModifyReqBO.getRspJsonschema(), "xml"));
            this.abilityParamMapper.updateByAbilityId(abilityParamPO);
            AbilityParamTargetPo abilityParamTargetPo = new AbilityParamTargetPo();
            abilityParamTargetPo.setAbilityId(abilityId);
            abilityParamTargetPo.setTargetReqJsonschema(abilityModifyReqBO.getTargetReqJsonschema());
            abilityParamTargetPo.setTargetRspJsonschema(abilityModifyReqBO.getTargetRspJsonschema());
            abilityParamTargetPo.setTargetReqXsd(StringUtils.isEmpty((Object)abilityModifyReqBO.getTargetReqJsonschema()) ? null : this.abilitySvcComponent.jsonSchemaToXsd(abilityModifyReqBO.getTargetReqJsonschema(), "xml"));
            abilityParamTargetPo.setTargetRspXsd(StringUtils.isEmpty((Object)abilityModifyReqBO.getTargetRspJsonschema()) ? null : this.abilitySvcComponent.jsonSchemaToXsd(abilityModifyReqBO.getTargetRspJsonschema(), "xml"));
            this.abilityParamTargetMapper.updateByAbilityId(abilityParamTargetPo);
            this.abilitySvcComponent.deployCustomSvc(abilityPO, abilityExtReq, abilityParamPO, abilityParamTargetPo);
        }
        AbilityToVegaPo change = (AbilityToVegaPo)BeanMapper.map((Object)abilityModifyReqBO, AbilityToVegaPo.class);
        if (ObjectUtils.isEmpty((Object)change.getForwardStatus())) {
            change.setForwardStatus(0);
        }
        this.abilityToVegaMapper.insertOrUpdateSelective(change);
        this.abilityChangeRecord(abilityId, AbilityOperateTypeEnum.UPDATE.getValue(), abilityModifyReqBO.getModifyRecord(), userId, date);
        return RspBO.success((Object)abilityPO);
    }

    @Override
    public void abilityChangeRecord(Long abilityId, Integer operType, String modifyRecord, Long userId, Date date) {
        AbilityModifyPO abilityModifyPO = new AbilityModifyPO();
        abilityModifyPO.setAbilityId(abilityId);
        abilityModifyPO.setOperType(operType);
        abilityModifyPO.setModifyRecord(modifyRecord);
        abilityModifyPO.setOperId(userId);
        abilityModifyPO.setOperTime(date);
        this.abilityModifyMapper.insertSelective(abilityModifyPO);
    }

    @Override
    @Transactional
    public RspBO simpleRegister(AbilityAddReqBO abilityAddReqBO) {
        Long userId = Long.valueOf(UserHolder.getUserId());
        AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
        Long tenantId = Long.valueOf(authorityUserInfoBO.getTenantId());
        if (StringUtils.isEmpty((Object)userId)) {
            throw new ZTBusinessException("\u83b7\u53d6\u7528\u6237id\u5931\u8d25");
        }
        if (tenantId == null) {
            throw new ZTBusinessException("\u83b7\u53d6\u79df\u6237id\u5931\u8d25");
        }
        abilityAddReqBO.setCreateUserId(userId);
        abilityAddReqBO.setHirerId(tenantId);
        Date date = new Date();
        AbilityPO abilityPO = (AbilityPO)BeanMapper.map((Object)abilityAddReqBO, AbilityPO.class);
        AbilityPO ability = new AbilityPO();
        ability.setAbilityEname(abilityPO.getAbilityEname());
        ability.setAbilityVersion(abilityPO.getAbilityVersion());
        ability.setHirerId(abilityAddReqBO.getHirerId());
        ability = this.abilityMapper.queryLimitOne(ability);
        if (ability != null) {
            StringBuilder errInfo = new StringBuilder();
            errInfo.append(ability.getAbilityEname()).append("_");
            if (ability.getAbilityVersion().toUpperCase().indexOf("V") >= 0) {
                errInfo.append(ability.getAbilityVersion()).append("\u5df2\u7ecf\u5b58\u5728!");
            } else {
                errInfo.append("v").append(ability.getAbilityVersion()).append("\u5df2\u7ecf\u5b58\u5728!");
            }
            throw new ZTBusinessException(errInfo.toString());
        }
        abilityPO.setCreateTime(date);
        abilityPO.setIsDraft(Constants.AbilityDraftType.NORMAL);
        if (abilityAddReqBO.getInputProtocal() == null || abilityAddReqBO.getInputProtocal().size() <= 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(abilityAddReqBO.getAbilityEname()).append("_");
            if (abilityAddReqBO.getAbilityVersion().toUpperCase().indexOf("V") >= 0) {
                sb.append(abilityAddReqBO.getAbilityVersion());
            } else {
                sb.append("v").append(abilityAddReqBO.getAbilityVersion());
            }
            throw new ZTBusinessException("\u80fd\u529b" + sb.toString() + "\u63a5\u5165\u534f\u8bae\u672a\u914d\u7f6e");
        }
        String collect = abilityAddReqBO.getInputProtocal().stream().collect(Collectors.joining(","));
        abilityPO.setInputProtocal(collect);
        abilityPO.setAttendStatus(Constants.AttendStatus.SIGN_OUT);
        if (abilityPO.getAppCodeSource() == null) {
            abilityPO.setAppCodeSource(0);
        }
        if (abilityPO.getAbilityType() == null) {
            abilityPO.setAbilityType(0);
        }
        this.abilityMapper.insertSelective(abilityPO);
        Long abilityId = abilityPO.getAbilityId();
        AbilityExtColumnPO abilityExtColumnPO = abilityAddReqBO.getExtInfo();
        if (abilityExtColumnPO == null) {
            abilityExtColumnPO = new AbilityExtColumnPO();
        }
        abilityExtColumnPO.setAbilityId(abilityId);
        this.abilityExtColumnMapper.insertSelective(abilityExtColumnPO);
        AbilityAppPO abilityAppPO = new AbilityAppPO();
        abilityAppPO.setRelationType(Constants.RelationType.PROVIDE);
        abilityAppPO.setAbilityVersion(abilityPO.getAbilityVersion());
        abilityAppPO.setAbilityEname(abilityPO.getAbilityEname());
        abilityAppPO.setHirerId(abilityPO.getHirerId());
        AppPO appPO = this.appMapper.queryByAppId(abilityAddReqBO.getAppId());
        abilityAppPO.setAppCode(appPO.getAppCode());
        this.abilityAppMapper.insertSelective(abilityAppPO);
        AbilityExtDefaultPO abilityExtDefaultPO = new AbilityExtDefaultPO();
        abilityExtDefaultPO.setAbilityId(abilityId);
        if (abilityAddReqBO.getOvertime() != null) {
            abilityExtDefaultPO.setOvertime(abilityAddReqBO.getOvertime());
        } else {
            abilityExtDefaultPO.setOvertime(Integer.valueOf(SystemCodeMap.getSystemCode((String)"1038", (String)"overtime").getDicValue()));
        }
        if (abilityAddReqBO.getRetryTime() != null) {
            abilityExtDefaultPO.setRetryTime(abilityAddReqBO.getRetryTime());
        } else {
            abilityExtDefaultPO.setRetryTime(Integer.valueOf(SystemCodeMap.getSystemCode((String)"1038", (String)"retryTime").getDicValue()));
        }
        this.abilityExtDefaultMapper.insertSelective(abilityExtDefaultPO);
        RateLimiterAbilityDefaultPO rateLimiterAbilityDefaultPO = new RateLimiterAbilityDefaultPO();
        rateLimiterAbilityDefaultPO.setAbilityId(abilityId);
        if (abilityAddReqBO.getRate() != null) {
            rateLimiterAbilityDefaultPO.setRate(abilityAddReqBO.getRate());
        } else {
            rateLimiterAbilityDefaultPO.setRate(Integer.valueOf(SystemCodeMap.getSystemCode((String)"1038", (String)"rate").getDicValue()));
        }
        if (abilityAddReqBO.getCapacity() != null) {
            rateLimiterAbilityDefaultPO.setCapacity(abilityAddReqBO.getCapacity());
        } else {
            rateLimiterAbilityDefaultPO.setCapacity(Integer.valueOf(SystemCodeMap.getSystemCode((String)"1038", (String)"capacity").getDicValue()));
        }
        this.rateLimiterAbilityDefaultMapper.insertSelective(rateLimiterAbilityDefaultPO);
        HashMap<String, Long> extendInfo = abilityAddReqBO.getExtendInfo();
        if (StringUtils.isEmpty((Object)extendInfo)) {
            extendInfo = new HashMap<String, Long>();
        }
        extendInfo.put("abilityId", abilityId);
        this.abilityHandlerService.handleAdd(extendInfo, abilityAddReqBO.getOutputProtocal());
        if (!"rpc".equals(abilityAddReqBO.getOutputTransProtocal())) {
            AbilityProvideHttpDefaultPO abilityProvideHttpDefaultPO = (AbilityProvideHttpDefaultPO)BeanMapper.map((Object)abilityAddReqBO.getExtendInfo(), AbilityProvideHttpDefaultPO.class);
            this.abilityProvideHttpDefaultMapper.insertSelective(abilityProvideHttpDefaultPO);
        }
        if (Constants.AbilityType.COMBINATION.equals(abilityAddReqBO.getAbilityType())) {
            SubAbilityPO subAbilityPO = new SubAbilityPO();
            subAbilityPO.setParentAbilityId(abilityId);
            subAbilityPO.setAbilityId(abilityAddReqBO.getSubAbilityId());
            this.subAbilityMapper.insertSelective(subAbilityPO);
            AbilityLogicPO abilityLogicPO = new AbilityLogicPO();
            abilityLogicPO.setAbilityId(abilityId);
            abilityLogicPO.setLogicScript(abilityAddReqBO.getLogicScript());
            this.abilityLogicMapper.insertSelective(abilityLogicPO);
        }
        AbilityExtPO abilityExtPO = new AbilityExtPO();
        abilityExtPO.setAbilityId(abilityId);
        this.abilityExtMapper.insertSelective(abilityExtPO);
        AbilityParamPO abilityParamPO = new AbilityParamPO();
        abilityParamPO.setAbilityId(abilityId);
        abilityParamPO.setReqXsdFile("req");
        abilityParamPO.setRespXsdFile("rsp");
        abilityParamPO.setReqJsonschemaFilename("req");
        abilityParamPO.setRspJsonschemaFilename("rsp");
        abilityParamPO.setReqJsonschema(abilityAddReqBO.getReqJsonschema());
        abilityParamPO.setRspJsonschema(abilityAddReqBO.getRspJsonschema());
        abilityParamPO.setReqXsd(this.abilitySvcComponent.jsonSchemaToXsd(abilityAddReqBO.getReqJsonschema(), "xml"));
        abilityParamPO.setRespXsd(this.abilitySvcComponent.jsonSchemaToXsd(abilityAddReqBO.getRspJsonschema(), "xml"));
        this.abilityParamMapper.insertSelective(abilityParamPO);
        AbilityParamTargetPo abilityParamTargetPo = new AbilityParamTargetPo();
        abilityParamTargetPo.setAbilityId(abilityId);
        abilityParamTargetPo.setTargetReqXsdFile("targetReq");
        abilityParamTargetPo.setTargetRspXsdFile("targetRsp");
        abilityParamTargetPo.setTargetReqJsonschemaFilename("targetReq");
        abilityParamTargetPo.setTargetRspJsonschemaFilename("targetRsp");
        abilityParamTargetPo.setTargetReqJsonschema(abilityAddReqBO.getTargetReqJsonschema());
        abilityParamTargetPo.setTargetRspJsonschema(abilityAddReqBO.getTargetRspJsonschema());
        abilityParamTargetPo.setTargetReqXsd(StringUtils.isEmpty((Object)abilityAddReqBO.getTargetReqJsonschema()) ? null : this.abilitySvcComponent.jsonSchemaToXsd(abilityAddReqBO.getTargetReqJsonschema(), "xml"));
        abilityParamTargetPo.setTargetRspXsd(StringUtils.isEmpty((Object)abilityAddReqBO.getTargetRspJsonschema()) ? null : this.abilitySvcComponent.jsonSchemaToXsd(abilityAddReqBO.getTargetRspJsonschema(), "xml"));
        this.abilityParamTargetMapper.insertSelective(abilityParamTargetPo);
        this.abilitySvcComponent.deployCustomSvc(abilityPO, abilityExtPO, abilityParamPO, abilityParamTargetPo);
        this.addDeploy(abilityAddReqBO, appPO, abilityAppPO);
        return RspBO.success((Object)abilityPO);
    }

    @Override
    public RspBO checkAbility(AbilityAddReqBO abilityAddReqBO) {
        AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
        Long tenantId = Long.valueOf(authorityUserInfoBO.getTenantId());
        ValidBatchUtils.isNotEmpty((Object)abilityAddReqBO, (String[])new String[]{"abilityEname", "abilityVersion"});
        AbilityPO ability = new AbilityPO();
        ability.setAbilityEname(abilityAddReqBO.getAbilityEname());
        ability.setAbilityVersion(abilityAddReqBO.getAbilityVersion());
        ability.setHirerId(tenantId);
        ability = this.abilityMapper.queryLimitOne(ability);
        if (ability != null) {
            return RspBO.success((Object)false);
        }
        return RspBO.success((Object)true);
    }

    @Override
    public RspBO qryAbilityOutputTransProtocal(AbilityAddReqBO abilityAddReqBO) {
        ArrayList list = null;
        if (abilityAddReqBO.getOutputClient() == null) {
            throw new ZTBusinessException("\u843d\u5730\u5ba2\u6237\u7aef\u9009\u9879\u4e3a\u7a7a!");
        }
        switch (abilityAddReqBO.getOutputClient()) {
            case "PushClient": {
                list = Lists.newArrayList((Object[])new OptionGenerRspBO[]{new OptionGenerRspBO((Serializable)((Object)"RocketMq"), (Serializable)((Object)"RocketMq")), new OptionGenerRspBO((Serializable)((Object)"Kafka"), (Serializable)((Object)"Kafka"))});
                break;
            }
            case "HttpClient": 
            case "WebClient": {
                list = Lists.newArrayList((Object[])new OptionGenerRspBO[]{new OptionGenerRspBO((Serializable)((Object)"POST"), (Serializable)((Object)"POST")), new OptionGenerRspBO((Serializable)((Object)"GET"), (Serializable)((Object)"GET"))});
                break;
            }
            default: {
                throw new ZTBusinessException("\u6ca1\u6709\u627e\u5230\u6b64\u843d\u5730\u534f\u8bae\u5904\u7406\u7c7b\u578b\uff1a" + abilityAddReqBO.getOutputClient());
            }
        }
        return RspBO.success((Object)list);
    }

    @Override
    public RspBO abilityModifyList(AbilityDetailReqBO abilityDetailReqBO) {
        StringBuilder order = new StringBuilder();
        if (abilityDetailReqBO.getSortName() != null) {
            order.append(abilityDetailReqBO.getSortName());
            if (abilityDetailReqBO.getSortOrder() != null) {
                order.append(" ");
                order.append(abilityDetailReqBO.getSortOrder());
            }
        } else {
            order.append("oper_time").append(" DESC");
        }
        Page page = !StringUtils.isEmpty((Object)order) ? PageMethod.startPage((int)abilityDetailReqBO.getPageNo(), (int)abilityDetailReqBO.getPageSize(), (String)order.toString()) : PageMethod.startPage((int)abilityDetailReqBO.getPageNo(), (int)abilityDetailReqBO.getPageSize());
        AbilityModifyPO abilityModifyPO = (AbilityModifyPO)BeanMapper.map((Object)abilityDetailReqBO, AbilityModifyPO.class);
        List<AbilityModifyPO> abilityModifyPOS = this.abilityModifyMapper.queryByCond(abilityModifyPO);
        List abilityModifyRspBOS = BeanMapper.mapList(abilityModifyPOS, AbilityModifyRspBO.class);
        abilityModifyRspBOS.forEach(parm -> {
            if (!StringUtils.isEmpty((Object)parm.getOperId())) {
                parm.setOperName(this.authorityService.getUserInfoByUserId(parm.getOperId().toString()).getName());
            }
            parm.setOperTypeName(SystemCodeMap.getSystemCode((String)"1038", (String)parm.getOperType().toString()).getDicValue());
        });
        RspPage rspPage = new RspPage(Integer.valueOf(abilityDetailReqBO.getPageSize()), Integer.valueOf(abilityDetailReqBO.getPageNo()), abilityModifyRspBOS, Long.valueOf(page.getTotal()));
        return RspBO.success((Object)rspPage);
    }

    private void notifyModify(List<Long> abilityIds, int status) {
        AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
        Long tenantId = Long.valueOf(authorityUserInfoBO.getTenantId());
        ModifyStatusBO modifyStatusBO = new ModifyStatusBO();
        modifyStatusBO.setHirerId(tenantId);
        modifyStatusBO.setFirstLevel(FisrtLevelEnum.ABILITY.getCode());
        modifyStatusBO.setSecondLevel(SecondLevelEnum.ABILITY_BASIC.getCode());
        modifyStatusBO.setPrimaryIds(abilityIds);
        modifyStatusBO.setStatus(Integer.valueOf(status));
        this.pubSubMsgHandler.abilityStatus(modifyStatusBO, "CHECK_MODIFY");
    }

    private void addDeploy(AbilityAddReqBO abilityAddReqBO, AppPO appPO, AbilityAppPO abilityAppPO) {
        ClusterPO clusterPO = new ClusterPO();
        clusterPO.setHirerId(abilityAddReqBO.getHirerId());
        List<ClusterPO> clusterPOS = this.clusterMapper.queryByCond(clusterPO);
        if (CollectionUtils.isEmpty(clusterPOS) || clusterPOS.size() > 1) {
            return;
        }
        clusterPO = clusterPOS.get(0);
        AppRegionPO appRegionPO = new AppRegionPO();
        appRegionPO.setAppCode(appPO.getAppCode());
        appRegionPO.setHirerId(appPO.getHirerId());
        appRegionPO.setClusterId(clusterPO.getClusterId());
        List<AppRegionPO> appRegionPOS = this.appRegionMapper.queryByCond(appRegionPO);
        if (CollectionUtils.isEmpty(appRegionPOS)) {
            return;
        }
        for (AppRegionPO tmp : appRegionPOS) {
            RegionPO regionPO = new RegionPO();
            regionPO.setRegionCode(tmp.getRegionCode());
            regionPO.setHirerId(abilityAddReqBO.getHirerId());
            if (!(regionPO = this.regionMapper.queryLimitOne(regionPO)).getRegionType().equals(0)) continue;
            AbilityProvideDeployPO abilityProvideDeployPO = new AbilityProvideDeployPO();
            abilityProvideDeployPO.setAbilityAppId(abilityAppPO.getAbilityAppId());
            abilityProvideDeployPO.setRegionCode(regionPO.getRegionCode());
            abilityProvideDeployPO.setClusterId(clusterPO.getClusterId());
            abilityProvideDeployPO.setDeployStatus(0);
            abilityProvideDeployPO.setCreateUserId(1L);
            abilityProvideDeployPO.setCreateTime(new Date());
            abilityProvideDeployPO.setProvideDeployId(this.idGenerator.snowflakeId());
            this.abilityProvideDeployMapper.insertSelective(abilityProvideDeployPO);
            return;
        }
    }
}

