/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.app.service.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.page.PageMethod;
import com.ohaotian.abilityadmin.ability.model.bo.DelAbilitySubscribeReqBO;
import com.ohaotian.abilityadmin.app.model.bo.AppSubscribeDeployBO;
import com.ohaotian.abilityadmin.app.model.bo.QryAppSubscribeReqBO;
import com.ohaotian.abilityadmin.app.model.bo.QryAppSubscribeRspBO;
import com.ohaotian.abilityadmin.app.service.AppSubscribeService;
import com.ohaotian.abilityadmin.mapper.AbilityAppMapper;
import com.ohaotian.abilityadmin.mapper.AbilityMapper;
import com.ohaotian.abilityadmin.mapper.AppMapper;
import com.ohaotian.abilityadmin.mapper.AppSubscribeDeployMapper;
import com.ohaotian.abilityadmin.mapper.ClusterMapper;
import com.ohaotian.abilityadmin.mapper.RateLimiterSubscribeMapper;
import com.ohaotian.abilityadmin.model.po.AbilityAppPO;
import com.ohaotian.abilityadmin.model.po.AbilityPO;
import com.ohaotian.abilityadmin.model.po.AppPO;
import com.ohaotian.abilityadmin.model.po.AppSubscribeDeployPO;
import com.ohaotian.abilityadmin.model.po.ClusterPO;
import com.ohaotian.abilityadmin.model.po.RateLimiterSubscribePO;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.portalcommon.constant.CodeMsg;
import com.ohaotian.portalcommon.constant.Constants;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.page.RspPage;
import com.ohaotian.portalcommon.util.StrUtil;
import com.ohaotian.portalcommon.util.ValidBatchUtils;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AppSubscribeServiceImpl
implements AppSubscribeService {
    private static final Logger log = LogManager.getLogger(AppSubscribeServiceImpl.class);
    @Resource
    private AppSubscribeDeployMapper appSubscribeDeployMapper;
    @Resource
    private AbilityAppMapper abilityAppMapper;
    @Resource
    private AbilityMapper abilityMapper;
    @Resource
    private AppMapper appMapper;
    @Resource
    private ClusterMapper clusterMapper;
    @Resource
    private RateLimiterSubscribeMapper rateLimiterSubscribeMapper;
    @Resource
    AuthorityService authorityService;

    @Override
    public RspBO<RspPage<QryAppSubscribeRspBO>> qryAppSubscribeListPageByCond(QryAppSubscribeReqBO qryAppSubscribeReqBO) throws ZTBusinessException {
        Long tenantId = Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId());
        qryAppSubscribeReqBO.setHirerId(tenantId);
        log.debug("AppSubscribeServiceImpl.qryAppSubscribeListPageByCond:{}", (Object)qryAppSubscribeReqBO);
        if (StringUtils.isEmpty((Object)qryAppSubscribeReqBO.getAppId())) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        if (!StringUtils.isEmpty((Object)qryAppSubscribeReqBO.getAbilityName())) {
            qryAppSubscribeReqBO.setAbilityName("%" + qryAppSubscribeReqBO.getAbilityName() + "%");
        }
        if (!StringUtils.isEmpty((Object)qryAppSubscribeReqBO.getAbilityEname())) {
            qryAppSubscribeReqBO.setAbilityEname("%" + qryAppSubscribeReqBO.getAbilityEname() + "%");
        }
        if (!StringUtils.isEmpty((Object)qryAppSubscribeReqBO.getInputProtocal())) {
            qryAppSubscribeReqBO.setInputProtocal("%" + qryAppSubscribeReqBO.getInputProtocal() + "%");
        }
        if (!StringUtils.isEmpty((Object)qryAppSubscribeReqBO.getOutputProtocal())) {
            qryAppSubscribeReqBO.setOutputProtocal("%" + qryAppSubscribeReqBO.getOutputProtocal() + "%");
        }
        StringBuilder order = new StringBuilder();
        if (!StringUtils.isEmpty((Object)qryAppSubscribeReqBO.getSortName())) {
            order.append(StrUtil.CamelToUnderline((String)qryAppSubscribeReqBO.getSortName()));
            if (!StringUtils.isEmpty((Object)qryAppSubscribeReqBO.getSortOrder())) {
                order.append(" ").append(qryAppSubscribeReqBO.getSortOrder());
            }
        }
        int pageNo = qryAppSubscribeReqBO.getPageNo();
        int pageSize = qryAppSubscribeReqBO.getPageSize();
        Page page = !StringUtils.isEmpty((Object)order) ? PageMethod.startPage((int)pageNo, (int)pageSize, (String)order.toString()) : PageMethod.startPage((int)pageNo, (int)pageSize);
        List<QryAppSubscribeRspBO> appRspBOList = this.appSubscribeDeployMapper.queryAppSubscribePageByCond(qryAppSubscribeReqBO);
        appRspBOList.stream().map(bo -> {
            ClusterPO clusterPO = this.clusterMapper.queryByClusterId(bo.getClusterId());
            bo.setClusterName(clusterPO.getClusterName());
            return bo;
        }).collect(Collectors.toList());
        RspPage rspPage = new RspPage(Integer.valueOf(pageSize), Integer.valueOf(pageNo), appRspBOList, Long.valueOf(page.getTotal()));
        return RspBO.success((Object)rspPage);
    }

    @Override
    public RspBO<RspPage<QryAppSubscribeRspBO>> qryAppUnSubscribeListPageByCond(QryAppSubscribeReqBO qryAppSubscribeReqBO) throws ZTBusinessException {
        Long tenantId = Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId());
        qryAppSubscribeReqBO.setHirerId(tenantId);
        log.debug("AppSubscribeServiceImpl.qryAppUnSubscribeListPageByCond:{}", (Object)qryAppSubscribeReqBO);
        if (StringUtils.isEmpty((Object)qryAppSubscribeReqBO.getAppId())) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        if (!StringUtils.isEmpty((Object)qryAppSubscribeReqBO.getAbilityName())) {
            qryAppSubscribeReqBO.setAbilityName("%" + qryAppSubscribeReqBO.getAbilityName() + "%");
        }
        if (!StringUtils.isEmpty((Object)qryAppSubscribeReqBO.getAbilityEname())) {
            qryAppSubscribeReqBO.setAbilityEname("%" + qryAppSubscribeReqBO.getAbilityEname() + "%");
        }
        if (!StringUtils.isEmpty((Object)qryAppSubscribeReqBO.getInputProtocal())) {
            qryAppSubscribeReqBO.setInputProtocal("%" + qryAppSubscribeReqBO.getInputProtocal() + "%");
        }
        if (!StringUtils.isEmpty((Object)qryAppSubscribeReqBO.getOutputProtocal())) {
            qryAppSubscribeReqBO.setOutputProtocal("%" + qryAppSubscribeReqBO.getOutputProtocal() + "%");
        }
        StringBuilder order = new StringBuilder();
        if (!StringUtils.isEmpty((Object)qryAppSubscribeReqBO.getSortName())) {
            order.append(StrUtil.CamelToUnderline((String)qryAppSubscribeReqBO.getSortName()));
            if (!StringUtils.isEmpty((Object)qryAppSubscribeReqBO.getSortOrder())) {
                order.append(" ").append(qryAppSubscribeReqBO.getSortOrder());
            }
        }
        int pageNo = qryAppSubscribeReqBO.getPageNo();
        int pageSize = qryAppSubscribeReqBO.getPageSize();
        Page page = !StringUtils.isEmpty((Object)order) ? PageMethod.startPage((int)pageNo, (int)pageSize, (String)order.toString()) : PageMethod.startPage((int)pageNo, (int)pageSize);
        List<QryAppSubscribeRspBO> appRspBOList = this.appSubscribeDeployMapper.queryAppUnSubscribePageByCond(qryAppSubscribeReqBO);
        appRspBOList.stream().map(bo -> {
            ClusterPO clusterPO = this.clusterMapper.queryByClusterId(bo.getClusterId());
            bo.setClusterName(clusterPO.getClusterName());
            return bo;
        }).collect(Collectors.toList());
        RspPage rspPage = new RspPage(Integer.valueOf(pageSize), Integer.valueOf(pageNo), appRspBOList, Long.valueOf(page.getTotal()));
        return RspBO.success((Object)rspPage);
    }

    @Override
    @Transactional(rollbackFor={ZTBusinessException.class})
    public RspBO<Boolean> deleteAppSubscribe(List<AppSubscribeDeployBO> list) throws ZTBusinessException {
        log.debug("AppSubscribeServiceImpl.deleteAppSubscribe:{}", list);
        list.forEach(bo -> ValidBatchUtils.isNotEmpty((Object)bo, (String[])new String[]{"subscribeDeployId", "abilityAppId"}));
        try {
            for (AppSubscribeDeployBO appSubscribeDeployBO : list) {
                AppSubscribeDeployPO appSubscribeDeployPO = new AppSubscribeDeployPO();
                appSubscribeDeployPO.setAbilityAppId(appSubscribeDeployBO.getAbilityAppId());
                List<AppSubscribeDeployPO> appSubscribeDeployPOList = this.appSubscribeDeployMapper.queryByCond(appSubscribeDeployPO);
                if (!CollectionUtils.isEmpty(appSubscribeDeployPOList) && appSubscribeDeployPOList.size() > 1) {
                    this.appSubscribeDeployMapper.deleteAppSubscribeDeployBySubscribeDeployId(appSubscribeDeployBO.getSubscribeDeployId());
                } else {
                    this.appSubscribeDeployMapper.deleteAppSubscribeDeployByRegionId(appSubscribeDeployBO.getAbilityAppId());
                    this.abilityAppMapper.deleteAbilityAppByAbilityAppId(appSubscribeDeployBO.getAbilityAppId());
                }
                this.rateLimiterSubscribeMapper.deleteRateLimiterSubscribeBySubscribeDeployId(appSubscribeDeployBO.getSubscribeDeployId());
            }
            return RspBO.success((Object)true);
        }
        catch (Exception e) {
            log.error("AppServiceImpl.deleteAppSubscribe:{}", (Object)CodeMsg.APP_UNSUBSCRIBE_ERROR.getMessage(), (Object)e);
            throw new ZTBusinessException(CodeMsg.APP_UNSUBSCRIBE_ERROR.getMessage());
        }
    }

    @Override
    @Transactional(rollbackFor={ZTBusinessException.class})
    public RspBO<Boolean> addAppSubscribe(List<AppSubscribeDeployBO> list) throws ZTBusinessException {
        Long tenantId = Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId());
        log.debug("AppSubscribeServiceImpl.addAppSubscribe:{}", list);
        list.forEach(bo -> ValidBatchUtils.isNotEmpty((Object)bo, (String[])new String[]{"clusterId", "abilityId", "appId", "capacity", "dailyCapacity", "rate", "singleMaxRate", "singleMaxCount", "singleDailyMaxCount"}));
        try {
            Long userId = Long.parseLong(UserHolder.getUserId());
            Date currentDate = new Date();
            for (AppSubscribeDeployBO appSubscribeDeployBO : list) {
                AbilityAppPO abilityAppPO = (AbilityAppPO)BeanMapper.map((Object)appSubscribeDeployBO, AbilityAppPO.class);
                abilityAppPO.setRelationType(Constants.RelationType.SUBSCRIBE);
                abilityAppPO.setHirerId(tenantId);
                AbilityPO abilityPO = this.abilityMapper.queryByAbilityId(appSubscribeDeployBO.getAbilityId());
                abilityAppPO.setAbilityEname(abilityPO.getAbilityEname());
                abilityAppPO.setAbilityVersion(abilityPO.getAbilityVersion());
                AppPO appPO = this.appMapper.queryByAppId(appSubscribeDeployBO.getAppId());
                abilityAppPO.setAppCode(appPO.getAppCode());
                List<AbilityAppPO> abilityAppPOList = this.abilityAppMapper.queryByCond(abilityAppPO);
                AppSubscribeDeployPO appSubscribeDeployPO = (AppSubscribeDeployPO)BeanMapper.map((Object)appSubscribeDeployBO, AppSubscribeDeployPO.class);
                appSubscribeDeployPO.setDeployUserId(userId);
                appSubscribeDeployPO.setDeployTime(currentDate);
                if (!CollectionUtils.isEmpty(abilityAppPOList) && abilityAppPOList.size() > 0) {
                    DelAbilitySubscribeReqBO delAbilitySubscribeReqBO = new DelAbilitySubscribeReqBO();
                    delAbilitySubscribeReqBO.setAbilityAppId(abilityAppPOList.get(0).getAbilityAppId());
                    delAbilitySubscribeReqBO.setClusterId(appSubscribeDeployPO.getClusterId());
                    this.appSubscribeDeployMapper.deleteAppSubscribeDeployByCond(delAbilitySubscribeReqBO);
                    appSubscribeDeployPO.setAbilityAppId(abilityAppPOList.get(0).getAbilityAppId());
                    this.appSubscribeDeployMapper.insertSelective(appSubscribeDeployPO);
                } else {
                    this.abilityAppMapper.insertSelective(abilityAppPO);
                    appSubscribeDeployPO.setAbilityAppId(abilityAppPO.getAbilityAppId());
                    this.appSubscribeDeployMapper.insertSelective(appSubscribeDeployPO);
                }
                RateLimiterSubscribePO rateLimiterSubscribePO = new RateLimiterSubscribePO();
                rateLimiterSubscribePO.setCapacity(appSubscribeDeployBO.getCapacity());
                rateLimiterSubscribePO.setDailyCapacity(appSubscribeDeployBO.getDailyCapacity());
                rateLimiterSubscribePO.setRate(appSubscribeDeployBO.getRate());
                rateLimiterSubscribePO.setSingleMaxRate(appSubscribeDeployBO.getSingleMaxRate());
                rateLimiterSubscribePO.setSingleMaxCount(appSubscribeDeployBO.getSingleMaxCount());
                rateLimiterSubscribePO.setSingleDailyMaxCount(appSubscribeDeployBO.getSingleDailyMaxCount());
                rateLimiterSubscribePO.setSubscribeDeployId(appSubscribeDeployPO.getSubscribeDeployId());
                rateLimiterSubscribePO.setCreateTime(currentDate);
                rateLimiterSubscribePO.setCreateUserId(userId);
                this.rateLimiterSubscribeMapper.insertSelective(rateLimiterSubscribePO);
            }
            return RspBO.success((Object)true);
        }
        catch (Exception e) {
            log.error("AppServiceImpl.addAppSubscribe:{}", (Object)CodeMsg.APP_SUBSCRIBE_ERROR.getMessage(), (Object)e);
            throw new ZTBusinessException(CodeMsg.APP_SUBSCRIBE_ERROR.getMessage());
        }
    }
}

