/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.config.pubsub.redis;

import com.ohaotian.abilityadmin.config.pubsub.ChannelNaming;
import com.ohaotian.abilityadmin.config.pubsub.properties.PubSubResProperties;
import com.ohaotian.abilityadmin.config.pubsub.redis.PubSubRedisConsumer;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.portalcommon.config.cluster.AdminClusterConfig;
import java.util.concurrent.CompletableFuture;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPubSub;

@Configuration
@ConditionalOnProperty(prefix="system.parma", name={"syncWay"}, havingValue="redis")
public class PubSubRedisConfiguration {
    private static final Logger log = LoggerFactory.getLogger(PubSubRedisConfiguration.class);
    @Autowired
    private PubSubResProperties pubSubResProperties;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private PubSubRedisConsumer pubSubRedisConsumer;
    @Autowired
    AdminClusterConfig adminClusterConfig;

    @Bean
    @PostConstruct
    public void exteriorRedisConsumer() {
        String pushChannel = ChannelNaming.get(this.pubSubResProperties.getWeb2admin() + "_" + this.adminClusterConfig.getName());
        CompletableFuture<Void> runFuture = CompletableFuture.runAsync(() -> {
            while (true) {
                log.info("\u7cfb\u7edf\u88c5\u8f7dRedis\u6570\u636e\u6d88\u8d39\u8005\uff1aPubSubRedisConsumer");
                try {
                    log.info("Redis \u8ba2\u9605\u901a\u9053\uff1a{}", (Object)pushChannel);
                    this.cacheClient.subscribe((JedisPubSub)this.pubSubRedisConsumer, pushChannel);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u5f02\u5e38\u6267\u884cRedis\u8ba2\u9605\u9519\u8bef" + pushChannel + e.getMessage());
                    continue;
                }
                break;
            }
        });
    }

    @Autowired
    public PubSubRedisConfiguration() {
    }
}

