/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.ability.service.impl;

import com.ohaotian.abilityadmin.ability.service.AbilityParameterTargetTemplateService;
import com.ohaotian.abilityadmin.mapper.AbilityParamMapper;
import com.ohaotian.abilityadmin.model.po.AbilityParamPO;
import com.ohaotian.piscesplatform.mapper.AbilityParamTargetMapper;
import com.ohaotian.piscesplatform.model.po.AbilityParamTargetPo;
import com.ohaotian.portalcommon.util.GsonUtil;
import com.ohaotian.portalcommon.util.JaxbUtil;
import com.ohaotian.portalcommon.util.ObjectUtil;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AbilityParameterTargetTemplateServiceImpl
implements AbilityParameterTargetTemplateService {
    @Resource
    AbilityParamMapper abilityParamMapper;
    @Resource
    AbilityParamTargetMapper abilityParamTargetMapper;

    @Override
    public void generateParameterTemplate(Long abilityId, String reqJsonSchema, String rspJsonSchema, String reqXsd, String rspXsd, String reqJarPath, String reqClassName, String rspJarPath, String rspClassName) throws Exception {
        AbilityParamPO abilityParamPO = new AbilityParamPO();
        abilityParamPO.setAbilityId(abilityId);
        abilityParamPO.setReqJsonschema(reqJsonSchema);
        abilityParamPO.setReqXsd(reqXsd);
        abilityParamPO.setRspJsonschema(rspJsonSchema);
        abilityParamPO.setRespXsd(rspXsd);
        URL reqUrl = new File(reqJarPath).toURI().toURL();
        URL rspUrl = new File(rspJarPath).toURI().toURL();
        try (URLClassLoader loader = new URLClassLoader(new URL[]{reqUrl, rspUrl}, Thread.currentThread().getContextClassLoader());){
            Class<?> reqClass = loader.loadClass(reqClassName);
            Class<?> rspClass = loader.loadClass(rspClassName);
            Object repObject = ObjectUtil.getObject(reqClass);
            Object rspObject = ObjectUtil.getObject(rspClass);
            abilityParamPO.setReqJsonTemplate(GsonUtil.toJson((Object)repObject));
            abilityParamPO.setRspJsonTemplate(GsonUtil.toJson((Object)rspObject));
            abilityParamPO.setReqXmlTemplate(JaxbUtil.beanToXml((Object)repObject));
            abilityParamPO.setRspXmlTemplate(JaxbUtil.beanToXml((Object)rspObject));
            this.abilityParamMapper.updateByAbilityId(abilityParamPO);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        this.abilityParamMapper.updateByAbilityId(abilityParamPO);
    }

    @Override
    public void generateParameterTargetTemplate(Long abilityId, String targetReqJsonSchema, String targetRspJsonSchema, String targetReqXsd, String targetRspXsd, String targetReqJarPath, String targetReqClassName, String targetRspJarPath, String targetRspClassName) throws Exception {
        AbilityParamTargetPo abilityParamTargetPo = new AbilityParamTargetPo();
        abilityParamTargetPo.setAbilityId(abilityId);
        abilityParamTargetPo.setTargetReqJsonschema(targetReqJsonSchema);
        abilityParamTargetPo.setTargetReqXsd(targetReqXsd);
        abilityParamTargetPo.setTargetRspJsonschema(targetRspJsonSchema);
        abilityParamTargetPo.setTargetRspXsd(targetRspXsd);
        URL reqUrl = new File(targetReqJarPath).toURI().toURL();
        URL rspUrl = new File(targetRspJarPath).toURI().toURL();
        try (URLClassLoader loader = new URLClassLoader(new URL[]{reqUrl, rspUrl}, Thread.currentThread().getContextClassLoader());){
            Class<?> reqClass = loader.loadClass(targetReqClassName);
            Class<?> rspClass = loader.loadClass(targetRspClassName);
            Object repObject = ObjectUtil.getObject(reqClass);
            Object rspObject = ObjectUtil.getObject(rspClass);
            abilityParamTargetPo.setTargetReqJsonTemplate(GsonUtil.toJson((Object)repObject));
            abilityParamTargetPo.setTargetRspJsonTemplate(GsonUtil.toJson((Object)rspObject));
            abilityParamTargetPo.setTargetReqXmlTemplate(JaxbUtil.beanToXml((Object)repObject));
            abilityParamTargetPo.setTargetRspXmlTemplate(JaxbUtil.beanToXml((Object)rspObject));
            this.abilityParamTargetMapper.updateByAbilityId(abilityParamTargetPo);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        this.abilityParamTargetMapper.updateByAbilityId(abilityParamTargetPo);
    }
}

