/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.app.service.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.page.PageMethod;
import com.ohaotian.abilityadmin.app.model.bo.AppSecretReqBO;
import com.ohaotian.abilityadmin.app.model.bo.AppSecretRspBO;
import com.ohaotian.abilityadmin.app.model.bo.ModifyAppSecretReqBO;
import com.ohaotian.abilityadmin.app.service.AppSecretService;
import com.ohaotian.abilityadmin.mapper.AppSecretMapper;
import com.ohaotian.abilityadmin.model.po.AppSecretPO;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.portalcommon.api.AppAPI;
import com.ohaotian.portalcommon.api.ClusterApi;
import com.ohaotian.portalcommon.model.AppBO;
import com.ohaotian.portalcommon.model.bo.ClusterBO;
import com.ohaotian.portalcommon.model.page.RspPage;
import com.ohaotian.portalcommon.util.SqlUtil;
import com.ohaotian.portalcommon.util.StrUtil;
import java.util.List;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AppSecretServiceImpl
implements AppSecretService {
    private static Logger logger = LogManager.getLogger(AppSecretServiceImpl.class);
    @Resource
    private AppSecretMapper appSecretMapper;
    @Resource
    private ClusterApi clusterApi;
    @Resource
    private AppAPI appAPI;
    @Resource
    private AuthorityService authorityService;

    @Override
    public RspPage<AppSecretRspBO> queryAppSecretList(AppSecretReqBO appSecretReqBO) {
        Long tenantId = Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId());
        StringBuilder order = new StringBuilder();
        if (!StringUtils.isEmpty((Object)appSecretReqBO.getSortName())) {
            order.append(StrUtil.CamelToUnderline((String)appSecretReqBO.getSortName()));
            if (!StringUtils.isEmpty((Object)appSecretReqBO.getSortOrder())) {
                order.append(" ").append(appSecretReqBO.getSortOrder());
            }
        } else {
            order.append(SqlUtil.getDefaultOrderByclusterId());
        }
        Page page = !StringUtils.isEmpty((Object)order) ? PageMethod.startPage((int)appSecretReqBO.getPageNo(), (int)appSecretReqBO.getPageSize(), (String)order.toString()) : PageMethod.startPage((int)appSecretReqBO.getPageNo(), (int)appSecretReqBO.getPageSize());
        List<AppSecretRspBO> appSecretRspBOS = this.appSecretMapper.selectAPIByAppIdAndTenantId(appSecretReqBO.getAppId(), tenantId);
        appSecretRspBOS.stream().forEach(s -> {
            ClusterBO clusterBO = this.clusterApi.qryClusterById(s.getClusterId());
            AppBO appBO = this.appAPI.queryAppByAppId(s.getAppId());
            if (clusterBO != null) {
                s.setClusterName(clusterBO.getClusterName());
            }
            if (appBO != null) {
                s.setAppName(appBO.getAppName());
            }
        });
        RspPage rspPage = new RspPage(Integer.valueOf(appSecretReqBO.getPageSize()), Integer.valueOf(appSecretReqBO.getPageNo()), appSecretRspBOS, Long.valueOf(page.getTotal()));
        return rspPage;
    }

    @Override
    public AppSecretPO modifyAppSecret(ModifyAppSecretReqBO modifyAppSecretReqBO) {
        AppSecretPO appSecret = (AppSecretPO)BeanMapper.map((Object)modifyAppSecretReqBO, AppSecretPO.class);
        if (appSecret == null || appSecret.getAppSecretId() == null) {
            throw new ZTBusinessException("\u8bf7\u6c42\u62a5\u6587\u4e3a\u7a7a");
        }
        this.appSecretMapper.updatePublicSecrets(appSecret);
        AppSecretPO appSecretPO = this.appSecretMapper.selectByappSecretId(appSecret.getAppSecretId());
        return appSecretPO;
    }
}

