/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.plugin.service.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.abilityadmin.app.model.bo.PluginExtPointRspPO;
import com.ohaotian.abilityadmin.mapper.AbilityPluginMapper;
import com.ohaotian.abilityadmin.mapper.PluginExtPointMapper;
import com.ohaotian.abilityadmin.mapper.PluginMapper;
import com.ohaotian.abilityadmin.model.po.AbilityPluginPO;
import com.ohaotian.abilityadmin.model.po.PluginExtPointPO;
import com.ohaotian.abilityadmin.model.po.PluginPO;
import com.ohaotian.abilityadmin.plugin.model.bo.ModPluginReqBO;
import com.ohaotian.abilityadmin.plugin.model.bo.PluginAddReqBO;
import com.ohaotian.abilityadmin.plugin.model.bo.PluginListReqBO;
import com.ohaotian.abilityadmin.plugin.model.bo.PluginListRspBO;
import com.ohaotian.abilityadmin.plugin.model.bo.PluginReqBO;
import com.ohaotian.abilityadmin.plugin.service.PluginAdminService;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.portalcommon.constant.Constants;
import com.ohaotian.portalcommon.enums.ExtensionPointPositionEnum;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.page.RspPage;
import com.ohaotian.portalcommon.service.PluginService;
import com.ohaotian.portalcommon.util.SqlUtil;
import com.ohaotian.portalcommon.util.StrUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PluginAdminServiceImpl
implements PluginAdminService {
    private static final Logger log = LogManager.getLogger(PluginAdminServiceImpl.class);
    @Resource
    private PluginMapper pluginMapper;
    @Resource
    private PluginExtPointMapper pluginExtPointMapper;
    @Resource
    PluginService pluginService;
    @Resource
    AbilityPluginMapper abilityPluginMapper;
    @Resource
    AuthorityService authorityService;

    @Override
    public Long insertSelective(PluginPO entity) {
        return this.pluginMapper.insertSelective(entity);
    }

    @Override
    public int insertRecords(List<PluginPO> records) {
        return this.pluginMapper.insertRecords(records);
    }

    @Override
    public PluginPO queryLimitOne(PluginPO entity) {
        return this.pluginMapper.queryLimitOne(entity);
    }

    @Override
    public List<PluginPO> queryByPluginIds(List<Long> pluginIds) {
        return this.pluginMapper.queryByPluginIds(pluginIds);
    }

    @Override
    public List<PluginListRspBO> queryByCond(PluginPO entity) {
        return this.pluginMapper.queryByCond(entity);
    }

    @Override
    public PluginPO queryByPluginId(Long pluginId) {
        return this.pluginMapper.queryByPluginId(pluginId);
    }

    @Override
    public RspBO updatePluginByPluginId(ModPluginReqBO modPluginReqBO) {
        Long userId = Long.parseLong(UserHolder.getUserId());
        if (org.springframework.util.StringUtils.isEmpty((Object)modPluginReqBO.getPluginId())) {
            return RspBO.error((String)"\u672a\u6307\u5b9a\u9700\u8981\u4fee\u6539\u7684\u8bb0\u5f55");
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)modPluginReqBO.getPluginName())) {
            return RspBO.error((String)"\u672a\u6307\u5b9a\u63d2\u4ef6\u540d\u79f0");
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)modPluginReqBO.getPluginEname())) {
            return RspBO.error((String)"\u672a\u6307\u5b9a\u63d2\u4ef6\u82f1\u6587\u540d");
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)modPluginReqBO.getRemark())) {
            return RspBO.error((String)"\u8bf7\u8f93\u5165\u5907\u6ce8");
        }
        PluginPO pluginPO = (PluginPO)BeanMapper.map((Object)modPluginReqBO, PluginPO.class);
        pluginPO.setUpdateTime(new Date());
        pluginPO.setUpdateUserId(userId);
        int count = this.pluginMapper.updatePluginByPluginId(pluginPO);
        if (count < 1) {
            throw new ZTBusinessException("\u66f4\u65b0\u5931\u8d25");
        }
        RspBO rspBO = RspBO.success(null);
        return rspBO;
    }

    @Override
    public int deletePluginByPluginId(Long pluginId) {
        PluginPO pluginPO = this.pluginMapper.queryByPluginId(pluginId);
        if (pluginPO != null) {
            AbilityPluginPO abilityPluginPO = new AbilityPluginPO();
            abilityPluginPO.setHirerId(pluginPO.getHirerId());
            abilityPluginPO.setPluginEname(pluginPO.getPluginEname());
            List<AbilityPluginPO> abilityPluginPOS = this.abilityPluginMapper.queryByCond(abilityPluginPO);
            if (abilityPluginPOS != null && abilityPluginPOS.size() > 0) {
                String collect = abilityPluginPOS.stream().map(a -> a.getAbilityEname() + "_" + a.getAbilityVersion()).collect(Collectors.joining(",", "[", "]"));
                throw new ZTBusinessException("\u63d2\u4ef6\u4e0d\u53ef\u5220\u9664:" + collect);
            }
        }
        return this.pluginMapper.deletePluginByPluginId(pluginId);
    }

    @Override
    @Transactional
    public void deletePluginByIds(List<Long> pluginIds) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        ArrayList<String> list = new ArrayList<String>();
        List<PluginPO> pluginPOS = this.pluginMapper.queryByPluginIds(pluginIds);
        for (PluginPO pluginPO : pluginPOS) {
            AbilityPluginPO abilityPluginPO = new AbilityPluginPO();
            abilityPluginPO.setHirerId(pluginPO.getHirerId());
            abilityPluginPO.setPluginEname(pluginPO.getPluginEname());
            List<AbilityPluginPO> abilityPluginPOS = this.abilityPluginMapper.queryByCond(abilityPluginPO);
            if (abilityPluginPOS != null && abilityPluginPOS.size() > 0) {
                String collect = abilityPluginPOS.stream().map(a -> a.getAbilityEname() + "_" + a.getAbilityVersion()).collect(Collectors.joining(",", "[", "]"));
                list.add("\u63d2\u4ef6" + pluginPO.getPluginEname() + "\u7ed1\u5b9a\u4e86\u80fd\u529b\u6709>>" + collect);
            }
            Map extInfo = BeanUtils.describe((Object)pluginPO);
            this.pluginService.handleDelete((Object)extInfo, pluginPO.getPluginType(), ExtensionPointPositionEnum.PLUGIN_POSITION.getCode());
        }
        if (list.size() > 0) {
            throw new ZTBusinessException("\u63d2\u4ef6\u4e0d\u53ef\u5220\u9664:" + list.stream().collect(Collectors.joining(",")) + ",\u8bf7\u89e3\u9664\u7ed1\u5b9a\u5173\u7cfb\u540e\u518d\u5220\u9664");
        }
        this.pluginMapper.deletePluginByIds(pluginIds);
    }

    @Override
    public RspBO<RspPage<PluginListRspBO>> qryPluginListPageByCond(PluginListReqBO pluginListReqBO) throws ZTBusinessException {
        log.debug("PluginServiceImpl.qryPluginListPageByCond.req:{}", (Object)pluginListReqBO);
        Long tenantId = Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId());
        pluginListReqBO.setHirerId(tenantId);
        if (StringUtils.isNotBlank((String)pluginListReqBO.getPluginName())) {
            pluginListReqBO.setPluginName("%" + pluginListReqBO.getPluginName() + "%");
        }
        if (StringUtils.isNotBlank((String)pluginListReqBO.getPluginEname())) {
            pluginListReqBO.setPluginEname("%" + pluginListReqBO.getPluginEname() + "%");
        }
        StringBuilder order = new StringBuilder();
        if (!org.springframework.util.StringUtils.isEmpty((Object)pluginListReqBO.getSortName())) {
            order.append(StrUtil.CamelToUnderline((String)pluginListReqBO.getSortName()));
            if (!org.springframework.util.StringUtils.isEmpty((Object)pluginListReqBO.getSortOrder())) {
                order.append(" ").append(pluginListReqBO.getSortOrder());
            }
        } else {
            order.append(SqlUtil.getCreateTimeOrderBy());
        }
        int pageNo = pluginListReqBO.getPageNo();
        int pageSize = pluginListReqBO.getPageSize();
        PluginPO pluginPO = (PluginPO)BeanMapper.map((Object)pluginListReqBO, PluginPO.class);
        Page page = !org.springframework.util.StringUtils.isEmpty((Object)order) ? PageHelper.startPage((int)pageNo, (int)pageSize, (String)order.toString()) : PageHelper.startPage((int)pageNo, (int)pageSize);
        List<PluginListRspBO> pluginListRspBOList = this.pluginMapper.queryByCond(pluginPO);
        PluginExtPointPO pluginExtPointPO = new PluginExtPointPO();
        pluginExtPointPO.setExtPointType(Constants.ExtPointType.PAGE_POINT);
        List<PluginExtPointPO> pluginExtPointPOS = this.pluginExtPointMapper.queryByCond(pluginExtPointPO);
        List rspList = pluginListRspBOList.stream().flatMap(x -> pluginExtPointPOS.stream().filter(y -> x.getPluginType().equals(y.getPluginType())).map(y -> {
            PluginListRspBO pluginListRspBO = x;
            pluginListRspBO.setPageUrl(y.getPageUrl());
            return pluginListRspBO;
        })).collect(Collectors.toList());
        RspPage rspPage = new RspPage(Integer.valueOf(pageSize), Integer.valueOf(pageNo), rspList, Long.valueOf(page.getTotal()));
        log.debug("PluginServiceImpl.qryPluginListPageByCond.rsp:{}", (Object)rspPage);
        return RspBO.success((Object)rspPage);
    }

    @Override
    public RspBO<List<PluginExtPointRspPO>> qryPluginList() {
        PluginExtPointPO pluginExtPointPO = new PluginExtPointPO();
        pluginExtPointPO.setExtPoint(Constants.ExtPoint.APP_PLUGIN);
        List<PluginExtPointPO> pluginExtPointPOList = this.pluginExtPointMapper.queryByCond(pluginExtPointPO);
        List pluginExtPointRspPOList = BeanMapper.mapList(pluginExtPointPOList, PluginExtPointRspPO.class);
        return RspBO.success((Object)pluginExtPointRspPOList);
    }

    @Override
    @Transactional
    public RspBO addPlugin(PluginAddReqBO pluginAddReqBO) {
        Long userId = Long.parseLong(UserHolder.getUserId());
        Long tenantId = Long.parseLong(this.authorityService.getUserInfoByUserId(String.valueOf(userId)).getTenantId());
        PluginPO pluginPO = (PluginPO)BeanMapper.map((Object)pluginAddReqBO, PluginPO.class);
        PluginPO pluginPO1 = new PluginPO();
        pluginPO1.setPluginEname(pluginPO.getPluginEname());
        pluginPO1.setHirerId(tenantId);
        pluginPO1 = this.pluginMapper.queryLimitOne(pluginPO1);
        if (pluginPO1 != null) {
            throw new ZTBusinessException("\u63d2\u4ef6\u82f1\u6587\u540d\u91cd\u590d\uff01");
        }
        pluginPO.setCreateTime(new Date());
        pluginPO.setCreateUserId(userId);
        pluginPO.setHirerId(tenantId);
        if ("hpartyCheck".equals(pluginAddReqBO.getPluginType()) || "multiTokenHPC".equals(pluginAddReqBO.getPluginType()) || "jdHpartyCheck".equals(pluginAddReqBO.getPluginType()) || "g3PlusHPC".equals(pluginAddReqBO.getPluginType())) {
            PluginReqBO pluginReqBO = (PluginReqBO)BeanMapper.map((Object)pluginAddReqBO.getExtInfo(), PluginReqBO.class);
            String regionCode = pluginReqBO.getAppRegion()[1];
            pluginPO.setRegionCode(regionCode);
        }
        this.pluginMapper.insertSelective(pluginPO);
        Map extInfo = pluginAddReqBO.getExtInfo();
        extInfo.put("pluginId", pluginPO.getPluginId());
        this.pluginService.handleAdd((Object)extInfo, pluginAddReqBO.getPluginType(), ExtensionPointPositionEnum.PLUGIN_POSITION.getCode());
        return RspBO.success((Object)pluginPO);
    }
}

