/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.ability.service.export.impl;

import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.metadata.Sheet;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ohaotian.abilityadmin.ability.model.bo.AbilityAddReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.export.ImportAbilityReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.export.ImportPostmanCheckReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.export.ImportUrlReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.postman.AbilityModel;
import com.ohaotian.abilityadmin.ability.model.bo.postman.PostmanCollection;
import com.ohaotian.abilityadmin.ability.service.AbilityDetailService;
import com.ohaotian.abilityadmin.ability.service.export.AbilityImportService;
import com.ohaotian.abilityadmin.ability.service.postman.ParseAbilityList;
import com.ohaotian.abilityadmin.app.model.bo.AppExtColumnReqBO;
import com.ohaotian.abilityadmin.app.model.bo.AppRegionRepBO;
import com.ohaotian.abilityadmin.app.model.bo.AppReqBO;
import com.ohaotian.abilityadmin.app.service.AppRegionService;
import com.ohaotian.abilityadmin.app.service.AppService;
import com.ohaotian.abilityadmin.component.deploy.AbilitySvcComponent;
import com.ohaotian.abilityadmin.mapper.AbilityAppMapper;
import com.ohaotian.abilityadmin.mapper.AbilityExtColumnMapper;
import com.ohaotian.abilityadmin.mapper.AbilityExtDefaultMapper;
import com.ohaotian.abilityadmin.mapper.AbilityExtMapper;
import com.ohaotian.abilityadmin.mapper.AbilityLogicMapper;
import com.ohaotian.abilityadmin.mapper.AbilityMapper;
import com.ohaotian.abilityadmin.mapper.AbilityParamMapper;
import com.ohaotian.abilityadmin.mapper.AbilityPluginMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideDeployMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideDubboDefaultInputMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideDubboDefaultMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideHsfDefaultInputMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideHsfDefaultMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideHttpCustomMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideHttpDefaultMapper;
import com.ohaotian.abilityadmin.mapper.AbilityTransMapper;
import com.ohaotian.abilityadmin.mapper.AppMapper;
import com.ohaotian.abilityadmin.mapper.PluginMapper;
import com.ohaotian.abilityadmin.mapper.RateLimiterAbilityDefaultMapper;
import com.ohaotian.abilityadmin.mapper.RegionMapper;
import com.ohaotian.abilityadmin.mapper.SubAbilityMapper;
import com.ohaotian.abilityadmin.model.po.AbilityAppPO;
import com.ohaotian.abilityadmin.model.po.AbilityExtColumnPO;
import com.ohaotian.abilityadmin.model.po.AbilityExtDefaultPO;
import com.ohaotian.abilityadmin.model.po.AbilityExtPO;
import com.ohaotian.abilityadmin.model.po.AbilityLogicPO;
import com.ohaotian.abilityadmin.model.po.AbilityPO;
import com.ohaotian.abilityadmin.model.po.AbilityParamPO;
import com.ohaotian.abilityadmin.model.po.AbilityPluginDeployPO;
import com.ohaotian.abilityadmin.model.po.AbilityPluginPO;
import com.ohaotian.abilityadmin.model.po.AbilityProvideDeployPO;
import com.ohaotian.abilityadmin.model.po.AbilityProvideDubboDefaultInputPO;
import com.ohaotian.abilityadmin.model.po.AbilityProvideDubboDefaultPO;
import com.ohaotian.abilityadmin.model.po.AbilityProvideHsfDefaultInputPO;
import com.ohaotian.abilityadmin.model.po.AbilityProvideHsfDefaultPO;
import com.ohaotian.abilityadmin.model.po.AbilityProvideHttpCustomPO;
import com.ohaotian.abilityadmin.model.po.AbilityProvideHttpDefaultPO;
import com.ohaotian.abilityadmin.model.po.AbilityTransPO;
import com.ohaotian.abilityadmin.model.po.AppPO;
import com.ohaotian.abilityadmin.model.po.PluginPO;
import com.ohaotian.abilityadmin.model.po.RateLimiterAbilityDefaultPO;
import com.ohaotian.abilityadmin.model.po.RegionPO;
import com.ohaotian.abilityadmin.model.po.SubAbilityPO;
import com.ohaotian.abilityadmin.platform.service.PlatformTemplateService;
import com.ohaotian.abilityadmin.plugin.model.bo.PluginAddReqBO;
import com.ohaotian.abilityadmin.plugin.model.bo.PluginBindAbilityBO;
import com.ohaotian.abilityadmin.plugin.service.PluginAdminService;
import com.ohaotian.abilityadmin.plugin.service.PluginAssociationService;
import com.ohaotian.abilityadmin.system.service.SysService;
import com.ohaotian.abilityadmin.util.HttpUtil;
import com.ohaotian.abilityadmin.util.MultipartFileUtil;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.piscesplatform.mapper.AbilityParamTargetMapper;
import com.ohaotian.piscesplatform.model.po.AbilityParamTargetPo;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.portalcommon.api.AppAPI;
import com.ohaotian.portalcommon.config.ExcelListener;
import com.ohaotian.portalcommon.constant.Constants;
import com.ohaotian.portalcommon.enums.PluginEnum;
import com.ohaotian.portalcommon.model.AppBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.util.ValidBatchUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AbilityImportServiceImpl
implements AbilityImportService {
    private static Logger logger = LogManager.getLogger(AbilityImportServiceImpl.class);
    @Resource
    private AbilityMapper abilityMapper;
    @Resource
    private AbilityLogicMapper abilityLogicMapper;
    @Resource
    private SubAbilityMapper subAbilityMapper;
    @Resource
    private AbilityParamMapper abilityParamMapper;
    @Resource
    private AbilityParamTargetMapper abilityParamTargetMapper;
    @Resource
    private AbilityExtColumnMapper abilityExtColumnMapper;
    @Resource
    private AbilityExtDefaultMapper abilityExtDefaultMapper;
    @Resource
    private AbilityProvideHsfDefaultMapper abilityProvideHsfDefaultMapper;
    @Resource
    private AbilityProvideHsfDefaultInputMapper abilityProvideHsfDefaultInputMapper;
    @Resource
    private AbilityProvideDubboDefaultMapper abilityProvideDubboDefaultMapper;
    @Resource
    private AbilityProvideDubboDefaultInputMapper abilityProvideDubboDefaultInputMapper;
    @Resource
    private AbilityProvideHttpDefaultMapper abilityProvideHttpDefaultMapper;
    @Resource
    private AbilityProvideHttpCustomMapper abilityProvideHttpCustomMapper;
    @Resource
    private AbilityProvideDeployMapper abilityProvideDeployMapper;
    @Resource
    private RateLimiterAbilityDefaultMapper rateLimiterAbilityDefaultMapper;
    @Resource
    private AbilityTransMapper abilityTransMapper;
    @Resource
    private AbilityExtMapper abilityExtMapper;
    @Resource
    private AbilityAppMapper abilityAppMapper;
    @Resource
    AbilitySvcComponent abilitySvcComponent;
    @Resource
    AbilityDetailService abilityDetailService;
    @Resource
    private AuthorityService authorityService;
    @Autowired
    private PlatformTemplateService platformTemplateService;
    @Resource
    AppRegionService appRegionService;
    @Resource
    private AppService appService;
    @Autowired
    private AppAPI appApi;
    @Resource
    private AppMapper appMapper;
    @Resource
    private RegionMapper regionMapper;
    @Resource
    private PluginMapper pluginMapper;
    @Resource
    private PluginAdminService pluginAdminService;
    @Resource
    private AbilityPluginMapper abilityPluginMapper;
    @Autowired
    PluginAssociationService pluginAssociationService;
    @Resource
    SysService sysService;

    @Override
    @Transactional(rollbackFor={ZTBusinessException.class})
    public RspBO importAbility(ImportAbilityReqBO importAbilityReqBO) {
        return this.importFromAbility(importAbilityReqBO);
    }

    @Override
    public RspBO importPostman(ImportAbilityReqBO importAbilityReqBO) {
        String multipartFileContent = MultipartFileUtil.getMultipartFileContent(importAbilityReqBO.getFile());
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            PostmanCollection postmanCollection = (PostmanCollection)objectMapper.readValue(multipartFileContent, PostmanCollection.class);
            ParseAbilityList parseAbilityList = new ParseAbilityList();
            parseAbilityList.parsePostmanCollection(postmanCollection);
            List<AbilityModel> abilityList = parseAbilityList.getAbilityList();
            for (int i = 0; i < abilityList.size(); ++i) {
                AbilityModel abilityModel = abilityList.get(i);
                abilityModel.setId(i);
                abilityList.set(i, abilityModel);
            }
            return RspBO.success(abilityList);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return RspBO.error((String)"\u5bfc\u5165postman\u63a5\u53e3\u5931\u8d25\uff01");
        }
    }

    @Override
    public RspBO importUrl(ImportUrlReqBO importUrlReqBO) {
        String respond = HttpUtil.sendPostJson(importUrlReqBO.getUrl(), importUrlReqBO.getHeaders(), importUrlReqBO.getBody(), 5, 10, Boolean.TRUE);
        JSONObject jsonObject = JSONObject.parseObject((String)respond);
        return RspBO.success((Object)jsonObject);
    }

    @Override
    public RspBO checkoutImportUrl(ImportPostmanCheckReqBO importPostmanCheckReqBO) {
        Long tenantId = Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId());
        Long userId = Long.parseLong(UserHolder.getUserId());
        if (importPostmanCheckReqBO != null && importPostmanCheckReqBO.getAbility() != null && importPostmanCheckReqBO.getAbility().size() > 0) {
            List<AbilityModel> ability = importPostmanCheckReqBO.getAbility();
            List collect = this.filterAbilityModels(ability);
            this.checkAbilityModel(tenantId, collect);
            String errorMsg = collect.stream().filter(a -> !StringUtils.isEmpty((Object)a.getMsg())).map(a -> a.getMsg()).collect(Collectors.joining("\u3001"));
            if (StringUtils.isEmpty((Object)errorMsg)) {
                collect = collect.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<AbilityModel>(Comparator.comparing(AbilityModel::getAbilityEname))), ArrayList::new));
                this.importUrlToAbility(importPostmanCheckReqBO, tenantId, userId, collect);
                return RspBO.success((Object)"\u80fd\u529b\u5bfc\u5165\u6210\u529f");
            }
            RspBO rspBO = new RspBO();
            rspBO.setCode("2");
            rspBO.setMessage(errorMsg);
            rspBO.setData((Object)collect);
            return rspBO;
        }
        return RspBO.error((String)"\u5bfc\u5165\u80fd\u529b\u4e3a\u7a7a\uff01");
    }

    @Override
    public RspBO checkoutImportPostman(ImportPostmanCheckReqBO importPostmanCheckReqBO) {
        Long tenantId = Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId());
        Long userId = Long.parseLong(UserHolder.getUserId());
        if (importPostmanCheckReqBO != null && importPostmanCheckReqBO.getAbility() != null && importPostmanCheckReqBO.getAbility().size() > 0) {
            List<AbilityModel> ability = importPostmanCheckReqBO.getAbility();
            List collect = this.filterAbilityModels(ability);
            this.checkAbilityModel(tenantId, collect);
            String errorMsg = collect.stream().filter(a -> !StringUtils.isEmpty((Object)a.getMsg())).map(a -> a.getMsg()).collect(Collectors.joining("\u3001"));
            if (StringUtils.isEmpty((Object)errorMsg)) {
                collect = collect.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<AbilityModel>(Comparator.comparing(AbilityModel::getAbilityEname))), ArrayList::new));
                this.importApiToAbility(importPostmanCheckReqBO, tenantId, userId, collect);
                return RspBO.success((Object)"\u80fd\u529b\u5bfc\u5165\u6210\u529f");
            }
            RspBO rspBO = new RspBO();
            rspBO.setCode("2");
            rspBO.setMessage(errorMsg);
            rspBO.setData((Object)collect);
            return rspBO;
        }
        return RspBO.error((String)"\u5bfc\u5165\u80fd\u529b\u4e3a\u7a7a\uff01");
    }

    @Override
    public RspBO confirmImportPostman(ImportPostmanCheckReqBO importPostmanCheckReqBO) {
        Long tenantId = Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId());
        Long userId = Long.parseLong(UserHolder.getUserId());
        if (importPostmanCheckReqBO != null && importPostmanCheckReqBO.getAbility() != null && importPostmanCheckReqBO.getAbility().size() > 0) {
            List<AbilityModel> ability = importPostmanCheckReqBO.getAbility();
            List<AbilityModel> collect1 = this.filterAbilityModels(ability);
            this.confirmAbilityModel(tenantId, collect1);
            String errorMsg = collect1.stream().filter(a -> a.getFlag() == false).map(a -> a.getMsg()).collect(Collectors.joining("\u3001"));
            List collect2 = this.filterAbilityModels(collect1);
            collect2 = collect2.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<AbilityModel>(Comparator.comparing(AbilityModel::getAbilityEname))), ArrayList::new));
            this.importApiToAbility(importPostmanCheckReqBO, tenantId, userId, collect2);
            if (StringUtils.isEmpty((Object)errorMsg)) {
                return RspBO.success((Object)"\u80fd\u529b\u5bfc\u5165\u6210\u529f\uff01");
            }
            return RspBO.success((Object)("\u80fd\u529b\u5bfc\u5165\u6210\u529f\uff0c\u5b58\u5728\u91cd\u590d\u80fd\u529b\uff1a" + errorMsg));
        }
        return RspBO.error((String)"\u5bfc\u5165\u80fd\u529b\u4e3a\u7a7a\uff01");
    }

    private void importUrlToAbility(ImportPostmanCheckReqBO importPostmanCheckReqBO, Long tenantId, Long userId, List<AbilityModel> collect) {
    }

    private List<AbilityModel> filterAbilityModels(List<AbilityModel> ability) {
        return ability.stream().filter(a -> a.getFlag()).collect(Collectors.toList());
    }

    private void importApiToAbility(ImportPostmanCheckReqBO importPostmanCheckReqBO, Long tenantId, Long userId, List<AbilityModel> collect) {
        collect.forEach(abilityModel -> {
            AbilityAddReqBO abilityAddReqBO = new AbilityAddReqBO();
            abilityAddReqBO.setReqJsonschema(abilityModel.getReqJsonschema());
            abilityAddReqBO.setRspJsonschema(abilityModel.getRspJsonschema());
            abilityAddReqBO.setHirerId(tenantId);
            abilityAddReqBO.setIsDraft(Constants.AbilityDraftType.NORMAL);
            abilityAddReqBO.setAttendStatus(Constants.AttendStatus.SIGN_IN);
            abilityAddReqBO.setOutputProtocal(abilityModel.getOutputProtocal());
            abilityAddReqBO.setAbilityVersion(abilityModel.getAbilityVersion());
            abilityAddReqBO.setAbilityEname(abilityModel.getAbilityEname());
            abilityAddReqBO.setInputProtocal(abilityModel.getInputProtocal());
            abilityAddReqBO.setAbilityName(abilityModel.getAbilityName());
            abilityAddReqBO.setOutputTransProtocal(abilityModel.getOutputTransProtocal());
            abilityAddReqBO.setIsMessageCheck(0);
            abilityAddReqBO.setAbilityType(0);
            abilityAddReqBO.setAppCodeSource(0);
            abilityAddReqBO.setRemark("\u5bfc\u5165\u80fd\u529b");
            abilityAddReqBO.setCreateUserId(userId);
            abilityAddReqBO.setCapacity(-1);
            abilityAddReqBO.setDailyCapacity(-1);
            abilityAddReqBO.setRetryTime(0);
            abilityAddReqBO.setOvertime(100);
            abilityAddReqBO.setAppId(importPostmanCheckReqBO.getAppId());
            abilityAddReqBO.setGlobalLimit("0");
            abilityAddReqBO.setSingleDailyMaxCount(-1);
            abilityAddReqBO.setSingleLimit("0");
            abilityAddReqBO.setRate(-1);
            abilityAddReqBO.setSingleMaxCount(-1);
            abilityAddReqBO.setSingleMaxRate(-1);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("eprPath", abilityModel.getEprPath());
            abilityAddReqBO.setExtendInfo(map);
            this.setDefaultExtColumn(abilityAddReqBO);
            try {
                ValidBatchUtils.isNotEmpty((Object)abilityAddReqBO, (String[])new String[]{"abilityName", "abilityEname", "abilityVersion", "outputProtocal", "outputTransProtocal", "isMessageCheck", "abilityType", "appCodeSource", "overtime", "retryTime", "appId", "reqJsonschema", "rspJsonschema"});
                this.abilityDetailService.submitAbility(abilityAddReqBO);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u670d\u52a1\u5bfc\u5165\u9519\u8bef\u670d\u52a1\uff1a{}", (Object)abilityModel.getAbilityName(), (Object)e.getMessage());
            }
        });
    }

    private void setDefaultExtColumn(AbilityAddReqBO abilityAddReqBO) {
        AbilityExtColumnPO abilityExtColumnPO = new AbilityExtColumnPO();
        AbilityExtColumnPO abilityExtColumnPO1 = this.abilityExtColumnMapper.queryLimitOne(abilityExtColumnPO);
        if (abilityExtColumnPO1 != null) {
            abilityExtColumnPO1.setAbilityExtColumnId(null);
            abilityExtColumnPO1.setAbilityId(null);
            abilityAddReqBO.setExtInfo(abilityExtColumnPO1);
        } else {
            abilityExtColumnPO.setExtOne("0");
            abilityExtColumnPO.setExtTwo("0");
            abilityExtColumnPO.setExtThree("0");
            abilityExtColumnPO.setExtFour("0");
            abilityExtColumnPO.setExtFive("0");
            abilityExtColumnPO.setExtSix("0");
            abilityExtColumnPO.setExtSeven("0");
            abilityExtColumnPO.setExtEight("0");
            abilityExtColumnPO.setExtNine("0");
            abilityExtColumnPO.setExtTen("0");
            abilityAddReqBO.setExtInfo(abilityExtColumnPO);
        }
    }

    private void confirmAbilityModel(Long tenantId, List<AbilityModel> collect) {
        collect.forEach(abilityModel -> {
            Integer integer = this.abilityMapper.selectByAbilityAndVersion(abilityModel.getAbilityEname(), abilityModel.getAbilityVersion(), tenantId);
            if (integer != null && integer > 0) {
                abilityModel.setError("\u80fd\u529b\u5e73\u53f0\u5df2\u7ecf\u5b58\u5728\u6b64\u80fd\u529b:" + abilityModel.getAbilityEname() + "_" + abilityModel.getAbilityVersion());
                abilityModel.paresMsg();
            }
        });
    }

    private void checkAbilityModel(Long tenantId, List<AbilityModel> collect) {
        collect.forEach(abilityModel -> {
            Integer integer = this.abilityMapper.selectByAbilityAndVersion(abilityModel.getAbilityEname(), abilityModel.getAbilityVersion(), tenantId);
            if (integer != null && integer > 0) {
                abilityModel.setSuccessMsg("\u80fd\u529b\u5e73\u53f0\u5df2\u7ecf\u5b58\u5728\u6b64\u80fd\u529b:" + abilityModel.getAbilityEname() + "_" + abilityModel.getAbilityVersion());
                abilityModel.paresMsg();
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RspBO importFromAbility(ImportAbilityReqBO importAbilityReqBO) {
        AbilityParamTargetPo abilityParamTargetPo;
        AbilityParamPO abilityParamPO;
        ArrayList<PluginBindAbilityBO> newPluginBindAbilityBOList;
        ArrayList newAbilityAppList;
        ArrayList oldAbilityTransList;
        ArrayList newAbilityTransList;
        ArrayList oldRateLimiterAbilityDefaultList;
        ArrayList newRateLimiterAbilityDefaultList;
        LinkedHashMap<String, Long> oldAbilityAppIdMap;
        ArrayList newAbilityProvideHttpCustomList;
        List<Object> newAbilityProvideDeployList;
        ArrayList oldAbilityProvideHttpDefaultList;
        ArrayList newAbilityProvideHttpDefaultList;
        ArrayList oldAbilityProvideDubboDefaultInputList;
        ArrayList newAbilityProvideDubboDefaultInputList;
        ArrayList oldAbilityProvideDubboDefaultList;
        ArrayList newAbilityProvideDubboDefaultList;
        ArrayList oldAbilityProvideHsfDefaultInputList;
        ArrayList newAbilityProvideHsfDefaultInputList;
        ArrayList oldAbilityProvideHsfDefaultList;
        ArrayList newAbilityProvideHsfDefaultList;
        ArrayList oldAbilityExtDefaultList;
        ArrayList newAbilityExtDefaultList;
        ArrayList oldAbilityExtColumnList;
        ArrayList newAbilityExtColumnList;
        ArrayList oldAbilityParamTargetList;
        ArrayList newAbilityParamTargetList;
        ArrayList oldAbilityParamList;
        ArrayList newAbilityParamList;
        ArrayList oldSubAbilityList;
        ArrayList newSubAbilityList;
        ArrayList oldabilityLogicPOList;
        ArrayList newabilityLogicPOList;
        HashMap oldAbilityMap;
        ArrayList newAbilityList;
        ArrayList oldAbilityList;
        Throwable throwable;
        BufferedInputStream inputStream;
        Long tenantId;
        Integer isCover;
        block158: {
            Map<String, Sheet> sheetMap;
            ExcelReader excelReader;
            ValidBatchUtils.isNotEmpty((Object)importAbilityReqBO, (String[])new String[]{"isCover", "importModules", "file"});
            MultipartFile excel = importAbilityReqBO.getFile();
            isCover = importAbilityReqBO.getIsCover();
            String filename = excel.getOriginalFilename();
            tenantId = Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId());
            if (filename == null) throw new ZTBusinessException("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff01");
            if (!filename.toLowerCase().endsWith(".xls") && !filename.toLowerCase().endsWith(".xlsx")) {
                throw new ZTBusinessException("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff01");
            }
            ExcelListener excelListener = new ExcelListener();
            try {
                inputStream = new BufferedInputStream(excel.getInputStream());
                throwable = null;
                try {
                    excelReader = EasyExcelFactory.getReader((InputStream)inputStream, (AnalysisEventListener)excelListener);
                    List sheetList = excelReader.getSheets();
                    sheetMap = sheetList.stream().collect(Collectors.toMap(Sheet::getSheetName, sheet -> sheet));
                    Sheet appSheet = sheetMap.get("app");
                    try {
                        excelReader.read(appSheet);
                        List apps = excelListener.getDatas();
                        Map managesTemplate = (Map)this.platformTemplateService.getManageTemplate().getData();
                        for (Map app : apps) {
                            String appCode = app.get("appCode").toString();
                            AppPO appPO = new AppPO();
                            appPO.setAppCode(appCode);
                            appPO = this.appMapper.queryLimitOne(appPO);
                            if (!ObjectUtils.isEmpty((Object)appPO)) {
                                logger.warn("appCode:{} \u5df2\u5b58\u5728\uff01", (Object)appCode);
                                continue;
                            }
                            AppReqBO appRegisterReqBO = new AppReqBO();
                            appRegisterReqBO.setAppName(app.get("appName").toString());
                            appRegisterReqBO.setAppCode(appCode);
                            appRegisterReqBO.setAppContact(managesTemplate.get("appContact").toString());
                            appRegisterReqBO.setAppPhone(managesTemplate.get("appPhone").toString());
                            appRegisterReqBO.setIsProvider(Integer.valueOf(app.get("isProvider").toString()));
                            appRegisterReqBO.setRemark(Objects.toString(app.get("remark"), ""));
                            AppExtColumnReqBO appExtColumnReqBO = new AppExtColumnReqBO();
                            appExtColumnReqBO.setAppOne("\u9ed8\u8ba4");
                            appExtColumnReqBO.setAppTwo("\u9ed8\u8ba4");
                            appExtColumnReqBO.setAppThree("\u9ed8\u8ba4");
                            appExtColumnReqBO.setAppFour("\u9ed8\u8ba4");
                            appExtColumnReqBO.setAppFive("\u9ed8\u8ba4");
                            appRegisterReqBO.setAppExtColumnReqBO(appExtColumnReqBO);
                            RspBO<Boolean> appRegisteRspBO = this.appService.appRegiste(appRegisterReqBO);
                            logger.info(appRegisteRspBO);
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u81ea\u52a8\u521b\u5efa\u5206\u533a\u5f02\u5e38\uff01");
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    try {
                        Sheet appRegionSheet = sheetMap.get("app_region");
                        excelReader.read(appRegionSheet);
                        List appRegions = excelListener.getDatas();
                        Map appRegionClusterMap = appRegions.stream().collect(Collectors.groupingBy(map -> map.get("regionCode").toString(), Collectors.mapping(m -> Long.parseLong(m.get("clusterId").toString()), Collectors.toList())));
                        Map appRegionMap = appRegions.stream().collect(Collectors.groupingBy(map -> map.get("regionCode").toString(), Collectors.mapping(m -> m.get("appCode").toString(), Collectors.toList())));
                        Sheet regionSheet = sheetMap.get("region");
                        excelReader.read(regionSheet);
                        List regions = excelListener.getDatas();
                        if (!CollectionUtils.isEmpty((Collection)regions)) {
                            Set clusters = ((List)this.sysService.qryClusterInfo().getData()).stream().filter(m -> m.containsKey("value")).map(m -> Long.parseLong(m.get("value").toString())).collect(Collectors.toSet());
                            for (Map region : regions) {
                                String regionCode = region.get("regionCode").toString();
                                RegionPO regionPO = new RegionPO();
                                regionPO.setRegionCode(regionCode);
                                regionPO = this.regionMapper.queryLimitOne(regionPO);
                                if (!ObjectUtils.isEmpty((Object)regionPO)) {
                                    logger.warn("regionCode:{} \u5df2\u5b58\u5728\uff01", (Object)regionCode);
                                    continue;
                                }
                                AppRegionRepBO appRegionRepBO = new AppRegionRepBO();
                                appRegionRepBO.setRegionName(region.get("regionName").toString());
                                appRegionRepBO.setRegionCode(regionCode);
                                appRegionRepBO.setProtocol(region.get("protocol").toString());
                                List<Long> regionClusters = appRegionClusterMap.get(regionCode);
                                regionClusters.removeIf(clusterId -> !clusters.contains(clusterId));
                                appRegionRepBO.setClusterIds(regionClusters);
                                appRegionRepBO.setCallAuthenticate(Integer.valueOf(region.get("callAuthenticate").toString()));
                                appRegionRepBO.setTrustAllCertificate(Integer.valueOf(region.get("trustAllCertificate").toString()));
                                appRegionRepBO.setCallProtocol(Integer.valueOf(region.get("callProtocol").toString()));
                                appRegionRepBO.setHaddrPolicy(Integer.valueOf(region.get("haddrPolicy").toString()));
                                appRegionRepBO.setRegionType(Integer.valueOf(region.get("regionType").toString()));
                                String appCode = (String)appRegionMap.get(region.get("regionCode").toString()).get(0);
                                AppPO appPO = new AppPO();
                                appPO.setAppCode(appCode);
                                appPO = this.appMapper.queryLimitOne(appPO);
                                if (ObjectUtils.isEmpty((Object)appPO)) {
                                    logger.warn("appCode:{},\u4e0d\u5b58\u5728\uff01", (Object)appCode);
                                    continue;
                                }
                                appRegionRepBO.setAppId(appPO.getAppId());
                                RspBO appRegionRsp = this.appRegionService.addAppRegion(appRegionRepBO);
                                logger.info((Object)appRegionRsp);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u81ea\u52a8\u521b\u5efa\u843d\u5730\u5206\u7ec4\u5f02\u5e38\uff01");
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    Sheet sheet2 = sheetMap.get("ability");
                    if (!"ability".equals(sheet2.getSheetName())) {
                        throw new ZTBusinessException("\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u6587\u4ef6\uff01");
                    }
                    excelReader.read(sheet2);
                    List abilitys = excelListener.getDatas();
                    oldAbilityList = Lists.newArrayList();
                    if (CollectionUtils.isEmpty((Collection)abilitys)) return RspBO.success((Object)oldAbilityList);
                    List abilityPOList = BeanMapper.mapList((Collection)abilitys, AbilityPO.class);
                    newAbilityList = Lists.newArrayList();
                    oldAbilityMap = Maps.newHashMap();
                    for (AbilityPO po2 : abilityPOList) {
                        po2.setHirerId(tenantId);
                        AbilityPO tmp2 = new AbilityPO();
                        tmp2.setHirerId(tenantId);
                        tmp2.setAbilityEname(po2.getAbilityEname());
                        tmp2.setAbilityVersion(po2.getAbilityVersion());
                        tmp2 = this.abilityMapper.queryLimitOne(tmp2);
                        if (tmp2 != null) {
                            oldAbilityMap.put(tmp2.getAbilityId(), po2);
                            continue;
                        }
                        newAbilityList.add(po2);
                    }
                    newabilityLogicPOList = Lists.newArrayList();
                    oldabilityLogicPOList = Lists.newArrayList();
                    newSubAbilityList = Lists.newArrayList();
                    oldSubAbilityList = Lists.newArrayList();
                    newAbilityParamList = Lists.newArrayList();
                    oldAbilityParamList = Lists.newArrayList();
                    newAbilityParamTargetList = Lists.newArrayList();
                    oldAbilityParamTargetList = Lists.newArrayList();
                    newAbilityExtColumnList = Lists.newArrayList();
                    oldAbilityExtColumnList = Lists.newArrayList();
                    newAbilityExtDefaultList = Lists.newArrayList();
                    oldAbilityExtDefaultList = Lists.newArrayList();
                    newAbilityProvideHsfDefaultList = Lists.newArrayList();
                    oldAbilityProvideHsfDefaultList = Lists.newArrayList();
                    newAbilityProvideHsfDefaultInputList = Lists.newArrayList();
                    oldAbilityProvideHsfDefaultInputList = Lists.newArrayList();
                    newAbilityProvideDubboDefaultList = Lists.newArrayList();
                    oldAbilityProvideDubboDefaultList = Lists.newArrayList();
                    newAbilityProvideDubboDefaultInputList = Lists.newArrayList();
                    oldAbilityProvideDubboDefaultInputList = Lists.newArrayList();
                    newAbilityProvideHttpDefaultList = Lists.newArrayList();
                    oldAbilityProvideHttpDefaultList = Lists.newArrayList();
                    newAbilityProvideDeployList = Lists.newArrayList();
                    ArrayList oldAbilityProvideDeployList = Lists.newArrayList();
                    newAbilityProvideHttpCustomList = Lists.newArrayList();
                    ArrayList oldAbilityProvideHttpCustomList = Lists.newArrayList();
                    oldAbilityAppIdMap = new LinkedHashMap<String, Long>();
                    newRateLimiterAbilityDefaultList = Lists.newArrayList();
                    oldRateLimiterAbilityDefaultList = Lists.newArrayList();
                    newAbilityTransList = Lists.newArrayList();
                    oldAbilityTransList = Lists.newArrayList();
                    newAbilityAppList = Lists.newArrayList();
                    ArrayList oldAbilityAppList = Lists.newArrayList();
                    newPluginBindAbilityBOList = new ArrayList<PluginBindAbilityBO>();
                    if (CollectionUtils.isEmpty((Collection)newAbilityList)) {
                        excelReader.read(sheetMap.get("ability_logic"));
                        List abilityLogics = excelListener.getDatas();
                        if (!CollectionUtils.isEmpty((Collection)abilityLogics)) {
                            List abilityLogicPOList = BeanMapper.mapList((Collection)abilityLogics, AbilityLogicPO.class);
                            oldabilityLogicPOList.addAll(abilityLogicPOList);
                        }
                        excelReader.read(sheetMap.get("sub_ability"));
                        List subAbility = excelListener.getDatas();
                        if (!CollectionUtils.isEmpty((Collection)subAbility)) {
                            List subAbilityList = BeanMapper.mapList((Collection)subAbility, SubAbilityPO.class);
                            oldSubAbilityList.addAll(subAbilityList);
                        }
                        excelReader.read(sheetMap.get("ability_param"));
                        List abilityParam = excelListener.getDatas();
                        if (!CollectionUtils.isEmpty((Collection)abilityParam)) {
                            List abilityParamList = BeanMapper.mapList((Collection)abilityParam, AbilityParamPO.class);
                            oldAbilityParamList.addAll(abilityParamList);
                        }
                        excelReader.read(sheetMap.get("ability_param_target"));
                        List abilityParamTarget = excelListener.getDatas();
                        if (!CollectionUtils.isEmpty((Collection)abilityParamTarget)) {
                            List abilityParamTargetList = BeanMapper.mapList((Collection)abilityParamTarget, AbilityParamTargetPo.class);
                            oldAbilityParamTargetList.addAll(abilityParamTargetList);
                        }
                        excelReader.read(sheetMap.get("ability_ext_column"));
                        List abilityExtColumn = excelListener.getDatas();
                        if (!CollectionUtils.isEmpty((Collection)abilityExtColumn)) {
                            List abilityExtColumnList = BeanMapper.mapList((Collection)abilityExtColumn, AbilityExtColumnPO.class);
                            oldAbilityExtColumnList.addAll(abilityExtColumnList);
                        }
                        excelReader.read(sheetMap.get("ability_ext_default"));
                        List abilityExtDefault = excelListener.getDatas();
                        if (!CollectionUtils.isEmpty((Collection)abilityExtDefault)) {
                            List abilityExtDefaultList = BeanMapper.mapList((Collection)abilityExtDefault, AbilityExtDefaultPO.class);
                            oldAbilityExtDefaultList.addAll(abilityExtDefaultList);
                        }
                        excelReader.read(sheetMap.get("ability_provide_hsf_default"));
                        List abilityProvideHsfDefault = excelListener.getDatas();
                        if (!CollectionUtils.isEmpty((Collection)abilityProvideHsfDefault)) {
                            List abilityProvideHsfDefaultList = BeanMapper.mapList((Collection)abilityProvideHsfDefault, AbilityProvideHsfDefaultPO.class);
                            oldAbilityProvideHsfDefaultList.addAll(abilityProvideHsfDefaultList);
                        }
                        excelReader.read(sheetMap.get("hsf_default_input"));
                        List abilityProvideHsfDefaultInput = excelListener.getDatas();
                        if (!CollectionUtils.isEmpty((Collection)abilityProvideHsfDefaultInput)) {
                            List abilityProvideHsfDefaultInputList = BeanMapper.mapList((Collection)abilityProvideHsfDefaultInput, AbilityProvideHsfDefaultInputPO.class);
                            oldAbilityProvideHsfDefaultInputList.addAll(abilityProvideHsfDefaultInputList);
                        }
                        excelReader.read(sheetMap.get("ability_provide_dubbo_default"));
                        List abilityProvideDubboDefault = excelListener.getDatas();
                        if (!CollectionUtils.isEmpty((Collection)abilityProvideDubboDefault)) {
                            List abilityProvideDubboDefaultList = BeanMapper.mapList((Collection)abilityProvideDubboDefault, AbilityProvideDubboDefaultPO.class);
                            oldAbilityProvideDubboDefaultList.addAll(abilityProvideDubboDefaultList);
                        }
                        excelReader.read(sheetMap.get("dubbo_default_input"));
                        List abilityProvideDubboDefaultInput = excelListener.getDatas();
                        if (!CollectionUtils.isEmpty((Collection)abilityProvideDubboDefaultInput)) {
                            List abilityProvideDubboDefaultInputList = BeanMapper.mapList((Collection)abilityProvideDubboDefaultInput, AbilityProvideDubboDefaultInputPO.class);
                            oldAbilityProvideDubboDefaultInputList.addAll(abilityProvideDubboDefaultInputList);
                        }
                        excelReader.read(sheetMap.get("ability_provide_http_default"));
                        List abilityProvideHttpDefault = excelListener.getDatas();
                        if (!CollectionUtils.isEmpty((Collection)abilityProvideHttpDefault)) {
                            List abilityProvideHttpDefaultList = BeanMapper.mapList((Collection)abilityProvideHttpDefault, AbilityProvideHttpDefaultPO.class);
                            oldAbilityProvideHttpDefaultList.addAll(abilityProvideHttpDefaultList);
                        }
                        excelReader.read(sheetMap.get("rate_limiter_ability_default"));
                        List rateLimiterAbilityDefault = excelListener.getDatas();
                        if (!CollectionUtils.isEmpty((Collection)rateLimiterAbilityDefault)) {
                            List abilityProvideHttpDefaultList = BeanMapper.mapList((Collection)rateLimiterAbilityDefault, RateLimiterAbilityDefaultPO.class);
                            oldRateLimiterAbilityDefaultList.addAll(abilityProvideHttpDefaultList);
                        }
                        excelReader.read(sheetMap.get("ability_trans"));
                        List abilityTrans = excelListener.getDatas();
                        if (!CollectionUtils.isEmpty((Collection)abilityTrans)) {
                            List abilityTransList = BeanMapper.mapList((Collection)abilityTrans, AbilityTransPO.class);
                            oldAbilityTransList.addAll(abilityTransList);
                        }
                        excelReader.read(sheetMap.get("ability_app"));
                        List abilityApp = excelListener.getDatas();
                        if (!CollectionUtils.isEmpty((Collection)abilityApp)) {
                            List abilityAppList = BeanMapper.mapList((Collection)abilityApp, AbilityAppPO.class);
                            oldAbilityAppList.addAll(abilityAppList);
                        }
                        break block158;
                    }
                    List newAbilityIds = newAbilityList.stream().map(AbilityPO::getAbilityId).collect(Collectors.toList());
                    HashMap map2 = Maps.newHashMap();
                    for (AbilityPO tmp3 : newAbilityList) {
                        Long oldAbilityId = tmp3.getAbilityId();
                        tmp3.setAbilityId(null);
                        tmp3.setHirerId(tenantId);
                        tmp3.setCreateUserId(Long.valueOf(UserHolder.getUserId()));
                        tmp3.setCreateTime(new Date());
                        tmp3.setUpdateUserId(tmp3.getCreateUserId());
                        tmp3.setUpdateTime(tmp3.getCreateTime());
                        tmp3.setAttendStatus(1);
                        tmp3.setCheckinTime(new Date());
                        tmp3.setIsDraft(1);
                        this.abilityMapper.insertSelective(tmp3);
                        map2.put(oldAbilityId, tmp3);
                    }
                    excelReader.read(sheetMap.get("ability_logic"));
                    List abilityLogics = excelListener.getDatas();
                    if (!CollectionUtils.isEmpty((Collection)abilityLogics)) {
                        List abilityLogicPOList = BeanMapper.mapList((Collection)abilityLogics, AbilityLogicPO.class);
                        for (Object po3 : abilityLogicPOList) {
                            if (newAbilityIds.contains(((AbilityLogicPO)po3).getAbilityId())) {
                                ((AbilityLogicPO)po3).setAbilityId(((AbilityPO)map2.get(((AbilityLogicPO)po3).getAbilityId())).getAbilityId());
                                ((AbilityLogicPO)po3).setAbilityLogicId(null);
                                newabilityLogicPOList.add(po3);
                                continue;
                            }
                            oldabilityLogicPOList.add(po3);
                        }
                    }
                    excelReader.read(sheetMap.get("sub_ability"));
                    List subAbility = excelListener.getDatas();
                    if (!CollectionUtils.isEmpty((Collection)subAbility)) {
                        List subAbilityList = BeanMapper.mapList((Collection)subAbility, SubAbilityPO.class);
                        for (Object po4 : subAbilityList) {
                            if (newAbilityIds.contains(((SubAbilityPO)po4).getParentAbilityId())) {
                                ((SubAbilityPO)po4).setParentAbilityId(((AbilityPO)map2.get(((SubAbilityPO)po4).getParentAbilityId())).getAbilityId());
                                ((SubAbilityPO)po4).setSubAbilityId(null);
                                newSubAbilityList.add(po4);
                                continue;
                            }
                            oldSubAbilityList.add(po4);
                        }
                    }
                    excelReader.read(sheetMap.get("ability_param"));
                    List abilityParam = excelListener.getDatas();
                    if (!CollectionUtils.isEmpty((Collection)abilityParam)) {
                        List abilityParamList = BeanMapper.mapList((Collection)abilityParam, AbilityParamPO.class);
                        for (Object po5 : abilityParamList) {
                            if (newAbilityIds.contains(((AbilityParamPO)po5).getAbilityId())) {
                                ((AbilityParamPO)po5).setAbilityId(((AbilityPO)map2.get(((AbilityParamPO)po5).getAbilityId())).getAbilityId());
                                ((AbilityParamPO)po5).setAbilityParamId(null);
                                newAbilityParamList.add(po5);
                                continue;
                            }
                            oldAbilityParamList.add(po5);
                        }
                    }
                    excelReader.read(sheetMap.get("ability_param_target"));
                    List abilityParamTarget = excelListener.getDatas();
                    if (!CollectionUtils.isEmpty((Collection)abilityParamTarget)) {
                        List abilityParamTargetList = BeanMapper.mapList((Collection)abilityParamTarget, AbilityParamTargetPo.class);
                        for (Object po6 : abilityParamTargetList) {
                            if (newAbilityIds.contains(po6.getAbilityId())) {
                                po6.setAbilityId(((AbilityPO)map2.get(po6.getAbilityId())).getAbilityId());
                                po6.setAbilityParamTargetId(null);
                                newAbilityParamTargetList.add(po6);
                                continue;
                            }
                            oldAbilityParamTargetList.add(po6);
                        }
                    }
                    excelReader.read(sheetMap.get("ability_ext_column"));
                    List abilityExtColumn = excelListener.getDatas();
                    if (!CollectionUtils.isEmpty((Collection)abilityExtColumn)) {
                        List abilityExtColumnList = BeanMapper.mapList((Collection)abilityExtColumn, AbilityExtColumnPO.class);
                        for (Object po7 : abilityExtColumnList) {
                            if (newAbilityIds.contains(((AbilityExtColumnPO)po7).getAbilityId())) {
                                ((AbilityExtColumnPO)po7).setAbilityId(((AbilityPO)map2.get(((AbilityExtColumnPO)po7).getAbilityId())).getAbilityId());
                                ((AbilityExtColumnPO)po7).setAbilityExtColumnId(null);
                                newAbilityExtColumnList.add(po7);
                                continue;
                            }
                            oldAbilityExtColumnList.add(po7);
                        }
                    }
                    excelReader.read(sheetMap.get("ability_ext_default"));
                    List abilityExtDefault = excelListener.getDatas();
                    if (!CollectionUtils.isEmpty((Collection)abilityExtDefault)) {
                        List abilityExtDefaultList = BeanMapper.mapList((Collection)abilityExtDefault, AbilityExtDefaultPO.class);
                        for (Object po8 : abilityExtDefaultList) {
                            if (newAbilityIds.contains(((AbilityExtDefaultPO)po8).getAbilityId())) {
                                ((AbilityExtDefaultPO)po8).setAbilityId(((AbilityPO)map2.get(((AbilityExtDefaultPO)po8).getAbilityId())).getAbilityId());
                                ((AbilityExtDefaultPO)po8).setAbilityExtDefaultId(null);
                                newAbilityExtDefaultList.add(po8);
                                continue;
                            }
                            oldAbilityExtDefaultList.add(po8);
                        }
                    }
                    excelReader.read(sheetMap.get("ability_provide_hsf_default"));
                    List abilityProvideHsfDefault = excelListener.getDatas();
                    if (!CollectionUtils.isEmpty((Collection)abilityProvideHsfDefault)) {
                        List abilityProvideHsfDefaultList = BeanMapper.mapList((Collection)abilityProvideHsfDefault, AbilityProvideHsfDefaultPO.class);
                        for (Object po9 : abilityProvideHsfDefaultList) {
                            if (newAbilityIds.contains(((AbilityProvideHsfDefaultPO)po9).getAbilityId())) {
                                ((AbilityProvideHsfDefaultPO)po9).setAbilityId(((AbilityPO)map2.get(((AbilityProvideHsfDefaultPO)po9).getAbilityId())).getAbilityId());
                                ((AbilityProvideHsfDefaultPO)po9).setHsfDefaultId(null);
                                newAbilityProvideHsfDefaultList.add(po9);
                                continue;
                            }
                            oldAbilityProvideHsfDefaultList.add(po9);
                        }
                    }
                    excelReader.read(sheetMap.get("hsf_default_input"));
                    List abilityProvideHsfDefaultInput = excelListener.getDatas();
                    if (!CollectionUtils.isEmpty((Collection)abilityProvideHsfDefaultInput)) {
                        List abilityProvideHsfDefaultInputList = BeanMapper.mapList((Collection)abilityProvideHsfDefaultInput, AbilityProvideHsfDefaultInputPO.class);
                        for (Object po10 : abilityProvideHsfDefaultInputList) {
                            if (newAbilityIds.contains(((AbilityProvideHsfDefaultInputPO)po10).getAbilityId())) {
                                ((AbilityProvideHsfDefaultInputPO)po10).setAbilityId(((AbilityPO)map2.get(((AbilityProvideHsfDefaultInputPO)po10).getAbilityId())).getAbilityId());
                                ((AbilityProvideHsfDefaultInputPO)po10).setHsfDefaultInputId(null);
                                newAbilityProvideHsfDefaultInputList.add(po10);
                                continue;
                            }
                            oldAbilityProvideHsfDefaultInputList.add(po10);
                        }
                    }
                    excelReader.read(sheetMap.get("ability_provide_dubbo_default"));
                    List abilityProvideDubboDefault = excelListener.getDatas();
                    if (!CollectionUtils.isEmpty((Collection)abilityProvideDubboDefault)) {
                        List abilityProvideDubboDefaultList = BeanMapper.mapList((Collection)abilityProvideDubboDefault, AbilityProvideDubboDefaultPO.class);
                        for (Object po11 : abilityProvideDubboDefaultList) {
                            if (newAbilityIds.contains(((AbilityProvideDubboDefaultPO)po11).getAbilityId())) {
                                ((AbilityProvideDubboDefaultPO)po11).setAbilityId(((AbilityPO)map2.get(((AbilityProvideDubboDefaultPO)po11).getAbilityId())).getAbilityId());
                                ((AbilityProvideDubboDefaultPO)po11).setDubboDefaultId(null);
                                newAbilityProvideDubboDefaultList.add(po11);
                                continue;
                            }
                            oldAbilityProvideDubboDefaultList.add(po11);
                        }
                    }
                    excelReader.read(sheetMap.get("dubbo_default_input"));
                    List abilityProvideDubboDefaultInput = excelListener.getDatas();
                    if (!CollectionUtils.isEmpty((Collection)abilityProvideDubboDefaultInput)) {
                        List abilityProvideDubboDefaultInputList = BeanMapper.mapList((Collection)abilityProvideDubboDefaultInput, AbilityProvideDubboDefaultInputPO.class);
                        for (Object po12 : abilityProvideDubboDefaultInputList) {
                            if (newAbilityIds.contains(((AbilityProvideDubboDefaultInputPO)po12).getAbilityId())) {
                                ((AbilityProvideDubboDefaultInputPO)po12).setAbilityId(((AbilityPO)map2.get(((AbilityProvideDubboDefaultInputPO)po12).getAbilityId())).getAbilityId());
                                ((AbilityProvideDubboDefaultInputPO)po12).setDubboDefaultInputId(null);
                                newAbilityProvideDubboDefaultInputList.add(po12);
                                continue;
                            }
                            oldAbilityProvideDubboDefaultInputList.add(po12);
                        }
                    }
                    excelReader.read(sheetMap.get("ability_provide_http_default"));
                    List abilityProvideHttpDefault = excelListener.getDatas();
                    if (!CollectionUtils.isEmpty((Collection)abilityProvideHttpDefault)) {
                        List abilityProvideHttpDefaultList = BeanMapper.mapList((Collection)abilityProvideHttpDefault, AbilityProvideHttpDefaultPO.class);
                        for (Object po13 : abilityProvideHttpDefaultList) {
                            if (newAbilityIds.contains(((AbilityProvideHttpDefaultPO)po13).getAbilityId())) {
                                ((AbilityProvideHttpDefaultPO)po13).setAbilityId(((AbilityPO)map2.get(((AbilityProvideHttpDefaultPO)po13).getAbilityId())).getAbilityId());
                                ((AbilityProvideHttpDefaultPO)po13).setHttpDefaultId(null);
                                newAbilityProvideHttpDefaultList.add(po13);
                                continue;
                            }
                            oldAbilityProvideHttpDefaultList.add(po13);
                        }
                    }
                    excelReader.read(sheetMap.get("ability_provide_deploy"));
                    List abilityProvideDeploy = excelListener.getDatas();
                    if (!CollectionUtils.isEmpty((Collection)abilityProvideDeploy)) {
                        List abilityProvideDeployPOList = BeanMapper.mapList((Collection)abilityProvideDeploy, AbilityProvideDeployPO.class);
                        for (AbilityProvideDeployPO po14 : abilityProvideDeployPOList) {
                            long provideDeployId = po14.getProvideDeployId();
                            po14.setProvideDeployId(null);
                            if (this.abilityProvideDeployMapper.queryLimitOne(po14) == null) {
                                po14.setProvideDeployId(provideDeployId);
                                po14.setDeployStatus(2);
                                newAbilityProvideDeployList.add(po14);
                                continue;
                            }
                            po14.setProvideDeployId(provideDeployId);
                            oldAbilityProvideDeployList.add(po14);
                        }
                    }
                    excelReader.read(sheetMap.get("ability_provide_http_custom"));
                    List abilityProvideHttpCustom = excelListener.getDatas();
                    if (!CollectionUtils.isEmpty((Collection)abilityProvideHttpCustom)) {
                        List abilityProvideHttpCustomPOList = BeanMapper.mapList((Collection)abilityProvideHttpCustom, AbilityProvideHttpCustomPO.class);
                        List newProvideDeployId = newAbilityProvideDeployList.stream().map(AbilityProvideDeployPO::getProvideDeployId).collect(Collectors.toList());
                        for (AbilityProvideHttpCustomPO po15 : abilityProvideHttpCustomPOList) {
                            if (newProvideDeployId.contains(po15.getProvideDeployId())) {
                                if (po15.getMqId() != null) {
                                    newAbilityProvideDeployList = newAbilityProvideDeployList.stream().filter(abilityProvideDeployPO -> !abilityProvideDeployPO.getProvideDeployId().equals(po15.getProvideDeployId())).collect(Collectors.toList());
                                    continue;
                                }
                                po15.setHttpCustomId(null);
                                newAbilityProvideHttpCustomList.add(po15);
                                continue;
                            }
                            oldAbilityProvideHttpCustomList.add(po15);
                        }
                    }
                    excelReader.read(sheetMap.get("rate_limiter_ability_default"));
                    List rateLimiterAbilityDefault = excelListener.getDatas();
                    if (!CollectionUtils.isEmpty((Collection)rateLimiterAbilityDefault)) {
                        List rateLimiterAbilityDefaultList = BeanMapper.mapList((Collection)rateLimiterAbilityDefault, RateLimiterAbilityDefaultPO.class);
                        for (Object po2 : rateLimiterAbilityDefaultList) {
                            if (newAbilityIds.contains(((RateLimiterAbilityDefaultPO)po2).getAbilityId())) {
                                ((RateLimiterAbilityDefaultPO)po2).setAbilityId(((AbilityPO)map2.get(((RateLimiterAbilityDefaultPO)po2).getAbilityId())).getAbilityId());
                                ((RateLimiterAbilityDefaultPO)po2).setRateLimiterAbilityDefaultId(null);
                                newRateLimiterAbilityDefaultList.add(po2);
                                continue;
                            }
                            oldRateLimiterAbilityDefaultList.add(po2);
                        }
                    }
                    excelReader.read(sheetMap.get("ability_trans"));
                    List abilityTrans = excelListener.getDatas();
                    if (!CollectionUtils.isEmpty((Collection)abilityTrans)) {
                        List abilityTransList = BeanMapper.mapList((Collection)abilityTrans, AbilityTransPO.class);
                        for (Object po16 : abilityTransList) {
                            if (newAbilityIds.contains(((AbilityTransPO)po16).getAbilityId())) {
                                ((AbilityTransPO)po16).setAbilityId(((AbilityPO)map2.get(((AbilityTransPO)po16).getAbilityId())).getAbilityId());
                                ((AbilityTransPO)po16).setAbilityTransId(null);
                                newAbilityTransList.add(po16);
                                continue;
                            }
                            oldAbilityTransList.add(po16);
                        }
                    }
                    excelReader.read(sheetMap.get("ability_app"));
                    List abilityApp = excelListener.getDatas();
                    if (!CollectionUtils.isEmpty((Collection)abilityApp)) {
                        List abilityAppList = BeanMapper.mapList((Collection)abilityApp, AbilityAppPO.class);
                        for (Object po17 : abilityAppList) {
                            int count = 0;
                            for (AbilityPO ability : newAbilityList) {
                                if (((AbilityAppPO)po17).getAbilityEname().equals(ability.getAbilityEname()) && ((AbilityAppPO)po17).getAbilityVersion().equals(ability.getAbilityVersion())) {
                                    oldAbilityAppIdMap.put(((AbilityAppPO)po17).getHirerId() + ((AbilityAppPO)po17).getAbilityEname() + ((AbilityAppPO)po17).getAbilityVersion() + ((AbilityAppPO)po17).getAppCode() + ((AbilityAppPO)po17).getRelationType(), ((AbilityAppPO)po17).getAbilityAppId());
                                    ((AbilityAppPO)po17).setAbilityAppId(null);
                                    newAbilityAppList.add(po17);
                                    break;
                                }
                                ++count;
                            }
                            if (count != newAbilityList.size()) continue;
                            oldAbilityAppList.add(po17);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException e) {
                throw new ZTBusinessException("\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25\uff01");
            }
            excelReader.read(sheetMap.get("plugin"));
            List plugin = excelListener.getDatas();
            if (!CollectionUtils.isEmpty((Collection)plugin)) {
                List pluginList = BeanMapper.mapList((Collection)plugin, PluginPO.class);
                for (PluginPO pluginPo : pluginList) {
                    PluginPO entity = new PluginPO();
                    entity.setPluginEname(pluginPo.getPluginEname());
                    entity.setHirerId(pluginPo.getHirerId());
                    entity = this.pluginMapper.queryLimitOne(entity);
                    if (!ObjectUtils.isEmpty((Object)entity)) {
                        logger.warn("\u63d2\u4ef6\u5df2\u5b58\u5728\uff1a{},\u8df3\u8fc7\u7ed1\u5b9a", (Object)pluginPo.getPluginEname());
                        continue;
                    }
                    PluginAddReqBO pluginAddReqBo = new PluginAddReqBO();
                    pluginAddReqBo.setPluginName(pluginPo.getPluginName());
                    pluginAddReqBo.setPluginEname(pluginPo.getPluginEname());
                    pluginAddReqBo.setPluginType(pluginPo.getPluginType());
                    pluginAddReqBo.setRemark(pluginPo.getRemark());
                    HashMap<String, Object> extInfo = new HashMap<String, Object>();
                    AppBO appBO = this.appApi.queryAppByRegionCode(pluginPo.getHirerId(), pluginPo.getRegionCode());
                    String[] appRegion = new String[]{String.valueOf(appBO.getAppId()), pluginPo.getRegionCode()};
                    extInfo.put("appRegion", appRegion);
                    extInfo.put("clientId", "you-should-change");
                    extInfo.put("clientSecret", "you-should-change");
                    extInfo.put("refreshInterval", "0 */5 * * * ?");
                    extInfo.put("tokenPath", "/accessToken");
                    extInfo.put("taskSwitch", "0");
                    if (Objects.equals(pluginPo.getPluginType(), PluginEnum.HPARTY_CHECK_PLUGIN.getCode())) {
                        extInfo.put("callProtocol", "0");
                        extInfo.put("userName", "you-should-change");
                        extInfo.put("userPassword", "you-should-change");
                        ArrayList<String> appendContents = new ArrayList<String>();
                        appendContents.add("token");
                        appendContents.add("appkey");
                        extInfo.put("appendContents", appendContents);
                        pluginAddReqBo.setExtInfo(extInfo);
                        this.pluginAdminService.addPlugin(pluginAddReqBo);
                        logger.info("\u63d2\u4ef6\u521b\u5efa\u6210\u529f\uff1a{}", (Object)pluginPo.getPluginEname());
                    }
                    if (!Objects.equals(pluginPo.getPluginType(), PluginEnum.JD_HPARTY_CHECK_PLUGIN.getCode())) continue;
                    extInfo.put("callProtocol", "1");
                    pluginAddReqBo.setExtInfo(extInfo);
                    this.pluginAdminService.addPlugin(pluginAddReqBo);
                    logger.info("\u63d2\u4ef6\u521b\u5efa\u6210\u529f\uff1a{}", (Object)pluginPo.getPluginEname());
                }
            }
            excelReader.read(sheetMap.get("ability_plugin_deploy"));
            List abilityPluginDeploy = excelListener.getDatas();
            Map<Object, Object> abilityPluginDeployMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)abilityPluginDeploy)) {
                List abilityPluginDeployList = BeanMapper.mapList((Collection)abilityPluginDeploy, AbilityPluginDeployPO.class);
                abilityPluginDeployMap = abilityPluginDeployList.stream().collect(Collectors.groupingBy(AbilityPluginDeployPO::getAbilityPluginId));
            }
            excelReader.read(sheetMap.get("ability_plugin"));
            List abilityPlugin = excelListener.getDatas();
            if (!CollectionUtils.isEmpty((Collection)abilityPlugin)) {
                List abilityPluginList = BeanMapper.mapList((Collection)abilityPlugin, AbilityPluginPO.class);
                for (AbilityPluginPO po18 : abilityPluginList) {
                    PluginPO existPluginPo = new PluginPO();
                    existPluginPo.setPluginEname(po18.getPluginEname());
                    existPluginPo = this.pluginMapper.queryLimitOne(existPluginPo);
                    if (ObjectUtils.isEmpty((Object)existPluginPo)) {
                        logger.warn("\u80fd\u529b\uff1a{},\u63d2\u4ef6\u4e0d\u5b58\u5728\uff1a{},\u8df3\u8fc7\u7ed1\u5b9a", (Object)po18.getAbilityEname(), (Object)po18.getPluginEname());
                        continue;
                    }
                    AbilityPluginPO existAbilityPluginPo = (AbilityPluginPO)BeanMapper.map((Object)po18, AbilityPluginPO.class);
                    existAbilityPluginPo.setAbilityPluginId(null);
                    existAbilityPluginPo = this.abilityPluginMapper.queryLimitOne(existAbilityPluginPo);
                    if (!ObjectUtils.isEmpty((Object)existAbilityPluginPo)) {
                        logger.warn("\u80fd\u529b\uff1a{},\u63d2\u4ef6\u7ed1\u5b9a\u5b58\u5728\uff1a{},\u8df3\u8fc7\u7ed1\u5b9a", (Object)po18.getAbilityEname(), (Object)po18.getPluginEname());
                        continue;
                    }
                    AbilityPO existAbilityPo = new AbilityPO();
                    existAbilityPo.setAbilityEname(po18.getAbilityEname());
                    existAbilityPo.setAbilityVersion(po18.getAbilityVersion());
                    existAbilityPo = this.abilityMapper.queryLimitOne(existAbilityPo);
                    if (ObjectUtils.isEmpty((Object)existAbilityPo)) {
                        logger.warn("\u80fd\u529b\uff1a{},\u80fd\u529bId\u83b7\u53d6\u5f02\u5e38", (Object)po18.getAbilityEname());
                        continue;
                    }
                    Set clusterIds = ((List)abilityPluginDeployMap.get(po18.getAbilityPluginId())).stream().map(AbilityPluginDeployPO::getClusterId).collect(Collectors.toSet());
                    if (CollectionUtils.isEmpty(clusterIds)) {
                        logger.warn("\u80fd\u529b\uff1a{},\u80fd\u529b\u7ed1\u5b9a\u96c6\u7fa4\u4e3a\u7a7a", (Object)po18.getAbilityEname());
                        continue;
                    }
                    PluginBindAbilityBO pluginBindAbilityBo = new PluginBindAbilityBO();
                    pluginBindAbilityBo.setAbilityId(existAbilityPo.getAbilityId());
                    pluginBindAbilityBo.setAbilityName(existAbilityPo.getAbilityName());
                    pluginBindAbilityBo.setClusterIds(new ArrayList<Long>(clusterIds));
                    pluginBindAbilityBo.setPluginId(existPluginPo.getPluginId());
                    pluginBindAbilityBo.setPluginType(existPluginPo.getPluginType());
                    newPluginBindAbilityBOList.add(pluginBindAbilityBo);
                }
            }
            excelReader.finish();
        }
        if (!CollectionUtils.isEmpty((Collection)newAbilityList)) {
            if (!CollectionUtils.isEmpty((Collection)newabilityLogicPOList)) {
                this.abilityLogicMapper.insertRecords(newabilityLogicPOList);
            }
            if (!CollectionUtils.isEmpty((Collection)newSubAbilityList)) {
                this.subAbilityMapper.insertRecords(newSubAbilityList);
            }
            if (CollectionUtils.isEmpty((Collection)newAbilityParamList)) throw new ZTBusinessException("\u8bf7\u5bfc\u5165\u6b63\u786e\u7684\u6587\u4ef6\uff01");
            this.abilityParamMapper.insertRecords(newAbilityParamList);
            if (CollectionUtils.isEmpty((Collection)newAbilityParamTargetList)) throw new ZTBusinessException("\u8bf7\u5bfc\u5165\u6b63\u786e\u7684\u6587\u4ef6\uff01");
            this.abilityParamTargetMapper.insertRecords((List)newAbilityParamTargetList);
            if (CollectionUtils.isEmpty((Collection)newAbilityExtColumnList)) throw new ZTBusinessException("\u8bf7\u5bfc\u5165\u6b63\u786e\u7684\u6587\u4ef6\uff01");
            this.abilityExtColumnMapper.insertRecords(newAbilityExtColumnList);
            if (CollectionUtils.isEmpty((Collection)newAbilityExtDefaultList)) throw new ZTBusinessException("\u8bf7\u5bfc\u5165\u6b63\u786e\u7684\u6587\u4ef6\uff01");
            this.abilityExtDefaultMapper.insertRecords(newAbilityExtDefaultList);
            if (!CollectionUtils.isEmpty((Collection)newAbilityProvideHsfDefaultList)) {
                this.abilityProvideHsfDefaultMapper.insertRecords(newAbilityProvideHsfDefaultList);
            }
            if (!CollectionUtils.isEmpty((Collection)newAbilityProvideHsfDefaultInputList)) {
                this.abilityProvideHsfDefaultInputMapper.insertRecords(newAbilityProvideHsfDefaultInputList);
            }
            if (!CollectionUtils.isEmpty((Collection)newAbilityProvideDubboDefaultList)) {
                this.abilityProvideDubboDefaultMapper.insertRecords(newAbilityProvideDubboDefaultList);
            }
            if (!CollectionUtils.isEmpty((Collection)newAbilityProvideDubboDefaultInputList)) {
                this.abilityProvideDubboDefaultInputMapper.insertRecords(newAbilityProvideDubboDefaultInputList);
            }
            if (!CollectionUtils.isEmpty((Collection)newAbilityProvideHttpDefaultList)) {
                this.abilityProvideHttpDefaultMapper.insertRecords(newAbilityProvideHttpDefaultList);
            }
            if (!CollectionUtils.isEmpty((Collection)newAbilityProvideHttpCustomList)) {
                this.abilityProvideHttpCustomMapper.insertRecords(newAbilityProvideHttpCustomList);
            }
            if (!CollectionUtils.isEmpty((Collection)newAbilityTransList)) {
                this.abilityTransMapper.insertRecords(newAbilityTransList);
            }
            if (CollectionUtils.isEmpty((Collection)newRateLimiterAbilityDefaultList)) throw new ZTBusinessException("\u8bf7\u5bfc\u5165\u6b63\u786e\u7684\u6587\u4ef6\uff01");
            this.rateLimiterAbilityDefaultMapper.insertRecords(newRateLimiterAbilityDefaultList);
            LinkedHashMap newAbilityAppIdMap = new LinkedHashMap();
            if (!CollectionUtils.isEmpty((Collection)newAbilityAppList)) {
                List<AbilityAppPO> provider = newAbilityAppList.stream().filter(po -> po.getRelationType() == 1).collect(Collectors.toList());
                provider = provider.stream().map(tmp -> {
                    tmp.setHirerId(tenantId);
                    this.abilityAppMapper.deleteAbilityAppByProvide((AbilityAppPO)tmp);
                    return tmp;
                }).collect(Collectors.toList());
                this.abilityAppMapper.insertRecords(provider);
                provider.forEach(po -> {
                    if (!ObjectUtils.isEmpty((Object)(po = this.abilityAppMapper.queryLimitOne((AbilityAppPO)po)))) {
                        long oldAppAbilityId = (Long)oldAbilityAppIdMap.get(po.getHirerId() + po.getAbilityEname() + po.getAbilityVersion() + po.getAppCode() + po.getRelationType());
                        newAbilityAppIdMap.put(oldAppAbilityId, po.getAbilityAppId());
                    }
                });
            }
            Iterator iterator = newAbilityProvideDeployList.stream().iterator();
            while (iterator.hasNext()) {
                AbilityProvideDeployPO po19 = (AbilityProvideDeployPO)iterator.next();
                if (!ObjectUtils.isEmpty(newAbilityAppIdMap.get(po19.getAbilityAppId()))) {
                    po19.setAbilityAppId((Long)newAbilityAppIdMap.get(po19.getAbilityAppId()));
                    continue;
                }
                logger.warn("\u843d\u5730\u8303\u56f4\u7ed1\u5b9a\u53c2\u6570\u6821\u9a8c\u5931\u8d25\uff01{}", (Object)po19);
                iterator.remove();
            }
            if (!CollectionUtils.isEmpty(newAbilityProvideDeployList)) {
                this.abilityProvideDeployMapper.insertRecords(newAbilityProvideDeployList);
            }
            for (AbilityPO newAbilityPO : newAbilityList) {
                AbilityPO po20 = new AbilityPO();
                po20.setAbilityEname(newAbilityPO.getAbilityEname());
                po20.setAbilityVersion(newAbilityPO.getAbilityVersion());
                po20.setHirerId(tenantId);
                newAbilityPO = this.abilityMapper.queryLimitOne(po20);
                AbilityExtPO abilityExtPO = new AbilityExtPO();
                abilityExtPO.setAbilityId(newAbilityPO.getAbilityId());
                this.abilityExtMapper.insertSelective(abilityExtPO);
                abilityParamPO = new AbilityParamPO();
                abilityParamPO.setAbilityId(newAbilityPO.getAbilityId());
                abilityParamPO = this.abilityParamMapper.queryLimitOne(abilityParamPO);
                abilityParamTargetPo = new AbilityParamTargetPo();
                abilityParamTargetPo.setAbilityId(newAbilityPO.getAbilityId());
                abilityParamTargetPo = this.abilityParamTargetMapper.queryLimitOne(abilityParamTargetPo);
                this.abilitySvcComponent.deployCustomSvc(newAbilityPO, abilityExtPO, abilityParamPO, abilityParamTargetPo);
            }
            try {
                RspBO<Boolean> saveAbilityBindPluginRsp = this.pluginAssociationService.saveAbilityBindPlugin(newPluginBindAbilityBOList);
                logger.warn("{}", saveAbilityBindPluginRsp);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (CollectionUtils.isEmpty((Map)oldAbilityMap)) return RspBO.success((Object)oldAbilityList);
        if (isCover == 1) {
            for (Map.Entry entry : oldAbilityMap.entrySet()) {
                List list;
                Long oldAbilityId = (Long)entry.getKey();
                AbilityPO po21 = (AbilityPO)oldAbilityMap.get(oldAbilityId);
                AbilityLogicPO abilityLogicPO = null;
                SubAbilityPO subAbilityPO = null;
                abilityParamPO = null;
                abilityParamTargetPo = null;
                AbilityExtColumnPO abilityExtColumnPO = null;
                AbilityExtDefaultPO abilityExtDefaultPO = null;
                AbilityProvideHsfDefaultPO abilityProvideHsfDefaultPO = null;
                AbilityProvideHsfDefaultInputPO abilityProvideHsfDefaultInputPO = null;
                AbilityProvideDubboDefaultPO abilityProvideDubboDefaultPO = null;
                AbilityProvideDubboDefaultInputPO abilityProvideDubboDefaultInputPO = null;
                AbilityProvideHttpDefaultPO abilityProvideHttpDefaultPO = null;
                RateLimiterAbilityDefaultPO rateLimiterAbilityDefaultPO = null;
                AbilityTransPO abilityTransPO = null;
                if (!oldAbilityId.equals(po21.getAbilityId())) {
                    if (!CollectionUtils.isEmpty((Collection)oldabilityLogicPOList) && !CollectionUtils.isEmpty(list = oldabilityLogicPOList.stream().filter(tmp -> po21.getAbilityId().equals(tmp.getAbilityId())).collect(Collectors.toList()))) {
                        abilityLogicPO = (AbilityLogicPO)list.get(0);
                        abilityLogicPO.setAbilityId(oldAbilityId);
                    }
                    if (!CollectionUtils.isEmpty((Collection)oldSubAbilityList) && !CollectionUtils.isEmpty(list = oldSubAbilityList.stream().filter(tmp -> po21.getAbilityId().equals(tmp.getParentAbilityId())).collect(Collectors.toList()))) {
                        subAbilityPO = (SubAbilityPO)list.get(0);
                        subAbilityPO.setParentAbilityId(oldAbilityId);
                    }
                    if (CollectionUtils.isEmpty((Collection)oldAbilityParamList)) throw new ZTBusinessException("\u8bf7\u5bfc\u5165\u6b63\u786e\u7684\u6587\u4ef6\uff01");
                    abilityParamPO = (AbilityParamPO)oldAbilityParamList.stream().filter(tmp -> po21.getAbilityId().equals(tmp.getAbilityId())).collect(Collectors.toList()).get(0);
                    abilityParamPO.setAbilityId(oldAbilityId);
                    if (CollectionUtils.isEmpty((Collection)oldAbilityParamTargetList)) throw new ZTBusinessException("\u8bf7\u5bfc\u5165\u6b63\u786e\u7684\u6587\u4ef6\uff01");
                    abilityParamTargetPo = (AbilityParamTargetPo)oldAbilityParamTargetList.stream().filter(tmp -> po21.getAbilityId().equals(tmp.getAbilityId())).collect(Collectors.toList()).get(0);
                    abilityParamTargetPo.setAbilityId(oldAbilityId);
                    if (CollectionUtils.isEmpty((Collection)oldAbilityExtColumnList)) throw new ZTBusinessException("\u8bf7\u5bfc\u5165\u6b63\u786e\u7684\u6587\u4ef6\uff01");
                    abilityExtColumnPO = (AbilityExtColumnPO)oldAbilityExtColumnList.stream().filter(tmp -> po21.getAbilityId().equals(tmp.getAbilityId())).collect(Collectors.toList()).get(0);
                    abilityExtColumnPO.setAbilityId(oldAbilityId);
                    if (CollectionUtils.isEmpty((Collection)oldAbilityExtDefaultList)) throw new ZTBusinessException("\u8bf7\u5bfc\u5165\u6b63\u786e\u7684\u6587\u4ef6\uff01");
                    abilityExtDefaultPO = (AbilityExtDefaultPO)oldAbilityExtDefaultList.stream().filter(tmp -> po21.getAbilityId().equals(tmp.getAbilityId())).collect(Collectors.toList()).get(0);
                    abilityExtDefaultPO.setAbilityId(oldAbilityId);
                    if (!CollectionUtils.isEmpty((Collection)oldAbilityProvideHsfDefaultList) && !CollectionUtils.isEmpty(list = oldAbilityProvideHsfDefaultList.stream().filter(tmp -> po21.getAbilityId().equals(tmp.getAbilityId())).collect(Collectors.toList()))) {
                        abilityProvideHsfDefaultPO = (AbilityProvideHsfDefaultPO)list.get(0);
                        abilityProvideHsfDefaultPO.setAbilityId(oldAbilityId);
                    }
                    if (!CollectionUtils.isEmpty((Collection)oldAbilityProvideHsfDefaultInputList) && !CollectionUtils.isEmpty(list = oldAbilityProvideHsfDefaultInputList.stream().filter(tmp -> po21.getAbilityId().equals(tmp.getAbilityId())).collect(Collectors.toList()))) {
                        abilityProvideHsfDefaultInputPO = (AbilityProvideHsfDefaultInputPO)list.get(0);
                        abilityProvideHsfDefaultInputPO.setAbilityId(oldAbilityId);
                    }
                    if (!CollectionUtils.isEmpty((Collection)oldAbilityProvideDubboDefaultList) && !CollectionUtils.isEmpty(list = oldAbilityProvideDubboDefaultList.stream().filter(tmp -> po21.getAbilityId().equals(tmp.getAbilityId())).collect(Collectors.toList()))) {
                        abilityProvideDubboDefaultPO = (AbilityProvideDubboDefaultPO)list.get(0);
                        abilityProvideDubboDefaultPO.setAbilityId(oldAbilityId);
                    }
                    if (!CollectionUtils.isEmpty((Collection)oldAbilityProvideDubboDefaultInputList) && !CollectionUtils.isEmpty(list = oldAbilityProvideDubboDefaultInputList.stream().filter(tmp -> po21.getAbilityId().equals(tmp.getAbilityId())).collect(Collectors.toList()))) {
                        abilityProvideDubboDefaultInputPO = (AbilityProvideDubboDefaultInputPO)list.get(0);
                        abilityProvideDubboDefaultInputPO.setAbilityId(oldAbilityId);
                    }
                    if (!CollectionUtils.isEmpty((Collection)oldAbilityProvideHttpDefaultList) && !CollectionUtils.isEmpty(list = oldAbilityProvideHttpDefaultList.stream().filter(tmp -> po21.getAbilityId().equals(tmp.getAbilityId())).collect(Collectors.toList()))) {
                        abilityProvideHttpDefaultPO = (AbilityProvideHttpDefaultPO)list.get(0);
                        abilityProvideHttpDefaultPO.setAbilityId(oldAbilityId);
                    }
                    if (!CollectionUtils.isEmpty((Collection)oldRateLimiterAbilityDefaultList) && !CollectionUtils.isEmpty(list = oldRateLimiterAbilityDefaultList.stream().filter(tmp -> po21.getAbilityId().equals(tmp.getAbilityId())).collect(Collectors.toList()))) {
                        rateLimiterAbilityDefaultPO = (RateLimiterAbilityDefaultPO)list.get(0);
                        rateLimiterAbilityDefaultPO.setAbilityId(oldAbilityId);
                    }
                    if (!CollectionUtils.isEmpty((Collection)oldAbilityTransList) && !CollectionUtils.isEmpty(list = oldAbilityTransList.stream().filter(tmp -> po21.getAbilityId().equals(tmp.getAbilityId())).collect(Collectors.toList()))) {
                        abilityTransPO = (AbilityTransPO)list.get(0);
                        abilityTransPO.setAbilityId(oldAbilityId);
                    }
                } else {
                    if (!CollectionUtils.isEmpty((Collection)oldabilityLogicPOList) && !CollectionUtils.isEmpty(list = oldabilityLogicPOList.stream().filter(tmp -> po21.getAbilityId().equals(tmp.getAbilityId())).collect(Collectors.toList()))) {
                        abilityLogicPO = (AbilityLogicPO)list.get(0);
                    }
                    if (!CollectionUtils.isEmpty((Collection)oldSubAbilityList) && !CollectionUtils.isEmpty(list = oldSubAbilityList.stream().filter(tmp -> po21.getAbilityId().equals(tmp.getParentAbilityId())).collect(Collectors.toList()))) {
                        subAbilityPO = (SubAbilityPO)list.get(0);
                    }
                    if (CollectionUtils.isEmpty((Collection)oldAbilityParamList)) throw new ZTBusinessException("\u8bf7\u5bfc\u5165\u6b63\u786e\u7684\u6587\u4ef6\uff01");
                    abilityParamPO = (AbilityParamPO)oldAbilityParamList.stream().filter(tmp -> po21.getAbilityId().equals(tmp.getAbilityId())).collect(Collectors.toList()).get(0);
                    if (CollectionUtils.isEmpty((Collection)oldAbilityParamTargetList)) throw new ZTBusinessException("\u8bf7\u5bfc\u5165\u6b63\u786e\u7684\u6587\u4ef6\uff01");
                    abilityParamTargetPo = (AbilityParamTargetPo)oldAbilityParamTargetList.stream().filter(tmp -> po21.getAbilityId().equals(tmp.getAbilityId())).collect(Collectors.toList()).get(0);
                    if (CollectionUtils.isEmpty((Collection)oldAbilityExtColumnList)) throw new ZTBusinessException("\u8bf7\u5bfc\u5165\u6b63\u786e\u7684\u6587\u4ef6\uff01");
                    abilityExtColumnPO = (AbilityExtColumnPO)oldAbilityExtColumnList.stream().filter(tmp -> po21.getAbilityId().equals(tmp.getAbilityId())).collect(Collectors.toList()).get(0);
                    if (CollectionUtils.isEmpty((Collection)oldAbilityExtDefaultList)) throw new ZTBusinessException("\u8bf7\u5bfc\u5165\u6b63\u786e\u7684\u6587\u4ef6\uff01");
                    abilityExtDefaultPO = (AbilityExtDefaultPO)oldAbilityExtDefaultList.stream().filter(tmp -> po21.getAbilityId().equals(tmp.getAbilityId())).collect(Collectors.toList()).get(0);
                    if (!CollectionUtils.isEmpty((Collection)oldAbilityProvideHsfDefaultList) && !CollectionUtils.isEmpty(list = oldAbilityProvideHsfDefaultList.stream().filter(tmp -> po21.getAbilityId().equals(tmp.getAbilityId())).collect(Collectors.toList()))) {
                        abilityProvideHsfDefaultPO = (AbilityProvideHsfDefaultPO)list.get(0);
                    }
                    if (!CollectionUtils.isEmpty((Collection)oldAbilityProvideHsfDefaultInputList) && !CollectionUtils.isEmpty(list = oldAbilityProvideHsfDefaultInputList.stream().filter(tmp -> po21.getAbilityId().equals(tmp.getAbilityId())).collect(Collectors.toList()))) {
                        abilityProvideHsfDefaultInputPO = (AbilityProvideHsfDefaultInputPO)list.get(0);
                    }
                    if (!CollectionUtils.isEmpty((Collection)oldAbilityProvideDubboDefaultList) && !CollectionUtils.isEmpty(list = oldAbilityProvideDubboDefaultList.stream().filter(tmp -> po21.getAbilityId().equals(tmp.getAbilityId())).collect(Collectors.toList()))) {
                        abilityProvideDubboDefaultPO = (AbilityProvideDubboDefaultPO)list.get(0);
                    }
                    if (!CollectionUtils.isEmpty((Collection)oldAbilityProvideDubboDefaultInputList) && !CollectionUtils.isEmpty(list = oldAbilityProvideDubboDefaultInputList.stream().filter(tmp -> po21.getAbilityId().equals(tmp.getAbilityId())).collect(Collectors.toList()))) {
                        abilityProvideDubboDefaultInputPO = (AbilityProvideDubboDefaultInputPO)list.get(0);
                    }
                    if (!CollectionUtils.isEmpty((Collection)oldAbilityProvideHttpDefaultList) && !CollectionUtils.isEmpty(list = oldAbilityProvideHttpDefaultList.stream().filter(tmp -> po21.getAbilityId().equals(tmp.getAbilityId())).collect(Collectors.toList()))) {
                        abilityProvideHttpDefaultPO = (AbilityProvideHttpDefaultPO)list.get(0);
                    }
                    if (!CollectionUtils.isEmpty((Collection)oldRateLimiterAbilityDefaultList) && !CollectionUtils.isEmpty(list = oldRateLimiterAbilityDefaultList.stream().filter(tmp -> po21.getAbilityId().equals(tmp.getAbilityId())).collect(Collectors.toList()))) {
                        rateLimiterAbilityDefaultPO = (RateLimiterAbilityDefaultPO)list.get(0);
                    }
                    if (!CollectionUtils.isEmpty((Collection)oldAbilityTransList) && !CollectionUtils.isEmpty(list = oldAbilityTransList.stream().filter(tmp -> po21.getAbilityId().equals(tmp.getAbilityId())).collect(Collectors.toList()))) {
                        abilityTransPO = (AbilityTransPO)list.get(0);
                    }
                }
                po21.setUpdateUserId(Long.valueOf(UserHolder.getUserId()));
                po21.setUpdateTime(new Date());
                po21.setAbilityId(oldAbilityId);
                this.abilityMapper.updateAbilityByAbilityId(po21);
                if (abilityLogicPO != null) {
                    this.abilityLogicMapper.modLogic(abilityLogicPO.getAbilityId(), abilityLogicPO.getLogicScript());
                }
                if (subAbilityPO != null) {
                    this.subAbilityMapper.updateSubAbilityByAppSubscribeId(subAbilityPO);
                }
                if (abilityParamPO != null) {
                    this.abilityParamMapper.updateByAbilityId(abilityParamPO);
                }
                if (abilityParamTargetPo != null) {
                    this.abilityParamTargetMapper.updateByAbilityId(abilityParamTargetPo);
                }
                if (abilityExtColumnPO != null) {
                    abilityExtColumnPO.setAbilityExtColumnId(null);
                    this.abilityExtColumnMapper.updateAbilityExtColumnByAbilityId(abilityExtColumnPO);
                }
                if (abilityExtDefaultPO != null) {
                    abilityExtDefaultPO.setAbilityExtDefaultId(null);
                    this.abilityExtDefaultMapper.updateAbilityExtDefaultByAbilityId(abilityExtDefaultPO);
                }
                if (abilityProvideHsfDefaultPO != null) {
                    this.abilityProvideHsfDefaultMapper.updateByAbilityId(abilityProvideHsfDefaultPO);
                }
                if (abilityProvideHsfDefaultInputPO != null) {
                    this.abilityProvideHsfDefaultInputMapper.updateByAbilityId(abilityProvideHsfDefaultInputPO);
                }
                if (abilityProvideDubboDefaultPO != null) {
                    this.abilityProvideDubboDefaultMapper.updateByAbilityId(abilityProvideDubboDefaultPO);
                }
                if (abilityProvideDubboDefaultInputPO != null) {
                    this.abilityProvideDubboDefaultInputMapper.updateByAbilityId(abilityProvideDubboDefaultInputPO);
                }
                if (abilityProvideHttpDefaultPO != null) {
                    this.abilityProvideHttpDefaultMapper.updateByAbilityId(abilityProvideHttpDefaultPO);
                }
                if (rateLimiterAbilityDefaultPO != null) {
                    this.rateLimiterAbilityDefaultMapper.updateByAbilityId(rateLimiterAbilityDefaultPO);
                }
                if (abilityTransPO != null) {
                    this.abilityTransMapper.updateByAbilityId(abilityTransPO);
                }
                this.abilityExtMapper.deleteByAbilityId(po21.getAbilityId());
                AbilityExtPO abilityExtPO = new AbilityExtPO();
                abilityExtPO.setAbilityId(po21.getAbilityId());
                this.abilityExtMapper.insertSelective(abilityExtPO);
                this.abilitySvcComponent.deployCustomSvc(po21, abilityExtPO, abilityParamPO, abilityParamTargetPo);
            }
        }
        Iterator iterator = oldAbilityMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            entry = iterator.next();
            oldAbilityList.add(entry.getValue());
        }
        return RspBO.success((Object)oldAbilityList);
        finally {
            if (inputStream != null) {
                if (throwable != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    ((InputStream)inputStream).close();
                }
            }
        }
    }
}

