/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.ability.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.ohaotian.abilityadmin.ability.model.bo.AbilityTestFormatTemplateReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.AbilityTestFormatTemplateRspBO;
import com.ohaotian.abilityadmin.ability.model.bo.AbilityTestRequestBO;
import com.ohaotian.abilityadmin.ability.model.bo.QryAbilitySubscribeRspBO;
import com.ohaotian.abilityadmin.ability.model.bo.QryAbilityTypeReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.QryTestAbilityParameterTemplateReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.abilitydeploy.query.QryAbilityProvideDeployClusterBO;
import com.ohaotian.abilityadmin.ability.service.AbilityTestService;
import com.ohaotian.abilityadmin.mapper.AbilityMapper;
import com.ohaotian.abilityadmin.mapper.AbilityParamMapper;
import com.ohaotian.abilityadmin.mapper.AbilityPluginMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideDeployMapper;
import com.ohaotian.abilityadmin.mapper.AppMapper;
import com.ohaotian.abilityadmin.mapper.AppSecretMapper;
import com.ohaotian.abilityadmin.mapper.AppSubscribeDeployMapper;
import com.ohaotian.abilityadmin.mapper.ClusterMapper;
import com.ohaotian.abilityadmin.mapper.NodeMapper;
import com.ohaotian.abilityadmin.model.po.AbilityPO;
import com.ohaotian.abilityadmin.model.po.AbilityParamPO;
import com.ohaotian.abilityadmin.model.po.AbilityPluginTestPO;
import com.ohaotian.abilityadmin.model.po.AppPO;
import com.ohaotian.abilityadmin.model.po.AppSecretPO;
import com.ohaotian.abilityadmin.model.po.ClusterPO;
import com.ohaotian.abilityadmin.model.po.NodePO;
import com.ohaotian.piscesplatform.mapper.AbilityParamTargetMapper;
import com.ohaotian.piscesplatform.model.po.AbilityParamTargetPo;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.portalcommon.enums.AbilityMockEnum;
import com.ohaotian.portalcommon.enums.AbilityProtocalEnum;
import com.ohaotian.portalcommon.enums.ExtensionPointPositionEnum;
import com.ohaotian.portalcommon.model.bo.AbilityHeadBO;
import com.ohaotian.portalcommon.model.bo.OptionGenerRspBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.service.PluginService;
import com.ohaotian.portalcommon.util.HttpUtil;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class AbilityTestServiceImpl
implements AbilityTestService {
    private static final Logger log = LogManager.getLogger(AbilityTestServiceImpl.class);
    @Resource
    AbilityProvideDeployMapper abilityProvideDeployMapper;
    @Resource
    AbilityMapper abilityMapper;
    @Resource
    AppSubscribeDeployMapper appSubscribeDeployMapper;
    @Resource
    AbilityParamMapper abilityParamMapper;
    @Resource
    AbilityParamTargetMapper abilityParamTargetMapper;
    @Resource
    AppMapper appMapper;
    @Resource
    ClusterMapper clusterMapper;
    @Resource
    AppSecretMapper appSecretMapper;
    @Resource
    PluginService pluginService;
    @Resource
    AbilityPluginMapper abilityPluginMapper;
    @Resource
    NodeMapper nodeMapper;
    @Value(value="${ability.web.path:http://dyc-ability-web:8080}")
    private String defaultAddress;

    @Override
    public List<OptionGenerRspBO<String, Long>> qryClusterType(QryAbilityTypeReqBO qryAbilityTypeReqBO) throws ZTBusinessException {
        AbilityPO abilityPO = new AbilityPO();
        abilityPO.setAbilityId(qryAbilityTypeReqBO.getAbilityId());
        abilityPO = this.abilityMapper.queryLimitOne(abilityPO);
        List<QryAbilityProvideDeployClusterBO> clusterDeployScope = this.abilityProvideDeployMapper.getClusterDeployScope(abilityPO.getHirerId(), abilityPO.getAbilityEname(), abilityPO.getAbilityVersion());
        List<OptionGenerRspBO<String, Long>> collect = clusterDeployScope.stream().map(a -> new OptionGenerRspBO((Serializable)((Object)a.getClusterName()), (Serializable)a.getClusterId())).distinct().collect(Collectors.toList());
        log.info(clusterDeployScope);
        return collect;
    }

    @Override
    public List<OptionGenerRspBO<String, String>> qrySubscribeType(QryAbilityTypeReqBO qryAbilityTypeReqBO) throws ZTBusinessException {
        List<QryAbilitySubscribeRspBO> qryAbilitySubscribeRspBOS = this.appSubscribeDeployMapper.queryAbilitySubscribeTest(qryAbilityTypeReqBO);
        log.info(qryAbilitySubscribeRspBOS);
        List<OptionGenerRspBO<String, String>> collect = qryAbilitySubscribeRspBOS.stream().map(a -> new OptionGenerRspBO((Serializable)((Object)a.getAppName()), (Serializable)((Object)a.getAppId()))).collect(Collectors.toList());
        return collect;
    }

    @Override
    public List<OptionGenerRspBO<String, Integer>> qryProMockType() throws ZTBusinessException {
        List mockSlect = AbilityMockEnum.getMockSlect();
        log.info((Object)mockSlect);
        return mockSlect;
    }

    @Override
    public Map<String, String> generatePath(QryAbilityTypeReqBO qryAbilityTypeReqBO) throws ZTBusinessException {
        AbilityPO abilityPO = new AbilityPO();
        abilityPO.setAbilityId(qryAbilityTypeReqBO.getAbilityId());
        abilityPO = this.abilityMapper.queryLimitOne(abilityPO);
        qryAbilityTypeReqBO.setAbilityEname(abilityPO.getAbilityEname());
        qryAbilityTypeReqBO.setAbilityVersion(abilityPO.getAbilityVersion());
        ClusterPO clusterPo = this.clusterMapper.queryByClusterId(qryAbilityTypeReqBO.getClusterId());
        if (!ObjectUtils.isEmpty((Object)clusterPo)) {
            qryAbilityTypeReqBO.setCenterAddr(clusterPo.getCenterAddr());
        }
        return this.generateAbilityPath(qryAbilityTypeReqBO);
    }

    @Override
    public Map<String, String> generateAbilityPath(QryAbilityTypeReqBO qryAbilityTypeReqBO) throws ZTBusinessException {
        String enumCode = AbilityProtocalEnum.getEnumCode((Integer)qryAbilityTypeReqBO.getParamType());
        StringBuilder stringBuilder = new StringBuilder();
        if (qryAbilityTypeReqBO.getRequestType() != null && qryAbilityTypeReqBO.getRequestType().equals(AbilityMockEnum.MOCK.getValue())) {
            stringBuilder.append("/");
            stringBuilder.append(AbilityMockEnum.MOCK.getCode());
        }
        stringBuilder.append("/");
        if ("json".equals(enumCode)) {
            stringBuilder.append("OSN/api");
        } else {
            stringBuilder.append(enumCode);
        }
        stringBuilder.append("/");
        stringBuilder.append(qryAbilityTypeReqBO.getAbilityEname().replaceAll("_", "/"));
        stringBuilder.append("/");
        stringBuilder.append(qryAbilityTypeReqBO.getAbilityVersion());
        HashMap<String, String> map = new HashMap<String, String>(2);
        if (ObjectUtils.isEmpty((Object)qryAbilityTypeReqBO.getCenterAddr())) {
            map.put("path", this.defaultAddress + stringBuilder);
        } else {
            map.put("path", qryAbilityTypeReqBO.getCenterAddr() + stringBuilder);
        }
        map.put("simple", stringBuilder.toString());
        return map;
    }

    @Override
    public RspBO updateParameter(QryTestAbilityParameterTemplateReqBO qryTestAbilityParameterTemplateReqBO) {
        AbilityParamPO abilityParamPO = new AbilityParamPO();
        abilityParamPO.setAbilityId(qryTestAbilityParameterTemplateReqBO.getAbilityId());
        AbilityParamTargetPo abilityParamTargetPo = new AbilityParamTargetPo();
        abilityParamTargetPo.setAbilityId(qryTestAbilityParameterTemplateReqBO.getAbilityId());
        switch (qryTestAbilityParameterTemplateReqBO.getParamType()) {
            case 0: {
                abilityParamPO.setReqJsonTemplate(qryTestAbilityParameterTemplateReqBO.getReqTemplate());
                abilityParamPO.setRspJsonTemplate(qryTestAbilityParameterTemplateReqBO.getRspTemplate());
                abilityParamTargetPo.setTargetReqJsonTemplate(qryTestAbilityParameterTemplateReqBO.getTargetReqTemplate());
                abilityParamTargetPo.setTargetRspJsonTemplate(qryTestAbilityParameterTemplateReqBO.getTargetRspTemplate());
                break;
            }
            case 1: {
                abilityParamPO.setReqXmlTemplate(qryTestAbilityParameterTemplateReqBO.getReqTemplate());
                abilityParamPO.setRspXmlTemplate(qryTestAbilityParameterTemplateReqBO.getRspTemplate());
                abilityParamTargetPo.setTargetReqXmlTemplate(qryTestAbilityParameterTemplateReqBO.getTargetReqTemplate());
                abilityParamTargetPo.setTargetRspXmlTemplate(qryTestAbilityParameterTemplateReqBO.getTargetRspTemplate());
                break;
            }
            case 2: {
                abilityParamPO.setReqWsTemplate(qryTestAbilityParameterTemplateReqBO.getReqTemplate());
                abilityParamPO.setRspWsTemplate(qryTestAbilityParameterTemplateReqBO.getRspTemplate());
                abilityParamTargetPo.setTargetReqWsTemplate(qryTestAbilityParameterTemplateReqBO.getTargetReqTemplate());
                abilityParamTargetPo.setTargetRspWsTemplate(qryTestAbilityParameterTemplateReqBO.getTargetRspTemplate());
                break;
            }
            default: {
                throw new ZTBusinessException("\u540c\u6b65\u53c2\u6570\u6a21\u7248\u5f02\u5e38\uff0c\u540c\u6b65\u53c2\u6570\u5f02\u5e38");
            }
        }
        if (Boolean.FALSE.equals(StringUtils.isEmpty((Object)qryTestAbilityParameterTemplateReqBO.getReqTemplate()) && StringUtils.isEmpty((Object)qryTestAbilityParameterTemplateReqBO.getRspTemplate()))) {
            this.abilityParamMapper.updateByAbilityId(abilityParamPO);
        }
        if (Boolean.FALSE.equals(StringUtils.isEmpty((Object)qryTestAbilityParameterTemplateReqBO.getTargetReqTemplate()) && StringUtils.isEmpty((Object)qryTestAbilityParameterTemplateReqBO.getTargetRspTemplate()))) {
            this.abilityParamTargetMapper.updateByAbilityId(abilityParamTargetPo);
        }
        return RspBO.success(null);
    }

    @Override
    public List<AbilityHeadBO> generateWebHead(QryAbilityTypeReqBO qryAbilityTypeReqBO) throws ZTBusinessException {
        ArrayList<AbilityHeadBO> list = new ArrayList<AbilityHeadBO>();
        AbilityHeadBO abilityHeadBO = new AbilityHeadBO();
        abilityHeadBO.setHeadKey("Content-Type");
        switch (qryAbilityTypeReqBO.getParamType()) {
            case 1: {
                abilityHeadBO.setHeadValue("application/xml");
                break;
            }
            case 2: {
                abilityHeadBO.setHeadValue("text/xml");
                break;
            }
            case 3: {
                abilityHeadBO.setHeadValue("multipart/form-data");
                break;
            }
            default: {
                abilityHeadBO.setHeadValue("application/json");
            }
        }
        list.add(abilityHeadBO);
        AbilityHeadBO appHead = new AbilityHeadBO();
        AppPO appPO = this.appMapper.queryByAppId(Long.valueOf(qryAbilityTypeReqBO.getAppId()));
        appHead.setHeadKey("appCode");
        appHead.setHeadValue(StringUtils.isEmpty((Object)appPO) ? null : appPO.getAppCode());
        list.add(appHead);
        AppSecretPO appSecretPO = this.appSecretMapper.selectByAppIdAndClusterId(Long.valueOf(qryAbilityTypeReqBO.getAppId()), qryAbilityTypeReqBO.getClusterId());
        if (appSecretPO == null) {
            throw new ZTBusinessException("\u6839\u636e\u5e94\u7528\u672a\u67e5\u8be2\u5230\u5bc6\u94a5\u3002\u8bf7\u6838\u67e5\u8bf7\u6c42\u5e94\u7528\u662f\u5426\u6b63\u5e38");
        }
        AbilityPO abilityPO = new AbilityPO();
        abilityPO.setAbilityId(qryAbilityTypeReqBO.getAbilityId());
        abilityPO = this.abilityMapper.queryLimitOne(abilityPO);
        List<AbilityPluginTestPO> abilityPluginTestPOS = this.abilityPluginMapper.queryByAbilityName(abilityPO.getHirerId(), abilityPO.getAbilityEname(), abilityPO.getAbilityVersion(), qryAbilityTypeReqBO.getClusterId());
        abilityPluginTestPOS.stream().forEach(a -> {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("appCode", appPO.getAppCode());
            map.put("appSercret", appSecretPO.getAppSecret());
            map.put("publicSercret", appSecretPO.getPublicSecrets());
            map.put("abilityPluginDeployId", a.getAbilityPluginDeployId());
            map.put("clusterId", qryAbilityTypeReqBO.getClusterId());
            RspBO mapRspBO = this.pluginService.handleHeadInfo(map, a.getPluginType(), ExtensionPointPositionEnum.ABILITY_TEST_POSITION.getCode());
            if (mapRspBO != null && "0".equals(mapRspBO.getCode()) && mapRspBO.getData() != null) {
                ((Map)mapRspBO.getData()).forEach((k, v) -> list.add(AbilityHeadBO.builder().headKey(k).headValue(v).build()));
            }
        });
        return list;
    }

    @Override
    public RspBO webRequest(AbilityTestRequestBO abilityTestRequestBO) {
        String url;
        String json = abilityTestRequestBO.getReqTemplate();
        HashMap heads = new HashMap(16);
        abilityTestRequestBO.getHeads().forEach(b -> heads.put(b.getHeadKey(), b.getHeadValue()));
        ClusterPO clusterPo = this.clusterMapper.queryByClusterId(abilityTestRequestBO.getClusterId());
        String centerAddr = "\u96c6\u7fa4\u914d\u7f6e\u5730\u5740\u5f02\u5e38:";
        if (!ObjectUtils.isEmpty((Object)clusterPo)) {
            centerAddr = clusterPo.getCenterAddr();
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)centerAddr)) {
            NodePO nodePO = this.nodeMapper.queryByClusterId(abilityTestRequestBO.getClusterId());
            if (nodePO == null) {
                throw new ZTBusinessException("\u8c03\u7528\u9519\u8bef\uff0c\u8bf7\u67e5\u770b\u6240\u9009\u96c6\u7fa4\u662f\u5426\u5b58\u5728\u6709\u6548\u8282\u70b9");
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("http://");
            stringBuilder.append(nodePO.getNodeIp().trim());
            stringBuilder.append(":");
            stringBuilder.append(nodePO.getPort());
            stringBuilder.append(abilityTestRequestBO.getPath().trim());
            url = stringBuilder.toString();
        } else {
            url = abilityTestRequestBO.getPath().trim();
        }
        Map map = this.callWeb(json, url, heads, abilityTestRequestBO.getParamType());
        return RspBO.success((Object)map);
    }

    @Override
    public RspBO formatParamTemplate(AbilityTestFormatTemplateReqBO abilityTestFormatTemplateReqBO) {
        AbilityTestFormatTemplateRspBO abilityTestFormatTemplateRspBO = new AbilityTestFormatTemplateRspBO();
        abilityTestFormatTemplateRspBO.setReqTemplate(this.fomat(abilityTestFormatTemplateReqBO.getReqTemplate(), abilityTestFormatTemplateReqBO.getParamType()));
        abilityTestFormatTemplateRspBO.setRspTemplate(this.fomat(abilityTestFormatTemplateReqBO.getRspTemplate(), abilityTestFormatTemplateReqBO.getParamType()));
        return RspBO.success((Object)abilityTestFormatTemplateRspBO);
    }

    private Map callWeb(String json, String addr, Map headers, Integer paramsType) {
        log.info("\u8c03\u7528web\u8bf7\u6c42\u6570\u636e>>>" + json);
        log.info("\u8c03\u7528web\u8bf7\u6c42\u5730\u5740>>>" + addr);
        log.info("\u8c03\u7528web\u8bf7\u6c42head>>>" + headers);
        Map rsp = null;
        try {
            rsp = (Map)HttpUtil.doPostJson((String)addr, (String)json, (status, str) -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("status", status);
                str = this.fomat((String)str, paramsType);
                map.put("response", str);
                log.info("\u8c03\u7528web\u8fd4\u56de\u6570\u636e>>>" + map);
                return map;
            }, (Map)headers);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u8c03\u7528web\u8282\u70b9\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
        }
        return rsp;
    }

    private String fomat(String str, Integer type) {
        if (StringUtils.isEmpty((Object)str)) {
            return null;
        }
        switch (type) {
            case 0: {
                return AbilityTestServiceImpl.fomatJson(str);
            }
            case 1: {
                return AbilityTestServiceImpl.fomatXml(str);
            }
            case 2: {
                return AbilityTestServiceImpl.fomatXml(str);
            }
        }
        throw new ZTBusinessException("\u534f\u8bae\u7c7b\u578b\u4e0d\u652f\u6301");
    }

    public static String fomatXml(String xml) {
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(xml));
            StreamResult xmlOutput = new StreamResult(new StringWriter());
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(xmlInput, xmlOutput);
            return xmlOutput.getWriter().toString().replaceFirst(">", ">\n");
        }
        catch (TransformerException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static String fomatJson(String json) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
            Object obj = mapper.readValue(json, Object.class);
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        }
        catch (IOException e) {
            throw new ZTBusinessException("\u683c\u5f0f\u5316json\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:" + e.getMessage());
        }
    }
}

