/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.util;

import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);

    public static String sendGet(String url, Map<String, String> headers, Map<String, String> params, int connectTimeoutSeconds, int readTimeoutSeconds, boolean isRetry) {
        String result = HttpUtil.doSendGet(url, headers, params, connectTimeoutSeconds, readTimeoutSeconds);
        if (StringUtils.isBlank((CharSequence)result) && isRetry) {
            log.error("get\u8bf7\u6c42\u65b9\u6cd5\u8c03\u7528\u91cd\u8bd5: {}", (Object)url);
            result = HttpUtil.doSendGet(url, headers, params, connectTimeoutSeconds, readTimeoutSeconds);
        }
        return result;
    }

    private static String doSendGet(String url, Map<String, String> headers, Map<String, String> params, int connectTimeout, int readTimeout) {
        String result = "";
        try {
            if (StringUtils.isBlank((CharSequence)url)) {
                return result;
            }
            RestTemplate restTemplate = HttpUtil.assembledSimpleRestTemplate(connectTimeout, readTimeout);
            HttpHeaders httpHeaders = new HttpHeaders();
            if (MapUtils.isNotEmpty(headers)) {
                headers.forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).add(arg_0, arg_1));
            }
            UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)url);
            URI uri = null;
            if (MapUtils.isNotEmpty(params)) {
                LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
                params.forEach((arg_0, arg_1) -> ((MultiValueMap)multiValueMap).add(arg_0, arg_1));
                uri = uriComponentsBuilder.queryParams((MultiValueMap)multiValueMap).build().toUri();
            }
            HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)httpHeaders);
            ResponseEntity responseEntity = restTemplate.exchange((URI)Objects.requireNonNull(uri), HttpMethod.GET, requestEntity, String.class);
            if (responseEntity.getStatusCode() != HttpStatus.OK) {
                log.error("get\u8bf7\u6c42\u5931\u8d25, url: {}, status: {}", (Object)url, (Object)responseEntity.getStatusCode());
                return result;
            }
            result = (String)responseEntity.getBody();
        }
        catch (Exception e) {
            log.error("get\u8bf7\u6c42\u5f02\u5e38, url: {}", (Object)url, (Object)e);
        }
        return result;
    }

    public static String sendPostJson(String url, Map<String, String> headers, String bodyJson, int connectTimeoutSeconds, int readTimeoutSeconds, boolean isRetry) {
        String result = HttpUtil.doSendPostJson(url, headers, bodyJson, connectTimeoutSeconds, readTimeoutSeconds);
        if (isRetry && StringUtils.isBlank((CharSequence)result)) {
            log.error("post\u8bf7\u6c42\u65b9\u6cd5\u8c03\u7528\u91cd\u8bd5(JSON\u683c\u5f0f): {}", (Object)url);
            result = HttpUtil.doSendPostJson(url, headers, bodyJson, connectTimeoutSeconds, readTimeoutSeconds);
        }
        return result;
    }

    private static String doSendPostJson(String url, Map<String, String> headers, String bodyJson, int connectTimeoutSeconds, int readTimeoutSeconds) {
        String result = "";
        try {
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.setContentType(MediaType.APPLICATION_JSON);
            if (MapUtils.isNotEmpty(headers)) {
                headers.forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).add(arg_0, arg_1));
            }
            HttpEntity httpEntity = new HttpEntity((Object)bodyJson, (MultiValueMap)httpHeaders);
            RestTemplate restTemplate = HttpUtil.assembledSimpleRestTemplate(connectTimeoutSeconds, readTimeoutSeconds);
            ResponseEntity responseEntity = restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
            if (responseEntity.getStatusCode() != HttpStatus.OK) {
                log.error("post\u8bf7\u6c42\u5931\u8d25(JSON\u683c\u5f0f), url: {}, status: {}", (Object)url, (Object)responseEntity.getStatusCode());
                return result;
            }
            result = (String)responseEntity.getBody();
        }
        catch (Exception e) {
            log.error("post\u8bf7\u6c42\u5f02\u5e38(JSON\u683c\u5f0f), url: {}", (Object)url, (Object)e);
        }
        return result;
    }

    public static String sendPostFormData(String url, Map<String, String> headers, Map<String, String> params, int connectTimeoutSeconds, int readTimeoutSeconds, boolean isRetry) {
        String result = HttpUtil.doSendPostFormData(url, headers, params, connectTimeoutSeconds, readTimeoutSeconds);
        if (isRetry && StringUtils.isBlank((CharSequence)result)) {
            log.error("post\u8bf7\u6c42\u65b9\u6cd5\u8c03\u7528\u91cd\u8bd5(FormData\u683c\u5f0f): {}", (Object)url);
            result = HttpUtil.doSendPostFormData(url, headers, params, connectTimeoutSeconds, readTimeoutSeconds);
        }
        return result;
    }

    private static String doSendPostFormData(String url, Map<String, String> headers, Map<String, String> params, int connectTimeoutSeconds, int readTimeoutSeconds) {
        String result = "";
        try {
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            if (MapUtils.isNotEmpty(headers)) {
                headers.forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).add(arg_0, arg_1));
            }
            LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
            if (MapUtils.isNotEmpty(params)) {
                params.forEach((arg_0, arg_1) -> ((MultiValueMap)multiValueMap).add(arg_0, arg_1));
            }
            HttpEntity httpEntity = new HttpEntity((Object)multiValueMap, (MultiValueMap)httpHeaders);
            RestTemplate restTemplate = HttpUtil.assembledSimpleRestTemplate(connectTimeoutSeconds, readTimeoutSeconds);
            ResponseEntity responseEntity = restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
            if (responseEntity.getStatusCode() != HttpStatus.OK) {
                log.error("post\u8bf7\u6c42\u5931\u8d25(FormData\u683c\u5f0f), url: {}, status: {}", (Object)url, (Object)responseEntity.getStatusCode());
                return result;
            }
            result = (String)responseEntity.getBody();
        }
        catch (Exception e) {
            log.error("post\u8bf7\u6c42\u5f02\u5e38(FormData\u683c\u5f0f), url: {}", (Object)url, (Object)e);
        }
        return result;
    }

    private static RestTemplate assembledSimpleRestTemplate(int connectTimeoutSeconds, int readTimeoutSeconds) {
        RestTemplate restTemplate = new RestTemplate();
        SimpleClientHttpRequestFactory simpleClientHttpRequestFactory = new SimpleClientHttpRequestFactory();
        if (connectTimeoutSeconds > 0) {
            simpleClientHttpRequestFactory.setConnectTimeout(connectTimeoutSeconds * 1000);
        }
        if (readTimeoutSeconds > 0) {
            simpleClientHttpRequestFactory.setReadTimeout(readTimeoutSeconds * 1000);
        }
        restTemplate.setRequestFactory((ClientHttpRequestFactory)simpleClientHttpRequestFactory);
        return restTemplate;
    }
}

