/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.aop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=100)
public class GlobalLogAbilityAspect {
    private static final Logger log = LoggerFactory.getLogger(GlobalLogAbilityAspect.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String SEPARATOR = "|";
    private static final String EXCLUDE_METHODS = "subscribe";
    private static final String CLASS_METHOD_SEPARATOR = ".";
    private static final String START_IDENTIFICATION = "START";
    private static final String ERROR_IDENTIFICATION = "ERROR";
    private static final String END_IDENTIFICATION = "END";
    private static Integer MAX_PARAM_OUT_SIZE = 5000;

    @Pointcut(value="execution(*  com.tydic.osworkflow.approve.ability.impl..*(..))||execution(*  com.tydic.osworkflow.ability.impl..*(..))|| execution(* com.ohaotian.abilityadmin.*.service.impl..*(..))")
    public void abilityPointCut() {
    }

    @Around(value="abilityPointCut()")
    public Object throwAopTreat(ProceedingJoinPoint pjp) throws Throwable {
        String traceId = UUID.randomUUID().toString();
        Object rspObj = null;
        String[] infos = this.printAbilityAopStartLog(pjp, traceId);
        try {
            rspObj = pjp.proceed();
            this.printAbilityAopEndLog(infos, rspObj);
        }
        catch (Exception e) {
            this.printAbilityAopErrorLog(infos, e);
        }
        return rspObj;
    }

    private void printAbilityAopErrorLog(String[] infos, Throwable e) {
        if (infos == null) {
            return;
        }
        long nowTime = System.currentTimeMillis();
        infos[1] = ERROR_IDENTIFICATION;
        infos[3] = Long.toString(nowTime);
        if (null != this.getThrowableStrRep(e)) {
            infos[5] = this.getThrowableStrRep(e);
        }
        log.error(this.getLogInfoByStrings(infos));
    }

    private String[] printAbilityAopStartLog(ProceedingJoinPoint pjp, String traceId) throws Throwable {
        long nowTime = System.currentTimeMillis();
        StringBuilder commonHead = new StringBuilder(traceId + SEPARATOR);
        String className = pjp.getTarget().getClass().getName();
        String methodString = pjp.getSignature().getName();
        if (EXCLUDE_METHODS.equals(methodString)) {
            return null;
        }
        commonHead.append(className);
        commonHead.append(CLASS_METHOD_SEPARATOR);
        commonHead.append(methodString);
        String[] infos = new String[7];
        infos[0] = commonHead.toString();
        infos[1] = START_IDENTIFICATION;
        infos[2] = Long.toString(nowTime);
        infos[3] = "";
        Object[] params = pjp.getArgs();
        if (params != null && params.length > 0) {
            if (params.length == 1) {
                try {
                    infos[4] = MAPPER.writeValueAsString(params[0]);
                }
                catch (JsonProcessingException e) {
                    infos[4] = ("\u8bf7\u6c42\u62a5\u6587\u8f6cjson\u51fa\u9519\uff0c\u6539\u7528toString\u65b9\u6cd5" + params[0]).replace("\r\n", "");
                }
            } else {
                StringBuilder paramsStr = new StringBuilder();
                paramsStr.append("[");
                for (Object obj : params) {
                    String objStr = null;
                    if (obj != null) {
                        try {
                            objStr = MAPPER.writeValueAsString(obj);
                        }
                        catch (JsonProcessingException e) {
                            objStr = null;
                        }
                    }
                    paramsStr.append(objStr);
                    paramsStr.append(",");
                }
                paramsStr.setLength(paramsStr.length() - 1);
                paramsStr.append("]");
            }
        }
        log.info(this.getLogInfoByStrings(infos));
        return infos;
    }

    private void printAbilityAopEndLog(String[] infos, Object object) {
        if (infos == null) {
            return;
        }
        Long nowTime = System.currentTimeMillis();
        infos[1] = END_IDENTIFICATION;
        infos[3] = nowTime.toString();
        String jsonStr = JSON.toJSONString((Object)object, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        infos[4] = jsonStr != null && jsonStr.length() > MAX_PARAM_OUT_SIZE ? jsonStr.substring(0, MAX_PARAM_OUT_SIZE) + "......" : jsonStr;
        infos[5] = "dealTime:[" + (Long.parseLong(infos[3]) - Long.parseLong(infos[2])) + "ms]";
        log.info(this.getLogInfoByStrings(infos));
    }

    private String getLogInfoByStrings(String[] infos) {
        StringBuilder stb = new StringBuilder();
        for (int i = 0; i < infos.length; ++i) {
            if (i == 2 || i == 3 || i != 4 && StringUtils.isBlank((CharSequence)infos[i])) continue;
            if (StringUtils.isBlank((CharSequence)infos[i])) {
                infos[i] = "";
            }
            stb.append(infos[i]).append(SEPARATOR);
        }
        if (stb.length() > 1) {
            stb.setLength(stb.length() - 1);
        }
        return stb.toString();
    }

    private String getThrowableStrRep(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        pw.flush();
        LineNumberReader reader = new LineNumberReader(new StringReader(sw.toString()));
        StringBuilder sb = new StringBuilder();
        try {
            String line = reader.readLine();
            while (line != null) {
                sb.append(line).append("\r\n");
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            sb.append(ex);
        }
        return sb.toString();
    }
}

