/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.app.service.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.page.PageMethod;
import com.google.common.collect.Lists;
import com.ohaotian.abilityadmin.app.model.bo.AppRegionRepBO;
import com.ohaotian.abilityadmin.app.model.bo.AppRegionRspBO;
import com.ohaotian.abilityadmin.app.model.bo.RegionAddrReqBO;
import com.ohaotian.abilityadmin.app.model.bo.RegionAddrRspBO;
import com.ohaotian.abilityadmin.app.service.AppRegionService;
import com.ohaotian.abilityadmin.config.pubsub.PubSubMsgHandler;
import com.ohaotian.abilityadmin.mapper.AgentNodeDubboMapper;
import com.ohaotian.abilityadmin.mapper.AgentNodeHsfMapper;
import com.ohaotian.abilityadmin.mapper.AgentNodeMapper;
import com.ohaotian.abilityadmin.mapper.AgentProtocolMapper;
import com.ohaotian.abilityadmin.mapper.AppMapper;
import com.ohaotian.abilityadmin.mapper.AppRegionMapper;
import com.ohaotian.abilityadmin.mapper.ClusterMapper;
import com.ohaotian.abilityadmin.mapper.RegionAddrMapper;
import com.ohaotian.abilityadmin.mapper.RegionCertificateMapper;
import com.ohaotian.abilityadmin.mapper.RegionMapper;
import com.ohaotian.abilityadmin.model.po.AgentNodeDubboPO;
import com.ohaotian.abilityadmin.model.po.AgentNodeHsfPO;
import com.ohaotian.abilityadmin.model.po.AgentNodePO;
import com.ohaotian.abilityadmin.model.po.AgentProtocolPO;
import com.ohaotian.abilityadmin.model.po.AppPO;
import com.ohaotian.abilityadmin.model.po.AppRegionPO;
import com.ohaotian.abilityadmin.model.po.ClusterPO;
import com.ohaotian.abilityadmin.model.po.RegionAddrPO;
import com.ohaotian.abilityadmin.model.po.RegionCertificatePO;
import com.ohaotian.abilityadmin.model.po.RegionPO;
import com.ohaotian.abilityadmin.system.model.bo.OptionRspBO;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.portalcommon.config.systemcode.SystemCodeMap;
import com.ohaotian.portalcommon.config.systemcode.SystemCodeValue;
import com.ohaotian.portalcommon.constant.CodeMsg;
import com.ohaotian.portalcommon.constant.Constants;
import com.ohaotian.portalcommon.enums.FisrtLevelEnum;
import com.ohaotian.portalcommon.enums.SecondLevelEnum;
import com.ohaotian.portalcommon.model.bo.ModifyStatusBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.page.RspPage;
import com.ohaotian.portalcommon.util.Base64Utils;
import com.ohaotian.portalcommon.util.SqlUtil;
import com.ohaotian.portalcommon.util.StrUtil;
import com.ohaotian.portalcommon.util.ValidBatchUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class AppRegionServiceImpl
implements AppRegionService {
    private Logger log = LogManager.getLogger(AppRegionServiceImpl.class);
    @Resource
    AppRegionMapper appRegionMapper;
    @Resource
    RegionMapper regionMapper;
    @Resource
    RegionAddrMapper regionAddrMapper;
    @Resource
    private AuthorityService authorityService;
    @Resource
    AppMapper appMapper;
    @Resource
    ClusterMapper clusterMapper;
    @Resource
    private AgentNodeHsfMapper agentNodeHsfMapper;
    @Resource
    private AgentNodeDubboMapper agentNodeDubboMapper;
    @Resource
    private AgentProtocolMapper agentProtocolMapper;
    @Resource
    private AgentNodeMapper agentNodeMapper;
    @Resource
    private RegionCertificateMapper regionCertificateMapper;
    @Autowired
    private PubSubMsgHandler pubSubMsgHandler;

    @Override
    public RspBO qryAppRegionList(AppRegionRepBO appRegionRepBO) {
        StringBuilder order = new StringBuilder();
        if (!StringUtils.isEmpty((Object)appRegionRepBO.getRegionCode())) {
            appRegionRepBO.setRegionCode("%" + appRegionRepBO.getRegionCode() + "%");
        }
        if (!StringUtils.isEmpty((Object)appRegionRepBO.getSortName())) {
            order.append(StrUtil.CamelToUnderline((String)appRegionRepBO.getSortName()));
            if (!StringUtils.isEmpty((Object)appRegionRepBO.getSortOrder())) {
                order.append(" ").append(appRegionRepBO.getSortOrder());
            }
        } else {
            order.append(SqlUtil.getDefaultOrderBy());
        }
        Page page = !StringUtils.isEmpty((Object)order) ? PageMethod.startPage((int)appRegionRepBO.getPageNo(), (int)appRegionRepBO.getPageSize(), (String)order.toString()) : PageMethod.startPage((int)appRegionRepBO.getPageNo(), (int)appRegionRepBO.getPageSize());
        List<AppRegionRspBO> appRegionRspBOList = this.appRegionMapper.selectAppRegionRepBOByAppIdandCode(appRegionRepBO.getAppId(), appRegionRepBO.getRegionCode());
        List<AppRegionRspBO> allAppRegionRspBOList = this.appRegionMapper.selectRegionIdByappIdandCode(appRegionRepBO.getAppId(), appRegionRepBO.getRegionCode());
        appRegionRspBOList.forEach(appRegionRspBO -> {
            ArrayList clusterListName = new ArrayList();
            allAppRegionRspBOList.forEach(allAppRegionRspBO -> {
                if (allAppRegionRspBO.getRegionId().equals(appRegionRspBO.getRegionId())) {
                    ClusterPO clusterPO = this.clusterMapper.queryByClusterId(allAppRegionRspBO.getClusterId());
                    clusterListName.add(clusterPO.getClusterName());
                }
            });
            appRegionRspBO.setClusterListName(org.apache.commons.lang3.StringUtils.join(clusterListName, (String)","));
            SystemCodeValue systemCode = SystemCodeMap.getSystemCode((String)"1011", (String)(appRegionRspBO.getHaddrPolicy() + ""));
            appRegionRspBO.setHaddrPolicyLabel(systemCode.getDicValue());
        });
        RspPage rspPage = new RspPage(Integer.valueOf(appRegionRepBO.getPageSize()), Integer.valueOf(appRegionRepBO.getPageNo()), appRegionRspBOList, Long.valueOf(page.getTotal()));
        return RspBO.success((Object)rspPage);
    }

    @Override
    public RspBO signAppRegion(AppRegionRepBO appRegionRepBO) {
        appRegionRepBO.setUpdateUserId(Long.parseLong(UserHolder.getUserId()));
        RegionPO regionPO = (RegionPO)BeanMapper.map((Object)appRegionRepBO, RegionPO.class);
        regionPO.setUpdateTime(new Date());
        appRegionRepBO.getRegionIds().forEach(param -> {
            regionPO.setRegionId((Long)param);
            int i = this.regionMapper.updateRegionByRegionId(regionPO);
            if (i < 1) {
                throw new ZTBusinessException("\u7b7e\u5230\u7b7e\u9000\u5931\u8d25");
            }
        });
        this.notifyModify(appRegionRepBO.getRegionIds(), 0, appRegionRepBO.getAttendStatus());
        return RspBO.success(null);
    }

    @Override
    @Transactional
    public RspBO deleteAppRegion(AppRegionRepBO appRegionRepBO) {
        if (StringUtils.isEmpty((Object)appRegionRepBO.getAppId())) {
            throw new ZTBusinessException("\u672a\u4f20\u5165\u5e94\u7528ID");
        }
        AppPO appPO = this.appMapper.queryByAppId(appRegionRepBO.getAppId());
        if (StringUtils.isEmpty((Object)appPO)) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5e94\u7528");
        }
        appRegionRepBO.getRegionIds().stream().forEach(reginId -> {
            RegionPO regionPO = this.regionMapper.queryByRegionId((Long)reginId);
            AppRegionPO appRegionPO = new AppRegionPO();
            appRegionPO.setHirerId(Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId()));
            appRegionPO.setClusterId(appRegionRepBO.getClusterId());
            appRegionPO.setRegionCode(regionPO.getRegionCode());
            appRegionPO.setAppCode(appPO.getAppCode());
            AppRegionPO appRegionPO1 = this.appRegionMapper.queryLimitOne(appRegionPO);
            this.appRegionMapper.deleteAppRegionByAppRegionId(appRegionPO1.getAppRegionId());
        });
        int i = this.regionMapper.deleteRegionByIds(appRegionRepBO.getRegionIds());
        if (i < 1) {
            throw new ZTBusinessException("\u5220\u9664\u5931\u8d25");
        }
        this.regionCertificateMapper.deleteByRegionIds(appRegionRepBO.getRegionIds());
        return RspBO.success(null);
    }

    @Override
    @Transactional
    public RspBO addAppRegion(AppRegionRepBO appRegionRepBO) {
        List<AgentNodePO> agentNodePOS;
        List<RegionAddrPO> list2;
        RspBO rspBO = this.validateRegion(appRegionRepBO);
        if (rspBO != null) {
            return rspBO;
        }
        ValidBatchUtils.isNotEmpty((Object)appRegionRepBO, (String[])new String[]{"regionName", "regionCode", "haddrPolicy", "protocol", "appId"});
        Date date = new Date();
        appRegionRepBO.setCreateUserId(Long.parseLong(UserHolder.getUserId()));
        RegionPO regionPO = (RegionPO)BeanMapper.map((Object)appRegionRepBO, RegionPO.class);
        regionPO.setHirerId(Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId()));
        regionPO.setProtocolId(appRegionRepBO.getCenterAddr());
        regionPO.setCreateTime(date);
        regionPO.setAttendStatus(Constants.AttendStatus.SIGN_IN);
        regionPO.setCheckinTime(date);
        this.regionMapper.insertSelective(regionPO);
        if (appRegionRepBO.getCallProtocol().equals(Constants.Http.HTTPS_INT) && (appRegionRepBO.getTrustStoreFile() != null || appRegionRepBO.getCertificateFile() != null)) {
            RegionCertificatePO regionCertificatePO = new RegionCertificatePO();
            try {
                if (appRegionRepBO.getCertificateFile() != null) {
                    regionCertificatePO.setCertificateName(appRegionRepBO.getCertificateFile().getOriginalFilename());
                    regionCertificatePO.setCertificate(Base64Utils.encode((byte[])appRegionRepBO.getCertificateFile().getBytes()));
                    regionCertificatePO.setCerKeypass(appRegionRepBO.getCerKeypass());
                }
                if (appRegionRepBO.getTrustStoreFile() != null) {
                    regionCertificatePO.setTrustKeystoreName(appRegionRepBO.getTrustStoreFile().getOriginalFilename());
                    regionCertificatePO.setTrustKeystore(Base64Utils.encode((byte[])appRegionRepBO.getTrustStoreFile().getBytes()));
                    regionCertificatePO.setTrustKeystoreKeypass(appRegionRepBO.getTrustKeystoreKeypass());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ZTBusinessException(CodeMsg.SERVER_ERROR.getMessage() + ":\u6587\u4ef6\u8bfb\u53d6\u5f02\u5e38");
            }
            regionCertificatePO.setRegionId(regionPO.getRegionId());
            regionCertificatePO.setCreateTime(date);
            regionCertificatePO.setCreateUserId(appRegionRepBO.getCreateUserId());
            this.regionCertificateMapper.insertSelective(regionCertificatePO);
        }
        String protocol2 = appRegionRepBO.getProtocol();
        List agentNodeIds = null;
        if ("dubbo".equals(protocol2) || "hsf".equals(protocol2)) {
            Long centerAddr = appRegionRepBO.getCenterAddr();
            AgentProtocolPO agentProtocolPO = new AgentProtocolPO();
            agentProtocolPO.setProtocolId(centerAddr);
            agentProtocolPO.setProtocol(protocol2);
            List<AgentProtocolPO> agentProtocolPOS = this.agentProtocolMapper.queryByCond(agentProtocolPO);
            agentNodeIds = agentProtocolPOS.stream().map(po -> po.getAgentNodeId()).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(agentNodeIds) && CollectionUtils.isNotEmpty(list2 = (agentNodePOS = this.agentNodeMapper.queryByAgentNodeIds(agentNodeIds)).stream().map(po -> {
            RegionAddrPO bo = new RegionAddrPO();
            bo.setRegionId(regionPO.getRegionId());
            bo.setCapacity(5);
            bo.setAddrType(1);
            bo.setIp(po.getAgentNodeIp());
            bo.setPort(po.getPort());
            bo.setAttendStatus(po.getValidFlag());
            bo.setAttendStatus(Constants.AttendStatus.SIGN_IN);
            bo.setCheckinTime(new Date());
            bo.setCreateTime(new Date());
            bo.setCreateUserId(appRegionRepBO.getCreateUserId());
            bo.setUpdateTime(new Date());
            bo.setUpdateUserId(appRegionRepBO.getCreateUserId());
            return bo;
        }).collect(Collectors.toList()))) {
            this.regionAddrMapper.insertRecords(list2);
        }
        appRegionRepBO.getClusterIds().forEach(list -> {
            this.log.debug("regionId\u300b\u300b\u300b\u300b\u300b\u300b\uff1a{}", (Object)regionPO.getRegionId());
            AppRegionPO appRegionPO = (AppRegionPO)BeanMapper.map((Object)appRegionRepBO, AppRegionPO.class);
            appRegionPO.setClusterId((Long)list);
            AppPO appPO = this.appMapper.queryByAppId(appRegionRepBO.getAppId());
            appRegionPO.setAppCode(appPO.getAppCode());
            appRegionPO.setHirerId(appPO.getHirerId());
            this.appRegionMapper.insertSelective(appRegionPO);
        });
        return RspBO.success(null);
    }

    @Override
    public RspBO qryRegionInfo(AppRegionRepBO appRegionRepBO) {
        String protocol2;
        SystemCodeValue systemCodeRegionType;
        SystemCodeValue systemCode;
        RegionPO regionPO = this.regionMapper.queryByRegionId(appRegionRepBO.getRegionId());
        AppRegionRspBO appRegionRspBO = (AppRegionRspBO)BeanMapper.map((Object)regionPO, AppRegionRspBO.class);
        RegionCertificatePO regionCertificatePO = this.regionCertificateMapper.queryByRegionId(regionPO.getRegionId());
        if (regionCertificatePO != null) {
            appRegionRspBO.setCertificateFileName(regionCertificatePO.getCertificateName());
            appRegionRspBO.setCerKeypass(regionCertificatePO.getCerKeypass());
            appRegionRspBO.setTrustStoreFileName(regionCertificatePO.getTrustKeystoreName());
            appRegionRspBO.setTrustKeystoreKeypass(regionCertificatePO.getTrustKeystoreKeypass());
        }
        AppRegionPO appRegionPO = (AppRegionPO)BeanMapper.map((Object)regionPO, AppRegionPO.class);
        Long tenantId = Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId());
        appRegionPO.setHirerId(tenantId);
        List<AppRegionPO> appRegionPOList = this.appRegionMapper.queryByCond(appRegionPO);
        List<Long> list = appRegionPOList.stream().map(po -> po.getClusterId()).distinct().collect(Collectors.toList());
        appRegionRspBO.setClusterIds(list);
        ArrayList clusterListName = Lists.newArrayList();
        list.forEach(clusterId -> {
            ClusterPO clusterPO = this.clusterMapper.queryByClusterId((Long)clusterId);
            clusterListName.add(clusterPO.getClusterName());
        });
        appRegionRspBO.setClusterIdsLabel(clusterListName);
        if (!StringUtils.isEmpty((Object)appRegionRspBO.getCreateUserId())) {
            appRegionRspBO.setCreateUserName(this.authorityService.getUserInfoByUserId(String.valueOf(appRegionRspBO.getCreateUserId())).getName());
        }
        if (!StringUtils.isEmpty((Object)appRegionRspBO.getUpdateUserId())) {
            appRegionRspBO.setUpdateUserName(this.authorityService.getUserInfoByUserId(String.valueOf(appRegionRspBO.getUpdateUserId())).getName());
        }
        if ((systemCode = SystemCodeMap.getSystemCode((String)"1011", (String)(regionPO.getHaddrPolicy() + ""))) != null) {
            appRegionRspBO.setHaddrPolicyLabel(systemCode.getDicValue());
        }
        if ((systemCodeRegionType = SystemCodeMap.getSystemCode((String)"1010", (String)(regionPO.getRegionType() + ""))) != null) {
            appRegionRspBO.setRegionTypeLabel(systemCodeRegionType.getDicValue());
        }
        if ("dubbo".equals(protocol2 = regionPO.getProtocol())) {
            AgentNodeDubboPO agentNodeDubboPO = this.agentNodeDubboMapper.queryByAgnetDubboId(regionPO.getProtocolId());
            appRegionRspBO.setCenterAddrLabel(agentNodeDubboPO.getZkAddr());
            appRegionRspBO.setCenterAddr(agentNodeDubboPO.getAgnetDubboId() + "");
        } else if ("hsf".equals(protocol2)) {
            AgentNodeHsfPO agentNodeHsfPO = this.agentNodeHsfMapper.queryByAgnetHsfId(regionPO.getProtocolId());
            appRegionRspBO.setCenterAddrLabel(agentNodeHsfPO.getEdasAddr() + "_" + agentNodeHsfPO.getTenantId());
            appRegionRspBO.setCenterAddr(agentNodeHsfPO.getAgnetHsfId() + "");
        }
        return RspBO.success((Object)appRegionRspBO);
    }

    @Override
    @Transactional
    public RspBO updateRegion(AppRegionRepBO appRegionRepBO) {
        ValidBatchUtils.isNotEmpty((Object)appRegionRepBO, (String[])new String[]{"attendStatus", "regionName", "regionCode", "regionType", "haddrPolicy", "protocol", "trustStoreOperation", "trustStoreOperation"});
        RspBO rspBO = this.validateRegion(appRegionRepBO);
        if (rspBO != null) {
            return rspBO;
        }
        Date date = new Date();
        appRegionRepBO.setUpdateUserId(Long.parseLong(UserHolder.getUserId()));
        RegionPO regionPO = (RegionPO)BeanMapper.map((Object)appRegionRepBO, RegionPO.class);
        regionPO.setProtocolId(appRegionRepBO.getCenterAddr());
        regionPO.setUpdateTime(date);
        regionPO.setCheckinTime(date);
        RegionPO region = this.regionMapper.queryByRegionId(regionPO.getRegionId());
        regionPO.setCreateUserId(region.getCreateUserId());
        regionPO.setCreateTime(region.getCreateTime());
        int i = this.regionMapper.updateRegionByRegionId(regionPO);
        if (i < 1) {
            throw new ZTBusinessException("\u5206\u533a\u4fee\u6539\u5931\u8d25");
        }
        try {
            if (appRegionRepBO.getCertificateOperation() == 0 && appRegionRepBO.getTrustStoreOperation() == 0) {
                RegionCertificatePO regionCertificatePO = this.getCommonRegionCertificate(regionPO.getRegionId(), appRegionRepBO.getUpdateUserId());
                if (regionCertificatePO.getCertificate() == null && regionCertificatePO.getTrustKeystore() == null && regionCertificatePO.getRegionCertificateId() != null) {
                    this.regionCertificateMapper.deleteByRegionId(regionPO.getRegionId());
                }
            } else if (appRegionRepBO.getCertificateOperation() == 2 && appRegionRepBO.getTrustStoreOperation() == 2) {
                this.regionCertificateMapper.deleteByRegionId(regionPO.getRegionId());
            } else if (appRegionRepBO.getCertificateOperation() == 0 && appRegionRepBO.getTrustStoreOperation() == 1) {
                RegionCertificatePO regionCertificatePO = this.getCommonRegionCertificate(regionPO.getRegionId(), appRegionRepBO.getUpdateUserId());
                regionCertificatePO.setTrustKeystoreName(appRegionRepBO.getTrustStoreFile().getOriginalFilename());
                regionCertificatePO.setTrustKeystore(Base64Utils.encode((byte[])appRegionRepBO.getTrustStoreFile().getBytes()));
                regionCertificatePO.setTrustKeystoreKeypass(appRegionRepBO.getTrustKeystoreKeypass());
                this.saveOrUpdateRegionCertificate(regionCertificatePO, false);
            } else if (appRegionRepBO.getCertificateOperation() == 1 && appRegionRepBO.getTrustStoreOperation() == 0) {
                RegionCertificatePO regionCertificatePO = this.getCommonRegionCertificate(regionPO.getRegionId(), appRegionRepBO.getUpdateUserId());
                regionCertificatePO.setCertificateName(appRegionRepBO.getCertificateFile().getOriginalFilename());
                regionCertificatePO.setCertificate(Base64Utils.encode((byte[])appRegionRepBO.getCertificateFile().getBytes()));
                regionCertificatePO.setCerKeypass(appRegionRepBO.getCerKeypass());
                this.saveOrUpdateRegionCertificate(regionCertificatePO, false);
            } else if (appRegionRepBO.getCertificateOperation() == 0 && appRegionRepBO.getTrustStoreOperation() == 2) {
                RegionCertificatePO regionCertificatePO = this.getCommonRegionCertificate(regionPO.getRegionId(), appRegionRepBO.getUpdateUserId());
                if (regionCertificatePO.getCertificate() == null) {
                    if (regionCertificatePO.getRegionCertificateId() != null) {
                        this.regionCertificateMapper.deleteByRegionId(regionPO.getRegionId());
                    }
                } else {
                    regionCertificatePO.setTrustKeystoreName(null);
                    regionCertificatePO.setTrustKeystore(null);
                    regionCertificatePO.setTrustKeystoreKeypass(null);
                    this.saveOrUpdateRegionCertificate(regionCertificatePO, true);
                }
            } else if (appRegionRepBO.getCertificateOperation() == 2 && appRegionRepBO.getTrustStoreOperation() == 0) {
                RegionCertificatePO regionCertificatePO = this.getCommonRegionCertificate(regionPO.getRegionId(), appRegionRepBO.getUpdateUserId());
                if (regionCertificatePO.getTrustKeystore() == null) {
                    if (regionCertificatePO.getRegionCertificateId() != null) {
                        this.regionCertificateMapper.deleteByRegionId(regionPO.getRegionId());
                    }
                } else {
                    regionCertificatePO.setCertificateName(null);
                    regionCertificatePO.setCertificate(null);
                    regionCertificatePO.setCerKeypass(null);
                    this.saveOrUpdateRegionCertificate(regionCertificatePO, true);
                }
            } else if (appRegionRepBO.getCertificateOperation() == 1 && appRegionRepBO.getTrustStoreOperation() == 1) {
                RegionCertificatePO regionCertificatePO = this.getCommonRegionCertificate(regionPO.getRegionId(), appRegionRepBO.getUpdateUserId());
                regionCertificatePO.setCertificateName(appRegionRepBO.getCertificateFile().getOriginalFilename());
                regionCertificatePO.setCertificate(Base64Utils.encode((byte[])appRegionRepBO.getCertificateFile().getBytes()));
                regionCertificatePO.setCerKeypass(appRegionRepBO.getCerKeypass());
                regionCertificatePO.setTrustKeystoreName(appRegionRepBO.getTrustStoreFile().getOriginalFilename());
                regionCertificatePO.setTrustKeystore(Base64Utils.encode((byte[])appRegionRepBO.getTrustStoreFile().getBytes()));
                regionCertificatePO.setTrustKeystoreKeypass(appRegionRepBO.getTrustKeystoreKeypass());
                this.saveOrUpdateRegionCertificate(regionCertificatePO, false);
            } else if (appRegionRepBO.getCertificateOperation() == 1 && appRegionRepBO.getTrustStoreOperation() == 2) {
                RegionCertificatePO regionCertificatePO = this.getCommonRegionCertificate(regionPO.getRegionId(), appRegionRepBO.getUpdateUserId());
                regionCertificatePO.setCertificateName(appRegionRepBO.getCertificateFile().getOriginalFilename());
                regionCertificatePO.setCertificate(Base64Utils.encode((byte[])appRegionRepBO.getCertificateFile().getBytes()));
                regionCertificatePO.setCerKeypass(appRegionRepBO.getCerKeypass());
                regionCertificatePO.setTrustKeystoreName(null);
                regionCertificatePO.setTrustKeystore(null);
                regionCertificatePO.setTrustKeystoreKeypass(null);
                this.saveOrUpdateRegionCertificate(regionCertificatePO, true);
            } else if (appRegionRepBO.getCertificateOperation() == 2 && appRegionRepBO.getTrustStoreOperation() == 1) {
                RegionCertificatePO regionCertificatePO = this.getCommonRegionCertificate(regionPO.getRegionId(), appRegionRepBO.getUpdateUserId());
                regionCertificatePO.setCertificateName(null);
                regionCertificatePO.setCertificate(null);
                regionCertificatePO.setCerKeypass(null);
                regionCertificatePO.setTrustKeystoreName(appRegionRepBO.getTrustStoreFile().getOriginalFilename());
                regionCertificatePO.setTrustKeystore(Base64Utils.encode((byte[])appRegionRepBO.getTrustStoreFile().getBytes()));
                regionCertificatePO.setTrustKeystoreKeypass(appRegionRepBO.getTrustKeystoreKeypass());
                this.saveOrUpdateRegionCertificate(regionCertificatePO, true);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ZTBusinessException(CodeMsg.SERVER_ERROR.getMessage() + ":\u6587\u4ef6\u8bfb\u53d6\u5f02\u5e38");
        }
        this.appRegionMapper.deleteByRegionCode(appRegionRepBO.getRegionCode());
        appRegionRepBO.getClusterIds().forEach(list -> {
            AppRegionPO appRegionPO = new AppRegionPO();
            appRegionPO.setClusterId((Long)list);
            appRegionPO.setRegionCode(regionPO.getRegionCode());
            AppPO appPO = this.appMapper.queryByAppId(appRegionRepBO.getAppId());
            appRegionPO.setAppCode(appPO.getAppCode());
            appRegionPO.setHirerId(appPO.getHirerId());
            this.appRegionMapper.insertSelective(appRegionPO);
        });
        return RspBO.success(null);
    }

    private RegionCertificatePO getCommonRegionCertificate(Long regionId, Long userId) {
        RegionCertificatePO regionCertificatePO = this.regionCertificateMapper.queryByRegionId(regionId);
        if (regionCertificatePO == null) {
            regionCertificatePO = new RegionCertificatePO();
            regionCertificatePO.setRegionId(regionId);
            regionCertificatePO.setCreateTime(new Date());
            regionCertificatePO.setCreateUserId(userId);
        } else {
            regionCertificatePO.setUpdateTime(new Date());
            regionCertificatePO.setUpdateUserId(userId);
        }
        return regionCertificatePO;
    }

    private void saveOrUpdateRegionCertificate(RegionCertificatePO regionCertificatePO, Boolean force) {
        if (regionCertificatePO.getRegionCertificateId() == null) {
            this.regionCertificateMapper.insertSelective(regionCertificatePO);
        } else if (force.booleanValue()) {
            this.regionCertificateMapper.updateRegionCertificateByRegionCertificateIdForcedly(regionCertificatePO);
        } else {
            this.regionCertificateMapper.updateRegionCertificateByRegionCertificateId(regionCertificatePO);
        }
    }

    @Override
    public RspBO qryRegionAddr(RegionAddrReqBO regionAddrReqBO) {
        StringBuilder order = new StringBuilder();
        if (!StringUtils.isEmpty((Object)regionAddrReqBO.getSortName())) {
            order.append(StrUtil.CamelToUnderline((String)regionAddrReqBO.getSortName()));
            if (!StringUtils.isEmpty((Object)regionAddrReqBO.getSortOrder())) {
                order.append(" ").append(regionAddrReqBO.getSortOrder());
            }
        } else {
            order.append(SqlUtil.getDefaultOrderBy());
        }
        int pageNo = regionAddrReqBO.getPageNo();
        int pageSize = regionAddrReqBO.getPageSize();
        RegionPO regionPO = this.regionMapper.queryByRegionId(regionAddrReqBO.getRegionId());
        RegionAddrPO regionAddrPO = (RegionAddrPO)BeanMapper.map((Object)regionAddrReqBO, RegionAddrPO.class);
        Page page = !StringUtils.isEmpty((Object)order) ? PageMethod.startPage((int)pageNo, (int)pageSize, (String)order.toString()) : PageMethod.startPage((int)pageNo, (int)pageSize);
        List<RegionAddrPO> regionAddrPOList = this.regionAddrMapper.queryByCond(regionAddrPO);
        List regionAddrRspBOList = BeanMapper.mapList(regionAddrPOList, RegionAddrRspBO.class);
        regionAddrRspBOList.stream().forEach(r -> {
            r.setRegionCode(regionPO.getRegionCode());
            r.setRegionName(regionPO.getRegionName());
        });
        RspPage rspPage = new RspPage(Integer.valueOf(regionAddrReqBO.getPageSize()), Integer.valueOf(regionAddrReqBO.getPageNo()), regionAddrRspBOList, Long.valueOf(page.getTotal()));
        return RspBO.success((Object)rspPage);
    }

    @Override
    public RspBO deleteRegionAddr(RegionAddrReqBO regionAddrReqBO) {
        this.regionAddrMapper.deleteRegionAddrByIds(regionAddrReqBO.getRegionAddrIds());
        return RspBO.success(null);
    }

    @Override
    public RspBO signRegionAddr(RegionAddrReqBO regionAddrReqBO) {
        regionAddrReqBO.setUpdateUserId(Long.parseLong(UserHolder.getUserId()));
        RegionAddrPO regionAddrPO = (RegionAddrPO)BeanMapper.map((Object)regionAddrReqBO, RegionAddrPO.class);
        regionAddrPO.setUpdateTime(new Date());
        regionAddrReqBO.getRegionAddrIds().forEach(param -> {
            regionAddrPO.setRegionAddrId((Long)param);
            int i = this.regionAddrMapper.updateStausByRegionAddrId(regionAddrPO);
            if (i < 1) {
                throw new ZTBusinessException("\u843d\u5730\u5730\u5740\u7b7e\u5230\uff0c\u7b7e\u9000\u5931\u8d25");
            }
        });
        this.notifyModify(regionAddrReqBO.getRegionAddrIds(), 1, regionAddrReqBO.getAttendStatus());
        return RspBO.success(null);
    }

    @Override
    public RspBO addRegionAddr(RegionAddrReqBO regionAddrReqBO) {
        regionAddrReqBO.setCreateUserId(Long.parseLong(UserHolder.getUserId()));
        RegionAddrPO regionAddrPO = (RegionAddrPO)BeanMapper.map((Object)regionAddrReqBO, RegionAddrPO.class);
        regionAddrPO.setAttendStatus(Constants.AttendStatus.SIGN_IN);
        regionAddrPO.setCheckinTime(new Date());
        regionAddrPO.setCreateTime(new Date());
        regionAddrPO.setAddrType(Constants.AddrType.LANDING);
        this.regionAddrMapper.insertSelective(regionAddrPO);
        return RspBO.success(null);
    }

    @Override
    public RspBO qryRegionAddrInfo(RegionAddrReqBO regionAddrReqBO) {
        RegionAddrPO regionAddrPO = this.regionAddrMapper.queryByRegionAddrId(regionAddrReqBO.getRegionAddrId());
        RegionAddrRspBO regionAddrRspBO = (RegionAddrRspBO)BeanMapper.map((Object)regionAddrPO, RegionAddrRspBO.class);
        if (!StringUtils.isEmpty((Object)regionAddrRspBO.getCreateUserId())) {
            regionAddrRspBO.setCreateUserName(this.authorityService.getUserInfoByUserId(String.valueOf(regionAddrRspBO.getCreateUserId())).getName());
        }
        if (!StringUtils.isEmpty((Object)regionAddrRspBO.getUpdateUserId())) {
            regionAddrRspBO.setUpdateUserName(this.authorityService.getUserInfoByUserId(String.valueOf(regionAddrRspBO.getUpdateUserId())).getName());
        }
        return RspBO.success((Object)regionAddrRspBO);
    }

    @Override
    public RspBO updateRegionAddr(RegionAddrReqBO regionAddrReqBO) {
        regionAddrReqBO.setUpdateUserId(Long.parseLong(UserHolder.getUserId()));
        RegionAddrPO regionAddrPO = (RegionAddrPO)BeanMapper.map((Object)regionAddrReqBO, RegionAddrPO.class);
        regionAddrPO.setUpdateTime(new Date());
        regionAddrPO.setCheckinTime(new Date());
        RegionAddrPO regionAddr = this.regionAddrMapper.queryByRegionAddrId(regionAddrPO.getRegionAddrId());
        regionAddrPO.setCreateUserId(regionAddr.getCreateUserId());
        regionAddrPO.setCreateTime(regionAddr.getCreateTime());
        int i = this.regionAddrMapper.updateRegionAddrByRegionAddrId(regionAddrPO);
        if (i < 1) {
            throw new ZTBusinessException("\u843d\u5730\u5730\u5740\u4fee\u6539\u5931\u8d25");
        }
        return RspBO.success(null);
    }

    private void notifyModify(List<Long> list, int type, int status) {
        Long tenantId = Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId());
        ModifyStatusBO modifyStatusBO = new ModifyStatusBO();
        modifyStatusBO.setHirerId(tenantId);
        if (type == 0) {
            modifyStatusBO.setFirstLevel(FisrtLevelEnum.APP.getCode());
            modifyStatusBO.setSecondLevel(SecondLevelEnum.APP_REGION.getCode());
        } else {
            modifyStatusBO.setFirstLevel(FisrtLevelEnum.APP.getCode());
            modifyStatusBO.setSecondLevel(SecondLevelEnum.APP_REGION_ADDR.getCode());
        }
        modifyStatusBO.setPrimaryIds(list);
        modifyStatusBO.setStatus(Integer.valueOf(status));
        this.pubSubMsgHandler.abilityStatus(modifyStatusBO, "CHECK_MODIFY");
    }

    @Override
    public RspBO qryAllRegionByAppId(Long appId) {
        List<RegionPO> regionPOS = this.regionMapper.queryByAppId(appId);
        List bos = regionPOS.stream().map(po -> {
            OptionRspBO bo = new OptionRspBO();
            bo.setLabel(po.getRegionName());
            bo.setValue(po.getRegionCode());
            return bo;
        }).collect(Collectors.toList());
        return RspBO.success(bos);
    }

    @Override
    public RspBO qryCenterAddr(String protocol2) {
        this.log.debug("AppRegionServiceImpl.qryCenterAddr:{}", (Object)protocol2);
        List bos = null;
        if ("dubbo".equals(protocol2)) {
            AgentNodeDubboPO agentNodeDubboPO = new AgentNodeDubboPO();
            List<AgentNodeDubboPO> agentNodeDubboPOS = this.agentNodeDubboMapper.queryByCond(agentNodeDubboPO);
            bos = agentNodeDubboPOS.stream().map(po -> {
                OptionRspBO bo = new OptionRspBO();
                bo.setLabel(po.getZkAddr());
                bo.setValue(po.getAgnetDubboId() + "");
                return bo;
            }).collect(Collectors.toList());
        } else if ("hsf".equals(protocol2)) {
            AgentNodeHsfPO agentNodeHsfPO = new AgentNodeHsfPO();
            List<AgentNodeHsfPO> agentNodeHsfPOS = this.agentNodeHsfMapper.queryByCond(agentNodeHsfPO);
            bos = agentNodeHsfPOS.stream().map(po -> {
                OptionRspBO bo = new OptionRspBO();
                bo.setLabel(po.getEdasAddr() + "_" + po.getTenantId());
                bo.setValue(po.getAgnetHsfId() + "");
                return bo;
            }).collect(Collectors.toList());
        }
        return RspBO.success(bos);
    }

    private RspBO validateRegion(AppRegionRepBO appRegionRepBO) {
        if (appRegionRepBO.getCallProtocol() == null) {
            appRegionRepBO.setCallProtocol(Constants.Http.HTTP_INT);
        }
        if (appRegionRepBO.getCallProtocol().equals(Constants.Http.HTTPS_INT)) {
            if (appRegionRepBO.getCallAuthenticate().equals(Constants.HttpAuthenticate.DUBBO)) {
                if (appRegionRepBO.getRegionId() != null) {
                    if (0 != appRegionRepBO.getCertificateOperation() && 2 != appRegionRepBO.getCertificateOperation()) {
                        if (appRegionRepBO.getCertificateFile() == null) {
                            return RspBO.error((String)"\u53cc\u5411\u8ba4\u8bc1\u5fc5\u987b\u63d0\u4f9b\u8bc1\u4e66");
                        }
                        if (appRegionRepBO.getCerKeypass() == null || appRegionRepBO.getCerKeypass().trim().length() < 1) {
                            return RspBO.error((String)"\u5fc5\u987b\u4e3a\u8bc1\u4e66\u63d0\u4f9b\u53e3\u4ee4");
                        }
                    }
                } else {
                    if (appRegionRepBO.getCertificateFile() == null) {
                        return RspBO.error((String)"\u53cc\u5411\u8ba4\u8bc1\u5fc5\u987b\u63d0\u4f9b\u8bc1\u4e66");
                    }
                    if (appRegionRepBO.getCerKeypass() == null || appRegionRepBO.getCerKeypass().trim().length() < 1) {
                        return RspBO.error((String)"\u5fc5\u987b\u4e3a\u8bc1\u4e66\u63d0\u4f9b\u53e3\u4ee4");
                    }
                }
            }
            if (appRegionRepBO.getTrustAllCertificate() == null) {
                return RspBO.error((String)"\u5fc5\u987b\u6307\u5b9a\u662f\u5426\u4fe1\u4efb\u6240\u6709\u670d\u52a1\u7aef\u8bc1\u4e66");
            }
            if (appRegionRepBO.getTrustStoreOperation() != null && appRegionRepBO.getTrustStoreOperation() == 1 && appRegionRepBO.getTrustStoreFile() == null) {
                return RspBO.error((String)"\u8bf7\u6307\u5b9a\u4fee\u6539\u540e\u7684\u4fe1\u4efb\u5e93\u5185\u5bb9");
            }
            if (appRegionRepBO.getTrustStoreFile() != null && (appRegionRepBO.getTrustKeystoreKeypass() == null || appRegionRepBO.getTrustKeystoreKeypass().trim().length() < 1)) {
                return RspBO.error((String)"\u5fc5\u987b\u4e3a\u4fe1\u4efb\u5e93\u63d0\u4f9b\u53e3\u4ee4");
            }
        }
        return null;
    }
}

