/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.util.jsons2xsd;

import com.ohaotian.abilityadmin.util.jsons2xsd.Assert;
import com.ohaotian.abilityadmin.util.jsons2xsd.JsonSimpleType;
import com.ohaotian.abilityadmin.util.jsons2xsd.XsdSimpleType;
import java.util.HashMap;
import java.util.Map;

public class Config {
    private final String targetNamespace;
    private final String nsAlias;
    private final boolean createRootElement;
    private final String name;
    private final boolean attributesQualified;
    private final boolean includeOnlyUsedTypes;
    private final boolean validateXsdSchema;
    private final Map<String, String> typeMapping;
    private final boolean ignoreUnknownFormats;

    public boolean isAttributesQualified() {
        return this.attributesQualified;
    }

    public boolean isIncludeOnlyUsedTypes() {
        return this.includeOnlyUsedTypes;
    }

    public String getName() {
        return this.name;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public String getNsAlias() {
        return this.nsAlias;
    }

    public boolean isCreateRootElement() {
        return this.createRootElement;
    }

    public boolean isValidateXsdSchema() {
        return this.validateXsdSchema;
    }

    public Map<String, String> getTypeMapping() {
        return this.typeMapping;
    }

    public boolean isIgnoreUnknownFormats() {
        return this.ignoreUnknownFormats;
    }

    public String getType(String type, String format) {
        String key = (type + (format != null ? "|" + format : "")).toLowerCase();
        return this.typeMapping.get(key);
    }

    private Config(Builder builder) {
        this.targetNamespace = builder.targetNamespace;
        this.nsAlias = builder.nsAlias;
        this.createRootElement = builder.createRootElement;
        this.name = builder.name;
        this.attributesQualified = builder.attributesQualified;
        this.includeOnlyUsedTypes = builder.includeOnlyUsedTypes;
        this.validateXsdSchema = builder.validateXsdSchema;
        this.typeMapping = builder.typeMapping;
        this.ignoreUnknownFormats = builder.ignoreUnknownFormats;
    }

    public static class Builder {
        private String name;
        private String targetNamespace;
        private String nsAlias = "x";
        private boolean createRootElement = false;
        private boolean attributesQualified = false;
        private boolean includeOnlyUsedTypes = false;
        private boolean validateXsdSchema = true;
        private final Map<String, String> typeMapping = new HashMap<String, String>();
        private boolean ignoreUnknownFormats;

        public Builder targetNamespace(String targetNamespace) {
            this.targetNamespace = targetNamespace;
            return this;
        }

        public Builder nsAlias(String nsAlias) {
            this.nsAlias = nsAlias;
            return this;
        }

        public Builder createRootElement(boolean b) {
            this.createRootElement = b;
            return this;
        }

        public Builder includeOnlyUsedTypes(boolean b) {
            this.includeOnlyUsedTypes = b;
            return this;
        }

        public Config build() {
            Assert.notNull(this.name, "name must be set");
            return new Config(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder attributesQualified(boolean b) {
            this.attributesQualified = b;
            return this;
        }

        public Builder validateXsdSchema(boolean b) {
            this.validateXsdSchema = b;
            return this;
        }

        public Builder customTypeMapping(JsonSimpleType jsonSimpleType, String format, XsdSimpleType xsdSimpleType) {
            this.typeMapping.put(jsonSimpleType.value() + "|" + format, xsdSimpleType.value());
            return this;
        }

        public Builder nonJsonTypeMapping(String nonJsonType, XsdSimpleType xsdSimpleType) {
            return this.nonJsonTypeMapping(nonJsonType, null, xsdSimpleType);
        }

        public Builder nonJsonTypeMapping(String nonJsonType, String format, XsdSimpleType xsdSimpleType) {
            this.typeMapping.put(nonJsonType + "|" + format, xsdSimpleType.value());
            return this;
        }

        public Builder ignoreUnknownFormats(boolean b) {
            this.ignoreUnknownFormats = b;
            return this;
        }
    }
}

