/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.ability.service.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ohaotian.abilityadmin.ability.service.AbilityToVegaService;
import com.ohaotian.abilityadmin.config.pubsub.PubSubMsgHandler;
import com.ohaotian.abilityadmin.mapper.AbilityMapper;
import com.ohaotian.abilityadmin.mapper.AbilityToVegaMapper;
import com.ohaotian.abilityadmin.model.po.AbilityPO;
import com.ohaotian.abilityadmin.model.po.AbilityProvideDeployPO;
import com.ohaotian.abilityadmin.model.po.AbilityToVegaPo;
import com.ohaotian.portalcommon.model.bo.RspBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AbilityToVegaServiceImpl
implements AbilityToVegaService {
    @Autowired
    private AbilityToVegaMapper abilityToVegaMapper;
    @Autowired
    AbilityMapper abilityMapper;
    @Autowired
    private PubSubMsgHandler pubSubMsgHandler;

    @Override
    @Transactional
    public RspBO checkIn(Long abilityId) {
        AbilityToVegaPo abilityToVegaPo = new AbilityToVegaPo();
        abilityToVegaPo.setAbilityId(abilityId);
        abilityToVegaPo.setForwardStatus(1);
        this.abilityToVegaMapper.insertOrUpdateSelective(abilityToVegaPo);
        this.vegaSyncH2(abilityToVegaPo);
        return RspBO.success((Object)"\u6210\u529f");
    }

    @Override
    @Transactional
    public RspBO checkOut(Long abilityId) {
        AbilityToVegaPo abilityToVegaPo = new AbilityToVegaPo();
        abilityToVegaPo.setAbilityId(abilityId);
        abilityToVegaPo.setForwardStatus(0);
        this.abilityToVegaMapper.insertOrUpdateSelective(abilityToVegaPo);
        this.vegaSyncH2(abilityToVegaPo);
        return RspBO.success((Object)"\u6210\u529f");
    }

    private void vegaSyncH2(AbilityToVegaPo abilityToVegaPo) {
        AbilityPO abilityPo = this.abilityMapper.queryAbilityWithProvideDeployByAbilityId(abilityToVegaPo.getAbilityId());
        List syncDataClusterIdList = abilityPo.getAbilityProvideDeployPOList().stream().map(AbilityProvideDeployPO::getClusterId).distinct().collect(Collectors.toList());
        abilityToVegaPo = this.abilityToVegaMapper.queryByAbilityId(abilityToVegaPo.getAbilityId());
        TreeMap<String, List<String>> map = new TreeMap<String, List<String>>();
        for (Long clusterId : syncDataClusterIdList) {
            ArrayList<String> syncDataList = new ArrayList<String>();
            Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").serializeNulls().create();
            HashMap abilityToVegaPoMap = new HashMap();
            ArrayList<AbilityToVegaPo> abilityToVegaPoList = new ArrayList<AbilityToVegaPo>();
            abilityToVegaPoList.add(abilityToVegaPo);
            abilityToVegaPoMap.put("ability_to_vega", abilityToVegaPoList);
            syncDataList.add(gson.toJson((Object)RspBO.success(abilityToVegaPoMap)));
            map.put(String.valueOf(clusterId), syncDataList);
        }
        ArrayList<Long> abilityIds = new ArrayList<Long>();
        abilityIds.add(abilityToVegaPo.getAbilityId());
        this.pubSubMsgHandler.incrementWriteRedisNode(map, abilityIds, "INCREMENT_SYNC_DATA");
    }
}

