/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public abstract class CopyDirectoryUtil {
    public static void copyFile(File sourceFile, File targetFile) throws IOException {
        try (FileInputStream input = new FileInputStream(sourceFile);
             BufferedInputStream inBuff = new BufferedInputStream(input);
             FileOutputStream output = new FileOutputStream(targetFile);
             BufferedOutputStream outBuff = new BufferedOutputStream(output);){
            int len;
            byte[] b = new byte[5120];
            while ((len = inBuff.read(b)) != -1) {
                outBuff.write(b, 0, len);
            }
            outBuff.flush();
        }
    }

    public static void copyDirectiory(String sourceDir, String targetDir) throws IOException {
        new File(targetDir).mkdirs();
        File[] file = new File(sourceDir).listFiles();
        for (int i = 0; i < file.length; ++i) {
            if (file[i].isFile()) {
                File sourceFile = file[i];
                File targetFile = new File(new File(targetDir).getAbsolutePath() + File.separator + file[i].getName());
                CopyDirectoryUtil.copyFile(sourceFile, targetFile);
            }
            if (!file[i].isDirectory()) continue;
            String dir1 = sourceDir + "/" + file[i].getName();
            String dir2 = targetDir + "/" + file[i].getName();
            CopyDirectoryUtil.copyDirectiory(dir1, dir2);
        }
    }

    public static void main(String[] args) throws IOException {
        String url1 = "E:\\workspace\\DeployeTest";
        String url2 = "E:\\java\\project\\bin";
        new File(url2).mkdirs();
        File[] file = new File(url1).listFiles();
        for (int i = 0; i < file.length; ++i) {
            if (file[i].isFile()) {
                CopyDirectoryUtil.copyFile(file[i], new File(url2 + file[i].getName()));
            }
            if (!file[i].isDirectory()) continue;
            String sourceDir = url1 + File.separator + file[i].getName();
            String targetDir = url2 + File.separator + file[i].getName();
            CopyDirectoryUtil.copyDirectiory(sourceDir, targetDir);
        }
    }
}

