/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.ability.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.github.pagehelper.Page;
import com.github.pagehelper.page.PageMethod;
import com.ohaotian.abilityadmin.ability.model.bo.QryAbilityListPageRspBO;
import com.ohaotian.abilityadmin.ability.model.bo.QryAbilityListReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.QryAbilityListRspBO;
import com.ohaotian.abilityadmin.ability.model.bo.QryAbilityTypeReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.QryPluginReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.QryPluginRspBO;
import com.ohaotian.abilityadmin.ability.model.bo.abilitydeploy.query.QryAbilityDeployAllReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.abilitydeploy.query.QryAbilityDeployNewRspBO;
import com.ohaotian.abilityadmin.ability.service.AbilityDeployService;
import com.ohaotian.abilityadmin.ability.service.AbilityListService;
import com.ohaotian.abilityadmin.ability.service.AbilityTestService;
import com.ohaotian.abilityadmin.mapper.AbilityMapper;
import com.ohaotian.abilityadmin.mapper.AbilityToVegaMapper;
import com.ohaotian.abilityadmin.mapper.ClusterMapper;
import com.ohaotian.abilityadmin.mapper.PluginMapper;
import com.ohaotian.abilityadmin.model.po.AbilityPO;
import com.ohaotian.abilityadmin.model.po.ClusterPO;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.authority.model.AuthorityUserInfoBO;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.portalcommon.enums.AbilityProtocalEnum;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.page.RspPage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class AbilityListServiceImpl
implements AbilityListService {
    private static final Logger log = LoggerFactory.getLogger(AbilityListServiceImpl.class);
    @Resource
    AbilityMapper abilityMapper;
    @Resource
    private PluginMapper pluginMapper;
    @Resource
    private ClusterMapper clusterMapper;
    @Resource
    private AuthorityService authorityService;
    @Autowired
    private AbilityToVegaMapper abilityToVegaMapper;
    @Autowired
    private AbilityDeployService abilityDeployService;
    @Autowired
    private AbilityTestService abilityTestService;
    private ExecutorService executorService;

    @PostConstruct
    public void initAbilityListExecutor() {
        this.executorService = new ThreadPoolExecutor(50, 100, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(10000), new ThreadFactory(){
            final AtomicInteger sn = new AtomicInteger();

            @Override
            public Thread newThread(@Nonnull Runnable runnable) {
                Thread t = new Thread(runnable);
                t.setName("AbilityList_TNO_" + this.sn.incrementAndGet());
                return t;
            }
        });
        log.info("initAbilityListExecutor \u521d\u59cb\u5316......");
    }

    @Override
    public RspBO<List<QryAbilityListRspBO>> queryAbilityList(QryAbilityListReqBO qryAbilityListReqBO) {
        AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
        Long tenantId = Long.valueOf(authorityUserInfoBO.getTenantId());
        StringBuilder order = new StringBuilder();
        if (qryAbilityListReqBO.getSortName() != null) {
            order.append(qryAbilityListReqBO.getSortName());
            if (qryAbilityListReqBO.getSortOrder() != null) {
                order.append(" ");
                order.append(qryAbilityListReqBO.getSortOrder());
            }
        } else {
            order.append("a.").append("ability_id").append(" DESC");
        }
        Page page = PageMethod.startPage((int)qryAbilityListReqBO.getPageNo(), (int)qryAbilityListReqBO.getPageSize(), (String)order.toString());
        qryAbilityListReqBO.setHirerId(tenantId);
        ArrayList<QryAbilityListRspBO> qryAbilityListRspBOList = new ArrayList<QryAbilityListRspBO>();
        List<AbilityPO> abilityPOIdList = this.abilityMapper.queryAbilityList(qryAbilityListReqBO);
        for (AbilityPO abilityPo : abilityPOIdList) {
            QryAbilityListRspBO qryAbilityListRspBO = (QryAbilityListRspBO)BeanMapper.map((Object)abilityPo, QryAbilityListRspBO.class);
            if (Boolean.FALSE.equals(ObjectUtils.isEmpty((Object)abilityPo.getForwardStatus()))) {
                qryAbilityListRspBO.setForwardStatus(abilityPo.getForwardStatus());
            } else {
                qryAbilityListRspBO.setForwardStatus(0);
            }
            qryAbilityListRspBOList.add(qryAbilityListRspBO);
        }
        RspPage rspPage = new RspPage(Integer.valueOf(qryAbilityListReqBO.getPageSize()), Integer.valueOf(qryAbilityListReqBO.getPageNo()), qryAbilityListRspBOList, Long.valueOf(page.getTotal()));
        RspBO rspBO = RspBO.success((Object)rspPage);
        return rspBO;
    }

    @Override
    public RspBO<JSONObject> queryAbilityListPage(QryAbilityListReqBO qryAbilityListReqBO) {
        AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
        Long tenantId = Long.valueOf(authorityUserInfoBO.getTenantId());
        RspBO<List<QryAbilityListRspBO>> queryAbilityListRspBo = this.queryAbilityList(qryAbilityListReqBO);
        CopyOnWriteArrayList qryAbilityListPageRspBOList = new CopyOnWriteArrayList();
        RspPage qryAbilityListRspBOListPage = (RspPage)queryAbilityListRspBo.getData();
        List qryAbilityListRspBOList = (List)JSON.parseObject((String)JSON.toJSONString((Object)qryAbilityListRspBOListPage.getRows()), (TypeReference)new TypeReference<List<QryAbilityListRspBO>>(){}, (Feature[])new Feature[0]);
        JSON.parseArray((String)JSON.toJSONString((Object)qryAbilityListRspBOListPage.getRows()));
        CountDownLatch countDownLatch = new CountDownLatch(qryAbilityListRspBOList.size());
        AtomicInteger orderNum = new AtomicInteger();
        qryAbilityListRspBOList.forEach(qryAbilityBo -> qryAbilityBo.setOrderNum(orderNum.getAndIncrement()));
        qryAbilityListRspBOList.forEach(qryAbilityBo -> {
            CompletionStage future = CompletableFuture.runAsync(() -> {
                QryAbilityListPageRspBO qryAbilityListPageRspBo = new QryAbilityListPageRspBO();
                qryAbilityListPageRspBo.setOrderNum(qryAbilityBo.getOrderNum());
                qryAbilityListPageRspBo.setAbilityId(qryAbilityBo.getAbilityId());
                qryAbilityListPageRspBo.setAbilityName(qryAbilityBo.getAbilityName() + "(" + qryAbilityBo.getAbilityVersion() + ")");
                qryAbilityListPageRspBo.setAbilityEname(qryAbilityBo.getAbilityEname());
                QryPluginReqBO qryPluginReqBo = new QryPluginReqBO();
                qryPluginReqBo.setAbilityId(qryAbilityBo.getAbilityId());
                qryPluginReqBo.setHirerId(tenantId);
                List<QryPluginRspBO> pluginPoList = this.pluginMapper.queryBindPluginsByAbilityId(qryPluginReqBo);
                qryAbilityListPageRspBo.setPluginNum(pluginPoList.size());
                LinkedHashMap<String, List<String>> pluginNameList = new LinkedHashMap<String, List<String>>();
                pluginPoList.stream().collect(Collectors.groupingBy(QryPluginRspBO::getClusterName, Collectors.toList())).forEach((clusterName, qryPluginBo) -> {
                    List pluginOne = qryPluginBo.stream().map(QryPluginRspBO::getPluginName).collect(Collectors.toCollection(LinkedList::new));
                    pluginNameList.put((String)clusterName, pluginOne);
                });
                qryAbilityListPageRspBo.setPluginNameList(pluginNameList);
                QryAbilityDeployAllReqBO qryAbilityDeployReqBo = new QryAbilityDeployAllReqBO();
                qryAbilityDeployReqBo.setAbilityId(qryAbilityBo.getAbilityId());
                qryAbilityDeployReqBo.setWhole(Boolean.TRUE);
                AbilityPO abilityPo = new AbilityPO();
                abilityPo.setAbilityId(qryAbilityBo.getAbilityId());
                abilityPo.setOutputProtocal(qryAbilityBo.getOutputProtocal());
                abilityPo.setHirerId(qryAbilityBo.getHirerId());
                abilityPo.setAbilityEname(qryAbilityBo.getAbilityEname());
                abilityPo.setAbilityVersion(qryAbilityBo.getAbilityVersion());
                qryAbilityDeployReqBo.setAbilityPo(abilityPo);
                List<QryAbilityDeployNewRspBO> qryAbilityDeployRspBOList = this.abilityDeployService.deployScopeAll(qryAbilityDeployReqBo);
                LinkedList<Map<String, Object>> abilityDeployMap = new LinkedList<Map<String, Object>>();
                AtomicInteger abilityDeployNum = new AtomicInteger();
                qryAbilityDeployRspBOList.forEach(qryAbilityDeployRspBo -> {
                    LinkedHashMap<String, Object> abilityDeployClusterMap = new LinkedHashMap<String, Object>();
                    abilityDeployClusterMap.put("clusterId", qryAbilityDeployRspBo.getClusterId());
                    abilityDeployClusterMap.put("clusterFullName", qryAbilityDeployRspBo.getClusterFullName());
                    LinkedList data = new LinkedList();
                    qryAbilityDeployRspBo.getData().forEach(abilityDeployInfoData -> {
                        LinkedHashMap<String, String> infoData = new LinkedHashMap<String, String>();
                        infoData.put("regionName", abilityDeployInfoData.getBasicData().getRegionName());
                        infoData.put("type", abilityDeployInfoData.getBasicData().getType());
                        if ("Api".equals(abilityDeployInfoData.getBasicData().getType())) {
                            infoData.put("path", abilityDeployInfoData.getExtendData().getShareData().getEprPath());
                        } else if ("Kafka".equals(abilityDeployInfoData.getBasicData().getType())) {
                            infoData.put("path", abilityDeployInfoData.getBasicData().getKafkaConfigBo().getTopic());
                        } else if ("RocketMq".equals(abilityDeployInfoData.getBasicData().getType())) {
                            infoData.put("path", abilityDeployInfoData.getBasicData().getRocketMqConfigBo().getName());
                        } else {
                            infoData.put("path", "\u5730\u5740\u5f02\u5e38");
                        }
                        data.add(infoData);
                        abilityDeployNum.getAndIncrement();
                    });
                    abilityDeployClusterMap.put("data", data);
                    abilityDeployMap.add(abilityDeployClusterMap);
                });
                qryAbilityListPageRspBo.setAbilityDeployMap(abilityDeployMap);
                qryAbilityListPageRspBo.setAbilityDeployNum(String.valueOf(abilityDeployNum.get()));
                qryAbilityListPageRspBo.setForwardStatus(qryAbilityBo.getForwardStatus());
                qryAbilityListPageRspBo.setAttendStatus(qryAbilityBo.getAttendStatus());
                qryAbilityListPageRspBo.setProtocol(qryAbilityBo.getInputProtocal() + "=>" + qryAbilityBo.getOutputProtocal());
                qryAbilityListPageRspBo.setAllClusterName(qryAbilityBo.getAllClusterName());
                QryAbilityTypeReqBO qryAbilityTypeReqBo = new QryAbilityTypeReqBO();
                qryAbilityTypeReqBo.setAbilityId(qryAbilityBo.getAbilityId());
                qryAbilityTypeReqBo.setRequestType(0);
                qryAbilityTypeReqBo.setParamType(AbilityProtocalEnum.getEnumValue((String)qryAbilityBo.getInputProtocal()));
                qryAbilityTypeReqBo.setAbilityEname(qryAbilityBo.getAbilityEname());
                qryAbilityTypeReqBo.setAbilityVersion(qryAbilityBo.getAbilityVersion());
                qryAbilityTypeReqBo.setCenterAddr("");
                Map<String, String> abilityPathMap = this.abilityTestService.generateAbilityPath(qryAbilityTypeReqBo);
                qryAbilityListPageRspBo.setAbilityPath(abilityPathMap.get("simple"));
                qryAbilityListPageRspBo.setIsDraft(qryAbilityBo.getIsDraft());
                qryAbilityListPageRspBOList.add(qryAbilityListPageRspBo);
            }, this.executorService).exceptionally(e -> {
                log.info("\u80fd\u529b\u5217\u8868\u67e5\u8be2\u5f02\u5e38\uff01, ex:{}\uff01", (Object)e.getMessage());
                log.error(e.getMessage(), e);
                return null;
            });
            ((CompletableFuture)future).whenComplete((result, e) -> countDownLatch.countDown());
        });
        try {
            countDownLatch.await();
        }
        catch (Exception e) {
            log.info("\u80fd\u529b\u5217\u8868\u67e5\u8be2\u5f02\u5e38\uff01");
            log.error(e.getMessage(), (Throwable)e);
            return RspBO.error((String)"\u80fd\u529b\u5217\u8868\u67e5\u8be2\u5f02\u5e38!");
        }
        List<Object> qryAbilityListPageRspBoListRsp = new ArrayList(qryAbilityListPageRspBOList);
        qryAbilityListPageRspBoListRsp = qryAbilityListPageRspBoListRsp.stream().sorted(Comparator.comparing(QryAbilityListPageRspBO::getOrderNum)).collect(Collectors.toList());
        JSONObject data = new JSONObject();
        data.put("rows", qryAbilityListPageRspBoListRsp);
        data.put("recordsTotal", (Object)qryAbilityListRspBOListPage.getRecordsTotal());
        data.put("pageSize", (Object)qryAbilityListRspBOListPage.getPageSize());
        data.put("pageNo", (Object)qryAbilityListRspBOListPage.getPageNo());
        data.put("total", (Object)qryAbilityListRspBOListPage.getTotal());
        data.put("pageCout", (Object)qryAbilityListRspBOListPage.getPageCout());
        return RspBO.success((Object)data);
    }

    private String getAllClusterName(String clusterIds) {
        StringBuilder sb = new StringBuilder();
        List clusterPos = Arrays.stream(clusterIds.split(",")).map(clusterId -> this.clusterMapper.queryByClusterId(Long.parseLong(clusterId))).distinct().collect(Collectors.toList());
        for (int i = 0; i < clusterPos.size(); ++i) {
            ClusterPO clusterPO;
            if (i != 0) {
                sb.append(", ");
            }
            if (ObjectUtils.isEmpty((Object)(clusterPO = (ClusterPO)clusterPos.get(i)))) {
                sb.append("\u672a\u627e\u5230\u73af\u5883");
                continue;
            }
            sb.append(clusterPO.getClusterName());
        }
        return sb.toString();
    }
}

