/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.ability.service.postman.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.ohaotian.abilityadmin.ability.model.bo.postman.AbilityModel;
import com.ohaotian.abilityadmin.ability.model.bo.postman.PostmanItem;
import com.ohaotian.abilityadmin.ability.service.postman.GenerateSchemaService;
import com.ohaotian.abilityadmin.util.SchemaUtil;
import com.ohaotian.abilityadmin.util.XmlUtil;
import com.ohaotian.atp.base.util.GetFileContentUtil;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class GenerateSchemaFromRawServiceImpl
implements GenerateSchemaService<PostmanItem> {
    private static final Logger log = LoggerFactory.getLogger(GenerateSchemaFromRawServiceImpl.class);

    @Override
    public void invokGeenerateSchema(AbilityModel abilityModel, PostmanItem postmanItem) throws JsonProcessingException {
        String value = postmanItem.getRequest().getBody().getRaw().getValue();
        if (value != null) {
            if (value.startsWith("{")) {
                abilityModel.setReqJsonschema(SchemaUtil.json2Schema(value));
                abilityModel.setInputProtocal(Arrays.asList("json"));
                abilityModel.setOutputProtocal("json");
            } else if (value.startsWith("<")) {
                abilityModel.setReqJsonschema(SchemaUtil.json2Schema(XmlUtil.convertXmlToJson(value)));
                abilityModel.setInputProtocal(Arrays.asList("xml"));
                abilityModel.setOutputProtocal("xml");
            } else {
                abilityModel.setError("\u8bf7\u6c42\u7c7b\u578b\u6682\u4e0d\u652f\u6301\u89e3\u6790\uff1a" + value);
            }
        } else {
            abilityModel.setError("\u8bf7\u6c42\u62a5\u6587\u4e3a\u7a7a\u4e0d\u652f\u6301\u89e3\u6790");
        }
        ClassPathResource classPathResource = new ClassPathResource("schema/defaultResponse.json");
        String fileContent = GetFileContentUtil.getFileContent((Resource)classPathResource);
        abilityModel.setRspJsonschema(fileContent);
    }
}

