/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.app.controller;

import com.ohaotian.abilityadmin.app.model.bo.AppRegionRepBO;
import com.ohaotian.abilityadmin.app.model.bo.RegionAddrReqBO;
import com.ohaotian.abilityadmin.app.service.AppRegionService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.portalcommon.api.RegionAPI;
import com.ohaotian.portalcommon.model.RegionBO;
import com.ohaotian.portalcommon.model.RegionFirstAddrBo;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.util.ValidBatchUtils;
import javax.annotation.Resource;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/appRegion"})
public class AppRegionController {
    @Resource
    AppRegionService appRegionService;
    @Resource
    private RegionAPI regionApi;

    @RequestMapping(value={"/qryAppRegionList"})
    @BusiResponseBody
    public RspBO qryAppRegionList(@RequestBody AppRegionRepBO appRegionRepBO) {
        ValidBatchUtils.isNotEmpty((Object)appRegionRepBO, (String[])new String[]{"appId"});
        return this.appRegionService.qryAppRegionList(appRegionRepBO);
    }

    @RequestMapping(value={"/qryAllRegionByAppId"})
    @BusiResponseBody
    public RspBO qryAllRegionByAppId(@RequestBody AppRegionRepBO appRegionRepBO) {
        ValidBatchUtils.isNotEmpty((Object)appRegionRepBO, (String[])new String[]{"appId"});
        return this.appRegionService.qryAllRegionByAppId(appRegionRepBO.getAppId());
    }

    @RequestMapping(value={"/signAppRegion"})
    @BusiResponseBody
    public RspBO signAppRegion(@RequestBody AppRegionRepBO appRegionRepBO) {
        ValidBatchUtils.isNotEmpty((Object)appRegionRepBO, (String[])new String[]{"regionIds", "attendStatus"});
        return this.appRegionService.signAppRegion(appRegionRepBO);
    }

    @RequestMapping(value={"/deleteAppRegion"})
    @BusiResponseBody
    public RspBO deleteAppRegion(@RequestBody AppRegionRepBO appRegionRepBO) {
        ValidBatchUtils.isNotEmpty((Object)appRegionRepBO, (String[])new String[]{"regionIds"});
        return this.appRegionService.deleteAppRegion(appRegionRepBO);
    }

    @RequestMapping(value={"/addAppRegion"})
    @BusiResponseBody
    public RspBO addAppRegion(@ModelAttribute AppRegionRepBO appRegionRepBO) {
        return this.appRegionService.addAppRegion(appRegionRepBO);
    }

    @RequestMapping(value={"/qryRegionInfo"})
    @BusiResponseBody
    public RspBO qryRegionInfo(@RequestBody AppRegionRepBO appRegionRepBO) {
        ValidBatchUtils.isNotEmpty((Object)appRegionRepBO, (String[])new String[]{"regionId"});
        return this.appRegionService.qryRegionInfo(appRegionRepBO);
    }

    @RequestMapping(value={"/updateRegion"})
    @BusiResponseBody
    public RspBO updateRegion(@ModelAttribute AppRegionRepBO appRegionRepBO) {
        return this.appRegionService.updateRegion(appRegionRepBO);
    }

    @RequestMapping(value={"/qryRegionAddr"})
    @BusiResponseBody
    public RspBO qryRegionAddr(@RequestBody RegionAddrReqBO regionAddrReqBO) {
        return this.appRegionService.qryRegionAddr(regionAddrReqBO);
    }

    @RequestMapping(value={"/deleteRegionAddr"})
    @BusiResponseBody
    public RspBO deleteRegionAddr(@RequestBody RegionAddrReqBO regionAddrReqBO) {
        ValidBatchUtils.isNotEmpty((Object)regionAddrReqBO, (String[])new String[]{"regionAddrIds"});
        return this.appRegionService.deleteRegionAddr(regionAddrReqBO);
    }

    @RequestMapping(value={"/signRegionAddr"})
    @BusiResponseBody
    public RspBO signRegionAddr(@RequestBody RegionAddrReqBO regionAddrReqBO) {
        ValidBatchUtils.isNotEmpty((Object)regionAddrReqBO, (String[])new String[]{"regionAddrIds", "attendStatus"});
        return this.appRegionService.signRegionAddr(regionAddrReqBO);
    }

    @RequestMapping(value={"/addRegionAddr"})
    @BusiResponseBody
    public RspBO addRegionAddr(@RequestBody RegionAddrReqBO regionAddrReqBO) {
        ValidBatchUtils.isNotEmpty((Object)regionAddrReqBO, (String[])new String[]{"regionId", "capacity", "ip"});
        return this.appRegionService.addRegionAddr(regionAddrReqBO);
    }

    @RequestMapping(value={"/qryRegionAddrInfo"})
    @BusiResponseBody
    public RspBO qryRegionAddrInfo(@RequestBody RegionAddrReqBO regionAddrReqBO) {
        ValidBatchUtils.isNotEmpty((Object)regionAddrReqBO, (String[])new String[]{"regionAddrId"});
        return this.appRegionService.qryRegionAddrInfo(regionAddrReqBO);
    }

    @RequestMapping(value={"/updateRegionAddr"})
    @BusiResponseBody
    public RspBO updateRegionAddr(@RequestBody RegionAddrReqBO regionAddrReqBO) {
        ValidBatchUtils.isNotEmpty((Object)regionAddrReqBO, (String[])new String[]{"regionAddrId", "attendStatus", "addrType", "capacity", "ip"});
        return this.appRegionService.updateRegionAddr(regionAddrReqBO);
    }

    @RequestMapping(value={"/qryCenterAddr"})
    @BusiResponseBody
    public RspBO qryCenterAddr(@RequestBody AppRegionRepBO appRegionRepBO) {
        ValidBatchUtils.isNotEmpty((Object)appRegionRepBO, (String[])new String[]{"protocol"});
        return this.appRegionService.qryCenterAddr(appRegionRepBO.getProtocol());
    }

    @RequestMapping(value={"/qryRegionPath"})
    @BusiResponseBody
    public RspBO<String> qryRegionPath(@RequestBody AppRegionRepBO appRegionRepBO) {
        ValidBatchUtils.isNotEmpty((Object)appRegionRepBO, (String[])new String[]{"regionCode", "appId"});
        RegionBO regionBO = this.regionApi.queryRegionByAppIdAndRegionCode(appRegionRepBO.getAppId(), appRegionRepBO.getRegionCode());
        RegionFirstAddrBo regionFirstAddrBo = this.regionApi.queryRegionFirstAddrByRegionCode(appRegionRepBO.getRegionCode());
        StringBuilder stringBuilder = new StringBuilder();
        if (regionBO.getCallProtocol() != 0) {
            stringBuilder.append("https://");
        } else {
            stringBuilder.append("http://");
        }
        if (!ObjectUtils.isEmpty((Object)regionFirstAddrBo)) {
            stringBuilder.append(regionFirstAddrBo.getIp());
            if (!ObjectUtils.isEmpty((Object)regionFirstAddrBo.getPort())) {
                stringBuilder.append(":");
                stringBuilder.append(regionFirstAddrBo.getPort());
            }
        } else {
            stringBuilder.append("\u672a\u914d\u7f6e\u53ef\u7528\u5730\u5740");
        }
        return RspBO.success((Object)stringBuilder.toString());
    }
}

