/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.config.pool;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;

@EnableAsync
@Configuration
public class MqToolThreadPollManager {
    private static final Logger log = LoggerFactory.getLogger(MqToolThreadPollManager.class);
    public static final int PROCESSORS = Runtime.getRuntime().availableProcessors();
    @Value(value="${mq.consumer.executor.corePoolSize:50}")
    private int corePoolSize;
    @Value(value="${mq.consumer.executor.maximumPoolSize:100}")
    private int maximumPoolSize;
    @Value(value="${mq.consumer.executor.keepAliveTime:5}")
    private long keepAliveTime;
    @Value(value="${mq.consumer.executor.queueCapacity:1000}")
    private int queueCapacity;
    @Value(value="${mq.delay.executor.corePoolSize:50}")
    private int delayCorePoolSize;
    @Value(value="${mq.delay.executor.maximumPoolSize:100}")
    private int delayMaximumPoolSize;
    @Value(value="${mq.delay.executor.keepAliveTime:5}")
    private long delayKeepAliveTime;
    @Value(value="${mq.delay.executor.queueCapacity:1000}")
    private int delayQueueCapacity;

    @Bean(value={"mqConsumerExecutorService"})
    public ExecutorService mqConsumerExecutorService() {
        log.info("initialization mqConsumerExecutorService");
        return new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.keepAliveTime, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(this.queueCapacity), new ThreadFactory(){
            final AtomicInteger sn = new AtomicInteger();

            @Override
            public Thread newThread(Runnable runnable) {
                Thread t = new Thread(runnable);
                t.setName("MQ_CONSUMER_THREAD-NO_" + this.sn.incrementAndGet());
                return t;
            }
        });
    }

    @Bean(value={"mqDelayExecutorService"})
    public ExecutorService mqDelayExecutorService() {
        log.info("initialization mqDelayExecutorService");
        return new ThreadPoolExecutor(this.delayCorePoolSize, this.delayMaximumPoolSize, this.delayKeepAliveTime, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(this.delayQueueCapacity), new ThreadFactory(){
            final AtomicInteger sn = new AtomicInteger();

            @Override
            public Thread newThread(Runnable runnable) {
                Thread t = new Thread(runnable);
                t.setName("MQ_DELAY_THREAD-NO_" + this.sn.incrementAndGet());
                return t;
            }
        });
    }
}

