/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.platform.service.impl;

import com.ohaotian.abilityadmin.mapper.AbilityExtDefaultMapper;
import com.ohaotian.abilityadmin.mapper.AbilityMapper;
import com.ohaotian.abilityadmin.model.po.AbilityExtDefaultPO;
import com.ohaotian.abilityadmin.model.po.AbilityPO;
import com.ohaotian.abilityadmin.platform.model.bo.InquryInformationBO;
import com.ohaotian.abilityadmin.platform.model.bo.TestProcessBo;
import com.ohaotian.abilityadmin.platform.service.PlatformAbilityTestService;
import com.ohaotian.plugin.util.HpartyCheckHttpUtil;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.util.GsonUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import scala.collection.mutable.StringBuilder;

@Service
public class PlatformAbilityTestServiceImpl
implements PlatformAbilityTestService {
    private static final Logger log = LoggerFactory.getLogger(PlatformAbilityTestServiceImpl.class);
    @Autowired
    AbilityMapper abilityMapper;
    @Autowired
    AbilityExtDefaultMapper abilityExtDefaultMapper;
    private static int CONNECT_TIMEOUT = 35000;
    private static int SOCKET_TIMEOUT = 600000;

    @Override
    public RspBO testProcess(TestProcessBo testProcessBo) {
        LinkedHashMap result = new LinkedHashMap();
        ApplicationHome applicationHome = new ApplicationHome(this.getClass());
        String rootPath = applicationHome.getSource().getParentFile().toString();
        String pingPath = rootPath + "/ping.txt";
        String pingShell = "ping -R  -c  10 " + testProcessBo.getHost() + " > " + pingPath;
        PlatformAbilityTestServiceImpl.callShell(pingShell);
        LinkedHashMap<String, String> pingResultMap = new LinkedHashMap<String, String>();
        pingResultMap.put("\u6307\u4ee4", pingShell);
        try (Stream<String> pingData = Files.lines(Paths.get(pingPath, new String[0]));){
            StringBuilder data = new StringBuilder();
            pingData.forEachOrdered(s -> data.append(s).append(System.getProperty("line.separator")));
            pingResultMap.put("PING\u7ed3\u679c", data.toString());
        }
        catch (IOException e) {
            pingResultMap.put("PING\u7ed3\u679c", "\u6587\u4ef6\u8bfb\u53d6\u5f02\u5e38\uff0c" + e.getMessage());
        }
        result.put("ping", pingResultMap);
        LinkedHashMap<String, String> tcpdumpResultMap = new LinkedHashMap<String, String>();
        String tcpdumpPath = rootPath + "/tcpdump.txt";
        PlatformAbilityTestServiceImpl.callShell(" which tcpdump > " + tcpdumpPath);
        String tcpdump = "";
        try (Stream<String> tcpdumpData = Files.lines(Paths.get(tcpdumpPath, new String[0]));){
            StringBuilder data = new StringBuilder();
            tcpdumpData.forEachOrdered(s -> data.append(s).append(System.getProperty("line.separator")));
            tcpdump = data.toString().trim();
            if (StringUtils.isBlank((CharSequence)tcpdump)) {
                String install = "yum install -y tcpdump";
                PlatformAbilityTestServiceImpl.callShell(install);
                tcpdumpResultMap.put("\u5b89\u88c5", install);
            } else {
                tcpdumpResultMap.put("\u67e5\u627e", tcpdump);
            }
        }
        catch (IOException e) {
            tcpdumpResultMap.put("\u67e5\u627e\u5931\u8d25", e.getMessage());
        }
        if (StringUtils.isBlank((CharSequence)tcpdump)) {
            log.warn("tcpdump \u8def\u5f84\u83b7\u53d6\u5f02\u5e38,\u9ed8\u8ba4\u586b\u5145\u4e3atcpdump \uff01 ");
            tcpdump = "/usr/sbin/tcpdump";
        }
        String tcpdumpNohup = tcpdump + " -vv -i any tcp port " + testProcessBo.getPort() + " and host  " + testProcessBo.getHost();
        PlatformAbilityTestServiceImpl.callShell("nohup " + tcpdumpNohup + " > " + tcpdumpPath + " 2>&1 &");
        String url = testProcessBo.getProtocol() + "://" + testProcessBo.getHost() + ":" + testProcessBo.getPort() + testProcessBo.getPath();
        log.info("\u5730\u5740\uff1a{}", (Object)url);
        log.info("\u8bf7\u6c42\u5934\uff1a{}", testProcessBo.getHeaders());
        StringBuilder responseBody = new StringBuilder();
        try {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(CONNECT_TIMEOUT).setConnectionRequestTimeout(testProcessBo.getOverTimeout().intValue()).setSocketTimeout(SOCKET_TIMEOUT).build();
            if ("GET".equals(testProcessBo.getMethod())) {
                HpartyCheckHttpUtil.doGet((String)url.trim(), (status, rsp) -> {
                    responseBody.append(rsp);
                    return status;
                }, testProcessBo.getHeaders(), (RequestConfig)requestConfig);
            } else if ("POST".equals(testProcessBo.getMethod())) {
                HpartyCheckHttpUtil.doPostJson((String)url.trim(), (String)GsonUtil.toJson((Object)"{}"), (status, rsp) -> {
                    responseBody.append(rsp);
                    return status;
                }, testProcessBo.getHeaders(), (RequestConfig)requestConfig);
            }
        }
        catch (Exception e) {
            responseBody.append("\u8c03\u7528\u5f02\u5e38:").append(e.getMessage());
        }
        LinkedHashMap<String, Object> httpResultMap = new LinkedHashMap<String, Object>();
        httpResultMap.put("\u5730\u5740", url);
        httpResultMap.put("\u8bf7\u6c42\u5934", testProcessBo.getHeaders());
        httpResultMap.put("\u8c03\u7528\u7ed3\u679c", responseBody);
        result.put("http", httpResultMap);
        PlatformAbilityTestServiceImpl.callShell("kill -9 `ps -ef|grep -v grep|grep " + tcpdumpNohup + " | awk '{print $2}'`");
        tcpdumpResultMap.put("\u6307\u4ee4", tcpdumpNohup);
        try (Stream<String> tcpdumpData = Files.lines(Paths.get(tcpdumpPath, new String[0]));){
            StringBuilder data = new StringBuilder();
            tcpdumpData.forEachOrdered(s -> data.append(s).append(System.getProperty("line.separator")));
            tcpdumpResultMap.put("TCPDUMP\u7ed3\u679c", data.toString());
        }
        catch (IOException e) {
            tcpdumpResultMap.put("TCPDUMP\u7ed3\u679c", e.getMessage());
        }
        result.put("tcpdump", tcpdumpResultMap);
        return RspBO.success(result);
    }

    @Override
    public RspBO qryInformation(InquryInformationBO inquryInformationBO) {
        AbilityPO abilityPo = new AbilityPO();
        abilityPo.setAbilityId(inquryInformationBO.getAbilityId());
        AbilityPO abilityPos = this.abilityMapper.queryLimitOne(abilityPo);
        TestProcessBo testProcessBo = new TestProcessBo();
        testProcessBo.setMethod(abilityPos.getOutputTransProtocal());
        AbilityExtDefaultPO abilityExtDefaultPo = new AbilityExtDefaultPO();
        abilityExtDefaultPo.setAbilityId(inquryInformationBO.getAbilityId());
        AbilityExtDefaultPO abilityExtDefaultPos = this.abilityExtDefaultMapper.queryLimitOne(abilityExtDefaultPo);
        testProcessBo.setOverTimeout(abilityExtDefaultPos.getOvertime());
        String protocol2 = StringUtils.substringBefore((String)inquryInformationBO.getEprPath(), (String)":");
        testProcessBo.setProtocol(protocol2);
        String parts = StringUtils.substringAfter((String)inquryInformationBO.getEprPath(), (String)"//");
        String start = StringUtils.substringBefore((String)parts, (String)"/");
        String port = StringUtils.substringAfter((String)start, (String)":");
        if (!ObjectUtils.isEmpty((Object)port)) {
            testProcessBo.setPort(port);
            testProcessBo.setHost(StringUtils.substringBefore((String)start, (String)":"));
        } else {
            testProcessBo.setHost(start);
            if (testProcessBo.getProtocol().equals("http")) {
                testProcessBo.setPort("80");
            } else {
                testProcessBo.setPort("443");
            }
        }
        String end = StringUtils.substringAfter((String)parts, (String)"/");
        testProcessBo.setPath("/" + end);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Content-Type", "application/json;charset=UTF-8");
        testProcessBo.setHeaders(map);
        RspBO rspBo = this.testProcess(testProcessBo);
        return RspBO.success((Object)rspBo);
    }

    public static void callShell(String shellString) {
        log.info("linux exec\uff1a{}", (Object)shellString);
        String[] command = new String[]{"/bin/sh", "-c", shellString};
        try {
            Process process = Runtime.getRuntime().exec(command);
            int exitValue = process.waitFor();
            BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader error = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            if (0 != exitValue) {
                log.error("call shell failed. error code is : {}, description is : {}.", (Object)exitValue, (Object)error.readLine());
            } else {
                log.info("call shell successes. status code is : {}, description is : {}.", (Object)exitValue, (Object)input.readLine());
            }
            error.close();
            input.close();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }
}

