/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.plugin.controller;

import com.ohaotian.abilityadmin.plugin.model.bo.ModPluginReqBO;
import com.ohaotian.abilityadmin.plugin.model.bo.PluginAddReqBO;
import com.ohaotian.abilityadmin.plugin.model.bo.PluginExInfoReqBO;
import com.ohaotian.abilityadmin.plugin.model.bo.PluginListReqBO;
import com.ohaotian.abilityadmin.plugin.service.PluginAdminService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.portalcommon.enums.ExtensionPointPositionEnum;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.service.PluginService;
import com.ohaotian.portalcommon.util.ValidBatchUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/plugin"})
public class PluginController {
    private static Logger logger = LogManager.getLogger(PluginController.class);
    @Resource
    private PluginAdminService pluginAdminService;
    @Resource
    PluginService pluginService;

    @RequestMapping(value={"/list"})
    @BusiResponseBody
    public RspBO qryPluginListPage(@RequestBody PluginListReqBO pluginListReqBO) {
        return this.pluginAdminService.qryPluginListPageByCond(pluginListReqBO);
    }

    @RequestMapping(value={"/modPluginInfo"})
    @BusiResponseBody
    public RspBO modPluginInfo(@RequestBody ModPluginReqBO modPluginReqBO) {
        return this.pluginAdminService.updatePluginByPluginId(modPluginReqBO);
    }

    @RequestMapping(value={"/extInfo"})
    @BusiResponseBody
    public RspBO qryPluginExtInfo(@RequestBody PluginExInfoReqBO pluginExInfoReqBOS) {
        return this.pluginService.handleGetInfo(pluginExInfoReqBOS.getPluginType(), ExtensionPointPositionEnum.PLUGIN_POSITION.getCode());
    }

    @RequestMapping(value={"/addPlugin"})
    @BusiResponseBody
    @Transactional
    public RspBO addPlugin(@RequestBody PluginAddReqBO pluginAddReqBO) {
        logger.debug("\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}", (Object)pluginAddReqBO);
        ValidBatchUtils.isNotEmpty((Object)pluginAddReqBO, (String[])new String[]{"pluginType", "pluginName", "pluginEname"});
        return this.pluginAdminService.addPlugin(pluginAddReqBO);
    }

    @RequestMapping(value={"/deletePlugin"})
    @BusiResponseBody
    public RspBO deletePlugin(@RequestBody ModPluginReqBO modPluginReqBO) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        logger.debug("\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}", (Object)modPluginReqBO);
        ValidBatchUtils.isNotEmpty((Object)modPluginReqBO, (String[])new String[]{"pluginIds"});
        List<Long> pluginIds = modPluginReqBO.getPluginIds();
        if (pluginIds.size() < 1) {
            return RspBO.success(null);
        }
        this.pluginAdminService.deletePluginByIds(pluginIds);
        return RspBO.success(null);
    }
}

