/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.plugin.controller.jdvop;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.ConnectionBackoffStrategy;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.DefaultBackoffStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@Scope(value="singleton")
public class HttpClientService {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientService.class);
    private PoolingHttpClientConnectionManager httpClientConnectionManager = null;
    private HttpClient HTTP_CLIENT = null;
    @Value(value="${httpclient.connect.maxTotal:25600}")
    private int maxTotal;
    @Value(value="${httpclient.connect.maxPerRoute:5}")
    private int maxPerRoute;
    @Value(value="${httpclient.connect.timeout:30000}")
    private int connectTimeout;
    @Value(value="${httpclient.httpIdleTimeSec:60}")
    private int httpIdleTimeSec;
    @Value(value="${httpclient.retryCount:3}")
    private int retryCount;
    @Value(value="${httpclient.maxHttpResponseMb:0.5}")
    private double maxHttpResponseMb;

    @PostConstruct
    public void postConstruct() throws Throwable {
        PlainConnectionSocketFactory plainConnectionSocketFactory = new PlainConnectionSocketFactory(){

            public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
                context.setAttribute("remoteAddress", (Object)remoteAddress);
                return super.connectSocket(connectTimeout, socket, host, remoteAddress, localAddress, context);
            }
        };
        TrustStrategy acceptingTrustStrategy = (cert, authType) -> true;
        SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)acceptingTrustStrategy).build();
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        this.httpClientConnectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)plainConnectionSocketFactory).register("https", (Object)sslConnectionSocketFactory).build(), (DnsResolver)SystemDefaultDnsResolver.INSTANCE);
        this.httpClientConnectionManager.setMaxTotal(this.maxTotal);
        this.httpClientConnectionManager.setDefaultMaxPerRoute(this.maxPerRoute);
        this.httpClientConnectionManager.setDefaultConnectionConfig(ConnectionConfig.custom().setCharset(StandardCharsets.UTF_8).build());
    }

    @Bean(value={"httpClientConnectionManager"})
    public HttpClientConnectionManager getHttpClientConnectionManager() {
        return this.httpClientConnectionManager;
    }

    @Bean(value={"httpClient"})
    public HttpClient getHttpClientBuilder() throws Throwable {
        this.HTTP_CLIENT = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)this.httpClientConnectionManager).setRetryHandler((exception, executionCount, context) -> {
            if (executionCount >= this.retryCount) {
                return false;
            }
            return exception instanceof NoHttpResponseException;
        }).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(this.connectTimeout).setConnectionRequestTimeout(this.connectTimeout).setSocketTimeout(this.connectTimeout).setCookieSpec("standard-strict").build()).setConnectionManagerShared(false).setConnectionBackoffStrategy((ConnectionBackoffStrategy)new DefaultBackoffStrategy()).build();
        return this.HTTP_CLIENT;
    }

    @Scheduled(fixedDelay=10000L, initialDelay=120000L)
    public void autoCloseConnectionsSchedule() {
        try {
            this.httpClientConnectionManager.closeExpiredConnections();
            this.httpClientConnectionManager.closeIdleConnections((long)this.httpIdleTimeSec, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public String getContentByEntity(@NotNull HttpEntity httpEntity) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String httpPost(HttpPost httpPost) {
        HttpResponse executeResponse = null;
        try {
            executeResponse = this.HTTP_CLIENT.execute((HttpUriRequest)httpPost, (HttpContext)HttpClientContext.create());
            String string = this.getContentByEntity(executeResponse.getEntity());
            return string;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            if (executeResponse != null) {
                EntityUtils.consumeQuietly((HttpEntity)executeResponse.getEntity());
            }
        }
    }

    public String httpGet(HttpGet httpGet) {
        HttpResponse executeResponse = null;
        try {
            executeResponse = this.HTTP_CLIENT.execute((HttpUriRequest)httpGet, (HttpContext)HttpClientContext.create());
            String string = this.getContentByEntity(executeResponse.getEntity());
            return string;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            if (executeResponse != null) {
                EntityUtils.consumeQuietly((HttpEntity)executeResponse.getEntity());
            }
        }
    }
}

