/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.pushClient.abilityMqBase.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.abilityadmin.ability.model.bo.QryAbilityParameterTemplateReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.QryAbilityTypeReqBO;
import com.ohaotian.abilityadmin.ability.service.AbilityParameterService;
import com.ohaotian.abilityadmin.ability.service.AbilityTestService;
import com.ohaotian.abilityadmin.mapper.AbilityProvideMqCacheDataMapper;
import com.ohaotian.abilityadmin.model.po.AbilityProvideMqCacheDataPo;
import com.ohaotian.abilityadmin.pushClient.abilityMqBase.AbilityMqBaseService;
import com.ohaotian.abilityadmin.util.TimeCalculateUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.util.HpartyCheckHttpUtil;
import com.ohaotian.portalcommon.model.bo.OptionGenerRspBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.util.ExecutorProcessPool;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class AbilityMqBaseServiceImpl
implements AbilityMqBaseService {
    private static final Logger log = LoggerFactory.getLogger(AbilityMqBaseServiceImpl.class);
    @Autowired
    private AbilityParameterService abilityParameterService;
    @Autowired
    private AbilityProvideMqCacheDataMapper abilityProvideMqCacheDataMapper;
    @Autowired
    private AbilityTestService abilityTestService;

    @Override
    public String getAbilityPath(Long abilityId) {
        QryAbilityParameterTemplateReqBO qryAbilityParameterTemplateReqBO = new QryAbilityParameterTemplateReqBO();
        qryAbilityParameterTemplateReqBO.setAbilityId(abilityId);
        QryAbilityTypeReqBO qryAbilityTypeReqBO = new QryAbilityTypeReqBO();
        List<OptionGenerRspBO<String, Integer>> optionGenerRspBos = this.abilityParameterService.paramType(qryAbilityParameterTemplateReqBO);
        if (!ObjectUtils.isEmpty(optionGenerRspBos)) {
            qryAbilityTypeReqBO.setAbilityId(abilityId);
            qryAbilityTypeReqBO.setParamType((Integer)optionGenerRspBos.get(0).getValue());
            qryAbilityTypeReqBO.setRequestType(0);
            Map<String, String> map = this.abilityTestService.generatePath(qryAbilityTypeReqBO);
            return map.get("path");
        }
        throw new ZTBusinessException("\u6839\u636e\u8be5\u80fd\u529bid\u6ca1\u6709\u83b7\u53d6\u5230\u6b63\u5e38\u8c03\u7528\u7684\u5730\u5740\u4fe1\u606f!");
    }

    @Override
    public void pushDataThread(Long mqDataId, String abilityPath, String value) {
        Runnable runPush = () -> this.pushData(mqDataId, abilityPath, value);
        ExecutorProcessPool.getInstance().executeByCustomThread(runPush);
    }

    @Override
    public void pushDataWait(Long mqDataId, String abilityPath, String value) {
        this.pushData(mqDataId, abilityPath, value);
    }

    private void pushData(Long mqDataId, String abilityPath, String value) {
        String time1 = TimeCalculateUtils.getNowTime();
        String success = "success";
        String code = "code";
        String zero = "0";
        AbilityProvideMqCacheDataPo failMqCacheDataPo = new AbilityProvideMqCacheDataPo();
        failMqCacheDataPo.setMqDataId(mqDataId);
        failMqCacheDataPo.setUpdateTime(new Date());
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json;charset=UTF-8");
            log.info("MQ_DATA_ID: {} ,\u63a8\u9001\u6570\u636e\u5730\u5740: {}", (Object)mqDataId, (Object)abilityPath);
            HpartyCheckHttpUtil.doPostJson((String)abilityPath, (String)value, (status, map) -> {
                failMqCacheDataPo.setRemake(map.getBytes(StandardCharsets.UTF_8));
                if (status.intValue() != HttpStatus.OK.value()) {
                    failMqCacheDataPo.setStatus(0);
                    this.abilityProvideMqCacheDataMapper.updateByPrimaryKeySelective(failMqCacheDataPo);
                    return RspBO.error((String)map);
                }
                JSONObject rsp = JSON.parseObject((String)map);
                if (rsp.get((Object)"success") != null && Boolean.TRUE.equals(rsp.get((Object)"success")) || rsp.get((Object)"code") != null && "0".equals(rsp.get((Object)"code").toString())) {
                    failMqCacheDataPo.setStatus(1);
                } else {
                    failMqCacheDataPo.setStatus(0);
                }
                this.abilityProvideMqCacheDataMapper.updateByPrimaryKeySelective(failMqCacheDataPo);
                return RspBO.success((Object)map);
            }, headers);
        }
        catch (Exception e) {
            failMqCacheDataPo.setStatus(0);
            if (ObjectUtils.isEmpty((Object)e.getMessage())) {
                failMqCacheDataPo.setRemake("Exception null!".getBytes(StandardCharsets.UTF_8));
            } else {
                failMqCacheDataPo.setRemake(e.getMessage().getBytes(StandardCharsets.UTF_8));
            }
            this.abilityProvideMqCacheDataMapper.updateByPrimaryKeySelective(failMqCacheDataPo);
            throw new RuntimeException(e);
        }
    }
}

