/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ohaotian.abilityadmin.app.model.bo.AppReqBO;
import com.ohaotian.abilityadmin.app.model.bo.AppSubscribeDeployBO;
import com.ohaotian.abilityadmin.app.model.bo.QryAppSubscribeReqBO;
import com.ohaotian.abilityadmin.app.model.bo.QryAppSubscribeRspBO;
import com.ohaotian.abilityadmin.app.service.AppService;
import com.ohaotian.abilityadmin.app.service.AppSubscribeService;
import com.ohaotian.abilityadmin.mapper.AppMapper;
import com.ohaotian.abilityadmin.mapper.AppSecretMapper;
import com.ohaotian.abilityadmin.model.po.AppPO;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.portalcommon.api.AppAPI;
import com.ohaotian.portalcommon.model.AppBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.page.RspPage;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class AppAPIImpl
implements AppAPI {
    @Resource
    AppMapper appMapper;
    @Resource
    AppSecretMapper appSecretMapper;
    @Resource
    private AppService appService;
    @Resource
    private AppSubscribeService appSubscribeService;

    public List<AppBO> queryAppByAppNameAndAppCode(String appName, String appCode, Long hirerId) {
        List<AppPO> appPOList = this.appMapper.queryAppByAppNameAndAppCode(appName, appCode, hirerId);
        return BeanMapper.mapList(appPOList, AppBO.class);
    }

    public AppBO queryAppByAppId(Long appId) {
        AppPO appPO = this.appMapper.queryByAppId(appId);
        return (AppBO)BeanMapper.map((Object)appPO, AppBO.class);
    }

    public AppBO queryAppByRegionCode(Long tenantId, String regionCode) {
        List<AppPO> appPOList = this.appMapper.queryAppByTenantIdRegionCode(tenantId, regionCode);
        return (AppBO)BeanMapper.map((Object)appPOList.get(0), AppBO.class);
    }

    public AppBO queryAppByAppCode(Long tenantId, String appCode) {
        AppPO entity = new AppPO();
        entity.setAppCode(appCode);
        entity.setHirerId(tenantId);
        AppPO appPo = this.appMapper.queryLimitOne(entity);
        if (ObjectUtils.isEmpty((Object)appPo)) {
            return null;
        }
        return (AppBO)BeanMapper.map((Object)appPo, AppBO.class);
    }

    public RspBO<Boolean> appRegiste(Object obj) throws ZTBusinessException {
        AppReqBO appRegisteReqBO = (AppReqBO)JSON.parseObject((String)JSON.toJSONString((Object)obj), AppReqBO.class);
        return this.appService.appRegiste(appRegisteReqBO);
    }

    public RspBO<Boolean> checkAppCode(Long aLong, String s) throws ZTBusinessException {
        return this.appService.checkAppCode(aLong, s);
    }

    public List<JSONObject> qryAppSubscribeListPageByCond(JSONObject obj) throws ZTBusinessException {
        QryAppSubscribeReqBO qryAppSubscribeReqBO = (QryAppSubscribeReqBO)JSON.parseObject((String)JSON.toJSONString((Object)obj), QryAppSubscribeReqBO.class);
        RspBO<RspPage<QryAppSubscribeRspBO>> rsp = this.appSubscribeService.qryAppSubscribeListPageByCond(qryAppSubscribeReqBO);
        return JSON.parseArray((String)JSON.toJSONString((Object)((RspPage)rsp.getData()).getRows()), JSONObject.class);
    }

    public RspBO<Boolean> deleteAppSubscribe(List<JSONObject> list) throws ZTBusinessException {
        List appSubscribeDeployBOList = (List)JSON.parseObject((String)JSON.toJSONString(list), (TypeReference)new TypeReference<List<AppSubscribeDeployBO>>(){}, (Feature[])new Feature[0]);
        return this.appSubscribeService.deleteAppSubscribe(appSubscribeDeployBOList);
    }

    public RspBO<Boolean> updateAttendIn(List<Long> list) throws ZTBusinessException {
        return this.appService.updateAttendIn(list);
    }

    public RspBO<Boolean> updateAttendOut(List<Long> list) throws ZTBusinessException {
        return this.appService.updateAttendOut(list);
    }

    public RspBO<Boolean> deleteApp(Long aLong) throws ZTBusinessException {
        return this.appService.deleteApp(aLong);
    }
}

