/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.plugin.controller.jdvop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ohaotian.abilityadmin.plugin.controller.jdvop.HttpClientService;
import com.ohaotian.abilityadmin.plugin.controller.jdvop.RsaCoderUtils;
import com.ohaotian.abilityadmin.plugin.model.bo.RefreshTokenReqBo;
import com.ohaotian.plugin.model.bo.rsp.RefreshTokenRspBO;
import com.ohaotian.portalcommon.util.DateUtil;
import java.net.URLEncoder;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.client.methods.HttpGet;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jd/vopSdk"})
public class GetAccessTokenController {
    public static final String UTF_8 = "utf-8";
    @Value(value="${jdvop.sdk.tokenUri:}")
    private String tokenUri;
    private static String appKey;
    @Value(value="${jdvop.sdk.appSecret:}")
    private String appSecret;
    @Value(value="${jdvop.sdk.redirectUri:http://127.0.0.1:8080/jd/vopSdk/noauth/callbackToken}")
    private String redirectUri;
    @Value(value="${jdvop.sdk.privateRsaKey:}")
    private String privateRsaKey;
    private static final TypeReference<Map<String, Object>> MAP_TYPE;
    @Resource
    private HttpClientService httpClientService;

    @PostMapping(value={"/noauth/getAccessToken"})
    public RefreshTokenRspBO getAccessToken(@RequestBody RefreshTokenReqBo refreshTokenReqBo) throws Throwable {
        appKey = refreshTokenReqBo.getClientId();
        String encodeRedirectUri = URLEncoder.encode(this.redirectUri, UTF_8);
        String encodeUsername = URLEncoder.encode(refreshTokenReqBo.getUserName(), UTF_8);
        String md5Password = DigestUtils.md5Hex((String)refreshTokenReqBo.getUserPassword());
        String ciphertextPassword = RsaCoderUtils.encryptByPrivateKey(md5Password, this.privateRsaKey);
        String encodePassword = URLEncoder.encode(ciphertextPassword, UTF_8);
        String getCodeUrl = this.tokenUri + "/oauth2/authorizeForVOP?app_key=" + appKey + "&redirect_uri=" + encodeRedirectUri + "&username=" + encodeUsername + "&password=" + encodePassword + "&response_type=code&scope=snsapi_base";
        HttpGet httpGet = new HttpGet(getCodeUrl);
        String tokenResp = this.httpClientService.httpGet(httpGet);
        JSONObject respJson = JSON.parseObject((String)tokenResp);
        RefreshTokenRspBO rspBO = new RefreshTokenRspBO();
        rspBO.setSuccess(Boolean.TRUE.booleanValue());
        rspBO.setResultCode("0000");
        rspBO.setResultMessage("true");
        RefreshTokenRspBO.TokenRspBO result = new RefreshTokenRspBO.TokenRspBO();
        result.setExpires_in(Long.valueOf(86400L));
        result.setAccess_token(respJson.getString("access_token"));
        result.setRefresh_token(respJson.getString("refresh_token"));
        result.setTime(DateUtil.getCurrentDateTime());
        rspBO.setResult(result);
        return rspBO;
    }

    @GetMapping(value={"/noauth/callbackToken"})
    public Map<String, Object> callbackToken(@RequestParam(value="code") String code) {
        String accessTokenUrl = this.tokenUri + "/oauth2/access_token?app_key=" + appKey + "&app_secret=" + this.appSecret + "&code=" + code + "&grant_type=authorization_code";
        HttpGet httpGet = new HttpGet(accessTokenUrl);
        String tokenResp = this.httpClientService.httpGet(httpGet);
        return (Map)JSON.parseObject((String)tokenResp, MAP_TYPE, (Feature[])new Feature[0]);
    }

    static {
        MAP_TYPE = new TypeReference<Map<String, Object>>(){};
    }
}

