/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsonschema2pojo.AnnotationStyle;
import org.jsonschema2pojo.Annotator;
import org.jsonschema2pojo.AnnotatorFactory;
import org.jsonschema2pojo.ContentResolver;
import org.jsonschema2pojo.FileCodeWriterWithEncoding;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.Language;
import org.jsonschema2pojo.ScalaFileCodeWriter;
import org.jsonschema2pojo.SchemaGenerator;
import org.jsonschema2pojo.SchemaMapper;
import org.jsonschema2pojo.SchemaStore;
import org.jsonschema2pojo.SourceType;
import org.jsonschema2pojo.URLProtocol;
import org.jsonschema2pojo.exception.GenerationException;
import org.jsonschema2pojo.rules.RuleFactory;
import org.jsonschema2pojo.util.URLUtil;

public class Jsonschema2Pojo {
    public static void generate(GenerationConfig config) throws IOException {
        Annotator annotator = Jsonschema2Pojo.getAnnotator(config);
        RuleFactory ruleFactory = Jsonschema2Pojo.createRuleFactory(config);
        ruleFactory.setAnnotator(annotator);
        ruleFactory.setGenerationConfig(config);
        ruleFactory.setSchemaStore(new SchemaStore(Jsonschema2Pojo.createContentResolver(config)));
        SchemaMapper mapper = new SchemaMapper(ruleFactory, Jsonschema2Pojo.createSchemaGenerator(config));
        JCodeModel codeModel = new JCodeModel();
        if (config.isRemoveOldOutput()) {
            Jsonschema2Pojo.removeOldOutput(config.getTargetDirectory());
        }
        Iterator<URL> sources = config.getSource();
        while (sources.hasNext()) {
            URL source = sources.next();
            if (URLUtil.parseProtocol((String)source.toString()) == URLProtocol.FILE && URLUtil.getFileFromURL((URL)source).isDirectory()) {
                Jsonschema2Pojo.generateRecursive(config, mapper, codeModel, StringUtils.defaultString((String)config.getTargetPackage()), Arrays.asList(URLUtil.getFileFromURL((URL)source).listFiles(config.getFileFilter())));
                continue;
            }
            mapper.generate(codeModel, Jsonschema2Pojo.getNodeName(source, config), StringUtils.defaultString((String)config.getTargetPackage()), source);
        }
        if (config.getTargetDirectory().exists() || config.getTargetDirectory().mkdirs()) {
            FileCodeWriterWithEncoding resourcesWriter;
            ScalaFileCodeWriter sourcesWriter;
            if (config.getTargetLanguage() == Language.SCALA) {
                sourcesWriter = new ScalaFileCodeWriter(config.getTargetDirectory(), config.getOutputEncoding());
                resourcesWriter = new FileCodeWriterWithEncoding(config.getTargetDirectory(), config.getOutputEncoding());
                codeModel.build((CodeWriter)sourcesWriter, (CodeWriter)resourcesWriter);
            } else {
                sourcesWriter = new FileCodeWriterWithEncoding(config.getTargetDirectory(), config.getOutputEncoding());
                resourcesWriter = new FileCodeWriterWithEncoding(config.getTargetDirectory(), config.getOutputEncoding());
                codeModel.build((CodeWriter)sourcesWriter, (CodeWriter)resourcesWriter);
            }
        } else {
            throw new GenerationException("Could not create or access target directory " + config.getTargetDirectory().getAbsolutePath());
        }
    }

    private static ContentResolver createContentResolver(GenerationConfig config) {
        if (config.getSourceType() == SourceType.YAMLSCHEMA || config.getSourceType() == SourceType.YAML) {
            return new ContentResolver((JsonFactory)new YAMLFactory());
        }
        return new ContentResolver();
    }

    private static SchemaGenerator createSchemaGenerator(GenerationConfig config) {
        if (config.getSourceType() == SourceType.YAMLSCHEMA || config.getSourceType() == SourceType.YAML) {
            return new SchemaGenerator((JsonFactory)new YAMLFactory());
        }
        return new SchemaGenerator();
    }

    private static RuleFactory createRuleFactory(GenerationConfig config) {
        Class<? extends RuleFactory> clazz = config.getCustomRuleFactory();
        if (!RuleFactory.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("The class name given as a rule factory  (" + clazz.getName() + ") does not refer to a class that implements " + RuleFactory.class.getName());
        }
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Failed to create a rule factory from the given class. An exception was thrown on trying to create a new instance.", e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Failed to create a rule factory from the given class. It appears that we do not have access to this class - is both the class and its no-arg constructor marked public?", e);
        }
    }

    private static void generateRecursive(GenerationConfig config, SchemaMapper mapper, JCodeModel codeModel, String packageName, List<File> schemaFiles) throws IOException {
        Collections.sort(schemaFiles, config.getSourceSortOrder().getComparator());
        for (File child : schemaFiles) {
            if (child.isFile()) {
                mapper.generate(codeModel, Jsonschema2Pojo.getNodeName(child.toURI().toURL(), config), StringUtils.defaultString((String)packageName), child.toURI().toURL());
                continue;
            }
            Jsonschema2Pojo.generateRecursive(config, mapper, codeModel, Jsonschema2Pojo.childQualifiedName(packageName, child.getName()), Arrays.asList(child.listFiles(config.getFileFilter())));
        }
    }

    private static String childQualifiedName(String parentQualifiedName, String childSimpleName) {
        String safeChildName = childSimpleName.replaceAll("[^0-9a-zA-Z_$]", "_");
        return StringUtils.isEmpty((CharSequence)parentQualifiedName) ? safeChildName : parentQualifiedName + "." + safeChildName;
    }

    private static void removeOldOutput(File targetDirectory) {
        if (targetDirectory.exists()) {
            for (File f : targetDirectory.listFiles()) {
                Jsonschema2Pojo.delete(f);
            }
        }
    }

    private static void delete(File f) {
        if (f.isDirectory()) {
            for (File child : f.listFiles()) {
                Jsonschema2Pojo.delete(child);
            }
        }
        f.delete();
    }

    private static Annotator getAnnotator(GenerationConfig config) {
        AnnotatorFactory factory = new AnnotatorFactory(config);
        return factory.getAnnotator(factory.getAnnotator(config.getAnnotationStyle()), factory.getAnnotator(config.getCustomAnnotator()));
    }

    public static String getNodeName(URL file, GenerationConfig config) {
        return Jsonschema2Pojo.getNodeName(file.toString(), config);
    }

    public static String getNodeName(String filePath, GenerationConfig config) {
        if (config.getAnnotationStyle() == AnnotationStyle.JAXB) {
            return config.getFileName();
        }
        try {
            String fileName = FilenameUtils.getName((String)URLDecoder.decode(filePath, "UTF-8"));
            String[] extensions = config.getFileExtensions() == null ? new String[]{} : config.getFileExtensions();
            boolean extensionRemoved = false;
            for (int i = 0; i < extensions.length; ++i) {
                String extension = extensions[i];
                if (extension.length() == 0) continue;
                if (!extension.startsWith(".")) {
                    extension = "." + extension;
                }
                if (!fileName.endsWith(extension)) continue;
                fileName = StringUtils.removeEnd((String)fileName, (String)extension);
                extensionRemoved = true;
                break;
            }
            if (!extensionRemoved) {
                fileName = FilenameUtils.getBaseName((String)fileName);
            }
            return fileName;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(String.format("Unable to generate node name from URL: %s", filePath), e);
        }
    }
}

