/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.portalcommon.util;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileUtil {
    private static Logger log = LogManager.getLogger(FileUtil.class);

    public static void writeFile(String content, String path) {
        File fileText = new File(path);
        try {
            if (!fileText.exists()) {
                fileText.createNewFile();
            }
            FileWriter writer = new FileWriter(fileText);
            writer.write(content);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            throw new ZTBusinessException("\u90e8\u7f72\u80fd\u529b\u5f02\u5e38\uff1a\u7f16\u8bd1\u6587\u4ef6[" + path + "]\u5f02\u5e38\u4fe1\u606f\u4e3a\uff0c" + e.getMessage());
        }
    }

    public static void mkSeriveDir(String path) {
        File file = new File(path);
        if (!file.exists()) {
            boolean mkdir = file.mkdir();
            log.info("\u521b\u5efa\u6587\u4ef6:" + mkdir + ":[" + path + "]");
        }
    }

    public static boolean delAllFile(String path) {
        boolean flag = false;
        File file = new File(path);
        if (!file.exists()) {
            return flag;
        }
        if (!file.isDirectory()) {
            return flag;
        }
        String[] tempList = file.list();
        File temp = null;
        for (int i = 0; i < tempList.length; ++i) {
            temp = path.endsWith(File.separator) ? new File(path + tempList[i]) : new File(path + File.separator + tempList[i]);
            if (temp.isFile()) {
                temp.delete();
            }
            if (!temp.isDirectory()) continue;
            FileUtil.delAllFile(path + "/" + tempList[i]);
            FileUtil.delFolder(path + "/" + tempList[i]);
            flag = true;
        }
        return flag;
    }

    public static void delFolder(String folderPath) {
        try {
            FileUtil.delAllFile(folderPath);
            String filePath = folderPath;
            filePath = filePath.toString();
            File myFilePath = new File(filePath);
            myFilePath.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void rmFiles(String path, String serviceName) {
        File file = new File(path);
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].getPath().endsWith(serviceName)) continue;
                FileUtil.delFolder(files[i].getPath());
            }
        }
    }

    private byte[] inputStreamToByte(InputStream is) throws IOException {
        int ch;
        ByteArrayOutputStream bAOutputStream = new ByteArrayOutputStream();
        while ((ch = is.read()) != -1) {
            bAOutputStream.write(ch);
        }
        byte[] data = bAOutputStream.toByteArray();
        bAOutputStream.close();
        return data;
    }

    public static String toUpperCaseFirstOne(String s) {
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static void removeDir(File dir) {
        File[] files;
        if (!dir.exists()) {
            return;
        }
        if (dir.isFile()) {
            dir.delete();
            return;
        }
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                FileUtil.removeDir(file);
                continue;
            }
            file.delete();
        }
        log.info(dir + ":" + dir.delete());
    }

    public static void mkdir(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdir();
        }
    }

    public static void getFile(byte[] bfile, String filePath, String fileName) {
        File file = null;
        try {
            File dir = new File(filePath);
            if (!dir.exists()) {
                log.info("\u521b\u5efa\u76ee\u5f55{}", (Object)dir);
                dir.mkdirs();
            }
            file = new File(filePath + File.separator + fileName);
            try (FileOutputStream fos = new FileOutputStream(file);){
                BufferedOutputStream bos = new BufferedOutputStream(fos);
                bos.write(bfile);
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static File saveFile(byte[] data, String filePath, String filename) throws Exception {
        File f = new File(filePath);
        if (!f.exists()) {
            f.mkdir();
        }
        if (data != null) {
            String filepath = filePath + File.separator + filename;
            File file = new File(filepath);
            if (file.exists()) {
                file.delete();
            }
            try (FileOutputStream fos = new FileOutputStream(file);){
                fos.write(data, 0, data.length);
                fos.flush();
            }
            return file;
        }
        return f;
    }

    public static String extractedOne(String path, String key) {
        File file = new File(path);
        String filename = "";
        if (file.isFile()) {
            return "";
        }
        File[] fileArray = file.listFiles();
        boolean count = false;
        for (File name : fileArray) {
            String s = name.toString();
            if (!s.endsWith(key) || !name.isFile()) continue;
            filename = name.toString();
        }
        return filename;
    }

    public static String getFileContent(File file) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            byte[] bytes = new byte[2048];
            int n = -1;
            while ((n = in.read(bytes, 0, bytes.length)) != -1) {
                sb.append(new String(bytes, 0, n, "GBK"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static String getFileName(File file) {
        return file.getName();
    }

    public static void main(String[] args) {
        System.out.println(FileUtil.getFileName(new File("E:/JSON/generated.jsonschema")));
    }
}

