/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.portalcommon.util;

import java.util.regex.Pattern;

public final class IpCheckUtil {
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");
    private static final Pattern IPV6_STD_PATTERN = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    private static final Pattern IPV6_HEX_COMPRESSED_PATTERN = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");

    public static boolean isIPAddress(String[] input) {
        for (String ip : input) {
            if (IpCheckUtil.isIPAddress(ip)) continue;
            return false;
        }
        return true;
    }

    public static boolean isIPAddress(String input) {
        return IpCheckUtil.isIPv4Address(input) || IpCheckUtil.isIPv6Address(input);
    }

    public static boolean isIPv4Address(String input) {
        return IPV4_PATTERN.matcher(input).matches();
    }

    public static boolean isIPv6Address(String input) {
        return IpCheckUtil.isIPv6StdAddress(input) || IpCheckUtil.isIPv6HexCompressedAddress(input);
    }

    public static boolean isIPv6StdAddress(String input) {
        return IPV6_STD_PATTERN.matcher(input).matches();
    }

    public static boolean isIPv6HexCompressedAddress(String input) {
        return IPV6_HEX_COMPRESSED_PATTERN.matcher(input).matches();
    }
}

