/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.portalcommon.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class ObjectUtil {
    private static Random random;
    private static String randomStr;

    public static Object getObject(Class c) throws IllegalAccessException, InstantiationException {
        Field[] fields;
        if ("String".equalsIgnoreCase(c.getSimpleName())) {
            return ObjectUtil.getString(3);
        }
        if ("Boolean".equalsIgnoreCase(c.getSimpleName())) {
            return ObjectUtil.getBoolean();
        }
        if ("Long".equalsIgnoreCase(c.getSimpleName())) {
            return ObjectUtil.getLong(1L, 3L);
        }
        if ("Integer".equalsIgnoreCase(c.getSimpleName())) {
            return ObjectUtil.getInt(1, 3);
        }
        if ("int".equalsIgnoreCase(c.getSimpleName())) {
            return ObjectUtil.getInt(1, 3);
        }
        if ("float".equalsIgnoreCase(c.getSimpleName())) {
            return Float.valueOf(ObjectUtil.getFloat(0, 100, 2));
        }
        if ("double".equalsIgnoreCase(c.getSimpleName())) {
            return ObjectUtil.getDouble(0, 100, 3);
        }
        if ("byte".equalsIgnoreCase(c.getSimpleName())) {
            return ObjectUtil.getByte(1, 3);
        }
        if ("short".equalsIgnoreCase(c.getSimpleName())) {
            return ObjectUtil.getShort(1, 3);
        }
        if ("char".equalsIgnoreCase(c.getSimpleName())) {
            return Character.valueOf(ObjectUtil.getChar(1, 3));
        }
        Object object = c.newInstance();
        for (Field field : fields = c.getDeclaredFields()) {
            field.setAccessible(true);
            if ("String".equalsIgnoreCase(field.getType().getSimpleName())) {
                field.set(object, ObjectUtil.getString(3));
                continue;
            }
            if ("Boolean".equalsIgnoreCase(field.getType().getSimpleName())) {
                field.set(object, ObjectUtil.getBoolean());
                continue;
            }
            if ("Long".equalsIgnoreCase(field.getType().getSimpleName())) {
                field.set(object, ObjectUtil.getLong(1L, 3L));
                continue;
            }
            if ("Integer".equalsIgnoreCase(field.getType().getSimpleName())) {
                field.set(object, ObjectUtil.getInt(1, 3));
                continue;
            }
            if ("int".equalsIgnoreCase(field.getType().getSimpleName())) {
                field.set(object, ObjectUtil.getInt(1, 3));
                continue;
            }
            if ("float".equalsIgnoreCase(field.getType().getSimpleName())) {
                field.set(object, Float.valueOf(ObjectUtil.getFloat(0, 100, 2)));
                continue;
            }
            if ("double".equalsIgnoreCase(field.getType().getSimpleName())) {
                field.set(object, ObjectUtil.getDouble(0, 100, 3));
                continue;
            }
            if ("byte".equalsIgnoreCase(field.getType().getSimpleName())) {
                field.set(object, ObjectUtil.getByte(1, 3));
                continue;
            }
            if ("short".equalsIgnoreCase(field.getType().getSimpleName())) {
                field.set(object, ObjectUtil.getShort(1, 3));
                continue;
            }
            if ("char".equalsIgnoreCase(field.getType().getSimpleName())) {
                field.set(object, Character.valueOf(ObjectUtil.getChar(1, 3)));
                continue;
            }
            if (field.getType().isArray()) {
                Class<?> componentClass = field.getType().getComponentType();
                Object arrayObject = Array.newInstance(componentClass, 2);
                Array.set(arrayObject, 0, ObjectUtil.getObject(componentClass));
                Array.set(arrayObject, 1, ObjectUtil.getObject(componentClass));
                field.set(object, arrayObject);
                continue;
            }
            if (List.class.isAssignableFrom(field.getType())) {
                Type genericType = field.getGenericType();
                if (genericType == null) continue;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                if (!(genericType instanceof ParameterizedType)) continue;
                ParameterizedType parameterizedType = (ParameterizedType)genericType;
                Class genericClass = (Class)parameterizedType.getActualTypeArguments()[0];
                for (int i = 0; i < 2; ++i) {
                    arrayList.add(ObjectUtil.getObject(genericClass));
                }
                field.set(object, arrayList);
                continue;
            }
            field.set(object, ObjectUtil.getObject(field.getType()));
        }
        return object;
    }

    private static String getString(int length) {
        return "XXX";
    }

    private static Long getLong(long min, long max) {
        if (min >= max) {
            return 0L;
        }
        return (long)random.nextInt((int)(max - min)) + min;
    }

    private static int getInt(int min, int max) {
        if (min >= max) {
            return 0;
        }
        return random.nextInt(max - min) + min;
    }

    private static boolean getBoolean() {
        return random.nextBoolean();
    }

    private static float getFloat(int min, int max, int decimals) {
        if (min >= max) {
            return 0.0f;
        }
        int a = random.nextInt(max - min) + min;
        if (decimals > 0) {
            int bound = (int)Math.pow(10.0, decimals);
            int b = random.nextInt(bound);
            return Float.parseFloat(a + "." + b);
        }
        return a;
    }

    private static double getDouble(int min, int max, int decimals) {
        if (min >= max) {
            return 0.0;
        }
        int a = random.nextInt(max - min) + min;
        if (decimals > 0) {
            int bound = (int)Math.pow(10.0, decimals);
            int b = random.nextInt(bound);
            return Double.parseDouble(a + "." + b);
        }
        return a;
    }

    private static short getShort(int min, int max) {
        if (min >= max) {
            return 0;
        }
        return (short)(random.nextInt(max - min) + min);
    }

    private static char getChar(int min, int max) {
        if (min >= max) {
            return '\u0000';
        }
        return (char)(random.nextInt(max - min) + min);
    }

    private static byte getByte(int min, int max) {
        if (min >= max) {
            return 0;
        }
        return (byte)(random.nextInt(max - min) + min);
    }

    public static void main(String[] args) {
    }

    static {
        randomStr = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        random = new Random();
    }
}

