/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.portalcommon.util.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.springframework.util.StringUtils;

public class JSONUtil {
    private static final String EMPTY = "null";
    private static final String EMPTY_OUT = "\u65e0";
    private static final String TYPE_NOT_SUPPORTED = "\u6682\u4e0d\u652f\u6301\u7c7b\u578b";

    public static String fomateByFastJson(String json) {
        Object parse = JSON.parse((String)json);
        Object o = JSONUtil.parseObject(parse);
        return JSON.toJSONString((Object)o);
    }

    public static JSONObject parseJsonObject(JSONObject json) {
        JSONObject jsonObject = new JSONObject();
        json.forEach((k, v) -> jsonObject.put(k, JSONUtil.parseObject(v)));
        return jsonObject;
    }

    public static JSONArray parseJsonArray(JSONArray json) {
        JSONArray jsonArray = new JSONArray();
        if (json.size() < 1) {
            json.add((Object)EMPTY_OUT);
        }
        jsonArray.add(JSONUtil.parseObject(json.get(0)));
        return jsonArray;
    }

    public static Object parseObject(Object json) {
        if (StringUtils.isEmpty((Object)json)) {
            return EMPTY_OUT;
        }
        if (json instanceof JSONObject) {
            return JSONUtil.parseJsonObject((JSONObject)json);
        }
        if (json instanceof JSONArray) {
            return JSONUtil.parseJsonArray((JSONArray)json);
        }
        if (json instanceof String) {
            if (EMPTY.equalsIgnoreCase(String.valueOf(json))) {
                return EMPTY_OUT;
            }
            return json;
        }
        if (json instanceof Long) {
            return json;
        }
        if (json instanceof Integer) {
            return json;
        }
        if (json instanceof Boolean) {
            return json;
        }
        return TYPE_NOT_SUPPORTED;
    }
}

