/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.portalcommon.helper;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsonParseHelper {
    public static final String ALL_CHAR = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String LETTER_CHAR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final Pattern DEF_PATTERN = Pattern.compile("#/definitions/.+");

    public static void fieldsCheck(String type, ArrayList<String> fields, Map map) {
        for (String field : fields) {
            if (map.get(field) == null) continue;
            throw new RuntimeException("[jsonTemplate]: \u4e0d\u652f\u6301\u7684jsonSchema\u5c5e\u6027,type :" + type + ",\u5c5e\u6027\u540d:" + field);
        }
    }

    public static void generateArray(JsonGenerator jsonGenerator, String fieldName, ArrayList<Map> items, Integer[] props, Map defMap) {
        int minItems = props[0];
        int maxItems = props[1];
        int count = 0;
        try {
            if (items == null) {
                jsonGenerator.writeArrayFieldStart(fieldName);
                jsonGenerator.writeString("element1");
                jsonGenerator.writeString("element2");
                jsonGenerator.writeString("element3");
                jsonGenerator.writeEndArray();
            } else {
                if (fieldName != null) {
                    jsonGenerator.writeArrayFieldStart(fieldName);
                } else {
                    jsonGenerator.writeStartArray();
                }
                block3: while (count < minItems) {
                    for (Map map : items) {
                        if (count > minItems && count <= maxItems) break block3;
                        JsonParseHelper.processArray(jsonGenerator, map, defMap);
                        ++count;
                    }
                }
                jsonGenerator.writeEndArray();
            }
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException("[JsonUtil] \u751f\u6210JsonArray\u5f02\u5e38..." + e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException("[JsonUtil] JsonArray I/O\u5f02\u5e38..." + e.getMessage());
        }
    }

    public static void generateBegin(JsonGenerator jsonGenerator) {
        try {
            jsonGenerator.writeStartObject();
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException("[JsonUtil] \u751f\u6210Json\u5f00\u59cb\u5b57\u7b26\u5f02\u5e38..." + e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException("[JsonUtil] Json\u7ed3\u675f\u5b57\u7b26\u751f\u6210\u65f6I/O\u5f02\u5e38..." + e.getMessage());
        }
    }

    public static void generateBoolean(JsonGenerator jsonGenerator, String key, Boolean value) {
        try {
            if (key != null) {
                jsonGenerator.writeBooleanField(key, value.booleanValue());
            } else {
                jsonGenerator.writeBoolean(value.booleanValue());
            }
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException("[JsonUtil] \u751f\u6210JsonBoolean\u5f02\u5e38..." + e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException("[JsonUtil] JsonBoolean I/O\u5f02\u5e38..." + e.getMessage());
        }
    }

    public static void generateNull(JsonGenerator jsonGenerator, String key) {
        try {
            if (key != null) {
                jsonGenerator.writeNullField(key);
            } else {
                jsonGenerator.writeNull();
            }
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException("[JsonUtil] \u751f\u6210JsonNull\u5f02\u5e38..." + e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException("[JsonUtil] JsonNull I/O\u5f02\u5e38..." + e.getMessage());
        }
    }

    public static void generateEnd(JsonGenerator jsonGenerator) {
        try {
            jsonGenerator.writeEndObject();
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException("[JsonUtil] \u751f\u6210Json\u7ed3\u675f\u5b57\u7b26\u5f02\u5e38..." + e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException("[JsonUtil] Json\u7ed3\u675f\u5b57\u7b26\u751f\u6210\u65f6I/O\u5f02\u5e38..." + e.getMessage());
        }
    }

    public static void generateEnum(JsonGenerator jsonGenerator, String key, Object produceEnum) {
        try {
            if (key != null) {
                jsonGenerator.writeObjectField(key, produceEnum);
            } else {
                jsonGenerator.writeObject(produceEnum);
            }
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("[JsonUtil] \u751f\u6210JsonEnum\u5f02\u5e38..." + e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException("[JsonUtil] JsonEnum I/O\u5f02\u5e38..." + e.getMessage());
        }
    }

    public static void generateInteger(JsonGenerator jsonGenerator, String key, Integer value) {
        try {
            if (key != null) {
                jsonGenerator.writeNumberField(key, value.intValue());
            } else {
                jsonGenerator.writeNumber(value.intValue());
            }
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException("[JsonUtil] \u751f\u6210JsonInteger\u5f02\u5e38..." + e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException("[JsonUtil] JsonInteger I/O\u5f02\u5e38..." + e.getMessage());
        }
    }

    public static void generateNumber(JsonGenerator jsonGenerator, String key, Double value) {
        try {
            if (key != null) {
                jsonGenerator.writeNumberField(key, value.doubleValue());
            } else {
                jsonGenerator.writeNumber(value.doubleValue());
            }
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException("[JsonUtil] \u751f\u6210JsonNumber\u5f02\u5e38..." + e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException("[JsonUtil] JsonNumber I/O\u5f02\u5e38..." + e.getMessage());
        }
    }

    public static void generateObject(JsonGenerator jsonGenerator, String fieldName, Map properties, boolean needBrackets, Map defMap) {
        try {
            if (fieldName != null) {
                jsonGenerator.writeObjectFieldStart(fieldName);
            } else if (needBrackets) {
                jsonGenerator.writeStartObject();
            }
            JsonParseHelper.recursiveCall(jsonGenerator, null, properties, defMap);
            if (needBrackets) {
                jsonGenerator.writeEndObject();
            }
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException("[JsonUtil] \u751f\u6210JsonObject\u5f02\u5e38..." + e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException("[JsonUtil] JsonObject I/O\u5f02\u5e38..." + e.getMessage());
        }
    }

    public static void generateString(JsonGenerator jsonGenerator, String key, String value) {
        try {
            if (key != null) {
                jsonGenerator.writeStringField(key, value);
            } else {
                jsonGenerator.writeString(value);
            }
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException("[JsonUtil] \u751f\u6210JsonString\u5f02\u5e38..." + e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException("[JsonUtil] JsonString I/O\u5f02\u5e38..." + e.getMessage());
        }
    }

    public static void processArray(JsonGenerator jsonGenerator, Map map, Map defMap) {
        Map properties = null;
        if (map.get("$ref") != null) {
            properties = JsonParseHelper.getRefProperties((String)map.get("$ref"), defMap, jsonGenerator);
            JsonParseHelper.generateObject(jsonGenerator, null, properties, true, defMap);
        } else if ("integer".equals(map.get("type"))) {
            JsonParseHelper.generateInteger(jsonGenerator, null, JsonParseHelper.produceInteger(map).intValue());
        } else if ("number".equals(map.get("type"))) {
            JsonParseHelper.generateNumber(jsonGenerator, null, JsonParseHelper.produceNumber(map));
        } else if ("string".equals(map.get("type"))) {
            JsonParseHelper.generateString(jsonGenerator, null, JsonParseHelper.produceString(map));
        } else if ("boolean".equals(map.get("type"))) {
            JsonParseHelper.generateBoolean(jsonGenerator, null, true);
        } else if ("array".equals(map.get("type"))) {
            JsonParseHelper.generateArray(jsonGenerator, null, JsonParseHelper.produceArrayItems(map), JsonParseHelper.produceArrayProps(map), defMap);
        } else if ("enum".equals(map.get("type"))) {
            JsonParseHelper.generateEnum(jsonGenerator, null, JsonParseHelper.produceEnum(map));
        } else if ("null".equals(map.get("type"))) {
            JsonParseHelper.generateNull(jsonGenerator, null);
        } else if ("object".equals(map.get("type"))) {
            properties = (Map)map.get("properties");
            JsonParseHelper.generateObject(jsonGenerator, null, properties, true, defMap);
        }
    }

    private static Map getRefProperties(String refExpression, Map defMap, JsonGenerator jsonGenerator) {
        Matcher matcher = DEF_PATTERN.matcher(refExpression);
        if (!matcher.find()) {
            throw new IllegalArgumentException("\u975e\u6cd5\u7684definition\u8868\u8fbe\u5f0f:" + refExpression);
        }
        String defKey = refExpression.split("/")[2];
        Object defValue = defMap.get(defKey);
        if (defValue == null) {
            throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u8be5definition\u5b9a\u4e49:" + defKey);
        }
        return (Map)defValue;
    }

    public static void processMain(JsonGenerator jsonGenerator, String key, Map<String, Object> sonMap, Map defMap) {
        Iterator<Map.Entry<String, Object>> iter = sonMap.entrySet().iterator();
        Map.Entry<String, Object> entry = null;
        Map map = null;
        Object type = null;
        String fieldName = null;
        Map properties = null;
        while (iter.hasNext()) {
            entry = iter.next();
            map = (Map)entry.getValue();
            type = map.get("type");
            fieldName = entry.getKey();
            JsonParseHelper.supportCheck(type + "", map);
            if (type == null) {
                if (map.get("enum") != null) {
                    ArrayList enumm = (ArrayList)map.get("enum");
                    if (enumm.get(0) instanceof String) {
                        JsonParseHelper.generateString(jsonGenerator, fieldName, enumm.get(0).toString());
                        continue;
                    }
                    if (enumm.get(0) instanceof Integer) {
                        JsonParseHelper.generateInteger(jsonGenerator, fieldName, (Integer)enumm.get(0));
                        continue;
                    }
                    if (!(enumm.get(0) instanceof Double)) continue;
                    JsonParseHelper.generateNumber(jsonGenerator, fieldName, (Double)enumm.get(0));
                    continue;
                }
                if (map.get("$ref") == null) continue;
                properties = JsonParseHelper.getRefProperties((String)map.get("$ref"), defMap, jsonGenerator);
                JsonParseHelper.generateObject(jsonGenerator, fieldName, properties, true, defMap);
                continue;
            }
            if ("string".equals(type)) {
                JsonParseHelper.generateString(jsonGenerator, fieldName, JsonParseHelper.produceString(map));
                continue;
            }
            if ("number".equals(type)) {
                JsonParseHelper.generateNumber(jsonGenerator, fieldName, JsonParseHelper.produceNumber(map));
                continue;
            }
            if ("boolean".equals(type)) {
                JsonParseHelper.generateBoolean(jsonGenerator, fieldName, Boolean.valueOf("true"));
                continue;
            }
            if ("integer".equals(type)) {
                JsonParseHelper.generateInteger(jsonGenerator, fieldName, JsonParseHelper.produceInteger(map).intValue());
                continue;
            }
            if ("array".equals(type)) {
                JsonParseHelper.generateArray(jsonGenerator, fieldName, JsonParseHelper.produceArrayItems(map), JsonParseHelper.produceArrayProps(map), defMap);
                continue;
            }
            if ("null".equals(type)) {
                JsonParseHelper.generateNull(jsonGenerator, fieldName);
                continue;
            }
            if (!"object".equals(type)) continue;
            properties = (Map)map.get("properties");
            JsonParseHelper.generateObject(jsonGenerator, fieldName, properties, true, defMap);
        }
    }

    public static ArrayList<Map> produceArrayItems(Map<String, Object> sonMap) {
        if (sonMap.get("items") == null) {
            throw new RuntimeException("array\u4e2d\u6ca1\u6709items\u5c5e\u6027 ");
        }
        if (sonMap.get("items") instanceof ArrayList) {
            return (ArrayList)sonMap.get("items");
        }
        if (sonMap.get("items") instanceof LinkedHashMap) {
            ArrayList<Map> items = new ArrayList<Map>(8);
            items.add((Map)sonMap.get("items"));
            return items;
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684array item\u5c5e\u6027");
    }

    public static Integer[] produceArrayProps(Map map) {
        int minItems = map.get("minItems") == null ? 1 : (Integer)map.get("minItems");
        int maxItems = map.get("maxItems") == null ? 1 : (Integer)map.get("maxItems");
        return new Integer[]{minItems, maxItems};
    }

    public static Object produceEnum(Map<String, Object> sonMap) {
        Object enumResult = null;
        ArrayList enumList = (ArrayList)sonMap.get("enum");
        if (enumList.isEmpty()) {
            throw new RuntimeException("\u6ca1\u6709\u53ef\u679a\u4e3e\u9879\uff01");
        }
        enumResult = enumList.get(0);
        return enumResult;
    }

    public static Double produceNumber(Map<String, Object> sonMap) {
        ArrayList enumm;
        ArrayList arrayList = enumm = sonMap.get("enum") == null ? null : (ArrayList)sonMap.get("enum");
        if (enumm != null) {
            return Double.valueOf(enumm.get(0) + "");
        }
        Double minimum = sonMap.get("minimum") == null ? null : Double.valueOf(((Number)sonMap.get("minimum")).doubleValue());
        Double maximum = sonMap.get("maximum") == null ? null : Double.valueOf(((Number)sonMap.get("maximum")).doubleValue());
        Boolean exclusiveMinimum = sonMap.get("exclusiveMinimum") == null ? false : (Boolean)sonMap.get("exclusiveMinimum");
        Boolean exclusiveMaximum = sonMap.get("exclusiveMaximum") == null ? false : (Boolean)sonMap.get("exclusiveMaximum");
        if (minimum == null) {
            minimum = 0.0;
        }
        if (maximum == null) {
            maximum = 100.0;
        }
        if (minimum > maximum) {
            throw new IllegalArgumentException("[jsonTemplate]: Number \u7c7b\u578b  maxinum  > minimum");
        }
        if (minimum.equals(maximum)) {
            if (exclusiveMinimum.booleanValue() && exclusiveMaximum.booleanValue()) {
                throw new IllegalArgumentException("[jsonTemplate]: Number \u7c7b\u578b  \u6839\u636emaxinum,minimum, exclusiveMinimum,exclusiveMaximum\u65e0\u6cd5\u53d6\u5f97\u5408\u6cd5\u503c");
            }
            if (exclusiveMinimum.booleanValue() && !exclusiveMaximum.booleanValue()) {
                return (double)maximum;
            }
            if (!exclusiveMinimum.booleanValue() && exclusiveMaximum.booleanValue()) {
                return (double)minimum;
            }
        }
        return (minimum + maximum) / 2.0;
    }

    public static Long produceInteger(Map<String, Object> sonMap) {
        boolean exclusiveMaximum;
        ArrayList enumm;
        ArrayList arrayList = enumm = sonMap.get("enum") == null ? null : (ArrayList)sonMap.get("enum");
        if (enumm != null) {
            return Long.valueOf(enumm.get(0) + "");
        }
        Long minimum = sonMap.get("minimum") == null ? null : Long.valueOf("" + new BigDecimal("" + sonMap.get("minimum")).toPlainString());
        Long maximum = sonMap.get("maximum") == null ? null : Long.valueOf("" + new BigDecimal("" + sonMap.get("maximum")).toPlainString());
        boolean exclusiveMinimum = sonMap.get("exclusiveMinimum") != null && Boolean.parseBoolean(sonMap.get("exclusiveMinimum").toString());
        boolean bl = exclusiveMaximum = sonMap.get("exclusiveMaximum") != null && Boolean.parseBoolean(sonMap.get("exclusiveMaximum").toString());
        if (minimum == null) {
            minimum = 0L;
        }
        if (maximum == null) {
            maximum = 100L;
        }
        if (minimum > maximum) {
            throw new IllegalArgumentException("[jsonTemplate]: Integer \u7c7b\u578b  maxinum  > minimum");
        }
        if (minimum.equals(maximum) || maximum - minimum == 1L) {
            if (exclusiveMinimum && exclusiveMaximum) {
                throw new IllegalArgumentException("[jsonTemplate]: Integer \u7c7b\u578b  \u6839\u636emaxinum,minimum, exclusiveMinimum,exclusiveMaximum\u65e0\u6cd5\u53d6\u5f97\u5408\u6cd5\u503c");
            }
            if (exclusiveMinimum) {
                return maximum;
            }
            if (exclusiveMaximum) {
                return minimum;
            }
        }
        if (!exclusiveMinimum) {
            minimum = minimum + 1L;
        }
        if (!exclusiveMaximum) {
            maximum = maximum - 1L;
        }
        return Math.round(Math.random() * (double)(maximum - minimum) + (double)minimum.longValue());
    }

    public static String produceString(Map<String, Object> sonMap) {
        Integer minLength;
        ArrayList enumm;
        ArrayList arrayList = enumm = sonMap.get("enum") == null ? null : (ArrayList)sonMap.get("enum");
        if (enumm != null && !enumm.isEmpty()) {
            return (String)enumm.get(0);
        }
        if (sonMap.get("pattern") != null) {
            return "";
        }
        Integer maxLength = sonMap.get("maxLength") == null ? null : (Integer)sonMap.get("maxLength");
        Integer n = minLength = sonMap.get("minLength") == null ? null : (Integer)sonMap.get("minLength");
        if (maxLength == null) {
            maxLength = 10;
        }
        if (minLength == null) {
            minLength = 0;
        }
        StringBuffer sb = new StringBuffer(maxLength);
        long length = Math.round(Math.random() * (double)(maxLength - minLength) + (double)minLength.intValue());
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            int i = 0;
            while ((long)i < length) {
                sb.append(ALL_CHAR.charAt(random.nextInt(LETTER_CHAR.length())));
                ++i;
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static void recursiveCall(JsonGenerator jsonGenerator, String key, Map map, Map defMap) {
        if (map.get("type") != null && "object".equals(map.get("type"))) {
            if (map.get("properties") == null) {
                throw new RuntimeException("object \u7c7b\u578b\u5fc5\u987b\u6709 properties\u5c5e\u6027");
            }
            Map properties = (Map)map.get("properties");
            JsonParseHelper.generateObject(jsonGenerator, null, properties, false, defMap);
            return;
        }
        Iterator iter = map.entrySet().iterator();
        Map.Entry entry = null;
        Object clazzTypeArray = null;
        Object dataType = null;
        HashMap fatherMap = new HashMap();
        Map<String, Object> sonMap = new HashMap<String, Object>();
        while (iter.hasNext()) {
            entry = iter.next();
            if ("$schema".equals(entry.getKey()) || "required".equals(entry.getKey())) continue;
            if ("definitions".equals(entry.getKey())) {
                defMap = new HashMap(defMap);
                defMap.putAll((Map)entry.getValue());
                continue;
            }
            sonMap.put(entry.getKey() + "", entry.getValue());
        }
        if (sonMap.get("type") != null) {
            if ("object".equals(sonMap.get("type"))) {
                if (sonMap.get("properties") == null) {
                    throw new RuntimeException("object \u7c7b\u578b\u5fc5\u987b\u6709 properties\u5c5e\u6027");
                }
                Map properties = (Map)sonMap.get("properties");
                JsonParseHelper.generateObject(jsonGenerator, null, properties, true, defMap);
            }
        } else {
            if (sonMap.get("anyOf") != null) {
                Iterator iterr = sonMap.entrySet().iterator();
                Map.Entry entry1 = null;
                if (iterr.hasNext()) {
                    entry1 = iterr.next();
                    ArrayList arrayList = (ArrayList)entry1.getValue();
                    sonMap = (Map)arrayList.get(0);
                    JsonParseHelper.recursiveCall(jsonGenerator, null, sonMap, defMap);
                    return;
                }
            }
            JsonParseHelper.processMain(jsonGenerator, key, sonMap, defMap);
        }
    }

    public static void supportCheck(String type, Map map) {
        ArrayList<String> fields = new ArrayList<String>(0);
        if ("integer".equals(type) || "number".equals(type)) {
            fields.add("multipleOf");
        } else if (!"string".equals(type)) {
            if ("array".equals(type)) {
                fields.add("uniqueItems");
            } else if ("object".equals(type)) {
                fields.add("maxProperties");
                fields.add("minProperties");
                fields.add("dependencies");
                fields.add("patternProperties");
            }
        }
        JsonParseHelper.fieldsCheck(type, fields, map);
    }

    public static String formatJsonByString(String json) {
        ObjectMapper objectMapper = new ObjectMapper();
        Object jsons = null;
        String result = null;
        try {
            jsons = objectMapper.readValue(json, Object.class);
            result = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(jsons);
        }
        catch (JsonParseException e) {
            throw new RuntimeException("[JsonUtil] json\u683c\u5f0f\u5316\u8f6c\u5316\u5f02\u5e38..." + e.getMessage());
        }
        catch (JsonMappingException e) {
            throw new RuntimeException("[JsonUtil] json\u683c\u5f0f\u5316\u6620\u5c04\u5f02\u5e38..." + e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException("[JsonUtil] json\u683c\u5f0f\u5316I/O\u5f02\u5e38..." + e.getMessage());
        }
        return result;
    }
}

