/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.portalcommon.service.impl;

import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.authority.model.AuthorityUserInfoBO;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.portalcommon.api.AppAPI;
import com.ohaotian.portalcommon.api.RegionAPI;
import com.ohaotian.portalcommon.model.AppBO;
import com.ohaotian.portalcommon.model.RegionBO;
import com.ohaotian.portalcommon.model.RegionFirstAddrBo;
import com.ohaotian.portalcommon.service.RefreshTokenPath;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class RefreshTokenPathServiceImpl
implements RefreshTokenPath {
    @Value(value="${server.port}")
    private Integer port;
    @Resource
    private AppAPI appApi;
    @Resource
    private RegionAPI regionApi;
    @Resource
    private AuthorityService authorityService;

    @Override
    public String getAll(String tokenPath, String defaultPath, String regionCode) {
        return this.getIpPort(tokenPath, defaultPath, regionCode) + tokenPath;
    }

    @Override
    public String getIpPort(String tokenPath, String defaultPath, String regionCode) {
        AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
        Long tenantId = Long.valueOf(authorityUserInfoBO.getTenantId());
        if (tokenPath.startsWith("http")) {
            return "";
        }
        if (Objects.equals(tokenPath, defaultPath)) {
            return "http://127.0.0.1:" + this.port;
        }
        AppBO appBO = this.appApi.queryAppByRegionCode(tenantId, regionCode);
        RegionBO regionBo = this.regionApi.queryRegionByAppIdAndRegionCode(appBO.getAppId(), regionCode);
        RegionFirstAddrBo regionFirstAddrBo = this.regionApi.queryRegionFirstAddrByRegionCode(regionCode);
        StringBuilder stringBuilder = new StringBuilder();
        if (regionBo.getCallProtocol() != 0) {
            stringBuilder.append("https://");
        } else {
            stringBuilder.append("http://");
        }
        if (!ObjectUtils.isEmpty((Object)regionFirstAddrBo)) {
            stringBuilder.append(regionFirstAddrBo.getIp());
            if (!ObjectUtils.isEmpty((Object)regionFirstAddrBo.getPort())) {
                stringBuilder.append(":");
                stringBuilder.append(regionFirstAddrBo.getPort());
            }
        } else {
            stringBuilder.append("\u672a\u914d\u7f6eIP");
        }
        return stringBuilder.toString();
    }
}

