/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.portalcommon.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.atp.base.gemini.model.AbilityGeminiSendMsgReqBo;
import com.ohaotian.atp.base.gemini.model.GeminiSendAbilityReqBO;
import com.ohaotian.atp.base.gemini.service.AbilityGeminiService;
import com.ohaotian.portalcommon.config.systemcode.SystemParam;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.util.GetFileContentUtil;
import com.ohaotian.portalcommon.util.HttpUtil;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class AbilityGeminiServiceImpl
implements AbilityGeminiService {
    private static final Logger log = LoggerFactory.getLogger(AbilityGeminiServiceImpl.class);
    @Autowired
    private SystemParam systemParam;
    @Value(value="${geminiSendUrl:}")
    private String geminiSendUrl;
    @Value(value="${ability.gemini.taskCode:ability_token_refresh_notice}")
    private String taskCode;
    @Value(value="classpath:info/version.txt")
    private Resource projectVersion;
    @Value(value="classpath:info/time.txt")
    private Resource packageTime;

    public RspBO sendMessage(AbilityGeminiSendMsgReqBo reqBo) {
        if (StringUtils.isBlank((CharSequence)this.geminiSendUrl)) {
            return RspBO.error("\u672a\u914d\u7f6e\u901a\u77e5\u4e2d\u5fc3\u5730\u5740\uff01");
        }
        try {
            GeminiSendAbilityReqBO geminiSendAbilityReqBO = new GeminiSendAbilityReqBO();
            geminiSendAbilityReqBO.setSendId("666666");
            geminiSendAbilityReqBO.setSendName("\u80fd\u529b\u5e73\u53f0 " + this.systemParam.getProjectName());
            geminiSendAbilityReqBO.setTaskCode(this.taskCode);
            String total = reqBo.getPluginName() + " \u9274\u6743\u83b7\u53d6 " + (Boolean.TRUE.equals(reqBo.isStatus()) ? "\u6210\u529f." : "\u5931\u8d25!");
            geminiSendAbilityReqBO.setTitle(total);
            JSONObject data = JSON.parseObject((String)"{}");
            data.put("version", (Object)GetFileContentUtil.getFileContent(this.projectVersion));
            data.put("packTime", (Object)GetFileContentUtil.getFileContent(this.packageTime));
            data.put("message", (Object)reqBo.getErrorMsg());
            geminiSendAbilityReqBO.setData(data.toJSONString());
            LinkedHashMap<String, String> headerMap = new LinkedHashMap<String, String>();
            headerMap.put("Content-Type", "application/json");
            int statusCode = HttpUtil.doPostJson(this.geminiSendUrl.trim(), JSON.toJSONString((Object)geminiSendAbilityReqBO), (status, rsp) -> status, headerMap);
            if (statusCode != 200) {
                return RspBO.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff01\u72b6\u6001:" + statusCode);
            }
            return RspBO.success("\u6d88\u606f\u53d1\u9001\u6210\u529f!");
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u5f02\u5e38\uff01 ex:" + e.getMessage());
            e.printStackTrace();
            return RspBO.error("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u5f02\u5e38\uff01 ex:" + e.getMessage());
        }
    }
}

