/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.portalcommon.strategy;

import com.google.common.collect.Maps;
import com.ohaotian.portalcommon.annotation.AbilityHandlerType;
import com.ohaotian.portalcommon.annotation.PluginTypeHandlerType;
import com.ohaotian.portalcommon.strategy.HandlerContext;
import com.ohaotian.portalcommon.util.ClassScaner;
import java.util.HashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.stereotype.Component;

@Component
public class HandlerProcessor
implements BeanFactoryPostProcessor {
    private static final String HANDLER_PACKAGE = "com.ohaotian.plugin";
    private static final String ABILITY_HANDLER_PACKAGE = "com.ohaotian";

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        HashMap handlerMap = Maps.newHashMap();
        ClassScaner.scan(HANDLER_PACKAGE, PluginTypeHandlerType.class).forEach(clazz -> {
            String type = clazz.getAnnotation(PluginTypeHandlerType.class).value();
            String position = clazz.getAnnotation(PluginTypeHandlerType.class).position().getCode();
            handlerMap.put(type + "_" + position, clazz);
        });
        ClassScaner.scan(ABILITY_HANDLER_PACKAGE, AbilityHandlerType.class).forEach(clazz -> {
            String type = clazz.getAnnotation(AbilityHandlerType.class).value();
            handlerMap.put(type, clazz);
        });
        HandlerContext handlerContext = new HandlerContext(handlerMap);
        beanFactory.registerSingleton(HandlerContext.class.getName(), (Object)handlerContext);
    }
}

