/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.portalcommon.util;

import de.odysseus.staxon.json.JsonXMLConfig;
import de.odysseus.staxon.json.JsonXMLConfigBuilder;
import de.odysseus.staxon.json.JsonXMLInputFactory;
import de.odysseus.staxon.json.JsonXMLOutputFactory;
import de.odysseus.staxon.xml.util.PrettyXMLEventWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;

public class DataFormatUtil {
    private static Pattern p = Pattern.compile("\\s*|\t|\r|\n");

    public static String XmlToJson(String xmlString) throws Exception {
        StringReader input = new StringReader(xmlString);
        StringWriter output = new StringWriter();
        JsonXMLConfig config = new JsonXMLConfigBuilder().autoArray(true).autoPrimitive(true).prettyPrint(true).build();
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.supportDTD", false);
            XMLEventReader reader = factory.createXMLEventReader(input);
            XMLEventWriter writer = new JsonXMLOutputFactory(config).createXMLEventWriter((Writer)output);
            writer.add(reader);
            reader.close();
            writer.close();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            output.close();
            input.close();
        }
        return output.toString();
    }

    public static String JsonToXml(String jsonString) throws Exception {
        StringReader input = new StringReader(jsonString);
        StringWriter output = new StringWriter();
        JsonXMLConfig config = new JsonXMLConfigBuilder().multiplePI(false).repairingNamespaces(false).build();
        try {
            XMLEventReader reader = new JsonXMLInputFactory(config).createXMLEventReader((Reader)input);
            XMLEventWriter writer = XMLOutputFactory.newInstance().createXMLEventWriter(output);
            writer = new PrettyXMLEventWriter(writer);
            writer.add(reader);
            reader.close();
            writer.close();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            output.close();
            input.close();
        }
        if (output.toString().length() >= 38) {
            return output.toString().substring(39);
        }
        return output.toString();
    }

    public static String JsonToXmlReplaceBlank(String jsonString) throws Exception {
        String str = DataFormatUtil.JsonToXml(jsonString);
        String dest = "";
        if (str != null) {
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    public static String XmlToJsonReplaceBlank(String xmlString) throws Exception {
        String str = DataFormatUtil.XmlToJson(xmlString);
        String dest = "";
        if (str != null) {
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }
}

