/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.portalcommon.service.impl;

import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.authority.model.AuthorityUserInfoBO;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.portalcommon.api.AppAPI;
import com.ohaotian.portalcommon.api.RegionAPI;
import com.ohaotian.portalcommon.model.AppBO;
import com.ohaotian.portalcommon.model.RegionBO;
import com.ohaotian.portalcommon.model.RegionFirstAddrBo;
import com.ohaotian.portalcommon.service.RefreshTokenPath;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class RefreshTokenPathServiceImpl
implements RefreshTokenPath {
    private static final Logger log = LoggerFactory.getLogger(RefreshTokenPathServiceImpl.class);
    @Value(value="${server.port}")
    private Integer port;
    @Resource
    private AppAPI appApi;
    @Resource
    private RegionAPI regionApi;
    @Resource
    private AuthorityService authorityService;

    @Override
    public String getAll(String tokenPath, String defaultPath, String regionCode) {
        return this.getIpPort(tokenPath, defaultPath, regionCode) + tokenPath;
    }

    @Override
    public String getIpPort(String tokenPath, String defaultPath, String regionCode) {
        Long tenantId;
        try {
            AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
            tenantId = Long.valueOf(authorityUserInfoBO.getTenantId());
        }
        catch (Exception e) {
            tenantId = 1L;
        }
        if (tokenPath.startsWith("http")) {
            return "";
        }
        if (Objects.equals(tokenPath, defaultPath)) {
            return "http://127.0.0.1:" + this.port;
        }
        AppBO appBO = this.appApi.queryAppByRegionCode(tenantId, regionCode);
        RegionBO regionBo = this.regionApi.queryRegionByAppIdAndRegionCode(appBO.getAppId(), regionCode);
        RegionFirstAddrBo regionFirstAddrBo = this.regionApi.queryRegionFirstAddrByRegionCode(regionCode);
        StringBuilder stringBuilder = new StringBuilder();
        if (regionBo.getCallProtocol() != 0) {
            stringBuilder.append("https://");
        } else {
            stringBuilder.append("http://");
        }
        if (!ObjectUtils.isEmpty((Object)regionFirstAddrBo)) {
            stringBuilder.append(regionFirstAddrBo.getIp());
            if (!ObjectUtils.isEmpty((Object)regionFirstAddrBo.getPort())) {
                stringBuilder.append(":");
                stringBuilder.append(regionFirstAddrBo.getPort());
            }
        } else {
            stringBuilder.append("\u672a\u914d\u7f6e\u53ef\u7528\u5730\u5740");
        }
        return stringBuilder.toString();
    }

    @Override
    public Boolean getAttendStatus(String regionCode) {
        Long tenantId;
        try {
            AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
            tenantId = Long.valueOf(authorityUserInfoBO.getTenantId());
        }
        catch (Exception e) {
            tenantId = 1L;
        }
        AppBO appBO = this.appApi.queryAppByRegionCode(tenantId, regionCode);
        RegionBO regionBo = this.regionApi.queryRegionByAppIdAndRegionCode(appBO.getAppId(), regionCode);
        RegionFirstAddrBo regionFirstAddrBo = this.regionApi.queryRegionFirstAddrByRegionCode(regionCode);
        if (Objects.equals(appBO.getAttendStatus(), 0)) {
            log.info("{} \u5e94\u7528\u7b7e\u9000\u4e0d\u9700\u8981\u5237\u65b0", (Object)appBO.getAppCode());
            return Boolean.FALSE;
        }
        if (Objects.equals(regionBo.getAttendStatus(), 0)) {
            log.info("{} \u5730\u5740\u5206\u7ec4\u7b7e\u9000\u4e0d\u9700\u8981\u5237\u65b0", (Object)regionBo.getRegionCode());
            return Boolean.FALSE;
        }
        if (Objects.equals(regionFirstAddrBo.getAttendStatus(), 0)) {
            log.info("{} {} \u8d1f\u8f7d\u5730\u5740\u7b7e\u9000\u4e0d\u9700\u8981\u5237\u65b0", (Object)regionFirstAddrBo.getIp(), (Object)regionFirstAddrBo.getPort());
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

