/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.portalcommon.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cglib.beans.BeanMap;

public class BeanMapUtils {
    public static <T> Map<String, Object> beanToMap(T bean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (bean != null) {
            BeanMap beanMap = BeanMap.create(bean);
            for (Object key : beanMap.keySet()) {
                map.put(key + "", beanMap.get(key));
            }
        }
        return map;
    }

    public static <T> T mapToBean(Map<String, Object> map, T bean) {
        BeanMap beanMap = BeanMap.create(bean);
        beanMap.putAll(map);
        return bean;
    }

    public static <T> List<Map<String, Object>> objectsToMaps(List<T> objList) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (objList != null && objList.size() > 0) {
            Map<String, Object> map = null;
            T bean = null;
            int size = objList.size();
            for (int i = 0; i < size; ++i) {
                bean = objList.get(i);
                map = BeanMapUtils.beanToMap(bean);
                list.add(map);
            }
        }
        return list;
    }

    public static <T> List<T> mapsToObjects(List<Map<String, Object>> maps, Class<T> clazz) throws InstantiationException, IllegalAccessException {
        ArrayList<Object> list = new ArrayList<Object>();
        if (maps != null && maps.size() > 0) {
            Map<String, Object> map = null;
            Object bean = null;
            int size = maps.size();
            for (int i = 0; i < size; ++i) {
                map = maps.get(i);
                bean = clazz.newInstance();
                BeanMapUtils.mapToBean(map, bean);
                list.add(bean);
            }
        }
        return list;
    }
}

