/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.portalcommon.helper;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ohaotian.portalcommon.helper.JsonParseHelper;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class JsonHelper {
    private static JsonFactory jsonFactory = null;

    public static JsonFactory getJsonFactory() {
        return jsonFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String parseJsonByMapper(String jsonSchema) {
        if (jsonSchema == null) {
            throw new IllegalArgumentException("[JsonSchemaParser] jsonSchema \u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a null ...");
        }
        try (StringWriter sWriter = new StringWriter(jsonSchema.length());){
            try (JsonGenerator jsonGenerator = jsonFactory.createJsonGenerator((Writer)sWriter);){
                jsonGenerator.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
                ObjectMapper objectMapper = new ObjectMapper();
                Map maps = (Map)objectMapper.readValue(jsonSchema, Map.class);
                Map defMap = (Map)maps.get("definitions");
                JsonParseHelper.generateBegin(jsonGenerator);
                JsonParseHelper.recursiveCall(jsonGenerator, null, maps, defMap);
                JsonParseHelper.generateEnd(jsonGenerator);
            }
            catch (IOException e) {
                throw new RuntimeException("[JsonSchemaParser] \u6839\u636eJsonSchema\u751f\u6210Json\u6837\u4f8b\u5f02\u5e38 ..." + e.getMessage());
            }
            String string = sWriter.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("[JsonSchemaParser] \u6839\u636eJsonSchema\u751f\u6210Json\u6837\u4f8b\u5f02\u5e38 ..." + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String parseJsonByMapperFile(File jsonSchemaFile) {
        try (StringWriter sWriter = new StringWriter(2048);){
            try (JsonGenerator jsonGenerator = jsonFactory.createJsonGenerator((Writer)sWriter);){
                jsonGenerator.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
                ObjectMapper objectMapper = new ObjectMapper();
                Map maps = (Map)objectMapper.readValue(jsonSchemaFile, Map.class);
                Map defMap = (Map)maps.get("definitions");
                JsonParseHelper.generateBegin(jsonGenerator);
                JsonParseHelper.recursiveCall(jsonGenerator, null, maps, defMap);
                JsonParseHelper.generateEnd(jsonGenerator);
            }
            catch (JsonParseException e) {
                throw new RuntimeException("[JsonSchemaParser] \u6839\u636eJsonSchema \u8f6c\u5316\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38 ..." + e.getMessage());
            }
            catch (JsonMappingException e) {
                throw new RuntimeException("[JsonSchemaParser] \u6839\u636eJsonSchema \u6620\u5c04\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38 ..." + e.getMessage());
            }
            catch (IOException e) {
                throw new RuntimeException("[JsonSchemaParser] \u6839\u636eJsonSchema \u8f6c\u5316\u8fc7\u7a0b\u51fa\u73b0I/O\u5f02\u5e38 ..." + e.getMessage());
            }
            String string = sWriter.toString();
            return string;
        }
        catch (JsonParseException e) {
            throw new RuntimeException("[JsonSchemaParser] \u6839\u636eJsonSchema \u8f6c\u5316\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38 ..." + e.getMessage());
        }
        catch (JsonMappingException e) {
            throw new RuntimeException("[JsonSchemaParser] \u6839\u636eJsonSchema \u6620\u5c04\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38 ..." + e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException("[JsonSchemaParser] \u6839\u636eJsonSchema \u8f6c\u5316\u8fc7\u7a0b\u51fa\u73b0I/O\u5f02\u5e38 ..." + e.getMessage());
        }
    }

    public static void main(String[] args) {
        System.out.println("\u5185\u5bb9\uff1a" + JsonHelper.parseJsonByMapper("{\n  \"$schema\": \"http://json-schema.org/draft-04/schema#\",\n  \"type\": \"object\",\n  \"properties\": {\n    \"name\": {\n      \"type\": \"string\",\n      \"minLength\": 1,\n      \"maxLength\": 10\n    }\n  },\n  \"required\": [\n    \"name\"\n  ]\n}"));
    }

    static {
        jsonFactory = new JsonFactory();
    }
}

