/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilitycommon.config.classload;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DynamicJarClassLoader
extends URLClassLoader {
    private static Logger logger = LogManager.getLogger(DynamicJarClassLoader.class);
    private static boolean canCloseJar = false;
    private List<JarURLConnection> cachedJarFiles;

    public DynamicJarClassLoader(URL[] urls, ClassLoader parent) {
        super(new URL[0], parent);
        this.init(urls);
    }

    public DynamicJarClassLoader(URL[] urls) {
        super(new URL[0]);
        this.init(urls);
    }

    public DynamicJarClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(new URL[0], parent, factory);
        this.init(urls);
    }

    private void init(URL[] urls) {
        ArrayList arrayList = this.cachedJarFiles = canCloseJar ? null : new ArrayList();
        if (urls != null) {
            for (URL url : urls) {
                this.addURL(url);
            }
        }
    }

    @Override
    protected void addURL(URL url) {
        if (!canCloseJar) {
            try {
                URLConnection uc = url.openConnection();
                if (uc instanceof JarURLConnection) {
                    uc.setUseCaches(true);
                    ((JarURLConnection)uc).getManifest();
                    this.cachedJarFiles.add((JarURLConnection)uc);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.addURL(url);
    }

    @Override
    public void close() throws IOException {
        if (canCloseJar) {
            try {
                super.close();
            }
            catch (IOException iOException) {}
        } else {
            for (JarURLConnection conn : this.cachedJarFiles) {
                conn.getJarFile().close();
            }
            this.cachedJarFiles.clear();
        }
    }

    public static URL getJarUrl(String jarPath) throws MalformedURLException {
        URL jarUrl = new URL("jar:file:/" + jarPath + "!/");
        return jarUrl;
    }

    public static URL getJarFileUrl(String jarPath) throws MalformedURLException {
        URL jarUrl = new URL("file:/" + jarPath);
        return jarUrl;
    }

    static {
        try {
            URLClassLoader.class.getMethod("close", new Class[0]);
            canCloseJar = true;
            logger.info("\u672c\u73af\u5883\u652f\u6301jar\u5305close\u5378\u8f7d\u65b9\u6cd5");
        }
        catch (NoSuchMethodException e) {
            logger.info("\u672c\u73af\u5883\u4e0d\u652f\u6301jar\u5305close\u5378\u8f7d\u65b9\u6cd5");
        }
        catch (SecurityException e) {
            logger.info("\u672c\u73af\u5883\u4e0d\u652f\u6301jar\u5305close\u5378\u8f7d\u65b9\u6cd5");
        }
    }
}

