/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilitycommon.js.impl;

import com.ohaotian.abilitycommon.js.MngHelperService;
import javax.annotation.PostConstruct;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MngHelperServiceImpl
implements MngHelperService {
    private static final Logger log = LoggerFactory.getLogger(MngHelperServiceImpl.class);
    private static final String JS_CLASS = "com.ohaotian.abilityweb.component.js.JsHelper";
    private NashornScriptEngineFactory factory;
    @Value(value="${ability.MngHelper.compensation:3}")
    private int compensation;

    @PostConstruct
    public void initMngHelperService() {
        long start = System.currentTimeMillis();
        ScriptEngineManager sm = new ScriptEngineManager();
        for (ScriptEngineFactory f : sm.getEngineFactories()) {
            if (!"Oracle Nashorn".equalsIgnoreCase(f.getEngineName())) continue;
            this.factory = (NashornScriptEngineFactory)f;
            log.info("init nashornHelper states success!");
            break;
        }
        long end = System.currentTimeMillis();
        log.info("init nashornHelper cost time {}ms", (Object)(end - start));
    }

    private static void init(ScriptEngine engine) {
        SimpleScriptContext sc = new SimpleScriptContext();
        Bindings bindings = engine.createBindings();
        bindings.put("logger", (Object)log);
        sc.setBindings(bindings, 100);
        sc.setAttribute("__IS_SSR__", true, 100);
    }

    @Override
    public Object eval(String funName, String script, Object ... args) throws ScriptException, NoSuchMethodException {
        for (int i = 0; i < this.compensation; ++i) {
            try {
                ScriptEngine engine = this.factory.getScriptEngine();
                MngHelperServiceImpl.init(engine);
                engine.eval("function " + funName + "(msgCtx){ var esb = Java.type('" + JS_CLASS + "'); " + script + " }");
                Invocable invocable = (Invocable)((Object)engine);
                return invocable.invokeFunction(funName, args);
            }
            catch (NoSuchMethodException e) {
                log.debug("eval {} \u89e6\u53d1JS\u5f15\u64ce\u8865\u507f\u673a\u5236\uff01", (Object)funName);
                continue;
            }
        }
        throw new NoSuchMethodException(funName + " \u6267\u884c\u5f02\u5e38");
    }

    @Override
    public Object evalRoute(String funName, String script, Object ... args) throws ScriptException, NoSuchMethodException {
        for (int i = 0; i < this.compensation; ++i) {
            try {
                ScriptEngine engine = this.factory.getScriptEngine();
                MngHelperServiceImpl.init(engine);
                engine.eval("function " + funName + "(map){ var esb = Java.type('" + JS_CLASS + "'); " + script + " }");
                Invocable invocable = (Invocable)((Object)engine);
                return invocable.invokeFunction(funName, args);
            }
            catch (NoSuchMethodException e) {
                log.debug("eval {} \u89e6\u53d1JS\u5f15\u64ce\u8865\u507f\u673a\u5236\uff01", (Object)funName);
                continue;
            }
        }
        throw new NoSuchMethodException(funName + " \u6267\u884c\u5f02\u5e38");
    }

    @Override
    public Object evalException(String funName, String script, Object ... args) throws ScriptException, NoSuchMethodException {
        for (int i = 0; i < this.compensation; ++i) {
            try {
                ScriptEngine engine = this.factory.getScriptEngine();
                MngHelperServiceImpl.init(engine);
                engine.eval("function " + funName + "(resultData, defaultMsg, fromIp){ var esb = Java.type('" + JS_CLASS + "'); " + script + " }");
                Invocable invocable = (Invocable)((Object)engine);
                return invocable.invokeFunction(funName, args);
            }
            catch (NoSuchMethodException e) {
                log.debug("eval {} \u89e6\u53d1JS\u5f15\u64ce\u8865\u507f\u673a\u5236\uff01", (Object)funName);
                continue;
            }
        }
        throw new NoSuchMethodException(funName + " \u6267\u884c\u5f02\u5e38");
    }

    @Override
    public ScriptObjectMirror getGlobalGlobalMirrorObject(String objectName) {
        ScriptEngine engine = this.factory.getScriptEngine();
        MngHelperServiceImpl.init(engine);
        return (ScriptObjectMirror)engine.getBindings(100).get(objectName);
    }

    public NashornScriptEngineFactory getFactory() {
        return this.factory;
    }

    public int getCompensation() {
        return this.compensation;
    }

    public void setFactory(NashornScriptEngineFactory factory) {
        this.factory = factory;
    }

    public void setCompensation(int compensation) {
        this.compensation = compensation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MngHelperServiceImpl)) {
            return false;
        }
        MngHelperServiceImpl other = (MngHelperServiceImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NashornScriptEngineFactory this$factory = this.getFactory();
        NashornScriptEngineFactory other$factory = other.getFactory();
        if (this$factory == null ? other$factory != null : !this$factory.equals(other$factory)) {
            return false;
        }
        return this.getCompensation() == other.getCompensation();
    }

    protected boolean canEqual(Object other) {
        return other instanceof MngHelperServiceImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NashornScriptEngineFactory $factory = this.getFactory();
        result = result * 59 + ($factory == null ? 43 : $factory.hashCode());
        result = result * 59 + this.getCompensation();
        return result;
    }

    public String toString() {
        return "MngHelperServiceImpl(factory=" + this.getFactory() + ", compensation=" + this.getCompensation() + ")";
    }
}

