/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilitycommon.model.bo.system;

import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.system.EsbAbility;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.util.GsonUtil;
import com.ohaotian.abilitycommon.util.JaxbUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Consts;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TlogReqHeader
implements Serializable {
    private static Logger logger = LogManager.getLogger(TlogReqHeader.class);
    private static final long serialVersionUID = -5016575564119873560L;
    private byte[] reqData = null;
    private byte[] OldReqData = null;
    private Object reqObj = null;
    private Map<String, String> headersMap = new HashMap<String, String>();
    private Map<String, List<String>> queryParamsMap = new HashMap<String, List<String>>();
    private String joinTime;
    private long reqRecvStartTime;
    private String fromIp;
    private String method;

    public Object getReqObj(MsgContext msg) {
        if (this.reqObj != null) {
            return this.reqObj;
        }
        return this.getObject(msg);
    }

    private Object getObject(MsgContext msg) {
        TlogReqHeader tlogReqHeader = msg.getTlogReqHeader();
        String content = new String(tlogReqHeader.getReqData(), Consts.UTF_8);
        EsbAbility esbAbility = msg.getEsbAbility();
        String className = esbAbility.getInputClassName();
        try {
            Object object = null;
            if (msg.getInputProtocal().equalsIgnoreCase("json")) {
                Class<?> c = esbAbility.getClzLoader().loadClass(className);
                object = GsonUtil.fromJson(content, c);
            } else if (msg.getInputProtocal().equalsIgnoreCase("xml")) {
                Class<?> c = esbAbility.getClzLoader().loadClass(className);
                object = JaxbUtil.xmlToBean(content, msg.getEsbAbility().getContextReq());
            } else if (msg.getInputProtocal().equalsIgnoreCase("ws")) {
                // empty if block
            }
            tlogReqHeader.setReqObj(object);
            return object;
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u62a5\u6587\u8f6cobject\u5f02\u5e38", (Throwable)e);
            throw new AbilityException(CodeMsg.ESB_ERROR.fillArgs(":" + e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()), (Throwable)e);
        }
    }

    public byte[] getReqData() {
        return this.reqData;
    }

    public byte[] getOldReqData() {
        return this.OldReqData;
    }

    public Object getReqObj() {
        return this.reqObj;
    }

    public Map<String, String> getHeadersMap() {
        return this.headersMap;
    }

    public Map<String, List<String>> getQueryParamsMap() {
        return this.queryParamsMap;
    }

    public String getJoinTime() {
        return this.joinTime;
    }

    public long getReqRecvStartTime() {
        return this.reqRecvStartTime;
    }

    public String getFromIp() {
        return this.fromIp;
    }

    public String getMethod() {
        return this.method;
    }

    public void setReqData(byte[] reqData) {
        this.reqData = reqData;
    }

    public void setOldReqData(byte[] OldReqData) {
        this.OldReqData = OldReqData;
    }

    public void setReqObj(Object reqObj) {
        this.reqObj = reqObj;
    }

    public void setHeadersMap(Map<String, String> headersMap) {
        this.headersMap = headersMap;
    }

    public void setQueryParamsMap(Map<String, List<String>> queryParamsMap) {
        this.queryParamsMap = queryParamsMap;
    }

    public void setJoinTime(String joinTime) {
        this.joinTime = joinTime;
    }

    public void setReqRecvStartTime(long reqRecvStartTime) {
        this.reqRecvStartTime = reqRecvStartTime;
    }

    public void setFromIp(String fromIp) {
        this.fromIp = fromIp;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TlogReqHeader)) {
            return false;
        }
        TlogReqHeader other = (TlogReqHeader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getReqData(), other.getReqData())) {
            return false;
        }
        if (!Arrays.equals(this.getOldReqData(), other.getOldReqData())) {
            return false;
        }
        Object this$reqObj = this.getReqObj();
        Object other$reqObj = other.getReqObj();
        if (this$reqObj == null ? other$reqObj != null : !this$reqObj.equals(other$reqObj)) {
            return false;
        }
        Map<String, String> this$headersMap = this.getHeadersMap();
        Map<String, String> other$headersMap = other.getHeadersMap();
        if (this$headersMap == null ? other$headersMap != null : !((Object)this$headersMap).equals(other$headersMap)) {
            return false;
        }
        Map<String, List<String>> this$queryParamsMap = this.getQueryParamsMap();
        Map<String, List<String>> other$queryParamsMap = other.getQueryParamsMap();
        if (this$queryParamsMap == null ? other$queryParamsMap != null : !((Object)this$queryParamsMap).equals(other$queryParamsMap)) {
            return false;
        }
        String this$joinTime = this.getJoinTime();
        String other$joinTime = other.getJoinTime();
        if (this$joinTime == null ? other$joinTime != null : !this$joinTime.equals(other$joinTime)) {
            return false;
        }
        if (this.getReqRecvStartTime() != other.getReqRecvStartTime()) {
            return false;
        }
        String this$fromIp = this.getFromIp();
        String other$fromIp = other.getFromIp();
        if (this$fromIp == null ? other$fromIp != null : !this$fromIp.equals(other$fromIp)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        return !(this$method == null ? other$method != null : !this$method.equals(other$method));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TlogReqHeader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getReqData());
        result = result * 59 + Arrays.hashCode(this.getOldReqData());
        Object $reqObj = this.getReqObj();
        result = result * 59 + ($reqObj == null ? 43 : $reqObj.hashCode());
        Map<String, String> $headersMap = this.getHeadersMap();
        result = result * 59 + ($headersMap == null ? 43 : ((Object)$headersMap).hashCode());
        Map<String, List<String>> $queryParamsMap = this.getQueryParamsMap();
        result = result * 59 + ($queryParamsMap == null ? 43 : ((Object)$queryParamsMap).hashCode());
        String $joinTime = this.getJoinTime();
        result = result * 59 + ($joinTime == null ? 43 : $joinTime.hashCode());
        long $reqRecvStartTime = this.getReqRecvStartTime();
        result = result * 59 + (int)($reqRecvStartTime >>> 32 ^ $reqRecvStartTime);
        String $fromIp = this.getFromIp();
        result = result * 59 + ($fromIp == null ? 43 : $fromIp.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        return result;
    }

    public String toString() {
        return "TlogReqHeader(reqData=" + Arrays.toString(this.getReqData()) + ", OldReqData=" + Arrays.toString(this.getOldReqData()) + ", reqObj=" + this.getReqObj() + ", headersMap=" + this.getHeadersMap() + ", queryParamsMap=" + this.getQueryParamsMap() + ", joinTime=" + this.getJoinTime() + ", reqRecvStartTime=" + this.getReqRecvStartTime() + ", fromIp=" + this.getFromIp() + ", method=" + this.getMethod() + ")";
    }
}

