/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilitycommon.util;

import com.google.common.base.Strings;

public class MacUtil {
    private static final String MAC_REGEX = "([0-9a-f][0-9a-f]:){5}[0-9a-f][0-9a-f]";
    private static final int MAC_PART = 6;

    public static String toMacString(byte[] buffer, int offset) {
        StringBuilder stringBuilder = new StringBuilder();
        int lastIndex = offset + 5;
        for (int i = offset; i < offset + 6; ++i) {
            String t = Integer.toHexString(buffer[i] & 0xFF);
            if (t.length() == 1) {
                stringBuilder.append(0);
            }
            stringBuilder.append(t);
            if (i == lastIndex) continue;
            stringBuilder.append(':');
        }
        return stringBuilder.toString();
    }

    public static boolean checkMacFormat(String mac) {
        return !Strings.isNullOrEmpty((String)mac) && mac.matches(MAC_REGEX);
    }

    public static void main(String[] args) {
        System.out.println(MacUtil.toMacString(new byte[]{27, 22, 53, 14, 35, 33}, 0));
    }
}

